// third_party/blink/public/mojom/webid/digital_identity_request.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-params-data.h"
#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-import-headers.h"
#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-test-utils.h"


namespace blink::mojom {
DigitalCredentialGetRequest::DigitalCredentialGetRequest()
    : protocol(),
      data() {}

DigitalCredentialGetRequest::DigitalCredentialGetRequest(
    const std::string& protocol_in,
    ::base::Value data_in)
    : protocol(std::move(protocol_in)),
      data(std::move(data_in)) {}

DigitalCredentialGetRequest::~DigitalCredentialGetRequest() = default;

void DigitalCredentialGetRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol"), this->protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DigitalCredentialGetRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DigitalCredentialCreateRequest::DigitalCredentialCreateRequest()
    : protocol(),
      data() {}

DigitalCredentialCreateRequest::DigitalCredentialCreateRequest(
    const std::string& protocol_in,
    ::base::Value data_in)
    : protocol(std::move(protocol_in)),
      data(std::move(data_in)) {}

DigitalCredentialCreateRequest::~DigitalCredentialCreateRequest() = default;

void DigitalCredentialCreateRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol"), this->protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DigitalCredentialCreateRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

DigitalIdentityRequest::IPCStableHashFunction DigitalIdentityRequest::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DigitalIdentityRequest>(message.name())) {
    case messages::DigitalIdentityRequest::kGet: {
      return &DigitalIdentityRequest::Get_Sym::IPCStableHash;
    }
    case messages::DigitalIdentityRequest::kCreate: {
      return &DigitalIdentityRequest::Create_Sym::IPCStableHash;
    }
    case messages::DigitalIdentityRequest::kAbort: {
      return &DigitalIdentityRequest::Abort_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DigitalIdentityRequest::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DigitalIdentityRequest>(message.name())) {
      case messages::DigitalIdentityRequest::kGet:
            return "Receive blink::mojom::DigitalIdentityRequest::Get";
      case messages::DigitalIdentityRequest::kCreate:
            return "Receive blink::mojom::DigitalIdentityRequest::Create";
      case messages::DigitalIdentityRequest::kAbort:
            return "Receive blink::mojom::DigitalIdentityRequest::Abort";
    }
  } else {
    switch (static_cast<messages::DigitalIdentityRequest>(message.name())) {
      case messages::DigitalIdentityRequest::kGet:
            return "Receive reply blink::mojom::DigitalIdentityRequest::Get";
      case messages::DigitalIdentityRequest::kCreate:
            return "Receive reply blink::mojom::DigitalIdentityRequest::Create";
      case messages::DigitalIdentityRequest::kAbort:
            return "Receive reply blink::mojom::DigitalIdentityRequest::Abort";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DigitalIdentityRequest::Get_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x02360a36;  // IPCStableHash for blink::mojom::DigitalIdentityRequest::Get
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DigitalIdentityRequest::Create_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e816a66;  // IPCStableHash for blink::mojom::DigitalIdentityRequest::Create
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DigitalIdentityRequest::Abort_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd15c25c5;  // IPCStableHash for blink::mojom::DigitalIdentityRequest::Abort
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DigitalIdentityRequest_Get_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalIdentityRequest_Get_ForwardToCallback(
      DigitalIdentityRequest::GetCallback callback
      ) : callback_(std::move(callback)) {
  }

  DigitalIdentityRequest_Get_ForwardToCallback(const DigitalIdentityRequest_Get_ForwardToCallback&) = delete;
  DigitalIdentityRequest_Get_ForwardToCallback& operator=(const DigitalIdentityRequest_Get_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DigitalIdentityRequest::GetCallback callback_;
};

class DigitalIdentityRequest_Create_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalIdentityRequest_Create_ForwardToCallback(
      DigitalIdentityRequest::CreateCallback callback
      ) : callback_(std::move(callback)) {
  }

  DigitalIdentityRequest_Create_ForwardToCallback(const DigitalIdentityRequest_Create_ForwardToCallback&) = delete;
  DigitalIdentityRequest_Create_ForwardToCallback& operator=(const DigitalIdentityRequest_Create_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DigitalIdentityRequest::CreateCallback callback_;
};

DigitalIdentityRequestProxy::DigitalIdentityRequestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DigitalIdentityRequestProxy::Get(
    std::vector<DigitalCredentialGetRequestPtr> in_digital_credential_requests, GetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DigitalIdentityRequest::Get", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("digital_credential_requests"), in_digital_credential_requests,
                        "<value of type std::vector<DigitalCredentialGetRequestPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalIdentityRequest::kGet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DigitalIdentityRequest_Get_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->digital_credential_requests)::BaseType>
      digital_credential_requests_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& digital_credential_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DigitalCredentialGetRequestDataView>>(
    in_digital_credential_requests,
    digital_credential_requests_fragment,
    &digital_credential_requests_validate_params);

  params->digital_credential_requests.Set(
      digital_credential_requests_fragment.is_null() ? nullptr : digital_credential_requests_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->digital_credential_requests.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null digital_credential_requests in DigitalIdentityRequest.Get request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalIdentityRequest::Name_);
  message.set_method_name("Get");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalIdentityRequest_Get_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DigitalIdentityRequestProxy::Create(
    std::vector<DigitalCredentialCreateRequestPtr> in_digital_credential_requests, CreateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DigitalIdentityRequest::Create", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("digital_credential_requests"), in_digital_credential_requests,
                        "<value of type std::vector<DigitalCredentialCreateRequestPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalIdentityRequest::kCreate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DigitalIdentityRequest_Create_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->digital_credential_requests)::BaseType>
      digital_credential_requests_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& digital_credential_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DigitalCredentialCreateRequestDataView>>(
    in_digital_credential_requests,
    digital_credential_requests_fragment,
    &digital_credential_requests_validate_params);

  params->digital_credential_requests.Set(
      digital_credential_requests_fragment.is_null() ? nullptr : digital_credential_requests_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->digital_credential_requests.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null digital_credential_requests in DigitalIdentityRequest.Create request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalIdentityRequest::Name_);
  message.set_method_name("Create");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalIdentityRequest_Create_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DigitalIdentityRequestProxy::Abort(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DigitalIdentityRequest::Abort");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalIdentityRequest::kAbort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DigitalIdentityRequest_Abort_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalIdentityRequest::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class DigitalIdentityRequest_Get_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DigitalIdentityRequest::GetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DigitalIdentityRequest_Get_ProxyToResponder> proxy(
        new DigitalIdentityRequest_Get_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DigitalIdentityRequest_Get_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalIdentityRequest_Get_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DigitalIdentityRequest_Get_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DigitalIdentityRequest::GetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      RequestDigitalIdentityStatus in_status, const std::optional<std::string>& in_protocol, std::optional<::base::Value> in_token);
};

bool DigitalIdentityRequest_Get_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DigitalIdentityRequest_Get_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalIdentityRequest_Get_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DigitalIdentityRequest.0
  bool success = true;
  RequestDigitalIdentityStatus p_status{};
  std::optional<std::string> p_protocol{};
  std::optional<::base::Value> p_token{};
  DigitalIdentityRequest_Get_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadProtocol(&p_protocol))
    success = false;
  if (success && !input_data_view.ReadToken(&p_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalIdentityRequest::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_protocol), 
std::move(p_token));
  }
  return true;
}

void DigitalIdentityRequest_Get_ProxyToResponder::Run(
    RequestDigitalIdentityStatus in_status, const std::optional<std::string>& in_protocol, std::optional<::base::Value> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DigitalIdentityRequest::Get", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type RequestDigitalIdentityStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("protocol"), in_protocol,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type std::optional<::base::Value>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalIdentityRequest::kGet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DigitalIdentityRequest_Get_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::RequestDigitalIdentityStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->protocol)::BaseType> protocol_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_protocol,
    protocol_fragment);

  params->protocol.Set(
      protocol_fragment.is_null() ? nullptr : protocol_fragment.data());
  mojo::internal::MessageFragment<decltype(params->token)>
      token_fragment(params.message());
  token_fragment.Claim(&params->token);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_token,
    token_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalIdentityRequest::Name_);
  message.set_method_name("Get");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DigitalIdentityRequest_Create_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DigitalIdentityRequest::CreateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DigitalIdentityRequest_Create_ProxyToResponder> proxy(
        new DigitalIdentityRequest_Create_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DigitalIdentityRequest_Create_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalIdentityRequest_Create_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DigitalIdentityRequest_Create_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DigitalIdentityRequest::CreateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      RequestDigitalIdentityStatus in_status, const std::optional<std::string>& in_protocol, std::optional<::base::Value> in_token);
};

bool DigitalIdentityRequest_Create_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DigitalIdentityRequest_Create_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalIdentityRequest_Create_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DigitalIdentityRequest.1
  bool success = true;
  RequestDigitalIdentityStatus p_status{};
  std::optional<std::string> p_protocol{};
  std::optional<::base::Value> p_token{};
  DigitalIdentityRequest_Create_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadProtocol(&p_protocol))
    success = false;
  if (success && !input_data_view.ReadToken(&p_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalIdentityRequest::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_protocol), 
std::move(p_token));
  }
  return true;
}

void DigitalIdentityRequest_Create_ProxyToResponder::Run(
    RequestDigitalIdentityStatus in_status, const std::optional<std::string>& in_protocol, std::optional<::base::Value> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DigitalIdentityRequest::Create", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type RequestDigitalIdentityStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("protocol"), in_protocol,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type std::optional<::base::Value>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalIdentityRequest::kCreate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DigitalIdentityRequest_Create_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::RequestDigitalIdentityStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->protocol)::BaseType> protocol_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_protocol,
    protocol_fragment);

  params->protocol.Set(
      protocol_fragment.is_null() ? nullptr : protocol_fragment.data());
  mojo::internal::MessageFragment<decltype(params->token)>
      token_fragment(params.message());
  token_fragment.Claim(&params->token);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_token,
    token_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalIdentityRequest::Name_);
  message.set_method_name("Create");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DigitalIdentityRequestStubDispatch::Accept(
    DigitalIdentityRequest* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DigitalIdentityRequest>(message->header()->name)) {
    case messages::DigitalIdentityRequest::kGet: {
      break;
    }
    case messages::DigitalIdentityRequest::kCreate: {
      break;
    }
    case messages::DigitalIdentityRequest::kAbort: {
      DCHECK(message->is_serialized());
      internal::DigitalIdentityRequest_Abort_Params_Data* params =
          reinterpret_cast<internal::DigitalIdentityRequest_Abort_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DigitalIdentityRequest.2
      bool success = true;
      DigitalIdentityRequest_Abort_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalIdentityRequest::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort(        );
      return true;
    }
  }
  return false;
}

// static
bool DigitalIdentityRequestStubDispatch::AcceptWithResponder(
    DigitalIdentityRequest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DigitalIdentityRequest>(message->header()->name)) {
    case messages::DigitalIdentityRequest::kGet: {
      internal::DigitalIdentityRequest_Get_Params_Data* params =
          reinterpret_cast<
              internal::DigitalIdentityRequest_Get_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DigitalIdentityRequest.0
      bool success = true;
      std::vector<DigitalCredentialGetRequestPtr> p_digital_credential_requests{};
      DigitalIdentityRequest_Get_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDigitalCredentialRequests(&p_digital_credential_requests))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalIdentityRequest::Name_, 0, false);
        return false;
      }
      auto callback =
          DigitalIdentityRequest_Get_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Get(        
        std::move(p_digital_credential_requests), std::move(callback));
      return true;
    }
    case messages::DigitalIdentityRequest::kCreate: {
      internal::DigitalIdentityRequest_Create_Params_Data* params =
          reinterpret_cast<
              internal::DigitalIdentityRequest_Create_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DigitalIdentityRequest.1
      bool success = true;
      std::vector<DigitalCredentialCreateRequestPtr> p_digital_credential_requests{};
      DigitalIdentityRequest_Create_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDigitalCredentialRequests(&p_digital_credential_requests))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalIdentityRequest::Name_, 1, false);
        return false;
      }
      auto callback =
          DigitalIdentityRequest_Create_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Create(        
        std::move(p_digital_credential_requests), std::move(callback));
      return true;
    }
    case messages::DigitalIdentityRequest::kAbort: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDigitalIdentityRequestValidationInfo[] = {
    { &internal::DigitalIdentityRequest_Get_Params_Data::Validate,
     &internal::DigitalIdentityRequest_Get_ResponseParams_Data::Validate},
    { &internal::DigitalIdentityRequest_Create_Params_Data::Validate,
     &internal::DigitalIdentityRequest_Create_ResponseParams_Data::Validate},
    { &internal::DigitalIdentityRequest_Abort_Params_Data::Validate,
     nullptr /* no response */},
};

bool DigitalIdentityRequestRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::DigitalIdentityRequest::Name_,
    kDigitalIdentityRequestValidationInfo);
}

bool DigitalIdentityRequestResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::DigitalIdentityRequest::Name_,
    kDigitalIdentityRequestValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::DigitalCredentialGetRequest::DataView, ::blink::mojom::DigitalCredentialGetRequestPtr>::Read(
    ::blink::mojom::DigitalCredentialGetRequest::DataView input,
    ::blink::mojom::DigitalCredentialGetRequestPtr* output) {
  bool success = true;
  ::blink::mojom::DigitalCredentialGetRequestPtr result(::blink::mojom::DigitalCredentialGetRequest::New());
  
      if (success && !input.ReadProtocol(&result->protocol))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DigitalCredentialCreateRequest::DataView, ::blink::mojom::DigitalCredentialCreateRequestPtr>::Read(
    ::blink::mojom::DigitalCredentialCreateRequest::DataView input,
    ::blink::mojom::DigitalCredentialCreateRequestPtr* output) {
  bool success = true;
  ::blink::mojom::DigitalCredentialCreateRequestPtr result(::blink::mojom::DigitalCredentialCreateRequest::New());
  
      if (success && !input.ReadProtocol(&result->protocol))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void DigitalIdentityRequestInterceptorForTesting::Get(std::vector<DigitalCredentialGetRequestPtr> digital_credential_requests, GetCallback callback) {
  GetForwardingInterface()->Get(
    std::move(digital_credential_requests)
    , std::move(callback));
}
void DigitalIdentityRequestInterceptorForTesting::Create(std::vector<DigitalCredentialCreateRequestPtr> digital_credential_requests, CreateCallback callback) {
  GetForwardingInterface()->Create(
    std::move(digital_credential_requests)
    , std::move(callback));
}
void DigitalIdentityRequestInterceptorForTesting::Abort() {
  GetForwardingInterface()->Abort();
}
DigitalIdentityRequestAsyncWaiter::DigitalIdentityRequestAsyncWaiter(
    DigitalIdentityRequest* proxy) : proxy_(proxy) {}

DigitalIdentityRequestAsyncWaiter::~DigitalIdentityRequestAsyncWaiter() = default;


void DigitalIdentityRequestAsyncWaiter::Get(
    std::vector<DigitalCredentialGetRequestPtr> digital_credential_requests, RequestDigitalIdentityStatus* out_status, std::optional<std::string>* out_protocol, std::optional<::base::Value>* out_token) {
  base::RunLoop loop;
  proxy_->Get(
      std::move(digital_credential_requests),
      base::BindOnce(
          [](base::RunLoop* loop,
             RequestDigitalIdentityStatus* out_status
,
             std::optional<std::string>* out_protocol
,
             std::optional<::base::Value>* out_token
,
             RequestDigitalIdentityStatus status,
             const std::optional<std::string>& protocol,
             std::optional<::base::Value> token) {*out_status = std::move(status);*out_protocol = std::move(protocol);*out_token = std::move(token);
            loop->Quit();
          },
          &loop,
          out_status,
          out_protocol,
          out_token));
  loop.Run();
}



void DigitalIdentityRequestAsyncWaiter::Create(
    std::vector<DigitalCredentialCreateRequestPtr> digital_credential_requests, RequestDigitalIdentityStatus* out_status, std::optional<std::string>* out_protocol, std::optional<::base::Value>* out_token) {
  base::RunLoop loop;
  proxy_->Create(
      std::move(digital_credential_requests),
      base::BindOnce(
          [](base::RunLoop* loop,
             RequestDigitalIdentityStatus* out_status
,
             std::optional<std::string>* out_protocol
,
             std::optional<::base::Value>* out_token
,
             RequestDigitalIdentityStatus status,
             const std::optional<std::string>& protocol,
             std::optional<::base::Value> token) {*out_status = std::move(status);*out_protocol = std::move(protocol);*out_token = std::move(token);
            loop->Quit();
          },
          &loop,
          out_status,
          out_protocol,
          out_token));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif