// third_party/blink/public/mojom/web_launch/web_launch.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  FileSystemAccessEntry as blink_mojom_FileSystemAccessEntry,
  FileSystemAccessEntrySpec as blink_mojom_FileSystemAccessEntrySpec
} from '../file_system_access/file_system_access_directory_handle.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebLaunchServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WebLaunchService', scope);
  }
}

/** @interface */
export class WebLaunchServiceInterface {
  
  /**
   * @param { !Array<!blink_mojom_FileSystemAccessEntry> } files
   */

  setLaunchFiles(files) {}
  
  /**
   * @param { !url_mojom_Url } launchUrl
   * @param { !mojoBase_mojom_TimeTicks } timeNavigationStartedInBrowser
   * @param { !boolean } navigationStarted
   */

  enqueueLaunchParams(launchUrl, timeNavigationStartedInBrowser, navigationStarted) {}
}

/**
 * @implements { WebLaunchServiceInterface }
 */
export class WebLaunchServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebLaunchServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebLaunchServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebLaunchServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink_mojom_FileSystemAccessEntry> } files
   */

  setLaunchFiles(
      files) {
    this.proxy.sendMessage(
        0,
        WebLaunchService_SetLaunchFiles_ParamsSpec.$,
        null,
        [
          files
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } launchUrl
   * @param { !mojoBase_mojom_TimeTicks } timeNavigationStartedInBrowser
   * @param { !boolean } navigationStarted
   */

  enqueueLaunchParams(
      launchUrl,
      timeNavigationStartedInBrowser,
      navigationStarted) {
    this.proxy.sendMessage(
        1,
        WebLaunchService_EnqueueLaunchParams_ParamsSpec.$,
        null,
        [
          launchUrl,
          timeNavigationStartedInBrowser,
          navigationStarted
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebLaunchService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebLaunchServiceReceiver {
  /**
   * @param {!WebLaunchServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebLaunchServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebLaunchServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebLaunchServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebLaunchService_SetLaunchFiles_ParamsSpec.$,
        null,
        impl.setLaunchFiles.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebLaunchService_EnqueueLaunchParams_ParamsSpec.$,
        null,
        impl.enqueueLaunchParams.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebLaunchService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebLaunchService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebLaunchServiceRemote}
   */
  static getRemote() {
    let remote = new WebLaunchServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebLaunchService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebLaunchServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebLaunchServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebLaunchServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setLaunchFiles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebLaunchService_SetLaunchFiles_ParamsSpec.$,
        null,
        this.setLaunchFiles.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enqueueLaunchParams =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebLaunchService_EnqueueLaunchParams_ParamsSpec.$,
        null,
        this.enqueueLaunchParams.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebLaunchService_SetLaunchFiles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebLaunchService_EnqueueLaunchParams_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WebLaunchService_SetLaunchFiles_ParamsSpec.$,
    'WebLaunchService_SetLaunchFiles_Params',
    [
      mojo.internal.StructField(
        'files', 0,
        0,
        mojo.internal.Array(blink_mojom_FileSystemAccessEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebLaunchService_SetLaunchFiles_Params {
  constructor() {
    /** @type { !Array<!blink_mojom_FileSystemAccessEntry> } */
    this.files;
  }
}



mojo.internal.Struct(
    WebLaunchService_EnqueueLaunchParams_ParamsSpec.$,
    'WebLaunchService_EnqueueLaunchParams_Params',
    [
      mojo.internal.StructField(
        'launchUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeNavigationStartedInBrowser', 8,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationStarted', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class WebLaunchService_EnqueueLaunchParams_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.launchUrl;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.timeNavigationStartedInBrowser;
    /** @type { !boolean } */
    this.navigationStarted;
  }
}

