// third_party/blink/public/mojom/web_install/web_install.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/web_install/web_install.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var WebInstallServiceResult = {};
  WebInstallServiceResult.kSuccess = 0;
  WebInstallServiceResult.kAbortError = 1;
  WebInstallServiceResult.kDataError = 2;
  WebInstallServiceResult.MIN_VALUE = 0;
  WebInstallServiceResult.MAX_VALUE = 2;

  WebInstallServiceResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  WebInstallServiceResult.toKnownEnumValue = function(value) {
    return value;
  };

  WebInstallServiceResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function InstallOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InstallOptions.prototype.initDefaults_ = function() {
    this.installUrl = null;
    this.manifestId = null;
  };
  InstallOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InstallOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InstallOptions.installUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InstallOptions.manifestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InstallOptions.encodedSize = codec.kStructHeaderSize + 16;

  InstallOptions.decode = function(decoder) {
    var packed;
    var val = new InstallOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.installUrl =
        decoder.decodeStructPointer(url$.Url);
    val.manifestId =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  InstallOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InstallOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.installUrl);
    encoder.encodeStructPointer(url$.Url, val.manifestId);
  };
  function WebInstallService_Install_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebInstallService_Install_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  WebInstallService_Install_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebInstallService_Install_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebInstallService_Install_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, InstallOptions, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebInstallService_Install_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebInstallService_Install_Params.decode = function(decoder) {
    var packed;
    var val = new WebInstallService_Install_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(InstallOptions);
    return val;
  };

  WebInstallService_Install_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebInstallService_Install_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(InstallOptions, val.options);
  };
  function WebInstallService_Install_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebInstallService_Install_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.manifestId = null;
  };
  WebInstallService_Install_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebInstallService_Install_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebInstallService_Install_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, WebInstallServiceResult);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebInstallService_Install_ResponseParams.manifestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebInstallService_Install_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  WebInstallService_Install_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebInstallService_Install_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(WebInstallServiceResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.manifestId =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  WebInstallService_Install_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebInstallService_Install_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url$.Url, val.manifestId);
  };
  var kWebInstallService_Install_Name = 0;

  function WebInstallServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebInstallService,
                                                   handleOrPtrInfo);
  }

  function WebInstallServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebInstallService, associatedInterfacePtrInfo);
  }

  WebInstallServiceAssociatedPtr.prototype =
      Object.create(WebInstallServicePtr.prototype);
  WebInstallServiceAssociatedPtr.prototype.constructor =
      WebInstallServiceAssociatedPtr;

  function WebInstallServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebInstallServicePtr.prototype.install = function() {
    return WebInstallServiceProxy.prototype.install
        .apply(this.ptr.getProxy(), arguments);
  };

  WebInstallServiceProxy.prototype.install = function(options) {
    var params_ = new WebInstallService_Install_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebInstallService_Install_Name,
          codec.align(WebInstallService_Install_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebInstallService_Install_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebInstallService_Install_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function WebInstallServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  WebInstallServiceStub.prototype.install = function(options) {
    return this.delegate_ && this.delegate_.install && this.delegate_.install(options);
  }

  WebInstallServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  WebInstallServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebInstallService_Install_Name:
      var params = reader.decodeStruct(WebInstallService_Install_Params);
      this.install(params.options).then(function(response) {
        var responseParams =
            new WebInstallService_Install_ResponseParams();
        responseParams.result = response.result;
        responseParams.manifestId = response.manifestId;
        var builder = new codec.MessageV1Builder(
            kWebInstallService_Install_Name,
            codec.align(WebInstallService_Install_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebInstallService_Install_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWebInstallServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebInstallService_Install_Name:
        if (message.expectsResponse())
          paramsClass = WebInstallService_Install_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebInstallServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWebInstallService_Install_Name:
        if (message.isResponse())
          paramsClass = WebInstallService_Install_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WebInstallService = {
    name: 'blink.mojom.WebInstallService',
    kVersion: 0,
    ptrClass: WebInstallServicePtr,
    proxyClass: WebInstallServiceProxy,
    stubClass: WebInstallServiceStub,
    validateRequest: validateWebInstallServiceRequest,
    validateResponse: validateWebInstallServiceResponse,
  };
  WebInstallServiceStub.prototype.validator = validateWebInstallServiceRequest;
  WebInstallServiceProxy.prototype.validator = validateWebInstallServiceResponse;
  exports.WebInstallServiceResult = WebInstallServiceResult;
  exports.InstallOptions = InstallOptions;
  exports.WebInstallService = WebInstallService;
  exports.WebInstallServicePtr = WebInstallServicePtr;
  exports.WebInstallServiceAssociatedPtr = WebInstallServiceAssociatedPtr;
})();