// third_party/blink/public/mojom/web_install/web_install.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebInstallServiceResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WebInstallServiceResult = {
  
  kSuccess: 0,
  kAbortError: 1,
  kDataError: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WebInstallServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.WebInstallService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.WebInstallServiceInterface }
 */
blink.mojom.WebInstallServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WebInstallServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WebInstallServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WebInstallServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?blink.mojom.InstallOptions } options
   * @return {!Promise<{
        result: !blink.mojom.WebInstallServiceResult,
        manifestId: !url.mojom.Url,
   *  }>}
   */

  install(
      options) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.WebInstallService_Install_ParamsSpec.$,
        blink.mojom.WebInstallService_Install_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebInstallService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WebInstallServiceReceiver = class {
  /**
   * @param {!blink.mojom.WebInstallServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WebInstallServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WebInstallServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WebInstallServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WebInstallService_Install_ParamsSpec.$,
        blink.mojom.WebInstallService_Install_ResponseParamsSpec.$,
        impl.install.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.WebInstallService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebInstallService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WebInstallServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WebInstallServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebInstallService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WebInstallServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WebInstallServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WebInstallServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.install =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WebInstallService_Install_ParamsSpec.$,
        blink.mojom.WebInstallService_Install_ResponseParamsSpec.$,
        this.install.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.InstallOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebInstallService_Install_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebInstallService_Install_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.InstallOptionsSpec.$,
    'InstallOptions',
    [
      mojo.internal.StructField(
        'installUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'manifestId', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.InstallOptions = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.installUrl;
    /** @export { (url.mojom.Url|undefined) } */
    this.manifestId;
  }
};



mojo.internal.Struct(
    blink.mojom.WebInstallService_Install_ParamsSpec.$,
    'WebInstallService_Install_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.InstallOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.WebInstallService_Install_Params = class {
  constructor() {
    /** @export { (blink.mojom.InstallOptions|undefined) } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.WebInstallService_Install_ResponseParamsSpec.$,
    'WebInstallService_Install_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.WebInstallServiceResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'manifestId', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.WebInstallService_Install_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.WebInstallServiceResult } */
    this.result;
    /** @export { !url.mojom.Url } */
    this.manifestId;
  }
};

