// third_party/blink/public/mojom/timing/resource_timing.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/timing/resource_timing.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/service_worker_router_info.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class ServerTimingInfoDataView;

class ResourceTimingInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ServerTimingInfoDataView> {
  using Data = ::blink::mojom::internal::ServerTimingInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ResourceTimingInfoDataView> {
  using Data = ::blink::mojom::internal::ResourceTimingInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class CacheState : int32_t {
  
  kNone = 0,
  
  kLocal = 1,
  
  kValidated = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CacheState value);
inline bool IsKnownEnumValue(CacheState value) {
  return internal::CacheState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ServerTimingInfoDataView {
 public:
  ServerTimingInfoDataView() = default;

  ServerTimingInfoDataView(
      internal::ServerTimingInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  double duration() const {
    return data_->duration;
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServerTimingInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceTimingInfoDataView {
 public:
  ResourceTimingInfoDataView() = default;

  ResourceTimingInfoDataView(
      internal::ResourceTimingInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetAlpnNegotiatedProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlpnNegotiatedProtocol(UserType* output) {
    
    auto* pointer = data_->alpn_negotiated_protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetConnectionInfoDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConnectionInfo(UserType* output) {
    
    auto* pointer = data_->connection_info.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTimingDataView(
      ::network::mojom::LoadTimingInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTiming(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::LoadTimingInfoDataView, UserType>(),
    "Attempting to read the optional `timing` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTiming` instead "
    "of `ReadTiming if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timing.Get();
    return mojo::internal::Deserialize<::network::mojom::LoadTimingInfoDataView>(
        pointer, output, message_);
  }
  inline void GetLastRedirectEndTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastRedirectEndTime(UserType* output) {
    
    auto* pointer = data_->last_redirect_end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetResponseEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseEnd(UserType* output) {
    
    auto* pointer = data_->response_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCacheState(UserType* output) const {
    auto data_value = data_->cache_state;
    return mojo::internal::Deserialize<::blink::mojom::CacheState>(
        data_value, output);
  }
  CacheState cache_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::CacheState>(data_->cache_state));
  }
  uint64_t encoded_body_size() const {
    return data_->encoded_body_size;
  }
  uint64_t decoded_body_size() const {
    return data_->decoded_body_size;
  }
  bool did_reuse_connection() const {
    return data_->did_reuse_connection;
  }
  bool is_secure_transport() const {
    return data_->is_secure_transport;
  }
  bool allow_timing_details() const {
    return data_->allow_timing_details;
  }
  bool allow_negative_values() const {
    return data_->allow_negative_values;
  }
  inline void GetServerTimingDataView(
      mojo::ArrayDataView<ServerTimingInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerTiming(UserType* output) {
    
    auto* pointer = data_->server_timing.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ServerTimingInfoDataView>>(
        pointer, output, message_);
  }
  bool render_blocking_status() const {
    return data_->render_blocking_status;
  }
  uint16_t response_status() const {
    return data_->response_status;
  }
  inline void GetContentTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentType(UserType* output) {
    
    auto* pointer = data_->content_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetContentEncodingDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentEncoding(UserType* output) {
    
    auto* pointer = data_->content_encoding.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorUrl(UserType* output) {
    
    auto* pointer = data_->initiator_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetServiceWorkerRouterInfoDataView(
      ::network::mojom::ServiceWorkerRouterInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerRouterInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ServiceWorkerRouterInfoDataView, UserType>(),
    "Attempting to read the optional `service_worker_router_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServiceWorkerRouterInfo` instead "
    "of `ReadServiceWorkerRouterInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->service_worker_router_info.Get();
    return mojo::internal::Deserialize<::network::mojom::ServiceWorkerRouterInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerResponseSource(UserType* output) const {
    auto data_value = data_->service_worker_response_source;
    return mojo::internal::Deserialize<::network::mojom::FetchResponseSource>(
        data_value, output);
  }
  ::network::mojom::FetchResponseSource service_worker_response_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::FetchResponseSource>(data_->service_worker_response_source));
  }
 private:
  internal::ResourceTimingInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_DATA_VIEW_H_