// third_party/blink/public/mojom/subapps/sub_apps_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/subapps/sub_apps_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');


  var SubAppsServiceResultCode = {};
  SubAppsServiceResultCode.kSuccess = 0;
  SubAppsServiceResultCode.kFailure = 1;
  SubAppsServiceResultCode.MIN_VALUE = 0;
  SubAppsServiceResultCode.MAX_VALUE = 1;

  SubAppsServiceResultCode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  SubAppsServiceResultCode.toKnownEnumValue = function(value) {
    return value;
  };

  SubAppsServiceResultCode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SubAppsServiceAddParameters(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubAppsServiceAddParameters.prototype.initDefaults_ = function() {
    this.manifestIdPath = null;
    this.installUrlPath = null;
  };
  SubAppsServiceAddParameters.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubAppsServiceAddParameters.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsServiceAddParameters.manifestIdPath
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsServiceAddParameters.installUrlPath
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubAppsServiceAddParameters.encodedSize = codec.kStructHeaderSize + 16;

  SubAppsServiceAddParameters.decode = function(decoder) {
    var packed;
    var val = new SubAppsServiceAddParameters();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.manifestIdPath =
        decoder.decodeStruct(codec.String);
    val.installUrlPath =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SubAppsServiceAddParameters.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubAppsServiceAddParameters.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.manifestIdPath);
    encoder.encodeStruct(codec.String, val.installUrlPath);
  };
  function SubAppsServiceAddResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubAppsServiceAddResult.prototype.initDefaults_ = function() {
    this.manifestIdPath = null;
    this.resultCode = 0;
  };
  SubAppsServiceAddResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubAppsServiceAddResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsServiceAddResult.manifestIdPath
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsServiceAddResult.resultCode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, SubAppsServiceResultCode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubAppsServiceAddResult.encodedSize = codec.kStructHeaderSize + 16;

  SubAppsServiceAddResult.decode = function(decoder) {
    var packed;
    var val = new SubAppsServiceAddResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.manifestIdPath =
        decoder.decodeStruct(codec.String);
    val.resultCode =
        decoder.decodeStruct(new codec.Enum(SubAppsServiceResultCode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SubAppsServiceAddResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubAppsServiceAddResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.manifestIdPath);
    encoder.encodeStruct(codec.Int32, val.resultCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SubAppsServiceListResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubAppsServiceListResult.prototype.initDefaults_ = function() {
    this.resultCode = 0;
    this.subAppsList = null;
  };
  SubAppsServiceListResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubAppsServiceListResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsServiceListResult.resultCode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SubAppsServiceResultCode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsServiceListResult.subAppsList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(SubAppsServiceListResultEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubAppsServiceListResult.encodedSize = codec.kStructHeaderSize + 16;

  SubAppsServiceListResult.decode = function(decoder) {
    var packed;
    var val = new SubAppsServiceListResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resultCode =
        decoder.decodeStruct(new codec.Enum(SubAppsServiceResultCode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.subAppsList =
        decoder.decodeArrayPointer(new codec.PointerTo(SubAppsServiceListResultEntry));
    return val;
  };

  SubAppsServiceListResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubAppsServiceListResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.resultCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(SubAppsServiceListResultEntry), val.subAppsList);
  };
  function SubAppsServiceListResultEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubAppsServiceListResultEntry.prototype.initDefaults_ = function() {
    this.manifestIdPath = null;
    this.appName = null;
  };
  SubAppsServiceListResultEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubAppsServiceListResultEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsServiceListResultEntry.manifestIdPath
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsServiceListResultEntry.appName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubAppsServiceListResultEntry.encodedSize = codec.kStructHeaderSize + 16;

  SubAppsServiceListResultEntry.decode = function(decoder) {
    var packed;
    var val = new SubAppsServiceListResultEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.manifestIdPath =
        decoder.decodeStruct(codec.String);
    val.appName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SubAppsServiceListResultEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubAppsServiceListResultEntry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.manifestIdPath);
    encoder.encodeStruct(codec.String, val.appName);
  };
  function SubAppsServiceRemoveResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubAppsServiceRemoveResult.prototype.initDefaults_ = function() {
    this.manifestIdPath = null;
    this.resultCode = 0;
  };
  SubAppsServiceRemoveResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubAppsServiceRemoveResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsServiceRemoveResult.manifestIdPath
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsServiceRemoveResult.resultCode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, SubAppsServiceResultCode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubAppsServiceRemoveResult.encodedSize = codec.kStructHeaderSize + 16;

  SubAppsServiceRemoveResult.decode = function(decoder) {
    var packed;
    var val = new SubAppsServiceRemoveResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.manifestIdPath =
        decoder.decodeStruct(codec.String);
    val.resultCode =
        decoder.decodeStruct(new codec.Enum(SubAppsServiceResultCode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SubAppsServiceRemoveResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubAppsServiceRemoveResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.manifestIdPath);
    encoder.encodeStruct(codec.Int32, val.resultCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SubAppsService_Add_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubAppsService_Add_Params.prototype.initDefaults_ = function() {
    this.subAppsToAdd = null;
  };
  SubAppsService_Add_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubAppsService_Add_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsService_Add_Params.subAppsToAdd
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SubAppsServiceAddParameters), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubAppsService_Add_Params.encodedSize = codec.kStructHeaderSize + 8;

  SubAppsService_Add_Params.decode = function(decoder) {
    var packed;
    var val = new SubAppsService_Add_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.subAppsToAdd =
        decoder.decodeArrayPointer(new codec.PointerTo(SubAppsServiceAddParameters));
    return val;
  };

  SubAppsService_Add_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubAppsService_Add_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SubAppsServiceAddParameters), val.subAppsToAdd);
  };
  function SubAppsService_Add_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubAppsService_Add_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SubAppsService_Add_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubAppsService_Add_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsService_Add_ResponseParams.result
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SubAppsServiceAddResult), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubAppsService_Add_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SubAppsService_Add_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SubAppsService_Add_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeArrayPointer(new codec.PointerTo(SubAppsServiceAddResult));
    return val;
  };

  SubAppsService_Add_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubAppsService_Add_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SubAppsServiceAddResult), val.result);
  };
  function SubAppsService_List_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubAppsService_List_Params.prototype.initDefaults_ = function() {
  };
  SubAppsService_List_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubAppsService_List_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubAppsService_List_Params.encodedSize = codec.kStructHeaderSize + 0;

  SubAppsService_List_Params.decode = function(decoder) {
    var packed;
    var val = new SubAppsService_List_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SubAppsService_List_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubAppsService_List_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SubAppsService_List_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubAppsService_List_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SubAppsService_List_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubAppsService_List_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsService_List_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SubAppsServiceListResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubAppsService_List_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SubAppsService_List_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SubAppsService_List_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(SubAppsServiceListResult);
    return val;
  };

  SubAppsService_List_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubAppsService_List_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SubAppsServiceListResult, val.result);
  };
  function SubAppsService_Remove_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubAppsService_Remove_Params.prototype.initDefaults_ = function() {
    this.manifestIdPaths = null;
  };
  SubAppsService_Remove_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubAppsService_Remove_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsService_Remove_Params.manifestIdPaths
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubAppsService_Remove_Params.encodedSize = codec.kStructHeaderSize + 8;

  SubAppsService_Remove_Params.decode = function(decoder) {
    var packed;
    var val = new SubAppsService_Remove_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.manifestIdPaths =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  SubAppsService_Remove_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubAppsService_Remove_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.manifestIdPaths);
  };
  function SubAppsService_Remove_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubAppsService_Remove_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SubAppsService_Remove_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubAppsService_Remove_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubAppsService_Remove_ResponseParams.result
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SubAppsServiceRemoveResult), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubAppsService_Remove_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SubAppsService_Remove_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SubAppsService_Remove_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeArrayPointer(new codec.PointerTo(SubAppsServiceRemoveResult));
    return val;
  };

  SubAppsService_Remove_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubAppsService_Remove_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SubAppsServiceRemoveResult), val.result);
  };
  var kSubAppsService_Add_Name = 0;
  var kSubAppsService_List_Name = 1;
  var kSubAppsService_Remove_Name = 2;

  function SubAppsServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SubAppsService,
                                                   handleOrPtrInfo);
  }

  function SubAppsServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SubAppsService, associatedInterfacePtrInfo);
  }

  SubAppsServiceAssociatedPtr.prototype =
      Object.create(SubAppsServicePtr.prototype);
  SubAppsServiceAssociatedPtr.prototype.constructor =
      SubAppsServiceAssociatedPtr;

  function SubAppsServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  SubAppsServicePtr.prototype.add = function() {
    return SubAppsServiceProxy.prototype.add
        .apply(this.ptr.getProxy(), arguments);
  };

  SubAppsServiceProxy.prototype.add = function(subAppsToAdd) {
    var params_ = new SubAppsService_Add_Params();
    params_.subAppsToAdd = subAppsToAdd;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSubAppsService_Add_Name,
          codec.align(SubAppsService_Add_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SubAppsService_Add_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SubAppsService_Add_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SubAppsServicePtr.prototype.list = function() {
    return SubAppsServiceProxy.prototype.list
        .apply(this.ptr.getProxy(), arguments);
  };

  SubAppsServiceProxy.prototype.list = function() {
    var params_ = new SubAppsService_List_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSubAppsService_List_Name,
          codec.align(SubAppsService_List_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SubAppsService_List_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SubAppsService_List_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SubAppsServicePtr.prototype.remove = function() {
    return SubAppsServiceProxy.prototype.remove
        .apply(this.ptr.getProxy(), arguments);
  };

  SubAppsServiceProxy.prototype.remove = function(manifestIdPaths) {
    var params_ = new SubAppsService_Remove_Params();
    params_.manifestIdPaths = manifestIdPaths;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSubAppsService_Remove_Name,
          codec.align(SubAppsService_Remove_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SubAppsService_Remove_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SubAppsService_Remove_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SubAppsServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  SubAppsServiceStub.prototype.add = function(subAppsToAdd) {
    return this.delegate_ && this.delegate_.add && this.delegate_.add(subAppsToAdd);
  }
  SubAppsServiceStub.prototype.list = function() {
    return this.delegate_ && this.delegate_.list && this.delegate_.list();
  }
  SubAppsServiceStub.prototype.remove = function(manifestIdPaths) {
    return this.delegate_ && this.delegate_.remove && this.delegate_.remove(manifestIdPaths);
  }

  SubAppsServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SubAppsServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSubAppsService_Add_Name:
      var params = reader.decodeStruct(SubAppsService_Add_Params);
      this.add(params.subAppsToAdd).then(function(response) {
        var responseParams =
            new SubAppsService_Add_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSubAppsService_Add_Name,
            codec.align(SubAppsService_Add_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SubAppsService_Add_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSubAppsService_List_Name:
      var params = reader.decodeStruct(SubAppsService_List_Params);
      this.list().then(function(response) {
        var responseParams =
            new SubAppsService_List_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSubAppsService_List_Name,
            codec.align(SubAppsService_List_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SubAppsService_List_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSubAppsService_Remove_Name:
      var params = reader.decodeStruct(SubAppsService_Remove_Params);
      this.remove(params.manifestIdPaths).then(function(response) {
        var responseParams =
            new SubAppsService_Remove_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSubAppsService_Remove_Name,
            codec.align(SubAppsService_Remove_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SubAppsService_Remove_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSubAppsServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSubAppsService_Add_Name:
        if (message.expectsResponse())
          paramsClass = SubAppsService_Add_Params;
      break;
      case kSubAppsService_List_Name:
        if (message.expectsResponse())
          paramsClass = SubAppsService_List_Params;
      break;
      case kSubAppsService_Remove_Name:
        if (message.expectsResponse())
          paramsClass = SubAppsService_Remove_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSubAppsServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSubAppsService_Add_Name:
        if (message.isResponse())
          paramsClass = SubAppsService_Add_ResponseParams;
        break;
      case kSubAppsService_List_Name:
        if (message.isResponse())
          paramsClass = SubAppsService_List_ResponseParams;
        break;
      case kSubAppsService_Remove_Name:
        if (message.isResponse())
          paramsClass = SubAppsService_Remove_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SubAppsService = {
    name: 'blink.mojom.SubAppsService',
    kVersion: 0,
    ptrClass: SubAppsServicePtr,
    proxyClass: SubAppsServiceProxy,
    stubClass: SubAppsServiceStub,
    validateRequest: validateSubAppsServiceRequest,
    validateResponse: validateSubAppsServiceResponse,
  };
  SubAppsServiceStub.prototype.validator = validateSubAppsServiceRequest;
  SubAppsServiceProxy.prototype.validator = validateSubAppsServiceResponse;
  exports.SubAppsServiceResultCode = SubAppsServiceResultCode;
  exports.SubAppsServiceAddParameters = SubAppsServiceAddParameters;
  exports.SubAppsServiceAddResult = SubAppsServiceAddResult;
  exports.SubAppsServiceListResult = SubAppsServiceListResult;
  exports.SubAppsServiceListResultEntry = SubAppsServiceListResultEntry;
  exports.SubAppsServiceRemoveResult = SubAppsServiceRemoveResult;
  exports.SubAppsService = SubAppsService;
  exports.SubAppsServicePtr = SubAppsServicePtr;
  exports.SubAppsServiceAssociatedPtr = SubAppsServiceAssociatedPtr;
})();