// third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_ROUTER_RULE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_ROUTER_RULE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "third_party/blink/public/mojom/safe_url_pattern.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/service_worker/service_worker_router_rule.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {





class BLINK_COMMON_EXPORT ServiceWorkerRouterRunningStatusCondition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterRunningStatusCondition, T>::value>;
  using DataView = ServiceWorkerRouterRunningStatusConditionDataView;
  using Data_ = internal::ServiceWorkerRouterRunningStatusCondition_Data;

  template <typename... Args>
  static ServiceWorkerRouterRunningStatusConditionPtr New(Args&&... args) {
    return ServiceWorkerRouterRunningStatusConditionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterRunningStatusConditionPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterRunningStatusConditionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterRunningStatusCondition>::Convert(*this);
  }


  ServiceWorkerRouterRunningStatusCondition();

  explicit ServiceWorkerRouterRunningStatusCondition(
      ServiceWorkerRouterRunningStatusEnum status);


  ~ServiceWorkerRouterRunningStatusCondition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterRunningStatusConditionPtr>
  ServiceWorkerRouterRunningStatusConditionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterRunningStatusCondition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterRunningStatusCondition::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterRunningStatusCondition::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterRunningStatusCondition::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterRunningStatusCondition::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterRunningStatusCondition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterRunningStatusCondition_UnserializedMessageContext<
            UserType, ServiceWorkerRouterRunningStatusCondition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterRunningStatusCondition::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterRunningStatusCondition::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterRunningStatusCondition_UnserializedMessageContext<
            UserType, ServiceWorkerRouterRunningStatusCondition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterRunningStatusCondition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ServiceWorkerRouterRunningStatusEnum status;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterRunningStatusCondition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterRunningStatusCondition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterRunningStatusCondition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterRunningStatusCondition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_COMMON_EXPORT ServiceWorkerRouterNetworkSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterNetworkSource, T>::value>;
  using DataView = ServiceWorkerRouterNetworkSourceDataView;
  using Data_ = internal::ServiceWorkerRouterNetworkSource_Data;

  template <typename... Args>
  static ServiceWorkerRouterNetworkSourcePtr New(Args&&... args) {
    return ServiceWorkerRouterNetworkSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterNetworkSourcePtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterNetworkSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterNetworkSource>::Convert(*this);
  }


  ServiceWorkerRouterNetworkSource();


  ~ServiceWorkerRouterNetworkSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterNetworkSourcePtr>
  ServiceWorkerRouterNetworkSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterNetworkSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterNetworkSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterNetworkSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterNetworkSource::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterNetworkSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterNetworkSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterNetworkSource_UnserializedMessageContext<
            UserType, ServiceWorkerRouterNetworkSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterNetworkSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterNetworkSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterNetworkSource_UnserializedMessageContext<
            UserType, ServiceWorkerRouterNetworkSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterNetworkSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterNetworkSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterNetworkSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterNetworkSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterNetworkSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ServiceWorkerRouterRaceNetworkAndFetchEventSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterRaceNetworkAndFetchEventSource, T>::value>;
  using DataView = ServiceWorkerRouterRaceNetworkAndFetchEventSourceDataView;
  using Data_ = internal::ServiceWorkerRouterRaceNetworkAndFetchEventSource_Data;

  template <typename... Args>
  static ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr New(Args&&... args) {
    return ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterRaceNetworkAndFetchEventSource>::Convert(*this);
  }


  ServiceWorkerRouterRaceNetworkAndFetchEventSource();


  ~ServiceWorkerRouterRaceNetworkAndFetchEventSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr>
  ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterRaceNetworkAndFetchEventSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterRaceNetworkAndFetchEventSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterRaceNetworkAndFetchEventSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterRaceNetworkAndFetchEventSource::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterRaceNetworkAndFetchEventSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterRaceNetworkAndFetchEventSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterRaceNetworkAndFetchEventSource_UnserializedMessageContext<
            UserType, ServiceWorkerRouterRaceNetworkAndFetchEventSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterRaceNetworkAndFetchEventSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterRaceNetworkAndFetchEventSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterRaceNetworkAndFetchEventSource_UnserializedMessageContext<
            UserType, ServiceWorkerRouterRaceNetworkAndFetchEventSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterRaceNetworkAndFetchEventSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterRaceNetworkAndFetchEventSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterRaceNetworkAndFetchEventSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterRaceNetworkAndFetchEventSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterRaceNetworkAndFetchEventSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ServiceWorkerRouterFetchEventSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterFetchEventSource, T>::value>;
  using DataView = ServiceWorkerRouterFetchEventSourceDataView;
  using Data_ = internal::ServiceWorkerRouterFetchEventSource_Data;

  template <typename... Args>
  static ServiceWorkerRouterFetchEventSourcePtr New(Args&&... args) {
    return ServiceWorkerRouterFetchEventSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterFetchEventSourcePtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterFetchEventSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterFetchEventSource>::Convert(*this);
  }


  ServiceWorkerRouterFetchEventSource();


  ~ServiceWorkerRouterFetchEventSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterFetchEventSourcePtr>
  ServiceWorkerRouterFetchEventSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterFetchEventSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterFetchEventSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterFetchEventSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterFetchEventSource::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterFetchEventSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterFetchEventSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterFetchEventSource_UnserializedMessageContext<
            UserType, ServiceWorkerRouterFetchEventSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterFetchEventSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterFetchEventSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterFetchEventSource_UnserializedMessageContext<
            UserType, ServiceWorkerRouterFetchEventSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterFetchEventSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterFetchEventSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterFetchEventSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterFetchEventSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterFetchEventSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ServiceWorkerRouterCacheSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterCacheSource, T>::value>;
  using DataView = ServiceWorkerRouterCacheSourceDataView;
  using Data_ = internal::ServiceWorkerRouterCacheSource_Data;

  template <typename... Args>
  static ServiceWorkerRouterCacheSourcePtr New(Args&&... args) {
    return ServiceWorkerRouterCacheSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterCacheSourcePtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterCacheSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterCacheSource>::Convert(*this);
  }


  ServiceWorkerRouterCacheSource();

  explicit ServiceWorkerRouterCacheSource(
      const std::optional<std::string>& cache_name);


  ~ServiceWorkerRouterCacheSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterCacheSourcePtr>
  ServiceWorkerRouterCacheSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterCacheSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterCacheSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterCacheSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterCacheSource::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterCacheSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterCacheSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterCacheSource_UnserializedMessageContext<
            UserType, ServiceWorkerRouterCacheSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterCacheSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterCacheSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterCacheSource_UnserializedMessageContext<
            UserType, ServiceWorkerRouterCacheSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterCacheSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> cache_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterCacheSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterCacheSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterCacheSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterCacheSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class BLINK_COMMON_EXPORT ServiceWorkerRouterSource {
 public:
  using DataView = ServiceWorkerRouterSourceDataView;
  using Data_ = internal::ServiceWorkerRouterSource_Data;
  using Tag = Data_::ServiceWorkerRouterSource_Tag;

  template <typename... Args>
  static ServiceWorkerRouterSourcePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |network_source|.
  static ServiceWorkerRouterSourcePtr NewNetworkSource(
      ServiceWorkerRouterNetworkSourcePtr value);
  // Construct an instance holding |race_network_and_fetch_event_source|.
  static ServiceWorkerRouterSourcePtr NewRaceNetworkAndFetchEventSource(
      ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr value);
  // Construct an instance holding |fetch_event_source|.
  static ServiceWorkerRouterSourcePtr NewFetchEventSource(
      ServiceWorkerRouterFetchEventSourcePtr value);
  // Construct an instance holding |cache_source|.
  static ServiceWorkerRouterSourcePtr NewCacheSource(
      ServiceWorkerRouterCacheSourcePtr value);
  // Construct an instance holding |race_network_and_cache_source|.
  static ServiceWorkerRouterSourcePtr NewRaceNetworkAndCacheSource(
      ServiceWorkerRouterRaceNetworkAndCacheSourcePtr value);

  template <typename U>
  static ServiceWorkerRouterSourcePtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterSource>::Convert(*this);
  }
  ~ServiceWorkerRouterSource();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ServiceWorkerRouterSource(const ServiceWorkerRouterSource& other) = delete;
  ServiceWorkerRouterSource& operator=(const ServiceWorkerRouterSource& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ServiceWorkerRouterSourcePtr>
  ServiceWorkerRouterSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ServiceWorkerRouterSource>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ServiceWorkerRouterSource>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_network_source() const { return tag_ == Tag::kNetworkSource; }
  const ServiceWorkerRouterNetworkSourcePtr& get_network_source() const {
    CHECK(tag_ == Tag::kNetworkSource);
    return data_.network_source;
  }
  ServiceWorkerRouterNetworkSourcePtr& get_network_source() {
    CHECK(tag_ == Tag::kNetworkSource);
    return data_.network_source;
  }
  void set_network_source(ServiceWorkerRouterNetworkSourcePtr network_source);

  bool is_race_network_and_fetch_event_source() const { return tag_ == Tag::kRaceNetworkAndFetchEventSource; }
  const ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr& get_race_network_and_fetch_event_source() const {
    CHECK(tag_ == Tag::kRaceNetworkAndFetchEventSource);
    return data_.race_network_and_fetch_event_source;
  }
  ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr& get_race_network_and_fetch_event_source() {
    CHECK(tag_ == Tag::kRaceNetworkAndFetchEventSource);
    return data_.race_network_and_fetch_event_source;
  }
  void set_race_network_and_fetch_event_source(ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr race_network_and_fetch_event_source);

  bool is_fetch_event_source() const { return tag_ == Tag::kFetchEventSource; }
  const ServiceWorkerRouterFetchEventSourcePtr& get_fetch_event_source() const {
    CHECK(tag_ == Tag::kFetchEventSource);
    return data_.fetch_event_source;
  }
  ServiceWorkerRouterFetchEventSourcePtr& get_fetch_event_source() {
    CHECK(tag_ == Tag::kFetchEventSource);
    return data_.fetch_event_source;
  }
  void set_fetch_event_source(ServiceWorkerRouterFetchEventSourcePtr fetch_event_source);

  bool is_cache_source() const { return tag_ == Tag::kCacheSource; }
  const ServiceWorkerRouterCacheSourcePtr& get_cache_source() const {
    CHECK(tag_ == Tag::kCacheSource);
    return data_.cache_source;
  }
  ServiceWorkerRouterCacheSourcePtr& get_cache_source() {
    CHECK(tag_ == Tag::kCacheSource);
    return data_.cache_source;
  }
  void set_cache_source(ServiceWorkerRouterCacheSourcePtr cache_source);

  bool is_race_network_and_cache_source() const { return tag_ == Tag::kRaceNetworkAndCacheSource; }
  const ServiceWorkerRouterRaceNetworkAndCacheSourcePtr& get_race_network_and_cache_source() const {
    CHECK(tag_ == Tag::kRaceNetworkAndCacheSource);
    return data_.race_network_and_cache_source;
  }
  ServiceWorkerRouterRaceNetworkAndCacheSourcePtr& get_race_network_and_cache_source() {
    CHECK(tag_ == Tag::kRaceNetworkAndCacheSource);
    return data_.race_network_and_cache_source;
  }
  void set_race_network_and_cache_source(ServiceWorkerRouterRaceNetworkAndCacheSourcePtr race_network_and_cache_source);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterSource::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNetworkSource)>,
        ServiceWorkerRouterNetworkSourcePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRaceNetworkAndFetchEventSource)>,
        ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFetchEventSource)>,
        ServiceWorkerRouterFetchEventSourcePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCacheSource)>,
        ServiceWorkerRouterCacheSourcePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRaceNetworkAndCacheSource)>,
        ServiceWorkerRouterRaceNetworkAndCacheSourcePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ServiceWorkerRouterNetworkSourcePtr network_source;
    ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr race_network_and_fetch_event_source;
    ServiceWorkerRouterFetchEventSourcePtr fetch_event_source;
    ServiceWorkerRouterCacheSourcePtr cache_source;
    ServiceWorkerRouterRaceNetworkAndCacheSourcePtr race_network_and_cache_source;
  };

  ServiceWorkerRouterSource(
      std::in_place_index_t<static_cast<size_t>(Tag::kNetworkSource)>,
      ServiceWorkerRouterNetworkSourcePtr value);
  ServiceWorkerRouterSource(
      std::in_place_index_t<static_cast<size_t>(Tag::kRaceNetworkAndFetchEventSource)>,
      ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr value);
  ServiceWorkerRouterSource(
      std::in_place_index_t<static_cast<size_t>(Tag::kFetchEventSource)>,
      ServiceWorkerRouterFetchEventSourcePtr value);
  ServiceWorkerRouterSource(
      std::in_place_index_t<static_cast<size_t>(Tag::kCacheSource)>,
      ServiceWorkerRouterCacheSourcePtr value);
  ServiceWorkerRouterSource(
      std::in_place_index_t<static_cast<size_t>(Tag::kRaceNetworkAndCacheSource)>,
      ServiceWorkerRouterRaceNetworkAndCacheSourcePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class BLINK_COMMON_EXPORT ServiceWorkerRouterRequestCondition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterRequestCondition, T>::value>;
  using DataView = ServiceWorkerRouterRequestConditionDataView;
  using Data_ = internal::ServiceWorkerRouterRequestCondition_Data;

  template <typename... Args>
  static ServiceWorkerRouterRequestConditionPtr New(Args&&... args) {
    return ServiceWorkerRouterRequestConditionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterRequestConditionPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterRequestConditionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterRequestCondition>::Convert(*this);
  }


  ServiceWorkerRouterRequestCondition();

  ServiceWorkerRouterRequestCondition(
      const std::optional<std::string>& method,
      bool has_mode,
      ::network::mojom::RequestMode mode,
      bool has_destination,
      ::network::mojom::RequestDestination destination);


  ~ServiceWorkerRouterRequestCondition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterRequestConditionPtr>
  ServiceWorkerRouterRequestConditionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterRequestCondition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterRequestCondition::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterRequestCondition::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterRequestCondition::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterRequestCondition::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterRequestCondition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterRequestCondition_UnserializedMessageContext<
            UserType, ServiceWorkerRouterRequestCondition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterRequestCondition::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterRequestCondition::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterRequestCondition_UnserializedMessageContext<
            UserType, ServiceWorkerRouterRequestCondition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterRequestCondition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> method;
  
  bool has_mode;
  
  ::network::mojom::RequestMode mode;
  
  bool has_destination;
  
  ::network::mojom::RequestDestination destination;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterRequestCondition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterRequestCondition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterRequestCondition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterRequestCondition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ServiceWorkerRouterOrCondition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterOrCondition, T>::value>;
  using DataView = ServiceWorkerRouterOrConditionDataView;
  using Data_ = internal::ServiceWorkerRouterOrCondition_Data;

  template <typename... Args>
  static ServiceWorkerRouterOrConditionPtr New(Args&&... args) {
    return ServiceWorkerRouterOrConditionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterOrConditionPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterOrConditionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterOrCondition>::Convert(*this);
  }


  ServiceWorkerRouterOrCondition();

  explicit ServiceWorkerRouterOrCondition(
      std::vector<ServiceWorkerRouterConditionPtr> conditions);

ServiceWorkerRouterOrCondition(const ServiceWorkerRouterOrCondition&) = delete;
ServiceWorkerRouterOrCondition& operator=(const ServiceWorkerRouterOrCondition&) = delete;

  ~ServiceWorkerRouterOrCondition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterOrConditionPtr>
  ServiceWorkerRouterOrConditionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterOrCondition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterOrCondition::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterOrCondition::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterOrCondition::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterOrCondition::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterOrCondition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterOrCondition_UnserializedMessageContext<
            UserType, ServiceWorkerRouterOrCondition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterOrCondition::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterOrCondition::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterOrCondition_UnserializedMessageContext<
            UserType, ServiceWorkerRouterOrCondition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterOrCondition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<ServiceWorkerRouterConditionPtr> conditions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterOrCondition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterOrCondition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterOrCondition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterOrCondition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ServiceWorkerRouterNotCondition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterNotCondition, T>::value>;
  using DataView = ServiceWorkerRouterNotConditionDataView;
  using Data_ = internal::ServiceWorkerRouterNotCondition_Data;

  template <typename... Args>
  static ServiceWorkerRouterNotConditionPtr New(Args&&... args) {
    return ServiceWorkerRouterNotConditionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterNotConditionPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterNotConditionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterNotCondition>::Convert(*this);
  }


  ServiceWorkerRouterNotCondition();

  explicit ServiceWorkerRouterNotCondition(
      ServiceWorkerRouterConditionPtr condition);

ServiceWorkerRouterNotCondition(const ServiceWorkerRouterNotCondition&) = delete;
ServiceWorkerRouterNotCondition& operator=(const ServiceWorkerRouterNotCondition&) = delete;

  ~ServiceWorkerRouterNotCondition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterNotConditionPtr>
  ServiceWorkerRouterNotConditionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterNotCondition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterNotCondition::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterNotCondition::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterNotCondition::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterNotCondition::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterNotCondition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterNotCondition_UnserializedMessageContext<
            UserType, ServiceWorkerRouterNotCondition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterNotCondition::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterNotCondition::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterNotCondition_UnserializedMessageContext<
            UserType, ServiceWorkerRouterNotCondition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterNotCondition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ServiceWorkerRouterConditionPtr condition;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterNotCondition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterNotCondition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterNotCondition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterNotCondition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ServiceWorkerRouterCondition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterCondition, T>::value>;
  using DataView = ServiceWorkerRouterConditionDataView;
  using Data_ = internal::ServiceWorkerRouterCondition_Data;

  template <typename... Args>
  static ServiceWorkerRouterConditionPtr New(Args&&... args) {
    return ServiceWorkerRouterConditionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterConditionPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterConditionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterCondition>::Convert(*this);
  }


  ServiceWorkerRouterCondition();

  ServiceWorkerRouterCondition(
      const std::optional<::blink::SafeUrlPattern>& url_pattern,
      ServiceWorkerRouterRequestConditionPtr request,
      ServiceWorkerRouterRunningStatusConditionPtr running_status,
      ServiceWorkerRouterOrConditionPtr or_condition,
      ServiceWorkerRouterNotConditionPtr not_condition);

ServiceWorkerRouterCondition(const ServiceWorkerRouterCondition&) = delete;
ServiceWorkerRouterCondition& operator=(const ServiceWorkerRouterCondition&) = delete;

  ~ServiceWorkerRouterCondition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterConditionPtr>
  ServiceWorkerRouterConditionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterCondition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterCondition::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterCondition::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterCondition::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterCondition::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterCondition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterCondition_UnserializedMessageContext<
            UserType, ServiceWorkerRouterCondition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterCondition::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterCondition::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterCondition_UnserializedMessageContext<
            UserType, ServiceWorkerRouterCondition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterCondition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::blink::SafeUrlPattern> url_pattern;
  
  ServiceWorkerRouterRequestConditionPtr request;
  
  ServiceWorkerRouterRunningStatusConditionPtr running_status;
  
  ServiceWorkerRouterOrConditionPtr or_condition;
  
  ServiceWorkerRouterNotConditionPtr not_condition;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterCondition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterCondition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterCondition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterCondition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_COMMON_EXPORT ServiceWorkerRouterRaceNetworkAndCacheSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterRaceNetworkAndCacheSource, T>::value>;
  using DataView = ServiceWorkerRouterRaceNetworkAndCacheSourceDataView;
  using Data_ = internal::ServiceWorkerRouterRaceNetworkAndCacheSource_Data;

  template <typename... Args>
  static ServiceWorkerRouterRaceNetworkAndCacheSourcePtr New(Args&&... args) {
    return ServiceWorkerRouterRaceNetworkAndCacheSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterRaceNetworkAndCacheSourcePtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterRaceNetworkAndCacheSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterRaceNetworkAndCacheSource>::Convert(*this);
  }


  ServiceWorkerRouterRaceNetworkAndCacheSource();

  explicit ServiceWorkerRouterRaceNetworkAndCacheSource(
      ServiceWorkerRouterCacheSourcePtr cache_source);

ServiceWorkerRouterRaceNetworkAndCacheSource(const ServiceWorkerRouterRaceNetworkAndCacheSource&) = delete;
ServiceWorkerRouterRaceNetworkAndCacheSource& operator=(const ServiceWorkerRouterRaceNetworkAndCacheSource&) = delete;

  ~ServiceWorkerRouterRaceNetworkAndCacheSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterRaceNetworkAndCacheSourcePtr>
  ServiceWorkerRouterRaceNetworkAndCacheSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterRaceNetworkAndCacheSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterRaceNetworkAndCacheSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterRaceNetworkAndCacheSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterRaceNetworkAndCacheSource::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterRaceNetworkAndCacheSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterRaceNetworkAndCacheSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterRaceNetworkAndCacheSource_UnserializedMessageContext<
            UserType, ServiceWorkerRouterRaceNetworkAndCacheSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterRaceNetworkAndCacheSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterRaceNetworkAndCacheSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterRaceNetworkAndCacheSource_UnserializedMessageContext<
            UserType, ServiceWorkerRouterRaceNetworkAndCacheSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterRaceNetworkAndCacheSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ServiceWorkerRouterCacheSourcePtr cache_source;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterRaceNetworkAndCacheSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterRaceNetworkAndCacheSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterRaceNetworkAndCacheSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterRaceNetworkAndCacheSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ServiceWorkerRouterRule {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterRule, T>::value>;
  using DataView = ServiceWorkerRouterRuleDataView;
  using Data_ = internal::ServiceWorkerRouterRule_Data;

  template <typename... Args>
  static ServiceWorkerRouterRulePtr New(Args&&... args) {
    return ServiceWorkerRouterRulePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterRulePtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterRulePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterRule>::Convert(*this);
  }


  ServiceWorkerRouterRule();

  ServiceWorkerRouterRule(
      ServiceWorkerRouterConditionPtr condition,
      std::vector<ServiceWorkerRouterSourcePtr> sources);

ServiceWorkerRouterRule(const ServiceWorkerRouterRule&) = delete;
ServiceWorkerRouterRule& operator=(const ServiceWorkerRouterRule&) = delete;

  ~ServiceWorkerRouterRule();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterRulePtr>
  ServiceWorkerRouterRulePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterRule::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterRule::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterRule::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterRule::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterRule::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterRule::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterRule_UnserializedMessageContext<
            UserType, ServiceWorkerRouterRule::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterRule::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterRule::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterRule_UnserializedMessageContext<
            UserType, ServiceWorkerRouterRule::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterRule::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ServiceWorkerRouterConditionPtr condition;
  
  std::vector<ServiceWorkerRouterSourcePtr> sources;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterRule::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterRule::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterRule::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterRule::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ServiceWorkerRouterRules {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterRules, T>::value>;
  using DataView = ServiceWorkerRouterRulesDataView;
  using Data_ = internal::ServiceWorkerRouterRules_Data;

  template <typename... Args>
  static ServiceWorkerRouterRulesPtr New(Args&&... args) {
    return ServiceWorkerRouterRulesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterRulesPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterRulesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterRules>::Convert(*this);
  }


  ServiceWorkerRouterRules();

  explicit ServiceWorkerRouterRules(
      std::vector<ServiceWorkerRouterRulePtr> rules);

ServiceWorkerRouterRules(const ServiceWorkerRouterRules&) = delete;
ServiceWorkerRouterRules& operator=(const ServiceWorkerRouterRules&) = delete;

  ~ServiceWorkerRouterRules();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterRulesPtr>
  ServiceWorkerRouterRulesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterRules::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterRules::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterRules::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterRules::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterRules::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterRules::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterRules_UnserializedMessageContext<
            UserType, ServiceWorkerRouterRules::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterRules::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterRules::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterRules_UnserializedMessageContext<
            UserType, ServiceWorkerRouterRules::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterRules::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<ServiceWorkerRouterRulePtr> rules;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterRules::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterRules::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterRules::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterRules::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ServiceWorkerRouterSourcePtr ServiceWorkerRouterSource::Clone() const {
  switch (tag_) {
    case Tag::kNetworkSource:
      return NewNetworkSource(
          mojo::Clone(data_.network_source));
    case Tag::kRaceNetworkAndFetchEventSource:
      return NewRaceNetworkAndFetchEventSource(
          mojo::Clone(data_.race_network_and_fetch_event_source));
    case Tag::kFetchEventSource:
      return NewFetchEventSource(
          mojo::Clone(data_.fetch_event_source));
    case Tag::kCacheSource:
      return NewCacheSource(
          mojo::Clone(data_.cache_source));
    case Tag::kRaceNetworkAndCacheSource:
      return NewRaceNetworkAndCacheSource(
          mojo::Clone(data_.race_network_and_cache_source));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ServiceWorkerRouterSource>::value>::type*>
bool ServiceWorkerRouterSource::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNetworkSource:
      return mojo::Equals(data_.network_source, other.data_.network_source);
    case Tag::kRaceNetworkAndFetchEventSource:
      return mojo::Equals(data_.race_network_and_fetch_event_source, other.data_.race_network_and_fetch_event_source);
    case Tag::kFetchEventSource:
      return mojo::Equals(data_.fetch_event_source, other.data_.fetch_event_source);
    case Tag::kCacheSource:
      return mojo::Equals(data_.cache_source, other.data_.cache_source);
    case Tag::kRaceNetworkAndCacheSource:
      return mojo::Equals(data_.race_network_and_cache_source, other.data_.race_network_and_cache_source);
  }

  return false;
}
template <typename StructPtrType>
ServiceWorkerRouterRunningStatusConditionPtr ServiceWorkerRouterRunningStatusCondition::Clone() const {
  return New(
      mojo::Clone(status)
  );
}

template <typename T, ServiceWorkerRouterRunningStatusCondition::EnableIfSame<T>*>
bool ServiceWorkerRouterRunningStatusCondition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  return true;
}

template <typename T, ServiceWorkerRouterRunningStatusCondition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerRouterRequestConditionPtr ServiceWorkerRouterRequestCondition::Clone() const {
  return New(
      mojo::Clone(method),
      mojo::Clone(has_mode),
      mojo::Clone(mode),
      mojo::Clone(has_destination),
      mojo::Clone(destination)
  );
}

template <typename T, ServiceWorkerRouterRequestCondition::EnableIfSame<T>*>
bool ServiceWorkerRouterRequestCondition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->has_mode, other_struct.has_mode))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->has_destination, other_struct.has_destination))
    return false;
  if (!mojo::Equals(this->destination, other_struct.destination))
    return false;
  return true;
}

template <typename T, ServiceWorkerRouterRequestCondition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.method < rhs.method)
    return true;
  if (rhs.method < lhs.method)
    return false;
  if (lhs.has_mode < rhs.has_mode)
    return true;
  if (rhs.has_mode < lhs.has_mode)
    return false;
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.has_destination < rhs.has_destination)
    return true;
  if (rhs.has_destination < lhs.has_destination)
    return false;
  if (lhs.destination < rhs.destination)
    return true;
  if (rhs.destination < lhs.destination)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerRouterOrConditionPtr ServiceWorkerRouterOrCondition::Clone() const {
  return New(
      mojo::Clone(conditions)
  );
}

template <typename T, ServiceWorkerRouterOrCondition::EnableIfSame<T>*>
bool ServiceWorkerRouterOrCondition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->conditions, other_struct.conditions))
    return false;
  return true;
}

template <typename T, ServiceWorkerRouterOrCondition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.conditions < rhs.conditions)
    return true;
  if (rhs.conditions < lhs.conditions)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerRouterNotConditionPtr ServiceWorkerRouterNotCondition::Clone() const {
  return New(
      mojo::Clone(condition)
  );
}

template <typename T, ServiceWorkerRouterNotCondition::EnableIfSame<T>*>
bool ServiceWorkerRouterNotCondition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->condition, other_struct.condition))
    return false;
  return true;
}

template <typename T, ServiceWorkerRouterNotCondition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.condition < rhs.condition)
    return true;
  if (rhs.condition < lhs.condition)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerRouterConditionPtr ServiceWorkerRouterCondition::Clone() const {
  return New(
      mojo::Clone(url_pattern),
      mojo::Clone(request),
      mojo::Clone(running_status),
      mojo::Clone(or_condition),
      mojo::Clone(not_condition)
  );
}

template <typename T, ServiceWorkerRouterCondition::EnableIfSame<T>*>
bool ServiceWorkerRouterCondition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url_pattern, other_struct.url_pattern))
    return false;
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->running_status, other_struct.running_status))
    return false;
  if (!mojo::Equals(this->or_condition, other_struct.or_condition))
    return false;
  if (!mojo::Equals(this->not_condition, other_struct.not_condition))
    return false;
  return true;
}

template <typename T, ServiceWorkerRouterCondition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url_pattern < rhs.url_pattern)
    return true;
  if (rhs.url_pattern < lhs.url_pattern)
    return false;
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  if (lhs.running_status < rhs.running_status)
    return true;
  if (rhs.running_status < lhs.running_status)
    return false;
  if (lhs.or_condition < rhs.or_condition)
    return true;
  if (rhs.or_condition < lhs.or_condition)
    return false;
  if (lhs.not_condition < rhs.not_condition)
    return true;
  if (rhs.not_condition < lhs.not_condition)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerRouterNetworkSourcePtr ServiceWorkerRouterNetworkSource::Clone() const {
  return New(
  );
}

template <typename T, ServiceWorkerRouterNetworkSource::EnableIfSame<T>*>
bool ServiceWorkerRouterNetworkSource::Equals(const T& other_struct) const {
  return true;
}

template <typename T, ServiceWorkerRouterNetworkSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr ServiceWorkerRouterRaceNetworkAndFetchEventSource::Clone() const {
  return New(
  );
}

template <typename T, ServiceWorkerRouterRaceNetworkAndFetchEventSource::EnableIfSame<T>*>
bool ServiceWorkerRouterRaceNetworkAndFetchEventSource::Equals(const T& other_struct) const {
  return true;
}

template <typename T, ServiceWorkerRouterRaceNetworkAndFetchEventSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
ServiceWorkerRouterFetchEventSourcePtr ServiceWorkerRouterFetchEventSource::Clone() const {
  return New(
  );
}

template <typename T, ServiceWorkerRouterFetchEventSource::EnableIfSame<T>*>
bool ServiceWorkerRouterFetchEventSource::Equals(const T& other_struct) const {
  return true;
}

template <typename T, ServiceWorkerRouterFetchEventSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
ServiceWorkerRouterCacheSourcePtr ServiceWorkerRouterCacheSource::Clone() const {
  return New(
      mojo::Clone(cache_name)
  );
}

template <typename T, ServiceWorkerRouterCacheSource::EnableIfSame<T>*>
bool ServiceWorkerRouterCacheSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cache_name, other_struct.cache_name))
    return false;
  return true;
}

template <typename T, ServiceWorkerRouterCacheSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cache_name < rhs.cache_name)
    return true;
  if (rhs.cache_name < lhs.cache_name)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerRouterRaceNetworkAndCacheSourcePtr ServiceWorkerRouterRaceNetworkAndCacheSource::Clone() const {
  return New(
      mojo::Clone(cache_source)
  );
}

template <typename T, ServiceWorkerRouterRaceNetworkAndCacheSource::EnableIfSame<T>*>
bool ServiceWorkerRouterRaceNetworkAndCacheSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cache_source, other_struct.cache_source))
    return false;
  return true;
}

template <typename T, ServiceWorkerRouterRaceNetworkAndCacheSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cache_source < rhs.cache_source)
    return true;
  if (rhs.cache_source < lhs.cache_source)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerRouterRulePtr ServiceWorkerRouterRule::Clone() const {
  return New(
      mojo::Clone(condition),
      mojo::Clone(sources)
  );
}

template <typename T, ServiceWorkerRouterRule::EnableIfSame<T>*>
bool ServiceWorkerRouterRule::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->condition, other_struct.condition))
    return false;
  if (!mojo::Equals(this->sources, other_struct.sources))
    return false;
  return true;
}

template <typename T, ServiceWorkerRouterRule::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.condition < rhs.condition)
    return true;
  if (rhs.condition < lhs.condition)
    return false;
  if (lhs.sources < rhs.sources)
    return true;
  if (rhs.sources < lhs.sources)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerRouterRulesPtr ServiceWorkerRouterRules::Clone() const {
  return New(
      mojo::Clone(rules)
  );
}

template <typename T, ServiceWorkerRouterRules::EnableIfSame<T>*>
bool ServiceWorkerRouterRules::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rules, other_struct.rules))
    return false;
  return true;
}

template <typename T, ServiceWorkerRouterRules::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rules < rhs.rules)
    return true;
  if (rhs.rules < lhs.rules)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterRunningStatusCondition::DataView,
                                         ::blink::mojom::ServiceWorkerRouterRunningStatusConditionPtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterRunningStatusConditionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterRunningStatusConditionPtr* output) { output->reset(); }

  static decltype(::blink::mojom::ServiceWorkerRouterRunningStatusCondition::status) status(
      const ::blink::mojom::ServiceWorkerRouterRunningStatusConditionPtr& input) {
    return input->status;
  }

  static bool Read(::blink::mojom::ServiceWorkerRouterRunningStatusCondition::DataView input, ::blink::mojom::ServiceWorkerRouterRunningStatusConditionPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterRequestCondition::DataView,
                                         ::blink::mojom::ServiceWorkerRouterRequestConditionPtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterRequestConditionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterRequestConditionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ServiceWorkerRouterRequestCondition::method)& method(
      const ::blink::mojom::ServiceWorkerRouterRequestConditionPtr& input) {
    return input->method;
  }

  static decltype(::blink::mojom::ServiceWorkerRouterRequestCondition::has_mode) has_mode(
      const ::blink::mojom::ServiceWorkerRouterRequestConditionPtr& input) {
    return input->has_mode;
  }

  static decltype(::blink::mojom::ServiceWorkerRouterRequestCondition::mode) mode(
      const ::blink::mojom::ServiceWorkerRouterRequestConditionPtr& input) {
    return input->mode;
  }

  static decltype(::blink::mojom::ServiceWorkerRouterRequestCondition::has_destination) has_destination(
      const ::blink::mojom::ServiceWorkerRouterRequestConditionPtr& input) {
    return input->has_destination;
  }

  static decltype(::blink::mojom::ServiceWorkerRouterRequestCondition::destination) destination(
      const ::blink::mojom::ServiceWorkerRouterRequestConditionPtr& input) {
    return input->destination;
  }

  static bool Read(::blink::mojom::ServiceWorkerRouterRequestCondition::DataView input, ::blink::mojom::ServiceWorkerRouterRequestConditionPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterOrCondition::DataView,
                                         ::blink::mojom::ServiceWorkerRouterOrConditionPtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterOrConditionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterOrConditionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ServiceWorkerRouterOrCondition::conditions)& conditions(
      const ::blink::mojom::ServiceWorkerRouterOrConditionPtr& input) {
    return input->conditions;
  }

  static bool Read(::blink::mojom::ServiceWorkerRouterOrCondition::DataView input, ::blink::mojom::ServiceWorkerRouterOrConditionPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterNotCondition::DataView,
                                         ::blink::mojom::ServiceWorkerRouterNotConditionPtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterNotConditionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterNotConditionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ServiceWorkerRouterNotCondition::condition)& condition(
      const ::blink::mojom::ServiceWorkerRouterNotConditionPtr& input) {
    return input->condition;
  }

  static bool Read(::blink::mojom::ServiceWorkerRouterNotCondition::DataView input, ::blink::mojom::ServiceWorkerRouterNotConditionPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterCondition::DataView,
                                         ::blink::mojom::ServiceWorkerRouterConditionPtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterConditionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterConditionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ServiceWorkerRouterCondition::url_pattern)& url_pattern(
      const ::blink::mojom::ServiceWorkerRouterConditionPtr& input) {
    return input->url_pattern;
  }

  static const decltype(::blink::mojom::ServiceWorkerRouterCondition::request)& request(
      const ::blink::mojom::ServiceWorkerRouterConditionPtr& input) {
    return input->request;
  }

  static const decltype(::blink::mojom::ServiceWorkerRouterCondition::running_status)& running_status(
      const ::blink::mojom::ServiceWorkerRouterConditionPtr& input) {
    return input->running_status;
  }

  static const decltype(::blink::mojom::ServiceWorkerRouterCondition::or_condition)& or_condition(
      const ::blink::mojom::ServiceWorkerRouterConditionPtr& input) {
    return input->or_condition;
  }

  static const decltype(::blink::mojom::ServiceWorkerRouterCondition::not_condition)& not_condition(
      const ::blink::mojom::ServiceWorkerRouterConditionPtr& input) {
    return input->not_condition;
  }

  static bool Read(::blink::mojom::ServiceWorkerRouterCondition::DataView input, ::blink::mojom::ServiceWorkerRouterConditionPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterNetworkSource::DataView,
                                         ::blink::mojom::ServiceWorkerRouterNetworkSourcePtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterNetworkSourcePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterNetworkSourcePtr* output) { output->reset(); }

  static bool Read(::blink::mojom::ServiceWorkerRouterNetworkSource::DataView input, ::blink::mojom::ServiceWorkerRouterNetworkSourcePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSource::DataView,
                                         ::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr* output) { output->reset(); }

  static bool Read(::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSource::DataView input, ::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterFetchEventSource::DataView,
                                         ::blink::mojom::ServiceWorkerRouterFetchEventSourcePtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterFetchEventSourcePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterFetchEventSourcePtr* output) { output->reset(); }

  static bool Read(::blink::mojom::ServiceWorkerRouterFetchEventSource::DataView input, ::blink::mojom::ServiceWorkerRouterFetchEventSourcePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterCacheSource::DataView,
                                         ::blink::mojom::ServiceWorkerRouterCacheSourcePtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterCacheSourcePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterCacheSourcePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ServiceWorkerRouterCacheSource::cache_name)& cache_name(
      const ::blink::mojom::ServiceWorkerRouterCacheSourcePtr& input) {
    return input->cache_name;
  }

  static bool Read(::blink::mojom::ServiceWorkerRouterCacheSource::DataView input, ::blink::mojom::ServiceWorkerRouterCacheSourcePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSource::DataView,
                                         ::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSourcePtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSourcePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSourcePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSource::cache_source)& cache_source(
      const ::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSourcePtr& input) {
    return input->cache_source;
  }

  static bool Read(::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSource::DataView input, ::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSourcePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterRule::DataView,
                                         ::blink::mojom::ServiceWorkerRouterRulePtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterRulePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterRulePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ServiceWorkerRouterRule::condition)& condition(
      const ::blink::mojom::ServiceWorkerRouterRulePtr& input) {
    return input->condition;
  }

  static const decltype(::blink::mojom::ServiceWorkerRouterRule::sources)& sources(
      const ::blink::mojom::ServiceWorkerRouterRulePtr& input) {
    return input->sources;
  }

  static bool Read(::blink::mojom::ServiceWorkerRouterRule::DataView input, ::blink::mojom::ServiceWorkerRouterRulePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterRules::DataView,
                                         ::blink::mojom::ServiceWorkerRouterRulesPtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterRulesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterRulesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ServiceWorkerRouterRules::rules)& rules(
      const ::blink::mojom::ServiceWorkerRouterRulesPtr& input) {
    return input->rules;
  }

  static bool Read(::blink::mojom::ServiceWorkerRouterRules::DataView input, ::blink::mojom::ServiceWorkerRouterRulesPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::ServiceWorkerRouterSource::DataView,
                                        ::blink::mojom::ServiceWorkerRouterSourcePtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterSourcePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterSourcePtr* output) { output->reset(); }

  static ::blink::mojom::ServiceWorkerRouterSource::Tag GetTag(const ::blink::mojom::ServiceWorkerRouterSourcePtr& input) {
    return input->which();
  }

  static const ::blink::mojom::ServiceWorkerRouterNetworkSourcePtr& network_source(const ::blink::mojom::ServiceWorkerRouterSourcePtr& input) {
    return input->get_network_source();
  }

  static const ::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr& race_network_and_fetch_event_source(const ::blink::mojom::ServiceWorkerRouterSourcePtr& input) {
    return input->get_race_network_and_fetch_event_source();
  }

  static const ::blink::mojom::ServiceWorkerRouterFetchEventSourcePtr& fetch_event_source(const ::blink::mojom::ServiceWorkerRouterSourcePtr& input) {
    return input->get_fetch_event_source();
  }

  static const ::blink::mojom::ServiceWorkerRouterCacheSourcePtr& cache_source(const ::blink::mojom::ServiceWorkerRouterSourcePtr& input) {
    return input->get_cache_source();
  }

  static const ::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSourcePtr& race_network_and_cache_source(const ::blink::mojom::ServiceWorkerRouterSourcePtr& input) {
    return input->get_race_network_and_cache_source();
  }

  static bool Read(::blink::mojom::ServiceWorkerRouterSource::DataView input, ::blink::mojom::ServiceWorkerRouterSourcePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_ROUTER_RULE_MOJOM_H_