// third_party/blink/public/mojom/service_worker/service_worker_registration.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  FetchClientSettingsObject as blink_mojom_FetchClientSettingsObject,
  FetchClientSettingsObjectSpec as blink_mojom_FetchClientSettingsObjectSpec
} from '../loader/fetch_client_settings_object.mojom.m.js';

import {
  NavigationPreloadState as blink_mojom_NavigationPreloadState,
  NavigationPreloadStateSpec as blink_mojom_NavigationPreloadStateSpec
} from './navigation_preload_state.mojom.m.js';

import {
  ServiceWorkerErrorType as blink_mojom_ServiceWorkerErrorType,
  ServiceWorkerErrorTypeSpec as blink_mojom_ServiceWorkerErrorTypeSpec
} from './service_worker_error_type.mojom.m.js';

import {
  ServiceWorkerObjectInfo as blink_mojom_ServiceWorkerObjectInfo,
  ServiceWorkerObjectInfoSpec as blink_mojom_ServiceWorkerObjectInfoSpec
} from './service_worker_object.mojom.m.js';

import {
  ServiceWorkerUpdateViaCache as blink_mojom_ServiceWorkerUpdateViaCache,
  ServiceWorkerUpdateViaCacheSpec as blink_mojom_ServiceWorkerUpdateViaCacheSpec
} from './service_worker_registration_options.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerRegistrationObjectHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerRegistrationObjectHost', scope);
  }
}

/** @interface */
export class ServiceWorkerRegistrationObjectHostInterface {
  
  /**
   * @param { !blink_mojom_FetchClientSettingsObject } outsideFetchClientSettingsObject
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  update(outsideFetchClientSettingsObject) {}
  
  /**
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  unregister() {}
  
  /**
   * @param { !boolean } enable
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  enableNavigationPreload(enable) {}
  
  /**
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
        state: ?blink_mojom_NavigationPreloadState,
   *  }>}
   */

  getNavigationPreloadState() {}
  
  /**
   * @param { !string } value
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  setNavigationPreloadHeader(value) {}
}

/**
 * @implements { ServiceWorkerRegistrationObjectHostInterface }
 */
export class ServiceWorkerRegistrationObjectHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerRegistrationObjectHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerRegistrationObjectHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerRegistrationObjectHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_FetchClientSettingsObject } outsideFetchClientSettingsObject
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  update(
      outsideFetchClientSettingsObject) {
    return this.proxy.sendMessage(
        0,
        ServiceWorkerRegistrationObjectHost_Update_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_Update_ResponseParamsSpec.$,
        [
          outsideFetchClientSettingsObject
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  unregister() {
    return this.proxy.sendMessage(
        1,
        ServiceWorkerRegistrationObjectHost_Unregister_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  enableNavigationPreload(
      enable) {
    return this.proxy.sendMessage(
        2,
        ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsSpec.$,
        [
          enable
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
        state: ?blink_mojom_NavigationPreloadState,
   *  }>}
   */

  getNavigationPreloadState() {
    return this.proxy.sendMessage(
        3,
        ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } value
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  setNavigationPreloadHeader(
      value) {
    return this.proxy.sendMessage(
        4,
        ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerRegistrationObjectHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerRegistrationObjectHostReceiver {
  /**
   * @param {!ServiceWorkerRegistrationObjectHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerRegistrationObjectHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerRegistrationObjectHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerRegistrationObjectHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerRegistrationObjectHost_Update_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_Update_ResponseParamsSpec.$,
        impl.update.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerRegistrationObjectHost_Unregister_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsSpec.$,
        impl.unregister.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsSpec.$,
        impl.enableNavigationPreload.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsSpec.$,
        impl.getNavigationPreloadState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsSpec.$,
        impl.setNavigationPreloadHeader.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerRegistrationObjectHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerRegistrationObjectHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerRegistrationObjectHostRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerRegistrationObjectHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerRegistrationObjectHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerRegistrationObjectHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerRegistrationObjectHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerRegistrationObjectHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.update =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerRegistrationObjectHost_Update_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_Update_ResponseParamsSpec.$,
        this.update.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unregister =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerRegistrationObjectHost_Unregister_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsSpec.$,
        this.unregister.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableNavigationPreload =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsSpec.$,
        this.enableNavigationPreload.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNavigationPreloadState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsSpec.$,
        this.getNavigationPreloadState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNavigationPreloadHeader =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsSpec.$,
        ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsSpec.$,
        this.setNavigationPreloadHeader.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerRegistrationObjectPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerRegistrationObject', scope);
  }
}

/** @interface */
export class ServiceWorkerRegistrationObjectInterface {
  
  /**
   * @param { !ChangedServiceWorkerObjectsMask } changedMask
   * @param { ?blink_mojom_ServiceWorkerObjectInfo } installing
   * @param { ?blink_mojom_ServiceWorkerObjectInfo } waiting
   * @param { ?blink_mojom_ServiceWorkerObjectInfo } active
   */

  setServiceWorkerObjects(changedMask, installing, waiting, active) {}
  
  /**
   * @param { !blink_mojom_ServiceWorkerUpdateViaCache } updateViaCache
   */

  setUpdateViaCache(updateViaCache) {}
  
  /**
   */

  updateFound() {}
}

/**
 * @implements { ServiceWorkerRegistrationObjectInterface }
 */
export class ServiceWorkerRegistrationObjectRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerRegistrationObjectPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerRegistrationObjectPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerRegistrationObjectPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ChangedServiceWorkerObjectsMask } changedMask
   * @param { ?blink_mojom_ServiceWorkerObjectInfo } installing
   * @param { ?blink_mojom_ServiceWorkerObjectInfo } waiting
   * @param { ?blink_mojom_ServiceWorkerObjectInfo } active
   */

  setServiceWorkerObjects(
      changedMask,
      installing,
      waiting,
      active) {
    this.proxy.sendMessage(
        0,
        ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsSpec.$,
        null,
        [
          changedMask,
          installing,
          waiting,
          active
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ServiceWorkerUpdateViaCache } updateViaCache
   */

  setUpdateViaCache(
      updateViaCache) {
    this.proxy.sendMessage(
        1,
        ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsSpec.$,
        null,
        [
          updateViaCache
        ],
        false);
  }

  
  /**
   */

  updateFound() {
    this.proxy.sendMessage(
        2,
        ServiceWorkerRegistrationObject_UpdateFound_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerRegistrationObject
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerRegistrationObjectReceiver {
  /**
   * @param {!ServiceWorkerRegistrationObjectInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerRegistrationObjectRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerRegistrationObjectRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerRegistrationObjectRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsSpec.$,
        null,
        impl.setServiceWorkerObjects.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsSpec.$,
        null,
        impl.setUpdateViaCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerRegistrationObject_UpdateFound_ParamsSpec.$,
        null,
        impl.updateFound.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerRegistrationObject {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerRegistrationObject";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerRegistrationObjectRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerRegistrationObjectRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerRegistrationObject
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerRegistrationObjectCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerRegistrationObjectRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerRegistrationObjectRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setServiceWorkerObjects =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsSpec.$,
        null,
        this.setServiceWorkerObjects.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setUpdateViaCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsSpec.$,
        null,
        this.setUpdateViaCache.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateFound =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerRegistrationObject_UpdateFound_ParamsSpec.$,
        null,
        this.updateFound.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ChangedServiceWorkerObjectsMaskSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObjectInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObjectHost_Update_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObjectHost_Update_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObjectHost_Unregister_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRegistrationObject_UpdateFound_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ChangedServiceWorkerObjectsMaskSpec.$,
    'ChangedServiceWorkerObjectsMask',
    [
      mojo.internal.StructField(
        'installing', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'waiting', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'active', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ChangedServiceWorkerObjectsMask {
  constructor() {
    /** @type { !boolean } */
    this.installing;
    /** @type { !boolean } */
    this.waiting;
    /** @type { !boolean } */
    this.active;
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObjectInfoSpec.$,
    'ServiceWorkerRegistrationObjectInfo',
    [
      mojo.internal.StructField(
        'registrationId', 0,
        0,
        mojo.internal.Int64,
        blink_mojom_INVALID_SERVICE_WORKER_REGISTRATION_ID,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scope', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updateViaCache', 16,
        0,
        blink_mojom_ServiceWorkerUpdateViaCacheSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostRemote', 20,
        0,
        mojo.internal.AssociatedInterfaceProxy(ServiceWorkerRegistrationObjectHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 28,
        0,
        mojo.internal.AssociatedInterfaceRequest(ServiceWorkerRegistrationObjectPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'installing', 32,
        0,
        blink_mojom_ServiceWorkerObjectInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'waiting', 40,
        0,
        blink_mojom_ServiceWorkerObjectInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'active', 48,
        0,
        blink_mojom_ServiceWorkerObjectInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObjectInfo {
  constructor() {
    /** @type { !bigint } */
    this.registrationId;
    /** @type { !url_mojom_Url } */
    this.scope;
    /** @type { !blink_mojom_ServiceWorkerUpdateViaCache } */
    this.updateViaCache;
    /** @type { !Object } */
    this.hostRemote;
    /** @type { !Object } */
    this.receiver;
    /** @type { (blink_mojom_ServiceWorkerObjectInfo|undefined) } */
    this.installing;
    /** @type { (blink_mojom_ServiceWorkerObjectInfo|undefined) } */
    this.waiting;
    /** @type { (blink_mojom_ServiceWorkerObjectInfo|undefined) } */
    this.active;
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObjectHost_Update_ParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_Update_Params',
    [
      mojo.internal.StructField(
        'outsideFetchClientSettingsObject', 0,
        0,
        blink_mojom_FetchClientSettingsObjectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObjectHost_Update_Params {
  constructor() {
    /** @type { !blink_mojom_FetchClientSettingsObject } */
    this.outsideFetchClientSettingsObject;
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObjectHost_Update_ResponseParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_Update_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_ServiceWorkerErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObjectHost_Update_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerErrorType } */
    this.error;
    /** @type { (string|undefined) } */
    this.errorMsg;
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObjectHost_Unregister_ParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_Unregister_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObjectHost_Unregister_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_ServiceWorkerErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerErrorType } */
    this.error;
    /** @type { (string|undefined) } */
    this.errorMsg;
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params {
  constructor() {
    /** @type { !boolean } */
    this.enable;
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_ServiceWorkerErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerErrorType } */
    this.error;
    /** @type { (string|undefined) } */
    this.errorMsg;
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_ServiceWorkerErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'state', 16,
        0,
        blink_mojom_NavigationPreloadStateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerErrorType } */
    this.error;
    /** @type { (string|undefined) } */
    this.errorMsg;
    /** @type { (blink_mojom_NavigationPreloadState|undefined) } */
    this.state;
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params {
  constructor() {
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_ServiceWorkerErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerErrorType } */
    this.error;
    /** @type { (string|undefined) } */
    this.errorMsg;
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsSpec.$,
    'ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params',
    [
      mojo.internal.StructField(
        'changedMask', 0,
        0,
        ChangedServiceWorkerObjectsMaskSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'installing', 8,
        0,
        blink_mojom_ServiceWorkerObjectInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'waiting', 16,
        0,
        blink_mojom_ServiceWorkerObjectInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'active', 24,
        0,
        blink_mojom_ServiceWorkerObjectInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params {
  constructor() {
    /** @type { !ChangedServiceWorkerObjectsMask } */
    this.changedMask;
    /** @type { (blink_mojom_ServiceWorkerObjectInfo|undefined) } */
    this.installing;
    /** @type { (blink_mojom_ServiceWorkerObjectInfo|undefined) } */
    this.waiting;
    /** @type { (blink_mojom_ServiceWorkerObjectInfo|undefined) } */
    this.active;
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsSpec.$,
    'ServiceWorkerRegistrationObject_SetUpdateViaCache_Params',
    [
      mojo.internal.StructField(
        'updateViaCache', 0,
        0,
        blink_mojom_ServiceWorkerUpdateViaCacheSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObject_SetUpdateViaCache_Params {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerUpdateViaCache } */
    this.updateViaCache;
  }
}



mojo.internal.Struct(
    ServiceWorkerRegistrationObject_UpdateFound_ParamsSpec.$,
    'ServiceWorkerRegistrationObject_UpdateFound_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerRegistrationObject_UpdateFound_Params {
  constructor() {
  }
}

