// third_party/blink/public/mojom/service_worker/service_worker_registration.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-import-headers.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-test-utils.h"


namespace blink::mojom {
ChangedServiceWorkerObjectsMask::ChangedServiceWorkerObjectsMask()
    : installing(),
      waiting(),
      active() {}

ChangedServiceWorkerObjectsMask::ChangedServiceWorkerObjectsMask(
    bool installing_in,
    bool waiting_in,
    bool active_in)
    : installing(std::move(installing_in)),
      waiting(std::move(waiting_in)),
      active(std::move(active_in)) {}

ChangedServiceWorkerObjectsMask::~ChangedServiceWorkerObjectsMask() = default;
size_t ChangedServiceWorkerObjectsMask::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->installing);
  seed = mojo::internal::Hash(seed, this->waiting);
  seed = mojo::internal::Hash(seed, this->active);
  return seed;
}

void ChangedServiceWorkerObjectsMask::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "installing"), this->installing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "waiting"), this->waiting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active"), this->active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ChangedServiceWorkerObjectsMask::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRegistrationObjectInfo::ServiceWorkerRegistrationObjectInfo()
    : registration_id(::blink::mojom::kInvalidServiceWorkerRegistrationId),
      scope(),
      update_via_cache(),
      host_remote(),
      receiver(),
      installing(),
      waiting(),
      active() {}

ServiceWorkerRegistrationObjectInfo::ServiceWorkerRegistrationObjectInfo(
    int64_t registration_id_in,
    const ::GURL& scope_in,
    ::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache_in,
    ::mojo::PendingAssociatedRemote<ServiceWorkerRegistrationObjectHost> host_remote_in,
    ::mojo::PendingAssociatedReceiver<ServiceWorkerRegistrationObject> receiver_in,
    ::blink::mojom::ServiceWorkerObjectInfoPtr installing_in,
    ::blink::mojom::ServiceWorkerObjectInfoPtr waiting_in,
    ::blink::mojom::ServiceWorkerObjectInfoPtr active_in)
    : registration_id(std::move(registration_id_in)),
      scope(std::move(scope_in)),
      update_via_cache(std::move(update_via_cache_in)),
      host_remote(std::move(host_remote_in)),
      receiver(std::move(receiver_in)),
      installing(std::move(installing_in)),
      waiting(std::move(waiting_in)),
      active(std::move(active_in)) {}

ServiceWorkerRegistrationObjectInfo::~ServiceWorkerRegistrationObjectInfo() = default;

void ServiceWorkerRegistrationObjectInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration_id"), this->registration_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope"), this->scope,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_via_cache"), this->update_via_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerUpdateViaCache>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_remote"), this->host_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<ServiceWorkerRegistrationObjectHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receiver"), this->receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<ServiceWorkerRegistrationObject>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "installing"), this->installing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerObjectInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "waiting"), this->waiting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerObjectInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active"), this->active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerObjectInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRegistrationObjectInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ServiceWorkerRegistrationObjectHost::IPCStableHashFunction ServiceWorkerRegistrationObjectHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerRegistrationObjectHost>(message.name())) {
    case messages::ServiceWorkerRegistrationObjectHost::kUpdate: {
      return &ServiceWorkerRegistrationObjectHost::Update_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerRegistrationObjectHost::kUnregister: {
      return &ServiceWorkerRegistrationObjectHost::Unregister_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerRegistrationObjectHost::kEnableNavigationPreload: {
      return &ServiceWorkerRegistrationObjectHost::EnableNavigationPreload_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerRegistrationObjectHost::kGetNavigationPreloadState: {
      return &ServiceWorkerRegistrationObjectHost::GetNavigationPreloadState_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerRegistrationObjectHost::kSetNavigationPreloadHeader: {
      return &ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeader_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerRegistrationObjectHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerRegistrationObjectHost>(message.name())) {
      case messages::ServiceWorkerRegistrationObjectHost::kUpdate:
            return "Receive blink::mojom::ServiceWorkerRegistrationObjectHost::Update";
      case messages::ServiceWorkerRegistrationObjectHost::kUnregister:
            return "Receive blink::mojom::ServiceWorkerRegistrationObjectHost::Unregister";
      case messages::ServiceWorkerRegistrationObjectHost::kEnableNavigationPreload:
            return "Receive blink::mojom::ServiceWorkerRegistrationObjectHost::EnableNavigationPreload";
      case messages::ServiceWorkerRegistrationObjectHost::kGetNavigationPreloadState:
            return "Receive blink::mojom::ServiceWorkerRegistrationObjectHost::GetNavigationPreloadState";
      case messages::ServiceWorkerRegistrationObjectHost::kSetNavigationPreloadHeader:
            return "Receive blink::mojom::ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeader";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerRegistrationObjectHost>(message.name())) {
      case messages::ServiceWorkerRegistrationObjectHost::kUpdate:
            return "Receive reply blink::mojom::ServiceWorkerRegistrationObjectHost::Update";
      case messages::ServiceWorkerRegistrationObjectHost::kUnregister:
            return "Receive reply blink::mojom::ServiceWorkerRegistrationObjectHost::Unregister";
      case messages::ServiceWorkerRegistrationObjectHost::kEnableNavigationPreload:
            return "Receive reply blink::mojom::ServiceWorkerRegistrationObjectHost::EnableNavigationPreload";
      case messages::ServiceWorkerRegistrationObjectHost::kGetNavigationPreloadState:
            return "Receive reply blink::mojom::ServiceWorkerRegistrationObjectHost::GetNavigationPreloadState";
      case messages::ServiceWorkerRegistrationObjectHost::kSetNavigationPreloadHeader:
            return "Receive reply blink::mojom::ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeader";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerRegistrationObjectHost::Update_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3058e295;  // IPCStableHash for blink::mojom::ServiceWorkerRegistrationObjectHost::Update
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerRegistrationObjectHost::Unregister_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7177de3a;  // IPCStableHash for blink::mojom::ServiceWorkerRegistrationObjectHost::Unregister
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerRegistrationObjectHost::EnableNavigationPreload_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe4323c4;  // IPCStableHash for blink::mojom::ServiceWorkerRegistrationObjectHost::EnableNavigationPreload
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerRegistrationObjectHost::GetNavigationPreloadState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3910265d;  // IPCStableHash for blink::mojom::ServiceWorkerRegistrationObjectHost::GetNavigationPreloadState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeader_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5dcb65ef;  // IPCStableHash for blink::mojom::ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeader
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback(
      ServiceWorkerRegistrationObjectHost::UpdateCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback(const ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback&) = delete;
  ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback& operator=(const ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerRegistrationObjectHost::UpdateCallback callback_;
};

class ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback(
      ServiceWorkerRegistrationObjectHost::UnregisterCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback(const ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback&) = delete;
  ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback& operator=(const ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerRegistrationObjectHost::UnregisterCallback callback_;
};

class ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback(
      ServiceWorkerRegistrationObjectHost::EnableNavigationPreloadCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback(const ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback&) = delete;
  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback& operator=(const ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerRegistrationObjectHost::EnableNavigationPreloadCallback callback_;
};

class ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback(
      ServiceWorkerRegistrationObjectHost::GetNavigationPreloadStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback(const ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback&) = delete;
  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback& operator=(const ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerRegistrationObjectHost::GetNavigationPreloadStateCallback callback_;
};

class ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback(
      ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeaderCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback(const ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback&) = delete;
  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback& operator=(const ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeaderCallback callback_;
};

ServiceWorkerRegistrationObjectHostProxy::ServiceWorkerRegistrationObjectHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerRegistrationObjectHostProxy::Update(
    ::blink::mojom::FetchClientSettingsObjectPtr in_outside_fetch_client_settings_object, UpdateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerRegistrationObjectHost::Update", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("outside_fetch_client_settings_object"), in_outside_fetch_client_settings_object,
                        "<value of type ::blink::mojom::FetchClientSettingsObjectPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObjectHost::kUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_Update_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->outside_fetch_client_settings_object)::BaseType> outside_fetch_client_settings_object_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FetchClientSettingsObjectDataView>(
    in_outside_fetch_client_settings_object,
    outside_fetch_client_settings_object_fragment);

  params->outside_fetch_client_settings_object.Set(
      outside_fetch_client_settings_object_fragment.is_null() ? nullptr : outside_fetch_client_settings_object_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->outside_fetch_client_settings_object.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null outside_fetch_client_settings_object in ServiceWorkerRegistrationObjectHost.Update request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("Update");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerRegistrationObjectHostProxy::Unregister(
    UnregisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorkerRegistrationObjectHost::Unregister");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObjectHost::kUnregister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_Unregister_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("Unregister");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerRegistrationObjectHostProxy::EnableNavigationPreload(
    bool in_enable, EnableNavigationPreloadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerRegistrationObjectHost::EnableNavigationPreload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable"), in_enable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObjectHost::kEnableNavigationPreload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data> params(
          message);
  params.Allocate();

  params->enable = in_enable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("EnableNavigationPreload");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerRegistrationObjectHostProxy::GetNavigationPreloadState(
    GetNavigationPreloadStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorkerRegistrationObjectHost::GetNavigationPreloadState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObjectHost::kGetNavigationPreloadState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("GetNavigationPreloadState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerRegistrationObjectHostProxy::SetNavigationPreloadHeader(
    const std::string& in_value, SetNavigationPreloadHeaderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeader", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObjectHost::kSetNavigationPreloadHeader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in ServiceWorkerRegistrationObjectHost.SetNavigationPreloadHeader request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("SetNavigationPreloadHeader");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerRegistrationObjectHost::UpdateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder> proxy(
        new ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerRegistrationObjectHost::UpdateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const std::optional<std::string>& in_error_msg);
};

bool ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerRegistrationObjectHost.0
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  std::optional<std::string> p_error_msg{};
  ServiceWorkerRegistrationObjectHost_Update_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerRegistrationObjectHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg));
  }
  return true;
}

void ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const std::optional<std::string>& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerRegistrationObjectHost::Update", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObjectHost::kUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("Update");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerRegistrationObjectHost::UnregisterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder> proxy(
        new ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerRegistrationObjectHost::UnregisterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const std::optional<std::string>& in_error_msg);
};

bool ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerRegistrationObjectHost.1
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  std::optional<std::string> p_error_msg{};
  ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerRegistrationObjectHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg));
  }
  return true;
}

void ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const std::optional<std::string>& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerRegistrationObjectHost::Unregister", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObjectHost::kUnregister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("Unregister");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerRegistrationObjectHost::EnableNavigationPreloadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder> proxy(
        new ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerRegistrationObjectHost::EnableNavigationPreloadCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const std::optional<std::string>& in_error_msg);
};

bool ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerRegistrationObjectHost.2
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  std::optional<std::string> p_error_msg{};
  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerRegistrationObjectHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg));
  }
  return true;
}

void ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const std::optional<std::string>& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerRegistrationObjectHost::EnableNavigationPreload", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObjectHost::kEnableNavigationPreload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("EnableNavigationPreload");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerRegistrationObjectHost::GetNavigationPreloadStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder> proxy(
        new ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerRegistrationObjectHost::GetNavigationPreloadStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const std::optional<std::string>& in_error_msg, ::blink::mojom::NavigationPreloadStatePtr in_state);
};

bool ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerRegistrationObjectHost.3
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  std::optional<std::string> p_error_msg{};
  ::blink::mojom::NavigationPreloadStatePtr p_state{};
  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerRegistrationObjectHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg), 
std::move(p_state));
  }
  return true;
}

void ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const std::optional<std::string>& in_error_msg, ::blink::mojom::NavigationPreloadStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerRegistrationObjectHost::GetNavigationPreloadState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::blink::mojom::NavigationPreloadStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObjectHost::kGetNavigationPreloadState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::NavigationPreloadStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("GetNavigationPreloadState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeaderCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder> proxy(
        new ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeaderCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const std::optional<std::string>& in_error_msg);
};

bool ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerRegistrationObjectHost.4
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  std::optional<std::string> p_error_msg{};
  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerRegistrationObjectHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg));
  }
  return true;
}

void ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const std::optional<std::string>& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeader", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObjectHost::kSetNavigationPreloadHeader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("SetNavigationPreloadHeader");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerRegistrationObjectHostStubDispatch::Accept(
    ServiceWorkerRegistrationObjectHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerRegistrationObjectHost>(message->header()->name)) {
    case messages::ServiceWorkerRegistrationObjectHost::kUpdate: {
      break;
    }
    case messages::ServiceWorkerRegistrationObjectHost::kUnregister: {
      break;
    }
    case messages::ServiceWorkerRegistrationObjectHost::kEnableNavigationPreload: {
      break;
    }
    case messages::ServiceWorkerRegistrationObjectHost::kGetNavigationPreloadState: {
      break;
    }
    case messages::ServiceWorkerRegistrationObjectHost::kSetNavigationPreloadHeader: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerRegistrationObjectHostStubDispatch::AcceptWithResponder(
    ServiceWorkerRegistrationObjectHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerRegistrationObjectHost>(message->header()->name)) {
    case messages::ServiceWorkerRegistrationObjectHost::kUpdate: {
      internal::ServiceWorkerRegistrationObjectHost_Update_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerRegistrationObjectHost_Update_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerRegistrationObjectHost.0
      bool success = true;
      ::blink::mojom::FetchClientSettingsObjectPtr p_outside_fetch_client_settings_object{};
      ServiceWorkerRegistrationObjectHost_Update_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOutsideFetchClientSettingsObject(&p_outside_fetch_client_settings_object))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObjectHost::Name_, 0, false);
        return false;
      }
      auto callback =
          ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Update(        
        std::move(p_outside_fetch_client_settings_object), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerRegistrationObjectHost::kUnregister: {
      internal::ServiceWorkerRegistrationObjectHost_Unregister_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerRegistrationObjectHost_Unregister_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerRegistrationObjectHost.1
      bool success = true;
      ServiceWorkerRegistrationObjectHost_Unregister_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObjectHost::Name_, 1, false);
        return false;
      }
      auto callback =
          ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unregister(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerRegistrationObjectHost::kEnableNavigationPreload: {
      internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerRegistrationObjectHost.2
      bool success = true;
      bool p_enable{};
      ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enable = input_data_view.enable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObjectHost::Name_, 2, false);
        return false;
      }
      auto callback =
          ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableNavigationPreload(        
        std::move(p_enable), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerRegistrationObjectHost::kGetNavigationPreloadState: {
      internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerRegistrationObjectHost.3
      bool success = true;
      ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObjectHost::Name_, 3, false);
        return false;
      }
      auto callback =
          ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNavigationPreloadState(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerRegistrationObjectHost::kSetNavigationPreloadHeader: {
      internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerRegistrationObjectHost.4
      bool success = true;
      std::string p_value{};
      ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObjectHost::Name_, 4, false);
        return false;
      }
      auto callback =
          ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNavigationPreloadHeader(        
        std::move(p_value), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerRegistrationObjectHostValidationInfo[] = {
    { &internal::ServiceWorkerRegistrationObjectHost_Update_Params_Data::Validate,
     &internal::ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerRegistrationObjectHost_Unregister_Params_Data::Validate,
     &internal::ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data::Validate,
     &internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data::Validate,
     &internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data::Validate,
     &internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data::Validate},
};

bool ServiceWorkerRegistrationObjectHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::ServiceWorkerRegistrationObjectHost::Name_,
    kServiceWorkerRegistrationObjectHostValidationInfo);
}

bool ServiceWorkerRegistrationObjectHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::ServiceWorkerRegistrationObjectHost::Name_,
    kServiceWorkerRegistrationObjectHostValidationInfo);
}
// The declaration includes the definition on other builds.

ServiceWorkerRegistrationObject::IPCStableHashFunction ServiceWorkerRegistrationObject::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerRegistrationObject>(message.name())) {
    case messages::ServiceWorkerRegistrationObject::kSetServiceWorkerObjects: {
      return &ServiceWorkerRegistrationObject::SetServiceWorkerObjects_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerRegistrationObject::kSetUpdateViaCache: {
      return &ServiceWorkerRegistrationObject::SetUpdateViaCache_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerRegistrationObject::kUpdateFound: {
      return &ServiceWorkerRegistrationObject::UpdateFound_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerRegistrationObject::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerRegistrationObject>(message.name())) {
      case messages::ServiceWorkerRegistrationObject::kSetServiceWorkerObjects:
            return "Receive blink::mojom::ServiceWorkerRegistrationObject::SetServiceWorkerObjects";
      case messages::ServiceWorkerRegistrationObject::kSetUpdateViaCache:
            return "Receive blink::mojom::ServiceWorkerRegistrationObject::SetUpdateViaCache";
      case messages::ServiceWorkerRegistrationObject::kUpdateFound:
            return "Receive blink::mojom::ServiceWorkerRegistrationObject::UpdateFound";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerRegistrationObject>(message.name())) {
      case messages::ServiceWorkerRegistrationObject::kSetServiceWorkerObjects:
            return "Receive reply blink::mojom::ServiceWorkerRegistrationObject::SetServiceWorkerObjects";
      case messages::ServiceWorkerRegistrationObject::kSetUpdateViaCache:
            return "Receive reply blink::mojom::ServiceWorkerRegistrationObject::SetUpdateViaCache";
      case messages::ServiceWorkerRegistrationObject::kUpdateFound:
            return "Receive reply blink::mojom::ServiceWorkerRegistrationObject::UpdateFound";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerRegistrationObject::SetServiceWorkerObjects_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x804bf538;  // IPCStableHash for blink::mojom::ServiceWorkerRegistrationObject::SetServiceWorkerObjects
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerRegistrationObject::SetUpdateViaCache_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6e30fdeb;  // IPCStableHash for blink::mojom::ServiceWorkerRegistrationObject::SetUpdateViaCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerRegistrationObject::UpdateFound_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbe097bbf;  // IPCStableHash for blink::mojom::ServiceWorkerRegistrationObject::UpdateFound
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ServiceWorkerRegistrationObjectProxy::ServiceWorkerRegistrationObjectProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerRegistrationObjectProxy::SetServiceWorkerObjects(
    ChangedServiceWorkerObjectsMaskPtr in_changed_mask, ::blink::mojom::ServiceWorkerObjectInfoPtr in_installing, ::blink::mojom::ServiceWorkerObjectInfoPtr in_waiting, ::blink::mojom::ServiceWorkerObjectInfoPtr in_active) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerRegistrationObject::SetServiceWorkerObjects", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("changed_mask"), in_changed_mask,
                        "<value of type ChangedServiceWorkerObjectsMaskPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("installing"), in_installing,
                        "<value of type ::blink::mojom::ServiceWorkerObjectInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("waiting"), in_waiting,
                        "<value of type ::blink::mojom::ServiceWorkerObjectInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active"), in_active,
                        "<value of type ::blink::mojom::ServiceWorkerObjectInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObject::kSetServiceWorkerObjects), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->changed_mask)::BaseType> changed_mask_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ChangedServiceWorkerObjectsMaskDataView>(
    in_changed_mask,
    changed_mask_fragment);

  params->changed_mask.Set(
      changed_mask_fragment.is_null() ? nullptr : changed_mask_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->changed_mask.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null changed_mask in ServiceWorkerRegistrationObject.SetServiceWorkerObjects request");
  mojo::internal::MessageFragment<
      typename decltype(params->installing)::BaseType> installing_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
    in_installing,
    installing_fragment);

  params->installing.Set(
      installing_fragment.is_null() ? nullptr : installing_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->waiting)::BaseType> waiting_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
    in_waiting,
    waiting_fragment);

  params->waiting.Set(
      waiting_fragment.is_null() ? nullptr : waiting_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->active)::BaseType> active_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
    in_active,
    active_fragment);

  params->active.Set(
      active_fragment.is_null() ? nullptr : active_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObject::Name_);
  message.set_method_name("SetServiceWorkerObjects");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerRegistrationObjectProxy::SetUpdateViaCache(
    ::blink::mojom::ServiceWorkerUpdateViaCache in_update_via_cache) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerRegistrationObject::SetUpdateViaCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_via_cache"), in_update_via_cache,
                        "<value of type ::blink::mojom::ServiceWorkerUpdateViaCache>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObject::kSetUpdateViaCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerUpdateViaCache>(
    in_update_via_cache,
    &params->update_via_cache);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObject::Name_);
  message.set_method_name("SetUpdateViaCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerRegistrationObjectProxy::UpdateFound(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorkerRegistrationObject::UpdateFound");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerRegistrationObject::kUpdateFound), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerRegistrationObject_UpdateFound_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObject::Name_);
  message.set_method_name("UpdateFound");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ServiceWorkerRegistrationObjectStubDispatch::Accept(
    ServiceWorkerRegistrationObject* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerRegistrationObject>(message->header()->name)) {
    case messages::ServiceWorkerRegistrationObject::kSetServiceWorkerObjects: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerRegistrationObject.0
      bool success = true;
      ChangedServiceWorkerObjectsMaskPtr p_changed_mask{};
      ::blink::mojom::ServiceWorkerObjectInfoPtr p_installing{};
      ::blink::mojom::ServiceWorkerObjectInfoPtr p_waiting{};
      ::blink::mojom::ServiceWorkerObjectInfoPtr p_active{};
      ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChangedMask(&p_changed_mask))
        success = false;
      if (success && !input_data_view.ReadInstalling(&p_installing))
        success = false;
      if (success && !input_data_view.ReadWaiting(&p_waiting))
        success = false;
      if (success && !input_data_view.ReadActive(&p_active))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObject::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetServiceWorkerObjects(        
        std::move(p_changed_mask), 
        std::move(p_installing), 
        std::move(p_waiting), 
        std::move(p_active));
      return true;
    }
    case messages::ServiceWorkerRegistrationObject::kSetUpdateViaCache: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerRegistrationObject.1
      bool success = true;
      ::blink::mojom::ServiceWorkerUpdateViaCache p_update_via_cache{};
      ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdateViaCache(&p_update_via_cache))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObject::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUpdateViaCache(        
        std::move(p_update_via_cache));
      return true;
    }
    case messages::ServiceWorkerRegistrationObject::kUpdateFound: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerRegistrationObject_UpdateFound_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerRegistrationObject_UpdateFound_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerRegistrationObject.2
      bool success = true;
      ServiceWorkerRegistrationObject_UpdateFound_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObject::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateFound(        );
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerRegistrationObjectStubDispatch::AcceptWithResponder(
    ServiceWorkerRegistrationObject* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerRegistrationObject>(message->header()->name)) {
    case messages::ServiceWorkerRegistrationObject::kSetServiceWorkerObjects: {
      break;
    }
    case messages::ServiceWorkerRegistrationObject::kSetUpdateViaCache: {
      break;
    }
    case messages::ServiceWorkerRegistrationObject::kUpdateFound: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerRegistrationObjectValidationInfo[] = {
    { &internal::ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerRegistrationObject_UpdateFound_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceWorkerRegistrationObjectRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::ServiceWorkerRegistrationObject::Name_,
    kServiceWorkerRegistrationObjectValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::ChangedServiceWorkerObjectsMask::DataView, ::blink::mojom::ChangedServiceWorkerObjectsMaskPtr>::Read(
    ::blink::mojom::ChangedServiceWorkerObjectsMask::DataView input,
    ::blink::mojom::ChangedServiceWorkerObjectsMaskPtr* output) {
  bool success = true;
  ::blink::mojom::ChangedServiceWorkerObjectsMaskPtr result(::blink::mojom::ChangedServiceWorkerObjectsMask::New());
  
      if (success)
        result->installing = input.installing();
      if (success)
        result->waiting = input.waiting();
      if (success)
        result->active = input.active();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRegistrationObjectInfo::DataView, ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr>::Read(
    ::blink::mojom::ServiceWorkerRegistrationObjectInfo::DataView input,
    ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr result(::blink::mojom::ServiceWorkerRegistrationObjectInfo::New());
  
      if (success)
        result->registration_id = input.registration_id();
      if (success && !input.ReadScope(&result->scope))
        success = false;
      if (success && !input.ReadUpdateViaCache(&result->update_via_cache))
        success = false;
      if (success) {
        result->host_remote =
            input.TakeHostRemote<decltype(result->host_remote)>();
      }
      if (success) {
        result->receiver =
            input.TakeReceiver<decltype(result->receiver)>();
      }
      if (success && !input.ReadInstalling(&result->installing))
        success = false;
      if (success && !input.ReadWaiting(&result->waiting))
        success = false;
      if (success && !input.ReadActive(&result->active))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void ServiceWorkerRegistrationObjectHostInterceptorForTesting::Update(::blink::mojom::FetchClientSettingsObjectPtr outside_fetch_client_settings_object, UpdateCallback callback) {
  GetForwardingInterface()->Update(
    std::move(outside_fetch_client_settings_object)
    , std::move(callback));
}
void ServiceWorkerRegistrationObjectHostInterceptorForTesting::Unregister(UnregisterCallback callback) {
  GetForwardingInterface()->Unregister(std::move(callback));
}
void ServiceWorkerRegistrationObjectHostInterceptorForTesting::EnableNavigationPreload(bool enable, EnableNavigationPreloadCallback callback) {
  GetForwardingInterface()->EnableNavigationPreload(
    std::move(enable)
    , std::move(callback));
}
void ServiceWorkerRegistrationObjectHostInterceptorForTesting::GetNavigationPreloadState(GetNavigationPreloadStateCallback callback) {
  GetForwardingInterface()->GetNavigationPreloadState(std::move(callback));
}
void ServiceWorkerRegistrationObjectHostInterceptorForTesting::SetNavigationPreloadHeader(const std::string& value, SetNavigationPreloadHeaderCallback callback) {
  GetForwardingInterface()->SetNavigationPreloadHeader(
    std::move(value)
    , std::move(callback));
}
ServiceWorkerRegistrationObjectHostAsyncWaiter::ServiceWorkerRegistrationObjectHostAsyncWaiter(
    ServiceWorkerRegistrationObjectHost* proxy) : proxy_(proxy) {}

ServiceWorkerRegistrationObjectHostAsyncWaiter::~ServiceWorkerRegistrationObjectHostAsyncWaiter() = default;


void ServiceWorkerRegistrationObjectHostAsyncWaiter::Update(
    ::blink::mojom::FetchClientSettingsObjectPtr outside_fetch_client_settings_object, ::blink::mojom::ServiceWorkerErrorType* out_error, std::optional<std::string>* out_error_msg) {
  base::RunLoop loop;
  proxy_->Update(
      std::move(outside_fetch_client_settings_object),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::ServiceWorkerErrorType* out_error
,
             std::optional<std::string>* out_error_msg
,
             ::blink::mojom::ServiceWorkerErrorType error,
             const std::optional<std::string>& error_msg) {*out_error = std::move(error);*out_error_msg = std::move(error_msg);
            loop->Quit();
          },
          &loop,
          out_error,
          out_error_msg));
  loop.Run();
}



void ServiceWorkerRegistrationObjectHostAsyncWaiter::Unregister(
    ::blink::mojom::ServiceWorkerErrorType* out_error, std::optional<std::string>* out_error_msg) {
  base::RunLoop loop;
  proxy_->Unregister(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::ServiceWorkerErrorType* out_error
,
             std::optional<std::string>* out_error_msg
,
             ::blink::mojom::ServiceWorkerErrorType error,
             const std::optional<std::string>& error_msg) {*out_error = std::move(error);*out_error_msg = std::move(error_msg);
            loop->Quit();
          },
          &loop,
          out_error,
          out_error_msg));
  loop.Run();
}



void ServiceWorkerRegistrationObjectHostAsyncWaiter::EnableNavigationPreload(
    bool enable, ::blink::mojom::ServiceWorkerErrorType* out_error, std::optional<std::string>* out_error_msg) {
  base::RunLoop loop;
  proxy_->EnableNavigationPreload(
      std::move(enable),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::ServiceWorkerErrorType* out_error
,
             std::optional<std::string>* out_error_msg
,
             ::blink::mojom::ServiceWorkerErrorType error,
             const std::optional<std::string>& error_msg) {*out_error = std::move(error);*out_error_msg = std::move(error_msg);
            loop->Quit();
          },
          &loop,
          out_error,
          out_error_msg));
  loop.Run();
}



void ServiceWorkerRegistrationObjectHostAsyncWaiter::GetNavigationPreloadState(
    ::blink::mojom::ServiceWorkerErrorType* out_error, std::optional<std::string>* out_error_msg, ::blink::mojom::NavigationPreloadStatePtr* out_state) {
  base::RunLoop loop;
  proxy_->GetNavigationPreloadState(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::ServiceWorkerErrorType* out_error
,
             std::optional<std::string>* out_error_msg
,
             ::blink::mojom::NavigationPreloadStatePtr* out_state
,
             ::blink::mojom::ServiceWorkerErrorType error,
             const std::optional<std::string>& error_msg,
             ::blink::mojom::NavigationPreloadStatePtr state) {*out_error = std::move(error);*out_error_msg = std::move(error_msg);*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_error,
          out_error_msg,
          out_state));
  loop.Run();
}



void ServiceWorkerRegistrationObjectHostAsyncWaiter::SetNavigationPreloadHeader(
    const std::string& value, ::blink::mojom::ServiceWorkerErrorType* out_error, std::optional<std::string>* out_error_msg) {
  base::RunLoop loop;
  proxy_->SetNavigationPreloadHeader(
      std::move(value),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::ServiceWorkerErrorType* out_error
,
             std::optional<std::string>* out_error_msg
,
             ::blink::mojom::ServiceWorkerErrorType error,
             const std::optional<std::string>& error_msg) {*out_error = std::move(error);*out_error_msg = std::move(error_msg);
            loop->Quit();
          },
          &loop,
          out_error,
          out_error_msg));
  loop.Run();
}






void ServiceWorkerRegistrationObjectInterceptorForTesting::SetServiceWorkerObjects(ChangedServiceWorkerObjectsMaskPtr changed_mask, ::blink::mojom::ServiceWorkerObjectInfoPtr installing, ::blink::mojom::ServiceWorkerObjectInfoPtr waiting, ::blink::mojom::ServiceWorkerObjectInfoPtr active) {
  GetForwardingInterface()->SetServiceWorkerObjects(
    std::move(changed_mask)
    , 
    std::move(installing)
    , 
    std::move(waiting)
    , 
    std::move(active)
    );
}
void ServiceWorkerRegistrationObjectInterceptorForTesting::SetUpdateViaCache(::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache) {
  GetForwardingInterface()->SetUpdateViaCache(
    std::move(update_via_cache)
    );
}
void ServiceWorkerRegistrationObjectInterceptorForTesting::UpdateFound() {
  GetForwardingInterface()->UpdateFound();
}
ServiceWorkerRegistrationObjectAsyncWaiter::ServiceWorkerRegistrationObjectAsyncWaiter(
    ServiceWorkerRegistrationObject* proxy) : proxy_(proxy) {}

ServiceWorkerRegistrationObjectAsyncWaiter::~ServiceWorkerRegistrationObjectAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif