// third_party/blink/public/mojom/service_worker/service_worker_container.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CONTAINER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CONTAINER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom-blink.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-blink.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_embedded_worker_status.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_error_type.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class ServiceWorkerContainerHostProxy;

template <typename ImplRefTraits>
class ServiceWorkerContainerHostStub;

class ServiceWorkerContainerHostRequestValidator;
class ServiceWorkerContainerHostResponseValidator;


class CORE_EXPORT ServiceWorkerContainerHost
    : public ServiceWorkerContainerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ServiceWorkerContainerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerContainerHostInterfaceBase;
  using Proxy_ = ServiceWorkerContainerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerContainerHostStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerContainerHostRequestValidator;
  using ResponseValidator_ = ServiceWorkerContainerHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRegisterMinVersion = 0,
    kGetRegistrationMinVersion = 0,
    kGetRegistrationsMinVersion = 0,
    kGetRegistrationForReadyMinVersion = 0,
    kEnsureControllerServiceWorkerMinVersion = 0,
    kCloneContainerHostMinVersion = 0,
    kHintToUpdateServiceWorkerMinVersion = 0,
    kEnsureFileAccessMinVersion = 0,
    kOnExecutionReadyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Register_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetRegistration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetRegistrations_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetRegistrationForReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnsureControllerServiceWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloneContainerHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HintToUpdateServiceWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnsureFileAccess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnExecutionReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerContainerHost() = default;

  using RegisterCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const ::blink::String&, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr)>;
  using RegisterMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const ::blink::String&, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr)>;

  virtual void Register(const ::blink::KURL& script_url, ::blink::mojom::blink::ServiceWorkerRegistrationOptionsPtr options, ::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object, RegisterCallback callback) = 0;

  using GetRegistrationCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const ::blink::String&, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr)>;
  using GetRegistrationMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const ::blink::String&, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr)>;

  virtual void GetRegistration(const ::blink::KURL& client_url, GetRegistrationCallback callback) = 0;

  using GetRegistrationsCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const ::blink::String&, std::optional<::blink::Vector<::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>>)>;
  using GetRegistrationsMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const ::blink::String&, std::optional<::blink::Vector<::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>>)>;

  virtual void GetRegistrations(GetRegistrationsCallback callback) = 0;

  using GetRegistrationForReadyCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr)>;
  using GetRegistrationForReadyMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr)>;

  virtual void GetRegistrationForReady(GetRegistrationForReadyCallback callback) = 0;

  virtual void EnsureControllerServiceWorker(::mojo::PendingReceiver<::blink::mojom::blink::ControllerServiceWorker> receiver, ControllerServiceWorkerPurpose purpose) = 0;

  virtual void CloneContainerHost(::mojo::PendingReceiver<ServiceWorkerContainerHost> container_host) = 0;

  virtual void HintToUpdateServiceWorker() = 0;

  using EnsureFileAccessCallback = base::OnceCallback<void()>;
  using EnsureFileAccessMojoCallback = base::OnceCallback<void()>;

  virtual void EnsureFileAccess(const ::blink::Vector<::base::FilePath>& files, EnsureFileAccessCallback callback) = 0;

  virtual void OnExecutionReady() = 0;
};

class ServiceWorkerContainerProxy;

template <typename ImplRefTraits>
class ServiceWorkerContainerStub;

class ServiceWorkerContainerRequestValidator;


class CORE_EXPORT ServiceWorkerContainer
    : public ServiceWorkerContainerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ServiceWorkerContainer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerContainerInterfaceBase;
  using Proxy_ = ServiceWorkerContainerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerContainerStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerContainerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetControllerMinVersion = 0,
    kPostMessageToClientMinVersion = 0,
    kCountFeatureMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetController_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PostMessageToClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CountFeature_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerContainer() = default;

  virtual void SetController(::blink::mojom::blink::ControllerServiceWorkerInfoPtr controller_info, bool should_notify_controllerchange) = 0;

  virtual void PostMessageToClient(::blink::mojom::blink::ServiceWorkerObjectInfoPtr source, ::blink::BlinkTransferableMessage message) = 0;

  virtual void CountFeature(::blink::mojom::blink::WebFeature feature) = 0;
};



class CORE_EXPORT ServiceWorkerContainerHostProxy
    : public ServiceWorkerContainerHost {
 public:
  using InterfaceType = ServiceWorkerContainerHost;

  explicit ServiceWorkerContainerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Register(const ::blink::KURL& script_url, ::blink::mojom::blink::ServiceWorkerRegistrationOptionsPtr options, ::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object, RegisterCallback callback) final;
  
  void GetRegistration(const ::blink::KURL& client_url, GetRegistrationCallback callback) final;
  
  void GetRegistrations(GetRegistrationsCallback callback) final;
  
  void GetRegistrationForReady(GetRegistrationForReadyCallback callback) final;
  
  void EnsureControllerServiceWorker(::mojo::PendingReceiver<::blink::mojom::blink::ControllerServiceWorker> receiver, ControllerServiceWorkerPurpose purpose) final;
  
  void CloneContainerHost(::mojo::PendingReceiver<ServiceWorkerContainerHost> container_host) final;
  
  void HintToUpdateServiceWorker() final;
  
  void EnsureFileAccess(const ::blink::Vector<::base::FilePath>& files, EnsureFileAccessCallback callback) final;
  
  void OnExecutionReady() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CORE_EXPORT ServiceWorkerContainerProxy
    : public ServiceWorkerContainer {
 public:
  using InterfaceType = ServiceWorkerContainer;

  explicit ServiceWorkerContainerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetController(::blink::mojom::blink::ControllerServiceWorkerInfoPtr controller_info, bool should_notify_controllerchange) final;
  
  void PostMessageToClient(::blink::mojom::blink::ServiceWorkerObjectInfoPtr source, ::blink::BlinkTransferableMessage message) final;
  
  void CountFeature(::blink::mojom::blink::WebFeature feature) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CORE_EXPORT ServiceWorkerContainerHostStubDispatch {
 public:
  static bool Accept(ServiceWorkerContainerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerContainerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerContainerHost>>
class ServiceWorkerContainerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerContainerHostStub() = default;
  ~ServiceWorkerContainerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerContainerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerContainerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT ServiceWorkerContainerStubDispatch {
 public:
  static bool Accept(ServiceWorkerContainer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerContainer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerContainer>>
class ServiceWorkerContainerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerContainerStub() = default;
  ~ServiceWorkerContainerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerContainerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerContainerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT ServiceWorkerContainerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT ServiceWorkerContainerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT ServiceWorkerContainerHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class CORE_EXPORT ServiceWorkerContainerInfoForClient {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerContainerInfoForClient, T>::value>;
  using DataView = ServiceWorkerContainerInfoForClientDataView;
  using Data_ = internal::ServiceWorkerContainerInfoForClient_Data;

  template <typename... Args>
  static ServiceWorkerContainerInfoForClientPtr New(Args&&... args) {
    return ServiceWorkerContainerInfoForClientPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerContainerInfoForClientPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerContainerInfoForClientPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerContainerInfoForClient>::Convert(*this);
  }


  ServiceWorkerContainerInfoForClient();

  ServiceWorkerContainerInfoForClient(
      ::mojo::PendingAssociatedRemote<ServiceWorkerContainerHost> host_remote,
      ::mojo::PendingAssociatedReceiver<ServiceWorkerContainer> client_receiver);

ServiceWorkerContainerInfoForClient(const ServiceWorkerContainerInfoForClient&) = delete;
ServiceWorkerContainerInfoForClient& operator=(const ServiceWorkerContainerInfoForClient&) = delete;

  ~ServiceWorkerContainerInfoForClient();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerContainerInfoForClientPtr>
  ServiceWorkerContainerInfoForClientPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerContainerInfoForClient::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerContainerInfoForClient::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerContainerInfoForClient::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerContainerInfoForClient::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerContainerInfoForClient_UnserializedMessageContext<
            UserType, ServiceWorkerContainerInfoForClient::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerContainerInfoForClient::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerContainerInfoForClient::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerContainerInfoForClient_UnserializedMessageContext<
            UserType, ServiceWorkerContainerInfoForClient::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerContainerInfoForClient::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingAssociatedRemote<ServiceWorkerContainerHost> host_remote;
  
  ::mojo::PendingAssociatedReceiver<ServiceWorkerContainer> client_receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerContainerInfoForClient::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerContainerInfoForClient::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerContainerInfoForClient::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerContainerInfoForClient::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServiceWorkerContainerInfoForClientPtr ServiceWorkerContainerInfoForClient::Clone() const {
  return New(
      mojo::Clone(host_remote),
      mojo::Clone(client_receiver)
  );
}

template <typename T, ServiceWorkerContainerInfoForClient::EnableIfSame<T>*>
bool ServiceWorkerContainerInfoForClient::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->host_remote, other_struct.host_remote))
    return false;
  if (!mojo::Equals(this->client_receiver, other_struct.client_receiver))
    return false;
  return true;
}

template <typename T, ServiceWorkerContainerInfoForClient::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.host_remote < rhs.host_remote)
    return true;
  if (rhs.host_remote < lhs.host_remote)
    return false;
  if (lhs.client_receiver < rhs.client_receiver)
    return true;
  if (rhs.client_receiver < lhs.client_receiver)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::ServiceWorkerContainerInfoForClient::DataView,
                                         ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr> {
  static bool IsNull(const ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::ServiceWorkerContainerInfoForClient::host_remote)& host_remote(
       ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr& input) {
    return input->host_remote;
  }

  static  decltype(::blink::mojom::blink::ServiceWorkerContainerInfoForClient::client_receiver)& client_receiver(
       ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr& input) {
    return input->client_receiver;
  }

  static bool Read(::blink::mojom::blink::ServiceWorkerContainerInfoForClient::DataView input, ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CONTAINER_MOJOM_BLINK_H_