// third_party/blink/public/mojom/service_worker/service_worker_client.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CLIENT_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CLIENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_client.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/request_context_frame_type.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "third_party/blink/public/mojom/service_worker/service_worker_client.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::ServiceWorkerClientType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ServiceWorkerClientType> {};

template <>
struct hash<::blink::mojom::ServiceWorkerClientLifecycleState>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ServiceWorkerClientLifecycleState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerClientType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ServiceWorkerClientType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ServiceWorkerClientType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerClientLifecycleState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ServiceWorkerClientLifecycleState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ServiceWorkerClientLifecycleState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerClientQueryOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerClientQueryOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerClientQueryOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->include_uncontrolled = Traits::include_uncontrolled(input);

    
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientType>(
      Traits::client_type(input),
      &fragment->client_type);
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerClientQueryOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerClientQueryOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerClientInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerClientInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerClientInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ServiceWorkerClientInfo struct");

    
    mojo::internal::Serialize<::blink::mojom::RequestContextFrameType>(
      Traits::frame_type(input),
      &fragment->frame_type);

    decltype(Traits::client_uuid(input)) in_client_uuid = Traits::client_uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_uuid)::BaseType> client_uuid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_client_uuid,
      client_uuid_fragment);

    fragment->client_uuid.Set(
        client_uuid_fragment.is_null() ? nullptr : client_uuid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->client_uuid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_uuid in ServiceWorkerClientInfo struct");

    
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientType>(
      Traits::client_type(input),
      &fragment->client_type);

    fragment->page_hidden = Traits::page_hidden(input);

    fragment->is_focused = Traits::is_focused(input);

    
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientLifecycleState>(
      Traits::lifecycle_state(input),
      &fragment->lifecycle_state);

    decltype(Traits::last_focus_time(input)) in_last_focus_time = Traits::last_focus_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_focus_time)::BaseType> last_focus_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_last_focus_time,
      last_focus_time_fragment);

    fragment->last_focus_time.Set(
        last_focus_time_fragment.is_null() ? nullptr : last_focus_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_focus_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_focus_time in ServiceWorkerClientInfo struct");

    decltype(Traits::creation_time(input)) in_creation_time = Traits::creation_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creation_time)::BaseType> creation_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_creation_time,
      creation_time_fragment);

    fragment->creation_time.Set(
        creation_time_fragment.is_null() ? nullptr : creation_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->creation_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null creation_time in ServiceWorkerClientInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerClientInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerClientInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void ServiceWorkerClientInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ServiceWorkerClientInfoDataView::GetClientUuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->client_uuid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ServiceWorkerClientInfoDataView::GetLastFocusTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->last_focus_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void ServiceWorkerClientInfoDataView::GetCreationTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->creation_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ServiceWorkerClientType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ServiceWorkerClientType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ServiceWorkerClientLifecycleState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ServiceWorkerClientLifecycleState value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CLIENT_MOJOM_SHARED_H_