// third_party/blink/public/mojom/service_worker/service_worker.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"
#include "third_party/blink/public/common/messaging/accelerated_static_bitmap_image_mojom_traits.h"
#include "third_party/blink/public/common/messaging/task_attribution_id_mojom_traits.h"
#include "third_party/blink/public/common/service_worker/service_worker_router_rule_mojom_traits.h"
#include "third_party/blink/renderer/platform/loader/fetch/fetch_api_request_body_mojom_traits.h"


namespace blink::mojom::blink {
ExtendableMessageEvent::ExtendableMessageEvent()
    : message(),
      source_origin(),
      source_info_for_client(),
      source_info_for_service_worker() {}

ExtendableMessageEvent::ExtendableMessageEvent(
    ::blink::BlinkTransferableMessage message_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& source_origin_in,
    ::blink::mojom::blink::ServiceWorkerClientInfoPtr source_info_for_client_in,
    ::blink::mojom::blink::ServiceWorkerObjectInfoPtr source_info_for_service_worker_in)
    : message(std::move(message_in)),
      source_origin(std::move(source_origin_in)),
      source_info_for_client(std::move(source_info_for_client_in)),
      source_info_for_service_worker(std::move(source_info_for_service_worker_in)) {}

ExtendableMessageEvent::~ExtendableMessageEvent() = default;

void ExtendableMessageEvent::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::BlinkTransferableMessage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_origin"), this->source_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_info_for_client"), this->source_info_for_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::ServiceWorkerClientInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_info_for_service_worker"), this->source_info_for_service_worker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::ServiceWorkerObjectInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExtendableMessageEvent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FocusResultPtr
FocusResult::NewClient(
    ::blink::mojom::blink::ServiceWorkerClientInfoPtr value) {
  return FocusResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kClient)>,
      std::move(value));
}

FocusResultPtr
FocusResult::NewErrorCode(
    FocusError value) {
  return FocusResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorCode)>,
      std::move(value));
}

FocusResult::FocusResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kClient)>,
    ::blink::mojom::blink::ServiceWorkerClientInfoPtr value)
    : tag_(Tag::kClient),
      data_(std::in_place_index<static_cast<size_t>(Tag::kClient)>,
            std::move(value)) {}

FocusResult::FocusResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
    FocusError value)
    : tag_(Tag::kErrorCode),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorCode)>,
            std::move(value)) {}
FocusResult::~FocusResult() {
  DestroyActive();
}

void FocusResult::set_client(::blink::mojom::blink::ServiceWorkerClientInfoPtr client) {
  if (tag_ == Tag::kClient) {
    data_.client = std::move(client);
  } else {
    DestroyActive();
    tag_ = Tag::kClient;
    new (&data_.client) ::blink::mojom::blink::ServiceWorkerClientInfoPtr(
        std::move(client));
  }
}

void FocusResult::set_error_code(FocusError error_code) {
  if (tag_ != Tag::kErrorCode) {
    DestroyActive();
    tag_ = Tag::kErrorCode;
  }
  data_.error_code = error_code;
}


FocusResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kClient)>,
    ::blink::mojom::blink::ServiceWorkerClientInfoPtr value)
    : client(std::move(value)) {}

FocusResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
    FocusError value)
    : error_code(std::move(value)) {}

void FocusResult::DestroyActive() {
  switch (tag_) {

    case Tag::kClient:
      std::destroy_at(&data_.client);
      break;
    case Tag::kErrorCode:
      std::destroy_at(&data_.error_code);
      break;
  }
}

bool FocusResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

ServiceWorkerHost::IPCStableHashFunction ServiceWorkerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerHost>(message.name())) {
    case messages::ServiceWorkerHost::kSetCachedMetadata: {
      return &ServiceWorkerHost::SetCachedMetadata_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kClearCachedMetadata: {
      return &ServiceWorkerHost::ClearCachedMetadata_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kGetClients: {
      return &ServiceWorkerHost::GetClients_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kGetClient: {
      return &ServiceWorkerHost::GetClient_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kOpenNewTab: {
      return &ServiceWorkerHost::OpenNewTab_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kOpenPaymentHandlerWindow: {
      return &ServiceWorkerHost::OpenPaymentHandlerWindow_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kPostMessageToClient: {
      return &ServiceWorkerHost::PostMessageToClient_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kFocusClient: {
      return &ServiceWorkerHost::FocusClient_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kNavigateClient: {
      return &ServiceWorkerHost::NavigateClient_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kSkipWaiting: {
      return &ServiceWorkerHost::SkipWaiting_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kClaimClients: {
      return &ServiceWorkerHost::ClaimClients_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kAddRoutes: {
      return &ServiceWorkerHost::AddRoutes_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerHost>(message.name())) {
      case messages::ServiceWorkerHost::kSetCachedMetadata:
            return "Receive blink::mojom::ServiceWorkerHost::SetCachedMetadata";
      case messages::ServiceWorkerHost::kClearCachedMetadata:
            return "Receive blink::mojom::ServiceWorkerHost::ClearCachedMetadata";
      case messages::ServiceWorkerHost::kGetClients:
            return "Receive blink::mojom::ServiceWorkerHost::GetClients";
      case messages::ServiceWorkerHost::kGetClient:
            return "Receive blink::mojom::ServiceWorkerHost::GetClient";
      case messages::ServiceWorkerHost::kOpenNewTab:
            return "Receive blink::mojom::ServiceWorkerHost::OpenNewTab";
      case messages::ServiceWorkerHost::kOpenPaymentHandlerWindow:
            return "Receive blink::mojom::ServiceWorkerHost::OpenPaymentHandlerWindow";
      case messages::ServiceWorkerHost::kPostMessageToClient:
            return "Receive blink::mojom::ServiceWorkerHost::PostMessageToClient";
      case messages::ServiceWorkerHost::kFocusClient:
            return "Receive blink::mojom::ServiceWorkerHost::FocusClient";
      case messages::ServiceWorkerHost::kNavigateClient:
            return "Receive blink::mojom::ServiceWorkerHost::NavigateClient";
      case messages::ServiceWorkerHost::kSkipWaiting:
            return "Receive blink::mojom::ServiceWorkerHost::SkipWaiting";
      case messages::ServiceWorkerHost::kClaimClients:
            return "Receive blink::mojom::ServiceWorkerHost::ClaimClients";
      case messages::ServiceWorkerHost::kAddRoutes:
            return "Receive blink::mojom::ServiceWorkerHost::AddRoutes";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerHost>(message.name())) {
      case messages::ServiceWorkerHost::kSetCachedMetadata:
            return "Receive reply blink::mojom::ServiceWorkerHost::SetCachedMetadata";
      case messages::ServiceWorkerHost::kClearCachedMetadata:
            return "Receive reply blink::mojom::ServiceWorkerHost::ClearCachedMetadata";
      case messages::ServiceWorkerHost::kGetClients:
            return "Receive reply blink::mojom::ServiceWorkerHost::GetClients";
      case messages::ServiceWorkerHost::kGetClient:
            return "Receive reply blink::mojom::ServiceWorkerHost::GetClient";
      case messages::ServiceWorkerHost::kOpenNewTab:
            return "Receive reply blink::mojom::ServiceWorkerHost::OpenNewTab";
      case messages::ServiceWorkerHost::kOpenPaymentHandlerWindow:
            return "Receive reply blink::mojom::ServiceWorkerHost::OpenPaymentHandlerWindow";
      case messages::ServiceWorkerHost::kPostMessageToClient:
            return "Receive reply blink::mojom::ServiceWorkerHost::PostMessageToClient";
      case messages::ServiceWorkerHost::kFocusClient:
            return "Receive reply blink::mojom::ServiceWorkerHost::FocusClient";
      case messages::ServiceWorkerHost::kNavigateClient:
            return "Receive reply blink::mojom::ServiceWorkerHost::NavigateClient";
      case messages::ServiceWorkerHost::kSkipWaiting:
            return "Receive reply blink::mojom::ServiceWorkerHost::SkipWaiting";
      case messages::ServiceWorkerHost::kClaimClients:
            return "Receive reply blink::mojom::ServiceWorkerHost::ClaimClients";
      case messages::ServiceWorkerHost::kAddRoutes:
            return "Receive reply blink::mojom::ServiceWorkerHost::AddRoutes";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerHost::SetCachedMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x509bbada;  // IPCStableHash for blink::mojom::ServiceWorkerHost::SetCachedMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::ClearCachedMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc5ba8d0b;  // IPCStableHash for blink::mojom::ServiceWorkerHost::ClearCachedMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::GetClients_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe613506a;  // IPCStableHash for blink::mojom::ServiceWorkerHost::GetClients
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::GetClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe30ad7f8;  // IPCStableHash for blink::mojom::ServiceWorkerHost::GetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::OpenNewTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6214c564;  // IPCStableHash for blink::mojom::ServiceWorkerHost::OpenNewTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::OpenPaymentHandlerWindow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4b42aedc;  // IPCStableHash for blink::mojom::ServiceWorkerHost::OpenPaymentHandlerWindow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::PostMessageToClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf550a1ee;  // IPCStableHash for blink::mojom::ServiceWorkerHost::PostMessageToClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::FocusClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8e1b77af;  // IPCStableHash for blink::mojom::ServiceWorkerHost::FocusClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::NavigateClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdd3f8f6c;  // IPCStableHash for blink::mojom::ServiceWorkerHost::NavigateClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::SkipWaiting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x37c0438b;  // IPCStableHash for blink::mojom::ServiceWorkerHost::SkipWaiting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::ClaimClients_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9c521a4c;  // IPCStableHash for blink::mojom::ServiceWorkerHost::ClaimClients
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::AddRoutes_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6016dadf;  // IPCStableHash for blink::mojom::ServiceWorkerHost::AddRoutes
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ServiceWorkerHost_GetClients_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_GetClients_ForwardToCallback(
      ServiceWorkerHost::GetClientsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerHost_GetClients_ForwardToCallback(const ServiceWorkerHost_GetClients_ForwardToCallback&) = delete;
  ServiceWorkerHost_GetClients_ForwardToCallback& operator=(const ServiceWorkerHost_GetClients_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::GetClientsCallback callback_;
};

class ServiceWorkerHost_GetClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_GetClient_ForwardToCallback(
      ServiceWorkerHost::GetClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerHost_GetClient_ForwardToCallback(const ServiceWorkerHost_GetClient_ForwardToCallback&) = delete;
  ServiceWorkerHost_GetClient_ForwardToCallback& operator=(const ServiceWorkerHost_GetClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::GetClientCallback callback_;
};

class ServiceWorkerHost_OpenNewTab_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_OpenNewTab_ForwardToCallback(
      ServiceWorkerHost::OpenNewTabCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerHost_OpenNewTab_ForwardToCallback(const ServiceWorkerHost_OpenNewTab_ForwardToCallback&) = delete;
  ServiceWorkerHost_OpenNewTab_ForwardToCallback& operator=(const ServiceWorkerHost_OpenNewTab_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::OpenNewTabCallback callback_;
};

class ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback(
      ServiceWorkerHost::OpenPaymentHandlerWindowCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback(const ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback&) = delete;
  ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback& operator=(const ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::OpenPaymentHandlerWindowCallback callback_;
};

class ServiceWorkerHost_FocusClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_FocusClient_ForwardToCallback(
      ServiceWorkerHost::FocusClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerHost_FocusClient_ForwardToCallback(const ServiceWorkerHost_FocusClient_ForwardToCallback&) = delete;
  ServiceWorkerHost_FocusClient_ForwardToCallback& operator=(const ServiceWorkerHost_FocusClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::FocusClientCallback callback_;
};

class ServiceWorkerHost_NavigateClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_NavigateClient_ForwardToCallback(
      ServiceWorkerHost::NavigateClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerHost_NavigateClient_ForwardToCallback(const ServiceWorkerHost_NavigateClient_ForwardToCallback&) = delete;
  ServiceWorkerHost_NavigateClient_ForwardToCallback& operator=(const ServiceWorkerHost_NavigateClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::NavigateClientCallback callback_;
};

class ServiceWorkerHost_SkipWaiting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_SkipWaiting_ForwardToCallback(
      ServiceWorkerHost::SkipWaitingCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerHost_SkipWaiting_ForwardToCallback(const ServiceWorkerHost_SkipWaiting_ForwardToCallback&) = delete;
  ServiceWorkerHost_SkipWaiting_ForwardToCallback& operator=(const ServiceWorkerHost_SkipWaiting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::SkipWaitingCallback callback_;
};

class ServiceWorkerHost_ClaimClients_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_ClaimClients_ForwardToCallback(
      ServiceWorkerHost::ClaimClientsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerHost_ClaimClients_ForwardToCallback(const ServiceWorkerHost_ClaimClients_ForwardToCallback&) = delete;
  ServiceWorkerHost_ClaimClients_ForwardToCallback& operator=(const ServiceWorkerHost_ClaimClients_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::ClaimClientsCallback callback_;
};

class ServiceWorkerHost_AddRoutes_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_AddRoutes_ForwardToCallback(
      ServiceWorkerHost::AddRoutesCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerHost_AddRoutes_ForwardToCallback(const ServiceWorkerHost_AddRoutes_ForwardToCallback&) = delete;
  ServiceWorkerHost_AddRoutes_ForwardToCallback& operator=(const ServiceWorkerHost_AddRoutes_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::AddRoutesCallback callback_;
};

ServiceWorkerHostProxy::ServiceWorkerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerHostProxy::SetCachedMetadata(
    const ::blink::KURL& in_url, ::base::span<const ::uint8_t> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerHost::SetCachedMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kSetCachedMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_SetCachedMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ServiceWorkerHost.SetCachedMetadata request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ServiceWorkerHost.SetCachedMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("SetCachedMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerHostProxy::ClearCachedMetadata(
    const ::blink::KURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerHost::ClearCachedMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kClearCachedMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_ClearCachedMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ServiceWorkerHost.ClearCachedMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("ClearCachedMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerHostProxy::GetClients(
    ::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr in_options, GetClientsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerHost::GetClients", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kGetClients), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_GetClients_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientQueryOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in ServiceWorkerHost.GetClients request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("GetClients");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_GetClients_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerHostProxy::GetClient(
    const ::blink::String& in_client_uuid, GetClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerHost::GetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_uuid"), in_client_uuid,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kGetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_GetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_uuid)::BaseType> client_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_client_uuid,
    client_uuid_fragment);

  params->client_uuid.Set(
      client_uuid_fragment.is_null() ? nullptr : client_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_uuid in ServiceWorkerHost.GetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("GetClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_GetClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerHostProxy::OpenNewTab(
    const ::blink::KURL& in_url, OpenNewTabCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerHost::OpenNewTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kOpenNewTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_OpenNewTab_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ServiceWorkerHost.OpenNewTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("OpenNewTab");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_OpenNewTab_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerHostProxy::OpenPaymentHandlerWindow(
    const ::blink::KURL& in_url, OpenPaymentHandlerWindowCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerHost::OpenPaymentHandlerWindow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kOpenPaymentHandlerWindow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_OpenPaymentHandlerWindow_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ServiceWorkerHost.OpenPaymentHandlerWindow request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("OpenPaymentHandlerWindow");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerHostProxy::PostMessageToClient(
    const ::blink::String& in_client_uuid, ::blink::BlinkTransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerHost::PostMessageToClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_uuid"), in_client_uuid,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::blink::BlinkTransferableMessage>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kPostMessageToClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_PostMessageToClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_uuid)::BaseType> client_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_client_uuid,
    client_uuid_fragment);

  params->client_uuid.Set(
      client_uuid_fragment.is_null() ? nullptr : client_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_uuid in ServiceWorkerHost.PostMessageToClient request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in ServiceWorkerHost.PostMessageToClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("PostMessageToClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerHostProxy::FocusClient(
    const ::blink::String& in_client_uuid, FocusClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerHost::FocusClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_uuid"), in_client_uuid,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kFocusClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_FocusClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_uuid)::BaseType> client_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_client_uuid,
    client_uuid_fragment);

  params->client_uuid.Set(
      client_uuid_fragment.is_null() ? nullptr : client_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_uuid in ServiceWorkerHost.FocusClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("FocusClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_FocusClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerHostProxy::NavigateClient(
    const ::blink::String& in_client_uuid, const ::blink::KURL& in_url, NavigateClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerHost::NavigateClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_uuid"), in_client_uuid,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kNavigateClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_NavigateClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_uuid)::BaseType> client_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_client_uuid,
    client_uuid_fragment);

  params->client_uuid.Set(
      client_uuid_fragment.is_null() ? nullptr : client_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_uuid in ServiceWorkerHost.NavigateClient request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ServiceWorkerHost.NavigateClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("NavigateClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_NavigateClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerHostProxy::SkipWaiting(
    SkipWaitingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorkerHost::SkipWaiting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kSkipWaiting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_SkipWaiting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("SkipWaiting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_SkipWaiting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerHostProxy::ClaimClients(
    ClaimClientsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorkerHost::ClaimClients");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kClaimClients), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_ClaimClients_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("ClaimClients");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_ClaimClients_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerHostProxy::AddRoutes(
    const ::blink::ServiceWorkerRouterRules& in_rules, AddRoutesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerHost::AddRoutes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rules"), in_rules,
                        "<value of type const ::blink::ServiceWorkerRouterRules&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kAddRoutes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_AddRoutes_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rules)::BaseType> rules_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterRulesDataView>(
    in_rules,
    rules_fragment);

  params->rules.Set(
      rules_fragment.is_null() ? nullptr : rules_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rules.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rules in ServiceWorkerHost.AddRoutes request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("AddRoutes");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_AddRoutes_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ServiceWorkerHost_GetClients_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerHost::GetClientsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerHost_GetClients_ProxyToResponder> proxy(
        new ServiceWorkerHost_GetClients_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerHost_GetClients_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_GetClients_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerHost_GetClients_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerHost::GetClientsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr> in_clients);
};

bool ServiceWorkerHost_GetClients_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_GetClients_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_GetClients_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerHost.2
  bool success = true;
  ::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr> p_clients{};
  ServiceWorkerHost_GetClients_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadClients(&p_clients))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_clients));
  }
  return true;
}

void ServiceWorkerHost_GetClients_ProxyToResponder::Run(
    ::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr> in_clients) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerHost::GetClients", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clients"), in_clients,
                        "<value of type ::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kGetClients), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_GetClients_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->clients)::BaseType>
      clients_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& clients_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ServiceWorkerClientInfoDataView>>(
    in_clients,
    clients_fragment,
    &clients_validate_params);

  params->clients.Set(
      clients_fragment.is_null() ? nullptr : clients_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->clients.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null clients in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("GetClients");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_GetClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerHost::GetClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerHost_GetClient_ProxyToResponder> proxy(
        new ServiceWorkerHost_GetClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerHost_GetClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_GetClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerHost_GetClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerHost::GetClientCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerClientInfoPtr in_client);
};

bool ServiceWorkerHost_GetClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_GetClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_GetClient_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerHost.3
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerClientInfoPtr p_client{};
  ServiceWorkerHost_GetClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadClient(&p_client))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_client));
  }
  return true;
}

void ServiceWorkerHost_GetClient_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerClientInfoPtr in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerHost::GetClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::blink::mojom::blink::ServiceWorkerClientInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kGetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_GetClient_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client)::BaseType> client_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientInfoDataView>(
    in_client,
    client_fragment);

  params->client.Set(
      client_fragment.is_null() ? nullptr : client_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("GetClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_OpenNewTab_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerHost::OpenNewTabCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerHost_OpenNewTab_ProxyToResponder> proxy(
        new ServiceWorkerHost_OpenNewTab_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerHost_OpenNewTab_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_OpenNewTab_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerHost_OpenNewTab_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerHost::OpenNewTabCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, ::blink::mojom::blink::ServiceWorkerClientInfoPtr in_client, const ::blink::String& in_error_msg);
};

bool ServiceWorkerHost_OpenNewTab_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_OpenNewTab_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_OpenNewTab_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerHost.4
  bool success = true;
  bool p_success{};
  ::blink::mojom::blink::ServiceWorkerClientInfoPtr p_client{};
  ::blink::String p_error_msg{};
  ServiceWorkerHost_OpenNewTab_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadClient(&p_client))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_client), 
std::move(p_error_msg));
  }
  return true;
}

void ServiceWorkerHost_OpenNewTab_ProxyToResponder::Run(
    bool in_success, ::blink::mojom::blink::ServiceWorkerClientInfoPtr in_client, const ::blink::String& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerHost::OpenNewTab", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::blink::mojom::blink::ServiceWorkerClientInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kOpenNewTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_OpenNewTab_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->client)::BaseType> client_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientInfoDataView>(
    in_client,
    client_fragment);

  params->client.Set(
      client_fragment.is_null() ? nullptr : client_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("OpenNewTab");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerHost::OpenPaymentHandlerWindowCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder> proxy(
        new ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerHost::OpenPaymentHandlerWindowCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, ::blink::mojom::blink::ServiceWorkerClientInfoPtr in_client, const ::blink::String& in_error_msg);
};

bool ServiceWorkerHost_OpenPaymentHandlerWindow_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerHost.5
  bool success = true;
  bool p_success{};
  ::blink::mojom::blink::ServiceWorkerClientInfoPtr p_client{};
  ::blink::String p_error_msg{};
  ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadClient(&p_client))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_client), 
std::move(p_error_msg));
  }
  return true;
}

void ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder::Run(
    bool in_success, ::blink::mojom::blink::ServiceWorkerClientInfoPtr in_client, const ::blink::String& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerHost::OpenPaymentHandlerWindow", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::blink::mojom::blink::ServiceWorkerClientInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kOpenPaymentHandlerWindow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->client)::BaseType> client_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientInfoDataView>(
    in_client,
    client_fragment);

  params->client.Set(
      client_fragment.is_null() ? nullptr : client_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("OpenPaymentHandlerWindow");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_FocusClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerHost::FocusClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerHost_FocusClient_ProxyToResponder> proxy(
        new ServiceWorkerHost_FocusClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerHost_FocusClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_FocusClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerHost_FocusClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerHost::FocusClientCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      FocusResultPtr in_result);
};

bool ServiceWorkerHost_FocusClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_FocusClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_FocusClient_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerHost.7
  bool success = true;
  FocusResultPtr p_result{};
  ServiceWorkerHost_FocusClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ServiceWorkerHost_FocusClient_ProxyToResponder::Run(
    FocusResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerHost::FocusClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type FocusResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kFocusClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_FocusClient_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::FocusResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("FocusClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_NavigateClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerHost::NavigateClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerHost_NavigateClient_ProxyToResponder> proxy(
        new ServiceWorkerHost_NavigateClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerHost_NavigateClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_NavigateClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerHost_NavigateClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerHost::NavigateClientCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, ::blink::mojom::blink::ServiceWorkerClientInfoPtr in_client, const ::blink::String& in_error_msg);
};

bool ServiceWorkerHost_NavigateClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_NavigateClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_NavigateClient_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerHost.8
  bool success = true;
  bool p_success{};
  ::blink::mojom::blink::ServiceWorkerClientInfoPtr p_client{};
  ::blink::String p_error_msg{};
  ServiceWorkerHost_NavigateClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadClient(&p_client))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_client), 
std::move(p_error_msg));
  }
  return true;
}

void ServiceWorkerHost_NavigateClient_ProxyToResponder::Run(
    bool in_success, ::blink::mojom::blink::ServiceWorkerClientInfoPtr in_client, const ::blink::String& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerHost::NavigateClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::blink::mojom::blink::ServiceWorkerClientInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kNavigateClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_NavigateClient_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->client)::BaseType> client_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerClientInfoDataView>(
    in_client,
    client_fragment);

  params->client.Set(
      client_fragment.is_null() ? nullptr : client_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("NavigateClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_SkipWaiting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerHost::SkipWaitingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerHost_SkipWaiting_ProxyToResponder> proxy(
        new ServiceWorkerHost_SkipWaiting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerHost_SkipWaiting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_SkipWaiting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerHost_SkipWaiting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerHost::SkipWaitingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool ServiceWorkerHost_SkipWaiting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_SkipWaiting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_SkipWaiting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerHost.9
  bool success = true;
  bool p_success{};
  ServiceWorkerHost_SkipWaiting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void ServiceWorkerHost_SkipWaiting_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerHost::SkipWaiting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kSkipWaiting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_SkipWaiting_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("SkipWaiting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_ClaimClients_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerHost::ClaimClientsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerHost_ClaimClients_ProxyToResponder> proxy(
        new ServiceWorkerHost_ClaimClients_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerHost_ClaimClients_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_ClaimClients_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerHost_ClaimClients_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerHost::ClaimClientsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerErrorType in_error, const ::blink::String& in_error_msg);
};

bool ServiceWorkerHost_ClaimClients_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_ClaimClients_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_ClaimClients_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerHost.10
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerErrorType p_error{};
  ::blink::String p_error_msg{};
  ServiceWorkerHost_ClaimClients_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg));
  }
  return true;
}

void ServiceWorkerHost_ClaimClients_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerErrorType in_error, const ::blink::String& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerHost::ClaimClients", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::blink::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kClaimClients), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_ClaimClients_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("ClaimClients");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerHost_AddRoutes_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerHost::AddRoutesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerHost_AddRoutes_ProxyToResponder> proxy(
        new ServiceWorkerHost_AddRoutes_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerHost_AddRoutes_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_AddRoutes_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerHost_AddRoutes_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerHost::AddRoutesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_parse_error);
};

bool ServiceWorkerHost_AddRoutes_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_AddRoutes_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_AddRoutes_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerHost.11
  bool success = true;
  bool p_is_parse_error{};
  ServiceWorkerHost_AddRoutes_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_parse_error = input_data_view.is_parse_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_parse_error));
  }
  return true;
}

void ServiceWorkerHost_AddRoutes_ProxyToResponder::Run(
    bool in_is_parse_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerHost::AddRoutes", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_parse_error"), in_is_parse_error,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kAddRoutes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerHost_AddRoutes_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_parse_error = in_is_parse_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("AddRoutes");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerHostStubDispatch::Accept(
    ServiceWorkerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerHost>(message->header()->name)) {
    case messages::ServiceWorkerHost::kSetCachedMetadata: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_SetCachedMetadata_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_SetCachedMetadata_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerHost.0
      bool success = true;
      ::blink::KURL p_url{};
      ::base::span<const ::uint8_t> p_data{};
      ServiceWorkerHost_SetCachedMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCachedMetadata(        
        std::move(p_url), 
        std::move(p_data));
      return true;
    }
    case messages::ServiceWorkerHost::kClearCachedMetadata: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_ClearCachedMetadata_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_ClearCachedMetadata_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerHost.1
      bool success = true;
      ::blink::KURL p_url{};
      ServiceWorkerHost_ClearCachedMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearCachedMetadata(        
        std::move(p_url));
      return true;
    }
    case messages::ServiceWorkerHost::kGetClients: {
      break;
    }
    case messages::ServiceWorkerHost::kGetClient: {
      break;
    }
    case messages::ServiceWorkerHost::kOpenNewTab: {
      break;
    }
    case messages::ServiceWorkerHost::kOpenPaymentHandlerWindow: {
      break;
    }
    case messages::ServiceWorkerHost::kPostMessageToClient: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_PostMessageToClient_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_PostMessageToClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerHost.6
      bool success = true;
      ::blink::String p_client_uuid{};
      ::blink::BlinkTransferableMessage p_message{};
      ServiceWorkerHost_PostMessageToClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUuid(&p_client_uuid))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PostMessageToClient(        
        std::move(p_client_uuid), 
        std::move(p_message));
      return true;
    }
    case messages::ServiceWorkerHost::kFocusClient: {
      break;
    }
    case messages::ServiceWorkerHost::kNavigateClient: {
      break;
    }
    case messages::ServiceWorkerHost::kSkipWaiting: {
      break;
    }
    case messages::ServiceWorkerHost::kClaimClients: {
      break;
    }
    case messages::ServiceWorkerHost::kAddRoutes: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerHostStubDispatch::AcceptWithResponder(
    ServiceWorkerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerHost>(message->header()->name)) {
    case messages::ServiceWorkerHost::kSetCachedMetadata: {
      break;
    }
    case messages::ServiceWorkerHost::kClearCachedMetadata: {
      break;
    }
    case messages::ServiceWorkerHost::kGetClients: {
      internal::ServiceWorkerHost_GetClients_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_GetClients_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerHost.2
      bool success = true;
      ::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr p_options{};
      ServiceWorkerHost_GetClients_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 2, false);
        return false;
      }
      auto callback =
          ServiceWorkerHost_GetClients_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetClients(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerHost::kGetClient: {
      internal::ServiceWorkerHost_GetClient_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_GetClient_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerHost.3
      bool success = true;
      ::blink::String p_client_uuid{};
      ServiceWorkerHost_GetClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUuid(&p_client_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 3, false);
        return false;
      }
      auto callback =
          ServiceWorkerHost_GetClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetClient(        
        std::move(p_client_uuid), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerHost::kOpenNewTab: {
      internal::ServiceWorkerHost_OpenNewTab_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_OpenNewTab_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerHost.4
      bool success = true;
      ::blink::KURL p_url{};
      ServiceWorkerHost_OpenNewTab_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 4, false);
        return false;
      }
      auto callback =
          ServiceWorkerHost_OpenNewTab_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenNewTab(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerHost::kOpenPaymentHandlerWindow: {
      internal::ServiceWorkerHost_OpenPaymentHandlerWindow_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_OpenPaymentHandlerWindow_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerHost.5
      bool success = true;
      ::blink::KURL p_url{};
      ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 5, false);
        return false;
      }
      auto callback =
          ServiceWorkerHost_OpenPaymentHandlerWindow_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenPaymentHandlerWindow(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerHost::kPostMessageToClient: {
      break;
    }
    case messages::ServiceWorkerHost::kFocusClient: {
      internal::ServiceWorkerHost_FocusClient_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_FocusClient_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerHost.7
      bool success = true;
      ::blink::String p_client_uuid{};
      ServiceWorkerHost_FocusClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUuid(&p_client_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 7, false);
        return false;
      }
      auto callback =
          ServiceWorkerHost_FocusClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusClient(        
        std::move(p_client_uuid), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerHost::kNavigateClient: {
      internal::ServiceWorkerHost_NavigateClient_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_NavigateClient_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerHost.8
      bool success = true;
      ::blink::String p_client_uuid{};
      ::blink::KURL p_url{};
      ServiceWorkerHost_NavigateClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUuid(&p_client_uuid))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 8, false);
        return false;
      }
      auto callback =
          ServiceWorkerHost_NavigateClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NavigateClient(        
        std::move(p_client_uuid), 
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerHost::kSkipWaiting: {
      internal::ServiceWorkerHost_SkipWaiting_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_SkipWaiting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerHost.9
      bool success = true;
      ServiceWorkerHost_SkipWaiting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 9, false);
        return false;
      }
      auto callback =
          ServiceWorkerHost_SkipWaiting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SkipWaiting(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerHost::kClaimClients: {
      internal::ServiceWorkerHost_ClaimClients_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_ClaimClients_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerHost.10
      bool success = true;
      ServiceWorkerHost_ClaimClients_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 10, false);
        return false;
      }
      auto callback =
          ServiceWorkerHost_ClaimClients_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClaimClients(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerHost::kAddRoutes: {
      internal::ServiceWorkerHost_AddRoutes_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_AddRoutes_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerHost.11
      bool success = true;
      ::blink::ServiceWorkerRouterRules p_rules{};
      ServiceWorkerHost_AddRoutes_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRules(&p_rules))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 11, false);
        return false;
      }
      auto callback =
          ServiceWorkerHost_AddRoutes_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddRoutes(        
        std::move(p_rules), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerHostValidationInfo[] = {
    { &internal::ServiceWorkerHost_SetCachedMetadata_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerHost_ClearCachedMetadata_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerHost_GetClients_Params_Data::Validate,
     &internal::ServiceWorkerHost_GetClients_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerHost_GetClient_Params_Data::Validate,
     &internal::ServiceWorkerHost_GetClient_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerHost_OpenNewTab_Params_Data::Validate,
     &internal::ServiceWorkerHost_OpenNewTab_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerHost_OpenPaymentHandlerWindow_Params_Data::Validate,
     &internal::ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerHost_PostMessageToClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerHost_FocusClient_Params_Data::Validate,
     &internal::ServiceWorkerHost_FocusClient_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerHost_NavigateClient_Params_Data::Validate,
     &internal::ServiceWorkerHost_NavigateClient_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerHost_SkipWaiting_Params_Data::Validate,
     &internal::ServiceWorkerHost_SkipWaiting_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerHost_ClaimClients_Params_Data::Validate,
     &internal::ServiceWorkerHost_ClaimClients_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerHost_AddRoutes_Params_Data::Validate,
     &internal::ServiceWorkerHost_AddRoutes_ResponseParams_Data::Validate},
};

bool ServiceWorkerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ServiceWorkerHost::Name_,
    kServiceWorkerHostValidationInfo);
}

bool ServiceWorkerHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::ServiceWorkerHost::Name_,
    kServiceWorkerHostValidationInfo);
}
// The declaration includes the definition on other builds.

ServiceWorker::IPCStableHashFunction ServiceWorker::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorker>(message.name())) {
    case messages::ServiceWorker::kInitializeGlobalScope: {
      return &ServiceWorker::InitializeGlobalScope_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchInstallEvent: {
      return &ServiceWorker::DispatchInstallEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchActivateEvent: {
      return &ServiceWorker::DispatchActivateEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchBackgroundFetchAbortEvent: {
      return &ServiceWorker::DispatchBackgroundFetchAbortEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchBackgroundFetchClickEvent: {
      return &ServiceWorker::DispatchBackgroundFetchClickEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchBackgroundFetchFailEvent: {
      return &ServiceWorker::DispatchBackgroundFetchFailEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchBackgroundFetchSuccessEvent: {
      return &ServiceWorker::DispatchBackgroundFetchSuccessEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchCookieChangeEvent: {
      return &ServiceWorker::DispatchCookieChangeEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchFetchEventForMainResource: {
      return &ServiceWorker::DispatchFetchEventForMainResource_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchNotificationClickEvent: {
      return &ServiceWorker::DispatchNotificationClickEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchNotificationCloseEvent: {
      return &ServiceWorker::DispatchNotificationCloseEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchPushEvent: {
      return &ServiceWorker::DispatchPushEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchPushEventRecordingNetworkRequests: {
      return &ServiceWorker::DispatchPushEventRecordingNetworkRequests_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchPushSubscriptionChangeEvent: {
      return &ServiceWorker::DispatchPushSubscriptionChangeEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchSyncEvent: {
      return &ServiceWorker::DispatchSyncEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchPeriodicSyncEvent: {
      return &ServiceWorker::DispatchPeriodicSyncEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchAbortPaymentEvent: {
      return &ServiceWorker::DispatchAbortPaymentEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchCanMakePaymentEvent: {
      return &ServiceWorker::DispatchCanMakePaymentEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchPaymentRequestEvent: {
      return &ServiceWorker::DispatchPaymentRequestEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchExtendableMessageEvent: {
      return &ServiceWorker::DispatchExtendableMessageEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchContentDeleteEvent: {
      return &ServiceWorker::DispatchContentDeleteEvent_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kPing: {
      return &ServiceWorker::Ping_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kSetIdleDelay: {
      return &ServiceWorker::SetIdleDelay_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kAddKeepAlive: {
      return &ServiceWorker::AddKeepAlive_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kClearKeepAlive: {
      return &ServiceWorker::ClearKeepAlive_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kAddMessageToConsole: {
      return &ServiceWorker::AddMessageToConsole_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kExecuteScriptForTest: {
      return &ServiceWorker::ExecuteScriptForTest_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorker::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorker>(message.name())) {
      case messages::ServiceWorker::kInitializeGlobalScope:
            return "Receive blink::mojom::ServiceWorker::InitializeGlobalScope";
      case messages::ServiceWorker::kDispatchInstallEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchInstallEvent";
      case messages::ServiceWorker::kDispatchActivateEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchActivateEvent";
      case messages::ServiceWorker::kDispatchBackgroundFetchAbortEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchBackgroundFetchAbortEvent";
      case messages::ServiceWorker::kDispatchBackgroundFetchClickEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchBackgroundFetchClickEvent";
      case messages::ServiceWorker::kDispatchBackgroundFetchFailEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchBackgroundFetchFailEvent";
      case messages::ServiceWorker::kDispatchBackgroundFetchSuccessEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchBackgroundFetchSuccessEvent";
      case messages::ServiceWorker::kDispatchCookieChangeEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchCookieChangeEvent";
      case messages::ServiceWorker::kDispatchFetchEventForMainResource:
            return "Receive blink::mojom::ServiceWorker::DispatchFetchEventForMainResource";
      case messages::ServiceWorker::kDispatchNotificationClickEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchNotificationClickEvent";
      case messages::ServiceWorker::kDispatchNotificationCloseEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchNotificationCloseEvent";
      case messages::ServiceWorker::kDispatchPushEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchPushEvent";
      case messages::ServiceWorker::kDispatchPushEventRecordingNetworkRequests:
            return "Receive blink::mojom::ServiceWorker::DispatchPushEventRecordingNetworkRequests";
      case messages::ServiceWorker::kDispatchPushSubscriptionChangeEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchPushSubscriptionChangeEvent";
      case messages::ServiceWorker::kDispatchSyncEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchSyncEvent";
      case messages::ServiceWorker::kDispatchPeriodicSyncEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchPeriodicSyncEvent";
      case messages::ServiceWorker::kDispatchAbortPaymentEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchAbortPaymentEvent";
      case messages::ServiceWorker::kDispatchCanMakePaymentEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchCanMakePaymentEvent";
      case messages::ServiceWorker::kDispatchPaymentRequestEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchPaymentRequestEvent";
      case messages::ServiceWorker::kDispatchExtendableMessageEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchExtendableMessageEvent";
      case messages::ServiceWorker::kDispatchContentDeleteEvent:
            return "Receive blink::mojom::ServiceWorker::DispatchContentDeleteEvent";
      case messages::ServiceWorker::kPing:
            return "Receive blink::mojom::ServiceWorker::Ping";
      case messages::ServiceWorker::kSetIdleDelay:
            return "Receive blink::mojom::ServiceWorker::SetIdleDelay";
      case messages::ServiceWorker::kAddKeepAlive:
            return "Receive blink::mojom::ServiceWorker::AddKeepAlive";
      case messages::ServiceWorker::kClearKeepAlive:
            return "Receive blink::mojom::ServiceWorker::ClearKeepAlive";
      case messages::ServiceWorker::kAddMessageToConsole:
            return "Receive blink::mojom::ServiceWorker::AddMessageToConsole";
      case messages::ServiceWorker::kExecuteScriptForTest:
            return "Receive blink::mojom::ServiceWorker::ExecuteScriptForTest";
    }
  } else {
    switch (static_cast<messages::ServiceWorker>(message.name())) {
      case messages::ServiceWorker::kInitializeGlobalScope:
            return "Receive reply blink::mojom::ServiceWorker::InitializeGlobalScope";
      case messages::ServiceWorker::kDispatchInstallEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchInstallEvent";
      case messages::ServiceWorker::kDispatchActivateEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchActivateEvent";
      case messages::ServiceWorker::kDispatchBackgroundFetchAbortEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchBackgroundFetchAbortEvent";
      case messages::ServiceWorker::kDispatchBackgroundFetchClickEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchBackgroundFetchClickEvent";
      case messages::ServiceWorker::kDispatchBackgroundFetchFailEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchBackgroundFetchFailEvent";
      case messages::ServiceWorker::kDispatchBackgroundFetchSuccessEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchBackgroundFetchSuccessEvent";
      case messages::ServiceWorker::kDispatchCookieChangeEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchCookieChangeEvent";
      case messages::ServiceWorker::kDispatchFetchEventForMainResource:
            return "Receive reply blink::mojom::ServiceWorker::DispatchFetchEventForMainResource";
      case messages::ServiceWorker::kDispatchNotificationClickEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchNotificationClickEvent";
      case messages::ServiceWorker::kDispatchNotificationCloseEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchNotificationCloseEvent";
      case messages::ServiceWorker::kDispatchPushEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchPushEvent";
      case messages::ServiceWorker::kDispatchPushEventRecordingNetworkRequests:
            return "Receive reply blink::mojom::ServiceWorker::DispatchPushEventRecordingNetworkRequests";
      case messages::ServiceWorker::kDispatchPushSubscriptionChangeEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchPushSubscriptionChangeEvent";
      case messages::ServiceWorker::kDispatchSyncEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchSyncEvent";
      case messages::ServiceWorker::kDispatchPeriodicSyncEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchPeriodicSyncEvent";
      case messages::ServiceWorker::kDispatchAbortPaymentEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchAbortPaymentEvent";
      case messages::ServiceWorker::kDispatchCanMakePaymentEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchCanMakePaymentEvent";
      case messages::ServiceWorker::kDispatchPaymentRequestEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchPaymentRequestEvent";
      case messages::ServiceWorker::kDispatchExtendableMessageEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchExtendableMessageEvent";
      case messages::ServiceWorker::kDispatchContentDeleteEvent:
            return "Receive reply blink::mojom::ServiceWorker::DispatchContentDeleteEvent";
      case messages::ServiceWorker::kPing:
            return "Receive reply blink::mojom::ServiceWorker::Ping";
      case messages::ServiceWorker::kSetIdleDelay:
            return "Receive reply blink::mojom::ServiceWorker::SetIdleDelay";
      case messages::ServiceWorker::kAddKeepAlive:
            return "Receive reply blink::mojom::ServiceWorker::AddKeepAlive";
      case messages::ServiceWorker::kClearKeepAlive:
            return "Receive reply blink::mojom::ServiceWorker::ClearKeepAlive";
      case messages::ServiceWorker::kAddMessageToConsole:
            return "Receive reply blink::mojom::ServiceWorker::AddMessageToConsole";
      case messages::ServiceWorker::kExecuteScriptForTest:
            return "Receive reply blink::mojom::ServiceWorker::ExecuteScriptForTest";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorker::InitializeGlobalScope_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x088e2dc1;  // IPCStableHash for blink::mojom::ServiceWorker::InitializeGlobalScope
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchInstallEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb16d2f2a;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchInstallEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchActivateEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8ac340c4;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchActivateEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchBackgroundFetchAbortEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf9b3775d;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchBackgroundFetchAbortEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchBackgroundFetchClickEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x09fa6ce9;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchBackgroundFetchClickEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchBackgroundFetchFailEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x82d6dfc4;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchBackgroundFetchFailEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchBackgroundFetchSuccessEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x922f5b75;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchBackgroundFetchSuccessEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchCookieChangeEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf7780bfd;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchCookieChangeEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchFetchEventForMainResource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x14d0f7ae;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchFetchEventForMainResource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchNotificationClickEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x757b3f0e;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchNotificationClickEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchNotificationCloseEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1fa6f7a1;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchNotificationCloseEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchPushEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ef0a903;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchPushEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchPushEventRecordingNetworkRequests_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08f17d2c;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchPushEventRecordingNetworkRequests
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchPushSubscriptionChangeEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4cd6435c;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchPushSubscriptionChangeEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchSyncEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa47f8d8e;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchSyncEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchPeriodicSyncEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ef8ec9f;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchPeriodicSyncEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchAbortPaymentEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfd06784d;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchAbortPaymentEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchCanMakePaymentEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe224d2bc;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchCanMakePaymentEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchPaymentRequestEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x501eb9da;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchPaymentRequestEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchExtendableMessageEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a5afc5a;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchExtendableMessageEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchContentDeleteEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x811307e2;  // IPCStableHash for blink::mojom::ServiceWorker::DispatchContentDeleteEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::Ping_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41004655;  // IPCStableHash for blink::mojom::ServiceWorker::Ping
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::SetIdleDelay_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a286e13;  // IPCStableHash for blink::mojom::ServiceWorker::SetIdleDelay
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::AddKeepAlive_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a6f2161;  // IPCStableHash for blink::mojom::ServiceWorker::AddKeepAlive
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::ClearKeepAlive_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8bc6f8ed;  // IPCStableHash for blink::mojom::ServiceWorker::ClearKeepAlive
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::AddMessageToConsole_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe149a5c8;  // IPCStableHash for blink::mojom::ServiceWorker::AddMessageToConsole
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::ExecuteScriptForTest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x65e9a4a9;  // IPCStableHash for blink::mojom::ServiceWorker::ExecuteScriptForTest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ServiceWorker_DispatchInstallEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchInstallEvent_ForwardToCallback(
      ServiceWorker::DispatchInstallEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchInstallEvent_ForwardToCallback(const ServiceWorker_DispatchInstallEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchInstallEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchInstallEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchInstallEventCallback callback_;
};

class ServiceWorker_DispatchActivateEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchActivateEvent_ForwardToCallback(
      ServiceWorker::DispatchActivateEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchActivateEvent_ForwardToCallback(const ServiceWorker_DispatchActivateEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchActivateEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchActivateEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchActivateEventCallback callback_;
};

class ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback(
      ServiceWorker::DispatchBackgroundFetchAbortEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback(const ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchBackgroundFetchAbortEventCallback callback_;
};

class ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback(
      ServiceWorker::DispatchBackgroundFetchClickEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback(const ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchBackgroundFetchClickEventCallback callback_;
};

class ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback(
      ServiceWorker::DispatchBackgroundFetchFailEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback(const ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchBackgroundFetchFailEventCallback callback_;
};

class ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback(
      ServiceWorker::DispatchBackgroundFetchSuccessEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback(const ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchBackgroundFetchSuccessEventCallback callback_;
};

class ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback(
      ServiceWorker::DispatchCookieChangeEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback(const ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchCookieChangeEventCallback callback_;
};

class ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback(
      ServiceWorker::DispatchFetchEventForMainResourceCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback(const ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback&) = delete;
  ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback& operator=(const ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchFetchEventForMainResourceCallback callback_;
};

class ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback(
      ServiceWorker::DispatchNotificationClickEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback(const ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchNotificationClickEventCallback callback_;
};

class ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback(
      ServiceWorker::DispatchNotificationCloseEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback(const ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchNotificationCloseEventCallback callback_;
};

class ServiceWorker_DispatchPushEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchPushEvent_ForwardToCallback(
      ServiceWorker::DispatchPushEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchPushEvent_ForwardToCallback(const ServiceWorker_DispatchPushEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchPushEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchPushEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchPushEventCallback callback_;
};

class ServiceWorker_DispatchPushEventRecordingNetworkRequests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchPushEventRecordingNetworkRequests_ForwardToCallback(
      ServiceWorker::DispatchPushEventRecordingNetworkRequestsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchPushEventRecordingNetworkRequests_ForwardToCallback(const ServiceWorker_DispatchPushEventRecordingNetworkRequests_ForwardToCallback&) = delete;
  ServiceWorker_DispatchPushEventRecordingNetworkRequests_ForwardToCallback& operator=(const ServiceWorker_DispatchPushEventRecordingNetworkRequests_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchPushEventRecordingNetworkRequestsCallback callback_;
};

class ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback(
      ServiceWorker::DispatchPushSubscriptionChangeEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback(const ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchPushSubscriptionChangeEventCallback callback_;
};

class ServiceWorker_DispatchSyncEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchSyncEvent_ForwardToCallback(
      ServiceWorker::DispatchSyncEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchSyncEvent_ForwardToCallback(const ServiceWorker_DispatchSyncEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchSyncEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchSyncEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchSyncEventCallback callback_;
};

class ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback(
      ServiceWorker::DispatchPeriodicSyncEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback(const ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchPeriodicSyncEventCallback callback_;
};

class ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback(
      ServiceWorker::DispatchAbortPaymentEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback(const ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchAbortPaymentEventCallback callback_;
};

class ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback(
      ServiceWorker::DispatchCanMakePaymentEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback(const ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchCanMakePaymentEventCallback callback_;
};

class ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback(
      ServiceWorker::DispatchPaymentRequestEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback(const ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchPaymentRequestEventCallback callback_;
};

class ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback(
      ServiceWorker::DispatchExtendableMessageEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback(const ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchExtendableMessageEventCallback callback_;
};

class ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback(
      ServiceWorker::DispatchContentDeleteEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback(const ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback&) = delete;
  ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback& operator=(const ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchContentDeleteEventCallback callback_;
};

class ServiceWorker_Ping_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_Ping_ForwardToCallback(
      ServiceWorker::PingCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_Ping_ForwardToCallback(const ServiceWorker_Ping_ForwardToCallback&) = delete;
  ServiceWorker_Ping_ForwardToCallback& operator=(const ServiceWorker_Ping_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::PingCallback callback_;
};

class ServiceWorker_ExecuteScriptForTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_ExecuteScriptForTest_ForwardToCallback(
      ServiceWorker::ExecuteScriptForTestCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_ExecuteScriptForTest_ForwardToCallback(const ServiceWorker_ExecuteScriptForTest_ForwardToCallback&) = delete;
  ServiceWorker_ExecuteScriptForTest_ForwardToCallback& operator=(const ServiceWorker_ExecuteScriptForTest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::ExecuteScriptForTestCallback callback_;
};

ServiceWorkerProxy::ServiceWorkerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerProxy::InitializeGlobalScope(
    ::mojo::PendingAssociatedRemote<ServiceWorkerHost> in_service_worker_host, ::mojo::PendingAssociatedRemote<::blink::mojom::blink::AssociatedInterfaceProvider> in_associated_interfaces_to_browser, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::AssociatedInterfaceProvider> in_associated_interfaces_from_browser, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr in_registration_info, ::blink::mojom::blink::ServiceWorkerObjectInfoPtr in_service_worker_info, FetchHandlerExistence in_fetch_handler_existence, ::blink::mojom::blink::AncestorFrameType in_ancestor_frame_type, const ::blink::BlinkStorageKey& in_storage_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::InitializeGlobalScope", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_host"), in_service_worker_host,
                        "<value of type ::mojo::PendingAssociatedRemote<ServiceWorkerHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("associated_interfaces_to_browser"), in_associated_interfaces_to_browser,
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::blink::AssociatedInterfaceProvider>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("associated_interfaces_from_browser"), in_associated_interfaces_from_browser,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::AssociatedInterfaceProvider>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_info"), in_registration_info,
                        "<value of type ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_info"), in_service_worker_info,
                        "<value of type ::blink::mojom::blink::ServiceWorkerObjectInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fetch_handler_existence"), in_fetch_handler_existence,
                        "<value of type FetchHandlerExistence>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ancestor_frame_type"), in_ancestor_frame_type,
                        "<value of type ::blink::mojom::blink::AncestorFrameType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::BlinkStorageKey&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kInitializeGlobalScope), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_InitializeGlobalScope_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerHostAssociatedPtrInfoDataView>(
    in_service_worker_host,
    &params->service_worker_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->service_worker_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid service_worker_host in ServiceWorker.InitializeGlobalScope request");

  
  mojo::internal::Serialize<::blink::mojom::AssociatedInterfaceProviderAssociatedPtrInfoDataView>(
    in_associated_interfaces_to_browser,
    &params->associated_interfaces_to_browser,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->associated_interfaces_to_browser)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid associated_interfaces_to_browser in ServiceWorker.InitializeGlobalScope request");

  
  mojo::internal::Serialize<::blink::mojom::AssociatedInterfaceProviderAssociatedRequestDataView>(
    in_associated_interfaces_from_browser,
    &params->associated_interfaces_from_browser,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->associated_interfaces_from_browser)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid associated_interfaces_from_browser in ServiceWorker.InitializeGlobalScope request");
  mojo::internal::MessageFragment<
      typename decltype(params->registration_info)::BaseType> registration_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerRegistrationObjectInfoDataView>(
    in_registration_info,
    registration_info_fragment);

  params->registration_info.Set(
      registration_info_fragment.is_null() ? nullptr : registration_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registration_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registration_info in ServiceWorker.InitializeGlobalScope request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_worker_info)::BaseType> service_worker_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
    in_service_worker_info,
    service_worker_info_fragment);

  params->service_worker_info.Set(
      service_worker_info_fragment.is_null() ? nullptr : service_worker_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_worker_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_worker_info in ServiceWorker.InitializeGlobalScope request");

  
  mojo::internal::Serialize<::blink::mojom::FetchHandlerExistence>(
    in_fetch_handler_existence,
    &params->fetch_handler_existence);

  
  mojo::internal::Serialize<::blink::mojom::AncestorFrameType>(
    in_ancestor_frame_type,
    &params->ancestor_frame_type);
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_storage_key,
    storage_key_fragment);

  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->storage_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null storage_key in ServiceWorker.InitializeGlobalScope request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("InitializeGlobalScope");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerProxy::DispatchInstallEvent(
    DispatchInstallEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorker::DispatchInstallEvent");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchInstallEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchInstallEvent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchInstallEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchInstallEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchActivateEvent(
    DispatchActivateEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorker::DispatchActivateEvent");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchActivateEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchActivateEvent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchActivateEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchActivateEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchBackgroundFetchAbortEvent(
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr in_registration, DispatchBackgroundFetchAbortEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchBackgroundFetchAbortEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::blink::mojom::blink::BackgroundFetchRegistrationPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchBackgroundFetchAbortEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchRegistrationDataView>(
    in_registration,
    registration_fragment);

  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registration in ServiceWorker.DispatchBackgroundFetchAbortEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchAbortEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchBackgroundFetchClickEvent(
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr in_registration, DispatchBackgroundFetchClickEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchBackgroundFetchClickEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::blink::mojom::blink::BackgroundFetchRegistrationPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchBackgroundFetchClickEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchClickEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchRegistrationDataView>(
    in_registration,
    registration_fragment);

  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registration in ServiceWorker.DispatchBackgroundFetchClickEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchClickEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchBackgroundFetchFailEvent(
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr in_registration, DispatchBackgroundFetchFailEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchBackgroundFetchFailEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::blink::mojom::blink::BackgroundFetchRegistrationPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchBackgroundFetchFailEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchFailEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchRegistrationDataView>(
    in_registration,
    registration_fragment);

  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registration in ServiceWorker.DispatchBackgroundFetchFailEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchFailEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchBackgroundFetchSuccessEvent(
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr in_registration, DispatchBackgroundFetchSuccessEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchBackgroundFetchSuccessEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::blink::mojom::blink::BackgroundFetchRegistrationPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchBackgroundFetchSuccessEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchRegistrationDataView>(
    in_registration,
    registration_fragment);

  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registration in ServiceWorker.DispatchBackgroundFetchSuccessEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchSuccessEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchCookieChangeEvent(
    ::network::mojom::blink::CookieChangeInfoPtr in_change, DispatchCookieChangeEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchCookieChangeEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("change"), in_change,
                        "<value of type ::network::mojom::blink::CookieChangeInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchCookieChangeEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchCookieChangeEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->change)::BaseType> change_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookieChangeInfoDataView>(
    in_change,
    change_fragment);

  params->change.Set(
      change_fragment.is_null() ? nullptr : change_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->change.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null change in ServiceWorker.DispatchCookieChangeEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchCookieChangeEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchFetchEventForMainResource(
    ::blink::mojom::blink::DispatchFetchEventParamsPtr in_params, ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback> in_response_callback, DispatchFetchEventForMainResourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchFetchEventForMainResource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::blink::mojom::blink::DispatchFetchEventParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_callback"), in_response_callback,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchFetchEventForMainResource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchFetchEventForMainResource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DispatchFetchEventParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in ServiceWorker.DispatchFetchEventForMainResource request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ServiceWorkerFetchResponseCallbackInterfaceBase>>(
    in_response_callback,
    &params->response_callback,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->response_callback)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid response_callback in ServiceWorker.DispatchFetchEventForMainResource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchFetchEventForMainResource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchNotificationClickEvent(
    const ::blink::String& in_notification_id, ::blink::mojom::blink::NotificationDataPtr in_notification_data, int32_t in_action_index, const ::blink::String& in_reply, DispatchNotificationClickEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchNotificationClickEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_id"), in_notification_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_data"), in_notification_data,
                        "<value of type ::blink::mojom::blink::NotificationDataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_index"), in_action_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reply"), in_reply,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchNotificationClickEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchNotificationClickEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notification_id)::BaseType> notification_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_notification_id,
    notification_id_fragment);

  params->notification_id.Set(
      notification_id_fragment.is_null() ? nullptr : notification_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_id in ServiceWorker.DispatchNotificationClickEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->notification_data)::BaseType> notification_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::NotificationDataDataView>(
    in_notification_data,
    notification_data_fragment);

  params->notification_data.Set(
      notification_data_fragment.is_null() ? nullptr : notification_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_data in ServiceWorker.DispatchNotificationClickEvent request");

  params->action_index = in_action_index;
  mojo::internal::MessageFragment<
      typename decltype(params->reply)::BaseType> reply_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_reply,
    reply_fragment);

  params->reply.Set(
      reply_fragment.is_null() ? nullptr : reply_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchNotificationClickEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchNotificationCloseEvent(
    const ::blink::String& in_notification_id, ::blink::mojom::blink::NotificationDataPtr in_notification_data, DispatchNotificationCloseEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchNotificationCloseEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_id"), in_notification_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_data"), in_notification_data,
                        "<value of type ::blink::mojom::blink::NotificationDataPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchNotificationCloseEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchNotificationCloseEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notification_id)::BaseType> notification_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_notification_id,
    notification_id_fragment);

  params->notification_id.Set(
      notification_id_fragment.is_null() ? nullptr : notification_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_id in ServiceWorker.DispatchNotificationCloseEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->notification_data)::BaseType> notification_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::NotificationDataDataView>(
    in_notification_data,
    notification_data_fragment);

  params->notification_data.Set(
      notification_data_fragment.is_null() ? nullptr : notification_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_data in ServiceWorker.DispatchNotificationCloseEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchNotificationCloseEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchPushEvent(
    const ::blink::String& in_payload, DispatchPushEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchPushEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("payload"), in_payload,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchPushEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPushEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->payload)::BaseType> payload_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_payload,
    payload_fragment);

  params->payload.Set(
      payload_fragment.is_null() ? nullptr : payload_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPushEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchPushEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchPushEventRecordingNetworkRequests(
    const ::blink::String& in_payload, DispatchPushEventRecordingNetworkRequestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchPushEventRecordingNetworkRequests", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("payload"), in_payload,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchPushEventRecordingNetworkRequests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPushEventRecordingNetworkRequests_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->payload)::BaseType> payload_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_payload,
    payload_fragment);

  params->payload.Set(
      payload_fragment.is_null() ? nullptr : payload_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPushEventRecordingNetworkRequests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchPushEventRecordingNetworkRequests_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchPushSubscriptionChangeEvent(
    ::blink::mojom::blink::PushSubscriptionPtr in_old_subscription, ::blink::mojom::blink::PushSubscriptionPtr in_new_subscription, DispatchPushSubscriptionChangeEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchPushSubscriptionChangeEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_subscription"), in_old_subscription,
                        "<value of type ::blink::mojom::blink::PushSubscriptionPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_subscription"), in_new_subscription,
                        "<value of type ::blink::mojom::blink::PushSubscriptionPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchPushSubscriptionChangeEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->old_subscription)::BaseType> old_subscription_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PushSubscriptionDataView>(
    in_old_subscription,
    old_subscription_fragment);

  params->old_subscription.Set(
      old_subscription_fragment.is_null() ? nullptr : old_subscription_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->new_subscription)::BaseType> new_subscription_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PushSubscriptionDataView>(
    in_new_subscription,
    new_subscription_fragment);

  params->new_subscription.Set(
      new_subscription_fragment.is_null() ? nullptr : new_subscription_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPushSubscriptionChangeEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchSyncEvent(
    const ::blink::String& in_tag, bool in_last_chance, ::base::TimeDelta in_timeout, DispatchSyncEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchSyncEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tag"), in_tag,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("last_chance"), in_last_chance,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timeout"), in_timeout,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchSyncEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchSyncEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tag)::BaseType> tag_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_tag,
    tag_fragment);

  params->tag.Set(
      tag_fragment.is_null() ? nullptr : tag_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tag.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tag in ServiceWorker.DispatchSyncEvent request");

  params->last_chance = in_last_chance;
  mojo::internal::MessageFragment<
      typename decltype(params->timeout)::BaseType> timeout_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_timeout,
    timeout_fragment);

  params->timeout.Set(
      timeout_fragment.is_null() ? nullptr : timeout_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timeout.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timeout in ServiceWorker.DispatchSyncEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchSyncEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchSyncEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchPeriodicSyncEvent(
    const ::blink::String& in_tag, ::base::TimeDelta in_timeout, DispatchPeriodicSyncEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchPeriodicSyncEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tag"), in_tag,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timeout"), in_timeout,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchPeriodicSyncEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPeriodicSyncEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tag)::BaseType> tag_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_tag,
    tag_fragment);

  params->tag.Set(
      tag_fragment.is_null() ? nullptr : tag_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tag.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tag in ServiceWorker.DispatchPeriodicSyncEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->timeout)::BaseType> timeout_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_timeout,
    timeout_fragment);

  params->timeout.Set(
      timeout_fragment.is_null() ? nullptr : timeout_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timeout.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timeout in ServiceWorker.DispatchPeriodicSyncEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPeriodicSyncEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchAbortPaymentEvent(
    ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> in_result_of_abort_payment, DispatchAbortPaymentEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchAbortPaymentEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_of_abort_payment"), in_result_of_abort_payment,
                        "<value of type ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchAbortPaymentEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchAbortPaymentEvent_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::PaymentHandlerResponseCallbackInterfaceBase>>(
    in_result_of_abort_payment,
    &params->result_of_abort_payment,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->result_of_abort_payment)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid result_of_abort_payment in ServiceWorker.DispatchAbortPaymentEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchAbortPaymentEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchCanMakePaymentEvent(
    ::payments::mojom::blink::CanMakePaymentEventDataPtr in_event_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> in_result_of_can_make_payment, DispatchCanMakePaymentEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchCanMakePaymentEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_data"), in_event_data,
                        "<value of type ::payments::mojom::blink::CanMakePaymentEventDataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_of_can_make_payment"), in_result_of_can_make_payment,
                        "<value of type ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchCanMakePaymentEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchCanMakePaymentEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_data)::BaseType> event_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::payments::mojom::CanMakePaymentEventDataDataView>(
    in_event_data,
    event_data_fragment);

  params->event_data.Set(
      event_data_fragment.is_null() ? nullptr : event_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_data in ServiceWorker.DispatchCanMakePaymentEvent request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::PaymentHandlerResponseCallbackInterfaceBase>>(
    in_result_of_can_make_payment,
    &params->result_of_can_make_payment,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->result_of_can_make_payment)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid result_of_can_make_payment in ServiceWorker.DispatchCanMakePaymentEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchCanMakePaymentEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchPaymentRequestEvent(
    ::payments::mojom::blink::PaymentRequestEventDataPtr in_request_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> in_response_callback, DispatchPaymentRequestEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchPaymentRequestEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_data"), in_request_data,
                        "<value of type ::payments::mojom::blink::PaymentRequestEventDataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_callback"), in_response_callback,
                        "<value of type ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchPaymentRequestEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPaymentRequestEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_data)::BaseType> request_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::payments::mojom::PaymentRequestEventDataDataView>(
    in_request_data,
    request_data_fragment);

  params->request_data.Set(
      request_data_fragment.is_null() ? nullptr : request_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_data in ServiceWorker.DispatchPaymentRequestEvent request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::PaymentHandlerResponseCallbackInterfaceBase>>(
    in_response_callback,
    &params->response_callback,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->response_callback)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid response_callback in ServiceWorker.DispatchPaymentRequestEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPaymentRequestEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchExtendableMessageEvent(
    ExtendableMessageEventPtr in_event, DispatchExtendableMessageEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchExtendableMessageEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ExtendableMessageEventPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchExtendableMessageEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchExtendableMessageEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ExtendableMessageEventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in ServiceWorker.DispatchExtendableMessageEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchExtendableMessageEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::DispatchContentDeleteEvent(
    const ::blink::String& in_id, DispatchContentDeleteEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::DispatchContentDeleteEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchContentDeleteEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchContentDeleteEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in ServiceWorker.DispatchContentDeleteEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchContentDeleteEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::Ping(
    PingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorker::Ping");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kPing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_Ping_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("Ping");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_Ping_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerProxy::SetIdleDelay(
    ::base::TimeDelta in_delay) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::SetIdleDelay", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delay"), in_delay,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kSetIdleDelay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_SetIdleDelay_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->delay)::BaseType> delay_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_delay,
    delay_fragment);

  params->delay.Set(
      delay_fragment.is_null() ? nullptr : delay_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->delay.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null delay in ServiceWorker.SetIdleDelay request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("SetIdleDelay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerProxy::AddKeepAlive(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorker::AddKeepAlive");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kAddKeepAlive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_AddKeepAlive_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("AddKeepAlive");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerProxy::ClearKeepAlive(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorker::ClearKeepAlive");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kClearKeepAlive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_ClearKeepAlive_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("ClearKeepAlive");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerProxy::AddMessageToConsole(
    ::blink::mojom::blink::ConsoleMessageLevel in_level, const ::blink::String& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::AddMessageToConsole", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("level"), in_level,
                        "<value of type ::blink::mojom::blink::ConsoleMessageLevel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kAddMessageToConsole), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_AddMessageToConsole_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageLevel>(
    in_level,
    &params->level);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in ServiceWorker.AddMessageToConsole request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("AddMessageToConsole");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerProxy::ExecuteScriptForTest(
    const ::blink::String& in_javascript, bool in_wants_result, ExecuteScriptForTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorker::ExecuteScriptForTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript"), in_javascript,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wants_result"), in_wants_result,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kExecuteScriptForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_ExecuteScriptForTest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript)::BaseType> javascript_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_javascript,
    javascript_fragment);

  params->javascript.Set(
      javascript_fragment.is_null() ? nullptr : javascript_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->javascript.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null javascript in ServiceWorker.ExecuteScriptForTest request");

  params->wants_result = in_wants_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("ExecuteScriptForTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_ExecuteScriptForTest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ServiceWorker_DispatchInstallEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchInstallEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchInstallEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchInstallEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchInstallEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchInstallEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchInstallEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchInstallEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status, uint32_t in_fetch_count);
};

bool ServiceWorker_DispatchInstallEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchInstallEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchInstallEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.1
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  uint32_t p_fetch_count{};
  ServiceWorker_DispatchInstallEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success)
    p_fetch_count = input_data_view.fetch_count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_fetch_count));
  }
  return true;
}

void ServiceWorker_DispatchInstallEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status, uint32_t in_fetch_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchInstallEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fetch_count"), in_fetch_count,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchInstallEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchInstallEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

  params->fetch_count = in_fetch_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchInstallEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchActivateEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchActivateEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchActivateEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchActivateEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchActivateEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchActivateEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchActivateEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchActivateEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchActivateEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchActivateEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchActivateEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.2
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchActivateEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchActivateEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchActivateEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchActivateEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchActivateEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchActivateEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchBackgroundFetchAbortEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchBackgroundFetchAbortEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchBackgroundFetchAbortEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.3
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchBackgroundFetchAbortEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchBackgroundFetchAbortEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchAbortEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchBackgroundFetchClickEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchBackgroundFetchClickEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchBackgroundFetchClickEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.4
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchBackgroundFetchClickEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchBackgroundFetchClickEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchClickEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchBackgroundFetchFailEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchBackgroundFetchFailEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchBackgroundFetchFailEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.5
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchBackgroundFetchFailEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchBackgroundFetchFailEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchFailEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchBackgroundFetchSuccessEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchBackgroundFetchSuccessEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchBackgroundFetchSuccessEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.6
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchBackgroundFetchSuccessEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchBackgroundFetchSuccessEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchBackgroundFetchSuccessEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchCookieChangeEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchCookieChangeEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchCookieChangeEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchCookieChangeEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchCookieChangeEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.7
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchCookieChangeEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchCookieChangeEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchCookieChangeEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchCookieChangeEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchCookieChangeEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchFetchEventForMainResourceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder> proxy(
        new ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchFetchEventForMainResourceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchFetchEventForMainResource_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchFetchEventForMainResource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchFetchEventForMainResource_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.8
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchFetchEventForMainResource", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchFetchEventForMainResource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchFetchEventForMainResource_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchFetchEventForMainResource");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchNotificationClickEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchNotificationClickEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchNotificationClickEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchNotificationClickEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchNotificationClickEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.9
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchNotificationClickEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchNotificationClickEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchNotificationClickEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchNotificationClickEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchNotificationClickEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchNotificationCloseEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchNotificationCloseEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchNotificationCloseEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchNotificationCloseEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchNotificationCloseEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.10
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchNotificationCloseEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchNotificationCloseEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchNotificationCloseEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchNotificationCloseEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchPushEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchPushEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchPushEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchPushEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchPushEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchPushEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchPushEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchPushEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchPushEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchPushEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchPushEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.11
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchPushEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchPushEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchPushEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchPushEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPushEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPushEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchPushEventRecordingNetworkRequests_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchPushEventRecordingNetworkRequestsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchPushEventRecordingNetworkRequests_ProxyToResponder> proxy(
        new ServiceWorker_DispatchPushEventRecordingNetworkRequests_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchPushEventRecordingNetworkRequests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchPushEventRecordingNetworkRequests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchPushEventRecordingNetworkRequests_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchPushEventRecordingNetworkRequestsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status, const std::optional<::blink::Vector<::blink::KURL>>& in_requested_urls);
};

bool ServiceWorker_DispatchPushEventRecordingNetworkRequests_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.12
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  std::optional<::blink::Vector<::blink::KURL>> p_requested_urls{};
  ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadRequestedUrls(&p_requested_urls))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_requested_urls));
  }
  return true;
}

void ServiceWorker_DispatchPushEventRecordingNetworkRequests_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status, const std::optional<::blink::Vector<::blink::KURL>>& in_requested_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchPushEventRecordingNetworkRequests", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_urls"), in_requested_urls,
                        "<value of type const std::optional<::blink::Vector<::blink::KURL>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchPushEventRecordingNetworkRequests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->requested_urls)::BaseType>
      requested_urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& requested_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_requested_urls,
    requested_urls_fragment,
    &requested_urls_validate_params);

  params->requested_urls.Set(
      requested_urls_fragment.is_null() ? nullptr : requested_urls_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPushEventRecordingNetworkRequests");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchPushSubscriptionChangeEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchPushSubscriptionChangeEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchPushSubscriptionChangeEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.13
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchPushSubscriptionChangeEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchPushSubscriptionChangeEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPushSubscriptionChangeEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchSyncEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchSyncEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchSyncEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchSyncEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchSyncEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchSyncEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchSyncEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchSyncEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchSyncEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchSyncEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchSyncEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.14
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchSyncEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchSyncEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchSyncEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchSyncEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchSyncEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchSyncEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchPeriodicSyncEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchPeriodicSyncEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchPeriodicSyncEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.15
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchPeriodicSyncEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchPeriodicSyncEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPeriodicSyncEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchAbortPaymentEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchAbortPaymentEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchAbortPaymentEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchAbortPaymentEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchAbortPaymentEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.16
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchAbortPaymentEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchAbortPaymentEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchAbortPaymentEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchAbortPaymentEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchCanMakePaymentEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchCanMakePaymentEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchCanMakePaymentEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.17
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 17, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchCanMakePaymentEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchCanMakePaymentEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchCanMakePaymentEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchPaymentRequestEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchPaymentRequestEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchPaymentRequestEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchPaymentRequestEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchPaymentRequestEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.18
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 18, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchPaymentRequestEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchPaymentRequestEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchPaymentRequestEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchPaymentRequestEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchExtendableMessageEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchExtendableMessageEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchExtendableMessageEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchExtendableMessageEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchExtendableMessageEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.19
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 19, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchExtendableMessageEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchExtendableMessageEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchExtendableMessageEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchExtendableMessageEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchContentDeleteEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder> proxy(
        new ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::DispatchContentDeleteEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerEventStatus in_status);
};

bool ServiceWorker_DispatchContentDeleteEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchContentDeleteEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchContentDeleteEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.20
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerEventStatus p_status{};
  ServiceWorker_DispatchContentDeleteEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::DispatchContentDeleteEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchContentDeleteEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_DispatchContentDeleteEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchContentDeleteEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_Ping_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::PingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_Ping_ProxyToResponder> proxy(
        new ServiceWorker_Ping_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_Ping_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_Ping_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_Ping_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::PingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool ServiceWorker_Ping_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_Ping_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_Ping_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.21
  bool success = true;
  ServiceWorker_Ping_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 21, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void ServiceWorker_Ping_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::ServiceWorker::Ping");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kPing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_Ping_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("Ping");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorker_ExecuteScriptForTest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::ExecuteScriptForTestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_ExecuteScriptForTest_ProxyToResponder> proxy(
        new ServiceWorker_ExecuteScriptForTest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_ExecuteScriptForTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_ExecuteScriptForTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_ExecuteScriptForTest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorker::ExecuteScriptForTestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result, const ::blink::String& in_error);
};

bool ServiceWorker_ExecuteScriptForTest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_ExecuteScriptForTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_ExecuteScriptForTest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorker.26
  bool success = true;
  ::base::Value p_result{};
  ::blink::String p_error{};
  ServiceWorker_ExecuteScriptForTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 26, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_error));
  }
  return true;
}

void ServiceWorker_ExecuteScriptForTest_ProxyToResponder::Run(
    ::base::Value in_result, const ::blink::String& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorker::ExecuteScriptForTest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::base::Value>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kExecuteScriptForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorker_ExecuteScriptForTest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("ExecuteScriptForTest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerStubDispatch::Accept(
    ServiceWorker* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorker>(message->header()->name)) {
    case messages::ServiceWorker::kInitializeGlobalScope: {
      DCHECK(message->is_serialized());
      internal::ServiceWorker_InitializeGlobalScope_Params_Data* params =
          reinterpret_cast<internal::ServiceWorker_InitializeGlobalScope_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorker.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<ServiceWorkerHost> p_service_worker_host{};
      ::mojo::PendingAssociatedRemote<::blink::mojom::blink::AssociatedInterfaceProvider> p_associated_interfaces_to_browser{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::AssociatedInterfaceProvider> p_associated_interfaces_from_browser{};
      ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr p_registration_info{};
      ::blink::mojom::blink::ServiceWorkerObjectInfoPtr p_service_worker_info{};
      FetchHandlerExistence p_fetch_handler_existence{};
      ::blink::mojom::blink::AncestorFrameType p_ancestor_frame_type{};
      ::blink::BlinkStorageKey p_storage_key{};
      ServiceWorker_InitializeGlobalScope_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_service_worker_host =
            input_data_view.TakeServiceWorkerHost<decltype(p_service_worker_host)>();
      }
      if (success) {
        p_associated_interfaces_to_browser =
            input_data_view.TakeAssociatedInterfacesToBrowser<decltype(p_associated_interfaces_to_browser)>();
      }
      if (success) {
        p_associated_interfaces_from_browser =
            input_data_view.TakeAssociatedInterfacesFromBrowser<decltype(p_associated_interfaces_from_browser)>();
      }
      if (success && !input_data_view.ReadRegistrationInfo(&p_registration_info))
        success = false;
      if (success && !input_data_view.ReadServiceWorkerInfo(&p_service_worker_info))
        success = false;
      if (success && !input_data_view.ReadFetchHandlerExistence(&p_fetch_handler_existence))
        success = false;
      if (success && !input_data_view.ReadAncestorFrameType(&p_ancestor_frame_type))
        success = false;
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeGlobalScope(        
        std::move(p_service_worker_host), 
        std::move(p_associated_interfaces_to_browser), 
        std::move(p_associated_interfaces_from_browser), 
        std::move(p_registration_info), 
        std::move(p_service_worker_info), 
        std::move(p_fetch_handler_existence), 
        std::move(p_ancestor_frame_type), 
        std::move(p_storage_key));
      return true;
    }
    case messages::ServiceWorker::kDispatchInstallEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchActivateEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchBackgroundFetchAbortEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchBackgroundFetchClickEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchBackgroundFetchFailEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchBackgroundFetchSuccessEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchCookieChangeEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchFetchEventForMainResource: {
      break;
    }
    case messages::ServiceWorker::kDispatchNotificationClickEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchNotificationCloseEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchPushEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchPushEventRecordingNetworkRequests: {
      break;
    }
    case messages::ServiceWorker::kDispatchPushSubscriptionChangeEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchSyncEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchPeriodicSyncEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchAbortPaymentEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchCanMakePaymentEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchPaymentRequestEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchExtendableMessageEvent: {
      break;
    }
    case messages::ServiceWorker::kDispatchContentDeleteEvent: {
      break;
    }
    case messages::ServiceWorker::kPing: {
      break;
    }
    case messages::ServiceWorker::kSetIdleDelay: {
      DCHECK(message->is_serialized());
      internal::ServiceWorker_SetIdleDelay_Params_Data* params =
          reinterpret_cast<internal::ServiceWorker_SetIdleDelay_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorker.22
      bool success = true;
      ::base::TimeDelta p_delay{};
      ServiceWorker_SetIdleDelay_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDelay(&p_delay))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIdleDelay(        
        std::move(p_delay));
      return true;
    }
    case messages::ServiceWorker::kAddKeepAlive: {
      DCHECK(message->is_serialized());
      internal::ServiceWorker_AddKeepAlive_Params_Data* params =
          reinterpret_cast<internal::ServiceWorker_AddKeepAlive_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorker.23
      bool success = true;
      ServiceWorker_AddKeepAlive_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddKeepAlive(        );
      return true;
    }
    case messages::ServiceWorker::kClearKeepAlive: {
      DCHECK(message->is_serialized());
      internal::ServiceWorker_ClearKeepAlive_Params_Data* params =
          reinterpret_cast<internal::ServiceWorker_ClearKeepAlive_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorker.24
      bool success = true;
      ServiceWorker_ClearKeepAlive_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearKeepAlive(        );
      return true;
    }
    case messages::ServiceWorker::kAddMessageToConsole: {
      DCHECK(message->is_serialized());
      internal::ServiceWorker_AddMessageToConsole_Params_Data* params =
          reinterpret_cast<internal::ServiceWorker_AddMessageToConsole_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorker.25
      bool success = true;
      ::blink::mojom::blink::ConsoleMessageLevel p_level{};
      ::blink::String p_message{};
      ServiceWorker_AddMessageToConsole_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLevel(&p_level))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddMessageToConsole(        
        std::move(p_level), 
        std::move(p_message));
      return true;
    }
    case messages::ServiceWorker::kExecuteScriptForTest: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerStubDispatch::AcceptWithResponder(
    ServiceWorker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorker>(message->header()->name)) {
    case messages::ServiceWorker::kInitializeGlobalScope: {
      break;
    }
    case messages::ServiceWorker::kDispatchInstallEvent: {
      internal::ServiceWorker_DispatchInstallEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchInstallEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.1
      bool success = true;
      ServiceWorker_DispatchInstallEvent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 1, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchInstallEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchInstallEvent(std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchActivateEvent: {
      internal::ServiceWorker_DispatchActivateEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchActivateEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.2
      bool success = true;
      ServiceWorker_DispatchActivateEvent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 2, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchActivateEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchActivateEvent(std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchBackgroundFetchAbortEvent: {
      internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.3
      bool success = true;
      ::blink::mojom::blink::BackgroundFetchRegistrationPtr p_registration{};
      ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 3, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchBackgroundFetchAbortEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchBackgroundFetchAbortEvent(        
        std::move(p_registration), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchBackgroundFetchClickEvent: {
      internal::ServiceWorker_DispatchBackgroundFetchClickEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchBackgroundFetchClickEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.4
      bool success = true;
      ::blink::mojom::blink::BackgroundFetchRegistrationPtr p_registration{};
      ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 4, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchBackgroundFetchClickEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchBackgroundFetchClickEvent(        
        std::move(p_registration), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchBackgroundFetchFailEvent: {
      internal::ServiceWorker_DispatchBackgroundFetchFailEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchBackgroundFetchFailEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.5
      bool success = true;
      ::blink::mojom::blink::BackgroundFetchRegistrationPtr p_registration{};
      ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 5, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchBackgroundFetchFailEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchBackgroundFetchFailEvent(        
        std::move(p_registration), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchBackgroundFetchSuccessEvent: {
      internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.6
      bool success = true;
      ::blink::mojom::blink::BackgroundFetchRegistrationPtr p_registration{};
      ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 6, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchBackgroundFetchSuccessEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchBackgroundFetchSuccessEvent(        
        std::move(p_registration), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchCookieChangeEvent: {
      internal::ServiceWorker_DispatchCookieChangeEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchCookieChangeEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.7
      bool success = true;
      ::network::mojom::blink::CookieChangeInfoPtr p_change{};
      ServiceWorker_DispatchCookieChangeEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChange(&p_change))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 7, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchCookieChangeEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchCookieChangeEvent(        
        std::move(p_change), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchFetchEventForMainResource: {
      internal::ServiceWorker_DispatchFetchEventForMainResource_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchFetchEventForMainResource_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.8
      bool success = true;
      ::blink::mojom::blink::DispatchFetchEventParamsPtr p_params{};
      ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback> p_response_callback{};
      ServiceWorker_DispatchFetchEventForMainResource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_response_callback =
            input_data_view.TakeResponseCallback<decltype(p_response_callback)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 8, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchFetchEventForMainResource_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchFetchEventForMainResource(        
        std::move(p_params), 
        std::move(p_response_callback), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchNotificationClickEvent: {
      internal::ServiceWorker_DispatchNotificationClickEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchNotificationClickEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.9
      bool success = true;
      ::blink::String p_notification_id{};
      ::blink::mojom::blink::NotificationDataPtr p_notification_data{};
      int32_t p_action_index{};
      ::blink::String p_reply{};
      ServiceWorker_DispatchNotificationClickEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotificationId(&p_notification_id))
        success = false;
      if (success && !input_data_view.ReadNotificationData(&p_notification_data))
        success = false;
      if (success)
        p_action_index = input_data_view.action_index();
      if (success && !input_data_view.ReadReply(&p_reply))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 9, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchNotificationClickEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchNotificationClickEvent(        
        std::move(p_notification_id), 
        std::move(p_notification_data), 
        std::move(p_action_index), 
        std::move(p_reply), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchNotificationCloseEvent: {
      internal::ServiceWorker_DispatchNotificationCloseEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchNotificationCloseEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.10
      bool success = true;
      ::blink::String p_notification_id{};
      ::blink::mojom::blink::NotificationDataPtr p_notification_data{};
      ServiceWorker_DispatchNotificationCloseEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotificationId(&p_notification_id))
        success = false;
      if (success && !input_data_view.ReadNotificationData(&p_notification_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 10, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchNotificationCloseEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchNotificationCloseEvent(        
        std::move(p_notification_id), 
        std::move(p_notification_data), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchPushEvent: {
      internal::ServiceWorker_DispatchPushEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchPushEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.11
      bool success = true;
      ::blink::String p_payload{};
      ServiceWorker_DispatchPushEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPayload(&p_payload))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 11, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchPushEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchPushEvent(        
        std::move(p_payload), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchPushEventRecordingNetworkRequests: {
      internal::ServiceWorker_DispatchPushEventRecordingNetworkRequests_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchPushEventRecordingNetworkRequests_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.12
      bool success = true;
      ::blink::String p_payload{};
      ServiceWorker_DispatchPushEventRecordingNetworkRequests_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPayload(&p_payload))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 12, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchPushEventRecordingNetworkRequests_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchPushEventRecordingNetworkRequests(        
        std::move(p_payload), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchPushSubscriptionChangeEvent: {
      internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.13
      bool success = true;
      ::blink::mojom::blink::PushSubscriptionPtr p_old_subscription{};
      ::blink::mojom::blink::PushSubscriptionPtr p_new_subscription{};
      ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOldSubscription(&p_old_subscription))
        success = false;
      if (success && !input_data_view.ReadNewSubscription(&p_new_subscription))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 13, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchPushSubscriptionChangeEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchPushSubscriptionChangeEvent(        
        std::move(p_old_subscription), 
        std::move(p_new_subscription), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchSyncEvent: {
      internal::ServiceWorker_DispatchSyncEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchSyncEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.14
      bool success = true;
      ::blink::String p_tag{};
      bool p_last_chance{};
      ::base::TimeDelta p_timeout{};
      ServiceWorker_DispatchSyncEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTag(&p_tag))
        success = false;
      if (success)
        p_last_chance = input_data_view.last_chance();
      if (success && !input_data_view.ReadTimeout(&p_timeout))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 14, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchSyncEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchSyncEvent(        
        std::move(p_tag), 
        std::move(p_last_chance), 
        std::move(p_timeout), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchPeriodicSyncEvent: {
      internal::ServiceWorker_DispatchPeriodicSyncEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchPeriodicSyncEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.15
      bool success = true;
      ::blink::String p_tag{};
      ::base::TimeDelta p_timeout{};
      ServiceWorker_DispatchPeriodicSyncEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTag(&p_tag))
        success = false;
      if (success && !input_data_view.ReadTimeout(&p_timeout))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 15, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchPeriodicSyncEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchPeriodicSyncEvent(        
        std::move(p_tag), 
        std::move(p_timeout), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchAbortPaymentEvent: {
      internal::ServiceWorker_DispatchAbortPaymentEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchAbortPaymentEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.16
      bool success = true;
      ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> p_result_of_abort_payment{};
      ServiceWorker_DispatchAbortPaymentEvent_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_result_of_abort_payment =
            input_data_view.TakeResultOfAbortPayment<decltype(p_result_of_abort_payment)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 16, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchAbortPaymentEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchAbortPaymentEvent(        
        std::move(p_result_of_abort_payment), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchCanMakePaymentEvent: {
      internal::ServiceWorker_DispatchCanMakePaymentEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchCanMakePaymentEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.17
      bool success = true;
      ::payments::mojom::blink::CanMakePaymentEventDataPtr p_event_data{};
      ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> p_result_of_can_make_payment{};
      ServiceWorker_DispatchCanMakePaymentEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventData(&p_event_data))
        success = false;
      if (success) {
        p_result_of_can_make_payment =
            input_data_view.TakeResultOfCanMakePayment<decltype(p_result_of_can_make_payment)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 17, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchCanMakePaymentEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchCanMakePaymentEvent(        
        std::move(p_event_data), 
        std::move(p_result_of_can_make_payment), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchPaymentRequestEvent: {
      internal::ServiceWorker_DispatchPaymentRequestEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchPaymentRequestEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.18
      bool success = true;
      ::payments::mojom::blink::PaymentRequestEventDataPtr p_request_data{};
      ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> p_response_callback{};
      ServiceWorker_DispatchPaymentRequestEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestData(&p_request_data))
        success = false;
      if (success) {
        p_response_callback =
            input_data_view.TakeResponseCallback<decltype(p_response_callback)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 18, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchPaymentRequestEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchPaymentRequestEvent(        
        std::move(p_request_data), 
        std::move(p_response_callback), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchExtendableMessageEvent: {
      internal::ServiceWorker_DispatchExtendableMessageEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchExtendableMessageEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.19
      bool success = true;
      ExtendableMessageEventPtr p_event{};
      ServiceWorker_DispatchExtendableMessageEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 19, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchExtendableMessageEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchExtendableMessageEvent(        
        std::move(p_event), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kDispatchContentDeleteEvent: {
      internal::ServiceWorker_DispatchContentDeleteEvent_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchContentDeleteEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.20
      bool success = true;
      ::blink::String p_id{};
      ServiceWorker_DispatchContentDeleteEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 20, false);
        return false;
      }
      auto callback =
          ServiceWorker_DispatchContentDeleteEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchContentDeleteEvent(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kPing: {
      internal::ServiceWorker_Ping_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_Ping_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.21
      bool success = true;
      ServiceWorker_Ping_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 21, false);
        return false;
      }
      auto callback =
          ServiceWorker_Ping_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Ping(std::move(callback));
      return true;
    }
    case messages::ServiceWorker::kSetIdleDelay: {
      break;
    }
    case messages::ServiceWorker::kAddKeepAlive: {
      break;
    }
    case messages::ServiceWorker::kClearKeepAlive: {
      break;
    }
    case messages::ServiceWorker::kAddMessageToConsole: {
      break;
    }
    case messages::ServiceWorker::kExecuteScriptForTest: {
      internal::ServiceWorker_ExecuteScriptForTest_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_ExecuteScriptForTest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorker.26
      bool success = true;
      ::blink::String p_javascript{};
      bool p_wants_result{};
      ServiceWorker_ExecuteScriptForTest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 26, false);
        return false;
      }
      auto callback =
          ServiceWorker_ExecuteScriptForTest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteScriptForTest(        
        std::move(p_javascript), 
        std::move(p_wants_result), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerValidationInfo[] = {
    { &internal::ServiceWorker_InitializeGlobalScope_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorker_DispatchInstallEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchInstallEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchActivateEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchActivateEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchBackgroundFetchClickEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchBackgroundFetchFailEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchCookieChangeEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchCookieChangeEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchFetchEventForMainResource_Params_Data::Validate,
     &internal::ServiceWorker_DispatchFetchEventForMainResource_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchNotificationClickEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchNotificationClickEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchNotificationCloseEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchNotificationCloseEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchPushEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchPushEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchPushEventRecordingNetworkRequests_Params_Data::Validate,
     &internal::ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchSyncEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchSyncEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchPeriodicSyncEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchAbortPaymentEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchAbortPaymentEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchCanMakePaymentEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchPaymentRequestEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchPaymentRequestEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchExtendableMessageEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchExtendableMessageEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_DispatchContentDeleteEvent_Params_Data::Validate,
     &internal::ServiceWorker_DispatchContentDeleteEvent_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_Ping_Params_Data::Validate,
     &internal::ServiceWorker_Ping_ResponseParams_Data::Validate},
    { &internal::ServiceWorker_SetIdleDelay_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorker_AddKeepAlive_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorker_ClearKeepAlive_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorker_AddMessageToConsole_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorker_ExecuteScriptForTest_Params_Data::Validate,
     &internal::ServiceWorker_ExecuteScriptForTest_ResponseParams_Data::Validate},
};

bool ServiceWorkerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ServiceWorker::Name_,
    kServiceWorkerValidationInfo);
}

bool ServiceWorkerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::ServiceWorker::Name_,
    kServiceWorkerValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ExtendableMessageEvent::DataView, ::blink::mojom::blink::ExtendableMessageEventPtr>::Read(
    ::blink::mojom::blink::ExtendableMessageEvent::DataView input,
    ::blink::mojom::blink::ExtendableMessageEventPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ExtendableMessageEventPtr result(::blink::mojom::blink::ExtendableMessageEvent::New());
  
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success && !input.ReadSourceOrigin(&result->source_origin))
        success = false;
      if (success && !input.ReadSourceInfoForClient(&result->source_info_for_client))
        success = false;
      if (success && !input.ReadSourceInfoForServiceWorker(&result->source_info_for_service_worker))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::FocusResult::DataView, ::blink::mojom::blink::FocusResultPtr>::Read(
    ::blink::mojom::blink::FocusResult::DataView input,
    ::blink::mojom::blink::FocusResultPtr* output) {
  using UnionType = ::blink::mojom::blink::FocusResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kClient: {
      ::blink::mojom::blink::ServiceWorkerClientInfoPtr result_client{};
      if (!input.ReadClient(&result_client))
        return false;

      *output = UnionType::NewClient(
          std::move(result_client));
      break;
    }
    case Tag::kErrorCode: {
      ::blink::mojom::blink::FocusError result_error_code;
      if (!input.ReadErrorCode(&result_error_code))
        return false;

      *output = UnionType::NewErrorCode(result_error_code);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ServiceWorkerHostInterceptorForTesting::SetCachedMetadata(const ::blink::KURL& url, ::base::span<const ::uint8_t> data) {
  GetForwardingInterface()->SetCachedMetadata(
    std::move(url)
    , 
    std::move(data)
    );
}
void ServiceWorkerHostInterceptorForTesting::ClearCachedMetadata(const ::blink::KURL& url) {
  GetForwardingInterface()->ClearCachedMetadata(
    std::move(url)
    );
}
void ServiceWorkerHostInterceptorForTesting::GetClients(::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr options, GetClientsCallback callback) {
  GetForwardingInterface()->GetClients(
    std::move(options)
    , std::move(callback));
}
void ServiceWorkerHostInterceptorForTesting::GetClient(const ::blink::String& client_uuid, GetClientCallback callback) {
  GetForwardingInterface()->GetClient(
    std::move(client_uuid)
    , std::move(callback));
}
void ServiceWorkerHostInterceptorForTesting::OpenNewTab(const ::blink::KURL& url, OpenNewTabCallback callback) {
  GetForwardingInterface()->OpenNewTab(
    std::move(url)
    , std::move(callback));
}
void ServiceWorkerHostInterceptorForTesting::OpenPaymentHandlerWindow(const ::blink::KURL& url, OpenPaymentHandlerWindowCallback callback) {
  GetForwardingInterface()->OpenPaymentHandlerWindow(
    std::move(url)
    , std::move(callback));
}
void ServiceWorkerHostInterceptorForTesting::PostMessageToClient(const ::blink::String& client_uuid, ::blink::BlinkTransferableMessage message) {
  GetForwardingInterface()->PostMessageToClient(
    std::move(client_uuid)
    , 
    std::move(message)
    );
}
void ServiceWorkerHostInterceptorForTesting::FocusClient(const ::blink::String& client_uuid, FocusClientCallback callback) {
  GetForwardingInterface()->FocusClient(
    std::move(client_uuid)
    , std::move(callback));
}
void ServiceWorkerHostInterceptorForTesting::NavigateClient(const ::blink::String& client_uuid, const ::blink::KURL& url, NavigateClientCallback callback) {
  GetForwardingInterface()->NavigateClient(
    std::move(client_uuid)
    , 
    std::move(url)
    , std::move(callback));
}
void ServiceWorkerHostInterceptorForTesting::SkipWaiting(SkipWaitingCallback callback) {
  GetForwardingInterface()->SkipWaiting(std::move(callback));
}
void ServiceWorkerHostInterceptorForTesting::ClaimClients(ClaimClientsCallback callback) {
  GetForwardingInterface()->ClaimClients(std::move(callback));
}
void ServiceWorkerHostInterceptorForTesting::AddRoutes(const ::blink::ServiceWorkerRouterRules& rules, AddRoutesCallback callback) {
  GetForwardingInterface()->AddRoutes(
    std::move(rules)
    , std::move(callback));
}
ServiceWorkerHostAsyncWaiter::ServiceWorkerHostAsyncWaiter(
    ServiceWorkerHost* proxy) : proxy_(proxy) {}

ServiceWorkerHostAsyncWaiter::~ServiceWorkerHostAsyncWaiter() = default;


void ServiceWorkerHostAsyncWaiter::GetClients(
    ::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr options, ::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr>* out_clients) {
  base::RunLoop loop;
  proxy_->GetClients(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr>* out_clients
,
             ::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr> clients) {*out_clients = std::move(clients);
            loop->Quit();
          },
          &loop,
          out_clients));
  loop.Run();
}

::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr> ServiceWorkerHostAsyncWaiter::GetClients(
    ::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr options) {
  ::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr> async_wait_result;
  GetClients(std::move(options),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerHostAsyncWaiter::GetClient(
    const ::blink::String& client_uuid, ::blink::mojom::blink::ServiceWorkerClientInfoPtr* out_client) {
  base::RunLoop loop;
  proxy_->GetClient(
      std::move(client_uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerClientInfoPtr* out_client
,
             ::blink::mojom::blink::ServiceWorkerClientInfoPtr client) {*out_client = std::move(client);
            loop->Quit();
          },
          &loop,
          out_client));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerClientInfoPtr ServiceWorkerHostAsyncWaiter::GetClient(
    const ::blink::String& client_uuid) {
  ::blink::mojom::blink::ServiceWorkerClientInfoPtr async_wait_result;
  GetClient(std::move(client_uuid),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerHostAsyncWaiter::OpenNewTab(
    const ::blink::KURL& url, bool* out_success, ::blink::mojom::blink::ServiceWorkerClientInfoPtr* out_client, ::blink::String* out_error_msg) {
  base::RunLoop loop;
  proxy_->OpenNewTab(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::blink::mojom::blink::ServiceWorkerClientInfoPtr* out_client
,
             ::blink::String* out_error_msg
,
             bool success,
             ::blink::mojom::blink::ServiceWorkerClientInfoPtr client,
             const ::blink::String& error_msg) {*out_success = std::move(success);*out_client = std::move(client);*out_error_msg = std::move(error_msg);
            loop->Quit();
          },
          &loop,
          out_success,
          out_client,
          out_error_msg));
  loop.Run();
}



void ServiceWorkerHostAsyncWaiter::OpenPaymentHandlerWindow(
    const ::blink::KURL& url, bool* out_success, ::blink::mojom::blink::ServiceWorkerClientInfoPtr* out_client, ::blink::String* out_error_msg) {
  base::RunLoop loop;
  proxy_->OpenPaymentHandlerWindow(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::blink::mojom::blink::ServiceWorkerClientInfoPtr* out_client
,
             ::blink::String* out_error_msg
,
             bool success,
             ::blink::mojom::blink::ServiceWorkerClientInfoPtr client,
             const ::blink::String& error_msg) {*out_success = std::move(success);*out_client = std::move(client);*out_error_msg = std::move(error_msg);
            loop->Quit();
          },
          &loop,
          out_success,
          out_client,
          out_error_msg));
  loop.Run();
}



void ServiceWorkerHostAsyncWaiter::FocusClient(
    const ::blink::String& client_uuid, FocusResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->FocusClient(
      std::move(client_uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             FocusResultPtr* out_result
,
             FocusResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

FocusResultPtr ServiceWorkerHostAsyncWaiter::FocusClient(
    const ::blink::String& client_uuid) {
  FocusResultPtr async_wait_result;
  FocusClient(std::move(client_uuid),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerHostAsyncWaiter::NavigateClient(
    const ::blink::String& client_uuid, const ::blink::KURL& url, bool* out_success, ::blink::mojom::blink::ServiceWorkerClientInfoPtr* out_client, ::blink::String* out_error_msg) {
  base::RunLoop loop;
  proxy_->NavigateClient(
      std::move(client_uuid),
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::blink::mojom::blink::ServiceWorkerClientInfoPtr* out_client
,
             ::blink::String* out_error_msg
,
             bool success,
             ::blink::mojom::blink::ServiceWorkerClientInfoPtr client,
             const ::blink::String& error_msg) {*out_success = std::move(success);*out_client = std::move(client);*out_error_msg = std::move(error_msg);
            loop->Quit();
          },
          &loop,
          out_success,
          out_client,
          out_error_msg));
  loop.Run();
}



void ServiceWorkerHostAsyncWaiter::SkipWaiting(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->SkipWaiting(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool ServiceWorkerHostAsyncWaiter::SkipWaiting(
    ) {
  bool async_wait_result;
  SkipWaiting(&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerHostAsyncWaiter::ClaimClients(
    ::blink::mojom::blink::ServiceWorkerErrorType* out_error, ::blink::String* out_error_msg) {
  base::RunLoop loop;
  proxy_->ClaimClients(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerErrorType* out_error
,
             ::blink::String* out_error_msg
,
             ::blink::mojom::blink::ServiceWorkerErrorType error,
             const ::blink::String& error_msg) {*out_error = std::move(error);*out_error_msg = std::move(error_msg);
            loop->Quit();
          },
          &loop,
          out_error,
          out_error_msg));
  loop.Run();
}



void ServiceWorkerHostAsyncWaiter::AddRoutes(
    const ::blink::ServiceWorkerRouterRules& rules, bool* out_is_parse_error) {
  base::RunLoop loop;
  proxy_->AddRoutes(
      std::move(rules),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_parse_error
,
             bool is_parse_error) {*out_is_parse_error = std::move(is_parse_error);
            loop->Quit();
          },
          &loop,
          out_is_parse_error));
  loop.Run();
}

bool ServiceWorkerHostAsyncWaiter::AddRoutes(
    const ::blink::ServiceWorkerRouterRules& rules) {
  bool async_wait_result;
  AddRoutes(std::move(rules),&async_wait_result);
  return async_wait_result;
}




void ServiceWorkerInterceptorForTesting::InitializeGlobalScope(::mojo::PendingAssociatedRemote<ServiceWorkerHost> service_worker_host, ::mojo::PendingAssociatedRemote<::blink::mojom::blink::AssociatedInterfaceProvider> associated_interfaces_to_browser, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::AssociatedInterfaceProvider> associated_interfaces_from_browser, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr registration_info, ::blink::mojom::blink::ServiceWorkerObjectInfoPtr service_worker_info, FetchHandlerExistence fetch_handler_existence, ::blink::mojom::blink::AncestorFrameType ancestor_frame_type, const ::blink::BlinkStorageKey& storage_key) {
  GetForwardingInterface()->InitializeGlobalScope(
    std::move(service_worker_host)
    , 
    std::move(associated_interfaces_to_browser)
    , 
    std::move(associated_interfaces_from_browser)
    , 
    std::move(registration_info)
    , 
    std::move(service_worker_info)
    , 
    std::move(fetch_handler_existence)
    , 
    std::move(ancestor_frame_type)
    , 
    std::move(storage_key)
    );
}
void ServiceWorkerInterceptorForTesting::DispatchInstallEvent(DispatchInstallEventCallback callback) {
  GetForwardingInterface()->DispatchInstallEvent(std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchActivateEvent(DispatchActivateEventCallback callback) {
  GetForwardingInterface()->DispatchActivateEvent(std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchBackgroundFetchAbortEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchAbortEventCallback callback) {
  GetForwardingInterface()->DispatchBackgroundFetchAbortEvent(
    std::move(registration)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchBackgroundFetchClickEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchClickEventCallback callback) {
  GetForwardingInterface()->DispatchBackgroundFetchClickEvent(
    std::move(registration)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchBackgroundFetchFailEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchFailEventCallback callback) {
  GetForwardingInterface()->DispatchBackgroundFetchFailEvent(
    std::move(registration)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchBackgroundFetchSuccessEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchSuccessEventCallback callback) {
  GetForwardingInterface()->DispatchBackgroundFetchSuccessEvent(
    std::move(registration)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchCookieChangeEvent(::network::mojom::blink::CookieChangeInfoPtr change, DispatchCookieChangeEventCallback callback) {
  GetForwardingInterface()->DispatchCookieChangeEvent(
    std::move(change)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchFetchEventForMainResource(::blink::mojom::blink::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback> response_callback, DispatchFetchEventForMainResourceCallback callback) {
  GetForwardingInterface()->DispatchFetchEventForMainResource(
    std::move(params)
    , 
    std::move(response_callback)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchNotificationClickEvent(const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, int32_t action_index, const ::blink::String& reply, DispatchNotificationClickEventCallback callback) {
  GetForwardingInterface()->DispatchNotificationClickEvent(
    std::move(notification_id)
    , 
    std::move(notification_data)
    , 
    std::move(action_index)
    , 
    std::move(reply)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchNotificationCloseEvent(const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, DispatchNotificationCloseEventCallback callback) {
  GetForwardingInterface()->DispatchNotificationCloseEvent(
    std::move(notification_id)
    , 
    std::move(notification_data)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchPushEvent(const ::blink::String& payload, DispatchPushEventCallback callback) {
  GetForwardingInterface()->DispatchPushEvent(
    std::move(payload)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchPushEventRecordingNetworkRequests(const ::blink::String& payload, DispatchPushEventRecordingNetworkRequestsCallback callback) {
  GetForwardingInterface()->DispatchPushEventRecordingNetworkRequests(
    std::move(payload)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchPushSubscriptionChangeEvent(::blink::mojom::blink::PushSubscriptionPtr old_subscription, ::blink::mojom::blink::PushSubscriptionPtr new_subscription, DispatchPushSubscriptionChangeEventCallback callback) {
  GetForwardingInterface()->DispatchPushSubscriptionChangeEvent(
    std::move(old_subscription)
    , 
    std::move(new_subscription)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchSyncEvent(const ::blink::String& tag, bool last_chance, ::base::TimeDelta timeout, DispatchSyncEventCallback callback) {
  GetForwardingInterface()->DispatchSyncEvent(
    std::move(tag)
    , 
    std::move(last_chance)
    , 
    std::move(timeout)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchPeriodicSyncEvent(const ::blink::String& tag, ::base::TimeDelta timeout, DispatchPeriodicSyncEventCallback callback) {
  GetForwardingInterface()->DispatchPeriodicSyncEvent(
    std::move(tag)
    , 
    std::move(timeout)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchAbortPaymentEvent(::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_abort_payment, DispatchAbortPaymentEventCallback callback) {
  GetForwardingInterface()->DispatchAbortPaymentEvent(
    std::move(result_of_abort_payment)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchCanMakePaymentEvent(::payments::mojom::blink::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_can_make_payment, DispatchCanMakePaymentEventCallback callback) {
  GetForwardingInterface()->DispatchCanMakePaymentEvent(
    std::move(event_data)
    , 
    std::move(result_of_can_make_payment)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchPaymentRequestEvent(::payments::mojom::blink::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> response_callback, DispatchPaymentRequestEventCallback callback) {
  GetForwardingInterface()->DispatchPaymentRequestEvent(
    std::move(request_data)
    , 
    std::move(response_callback)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchExtendableMessageEvent(ExtendableMessageEventPtr event, DispatchExtendableMessageEventCallback callback) {
  GetForwardingInterface()->DispatchExtendableMessageEvent(
    std::move(event)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::DispatchContentDeleteEvent(const ::blink::String& id, DispatchContentDeleteEventCallback callback) {
  GetForwardingInterface()->DispatchContentDeleteEvent(
    std::move(id)
    , std::move(callback));
}
void ServiceWorkerInterceptorForTesting::Ping(PingCallback callback) {
  GetForwardingInterface()->Ping(std::move(callback));
}
void ServiceWorkerInterceptorForTesting::SetIdleDelay(::base::TimeDelta delay) {
  GetForwardingInterface()->SetIdleDelay(
    std::move(delay)
    );
}
void ServiceWorkerInterceptorForTesting::AddKeepAlive() {
  GetForwardingInterface()->AddKeepAlive();
}
void ServiceWorkerInterceptorForTesting::ClearKeepAlive() {
  GetForwardingInterface()->ClearKeepAlive();
}
void ServiceWorkerInterceptorForTesting::AddMessageToConsole(::blink::mojom::blink::ConsoleMessageLevel level, const ::blink::String& message) {
  GetForwardingInterface()->AddMessageToConsole(
    std::move(level)
    , 
    std::move(message)
    );
}
void ServiceWorkerInterceptorForTesting::ExecuteScriptForTest(const ::blink::String& javascript, bool wants_result, ExecuteScriptForTestCallback callback) {
  GetForwardingInterface()->ExecuteScriptForTest(
    std::move(javascript)
    , 
    std::move(wants_result)
    , std::move(callback));
}
ServiceWorkerAsyncWaiter::ServiceWorkerAsyncWaiter(
    ServiceWorker* proxy) : proxy_(proxy) {}

ServiceWorkerAsyncWaiter::~ServiceWorkerAsyncWaiter() = default;


void ServiceWorkerAsyncWaiter::DispatchInstallEvent(
    ::blink::mojom::blink::ServiceWorkerEventStatus* out_status, uint32_t* out_fetch_count) {
  base::RunLoop loop;
  proxy_->DispatchInstallEvent(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             uint32_t* out_fetch_count
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status,
             uint32_t fetch_count) {*out_status = std::move(status);*out_fetch_count = std::move(fetch_count);
            loop->Quit();
          },
          &loop,
          out_status,
          out_fetch_count));
  loop.Run();
}



void ServiceWorkerAsyncWaiter::DispatchActivateEvent(
    ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchActivateEvent(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchActivateEvent(
    ) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchActivateEvent(&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchBackgroundFetchAbortEvent(
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchBackgroundFetchAbortEvent(
      std::move(registration),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchBackgroundFetchAbortEvent(
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr registration) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchBackgroundFetchAbortEvent(std::move(registration),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchBackgroundFetchClickEvent(
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchBackgroundFetchClickEvent(
      std::move(registration),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchBackgroundFetchClickEvent(
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr registration) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchBackgroundFetchClickEvent(std::move(registration),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchBackgroundFetchFailEvent(
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchBackgroundFetchFailEvent(
      std::move(registration),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchBackgroundFetchFailEvent(
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr registration) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchBackgroundFetchFailEvent(std::move(registration),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchBackgroundFetchSuccessEvent(
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchBackgroundFetchSuccessEvent(
      std::move(registration),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchBackgroundFetchSuccessEvent(
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr registration) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchBackgroundFetchSuccessEvent(std::move(registration),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchCookieChangeEvent(
    ::network::mojom::blink::CookieChangeInfoPtr change, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchCookieChangeEvent(
      std::move(change),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchCookieChangeEvent(
    ::network::mojom::blink::CookieChangeInfoPtr change) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchCookieChangeEvent(std::move(change),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchFetchEventForMainResource(
    ::blink::mojom::blink::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback> response_callback, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchFetchEventForMainResource(
      std::move(params),
      std::move(response_callback),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchFetchEventForMainResource(
    ::blink::mojom::blink::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback> response_callback) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchFetchEventForMainResource(std::move(params),std::move(response_callback),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchNotificationClickEvent(
    const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, int32_t action_index, const ::blink::String& reply, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchNotificationClickEvent(
      std::move(notification_id),
      std::move(notification_data),
      std::move(action_index),
      std::move(reply),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchNotificationClickEvent(
    const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, int32_t action_index, const ::blink::String& reply) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchNotificationClickEvent(std::move(notification_id),std::move(notification_data),std::move(action_index),std::move(reply),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchNotificationCloseEvent(
    const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchNotificationCloseEvent(
      std::move(notification_id),
      std::move(notification_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchNotificationCloseEvent(
    const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchNotificationCloseEvent(std::move(notification_id),std::move(notification_data),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchPushEvent(
    const ::blink::String& payload, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchPushEvent(
      std::move(payload),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchPushEvent(
    const ::blink::String& payload) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchPushEvent(std::move(payload),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchPushEventRecordingNetworkRequests(
    const ::blink::String& payload, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status, std::optional<::blink::Vector<::blink::KURL>>* out_requested_urls) {
  base::RunLoop loop;
  proxy_->DispatchPushEventRecordingNetworkRequests(
      std::move(payload),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             std::optional<::blink::Vector<::blink::KURL>>* out_requested_urls
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status,
             const std::optional<::blink::Vector<::blink::KURL>>& requested_urls) {*out_status = std::move(status);*out_requested_urls = std::move(requested_urls);
            loop->Quit();
          },
          &loop,
          out_status,
          out_requested_urls));
  loop.Run();
}



void ServiceWorkerAsyncWaiter::DispatchPushSubscriptionChangeEvent(
    ::blink::mojom::blink::PushSubscriptionPtr old_subscription, ::blink::mojom::blink::PushSubscriptionPtr new_subscription, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchPushSubscriptionChangeEvent(
      std::move(old_subscription),
      std::move(new_subscription),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchPushSubscriptionChangeEvent(
    ::blink::mojom::blink::PushSubscriptionPtr old_subscription, ::blink::mojom::blink::PushSubscriptionPtr new_subscription) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchPushSubscriptionChangeEvent(std::move(old_subscription),std::move(new_subscription),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchSyncEvent(
    const ::blink::String& tag, bool last_chance, ::base::TimeDelta timeout, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchSyncEvent(
      std::move(tag),
      std::move(last_chance),
      std::move(timeout),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchSyncEvent(
    const ::blink::String& tag, bool last_chance, ::base::TimeDelta timeout) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchSyncEvent(std::move(tag),std::move(last_chance),std::move(timeout),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchPeriodicSyncEvent(
    const ::blink::String& tag, ::base::TimeDelta timeout, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchPeriodicSyncEvent(
      std::move(tag),
      std::move(timeout),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchPeriodicSyncEvent(
    const ::blink::String& tag, ::base::TimeDelta timeout) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchPeriodicSyncEvent(std::move(tag),std::move(timeout),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchAbortPaymentEvent(
    ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_abort_payment, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchAbortPaymentEvent(
      std::move(result_of_abort_payment),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchAbortPaymentEvent(
    ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_abort_payment) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchAbortPaymentEvent(std::move(result_of_abort_payment),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchCanMakePaymentEvent(
    ::payments::mojom::blink::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_can_make_payment, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchCanMakePaymentEvent(
      std::move(event_data),
      std::move(result_of_can_make_payment),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchCanMakePaymentEvent(
    ::payments::mojom::blink::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_can_make_payment) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchCanMakePaymentEvent(std::move(event_data),std::move(result_of_can_make_payment),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchPaymentRequestEvent(
    ::payments::mojom::blink::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> response_callback, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchPaymentRequestEvent(
      std::move(request_data),
      std::move(response_callback),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchPaymentRequestEvent(
    ::payments::mojom::blink::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> response_callback) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchPaymentRequestEvent(std::move(request_data),std::move(response_callback),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchExtendableMessageEvent(
    ExtendableMessageEventPtr event, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchExtendableMessageEvent(
      std::move(event),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchExtendableMessageEvent(
    ExtendableMessageEventPtr event) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchExtendableMessageEvent(std::move(event),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::DispatchContentDeleteEvent(
    const ::blink::String& id, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchContentDeleteEvent(
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::blink::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerEventStatus ServiceWorkerAsyncWaiter::DispatchContentDeleteEvent(
    const ::blink::String& id) {
  ::blink::mojom::blink::ServiceWorkerEventStatus async_wait_result;
  DispatchContentDeleteEvent(std::move(id),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerAsyncWaiter::Ping(
    ) {
  base::RunLoop loop;
  proxy_->Ping(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void ServiceWorkerAsyncWaiter::ExecuteScriptForTest(
    const ::blink::String& javascript, bool wants_result, ::base::Value* out_result, ::blink::String* out_error) {
  base::RunLoop loop;
  proxy_->ExecuteScriptForTest(
      std::move(javascript),
      std::move(wants_result),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::Value* out_result
,
             ::blink::String* out_error
,
             ::base::Value result,
             const ::blink::String& error) {*out_result = std::move(result);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_result,
          out_error));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif