// third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/document_isolation_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_embedded_worker_status.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_bypass_option.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-shared.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_running_status_callback.mojom-shared.h"


namespace blink::mojom {
class ServiceWorkerRouterDataDataView;

class ControllerServiceWorkerInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterDataDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ControllerServiceWorkerInfoDataView> {
  using Data = ::blink::mojom::internal::ControllerServiceWorkerInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class ControllerServiceWorkerInterfaceBase {};

using ControllerServiceWorkerPtrDataView =
    mojo::InterfacePtrDataView<ControllerServiceWorkerInterfaceBase>;
using ControllerServiceWorkerRequestDataView =
    mojo::InterfaceRequestDataView<ControllerServiceWorkerInterfaceBase>;
using ControllerServiceWorkerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ControllerServiceWorkerInterfaceBase>;
using ControllerServiceWorkerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ControllerServiceWorkerInterfaceBase>;
class ControllerServiceWorkerConnectorInterfaceBase {};

using ControllerServiceWorkerConnectorPtrDataView =
    mojo::InterfacePtrDataView<ControllerServiceWorkerConnectorInterfaceBase>;
using ControllerServiceWorkerConnectorRequestDataView =
    mojo::InterfaceRequestDataView<ControllerServiceWorkerConnectorInterfaceBase>;
using ControllerServiceWorkerConnectorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ControllerServiceWorkerConnectorInterfaceBase>;
using ControllerServiceWorkerConnectorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ControllerServiceWorkerConnectorInterfaceBase>;


class ServiceWorkerRouterDataDataView {
 public:
  ServiceWorkerRouterDataDataView() = default;

  ServiceWorkerRouterDataDataView(
      internal::ServiceWorkerRouterData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRouterRulesDataView(
      ::blink::mojom::ServiceWorkerRouterRulesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouterRules(UserType* output) {
    
    auto* pointer = data_->router_rules.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterRulesDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitialRunningStatus(UserType* output) const {
    if (!data_->initial_running_status_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerEmbeddedWorkerStatus>(
        data_->initial_running_status_$value, &output->emplace());
  }
  std::optional<::blink::mojom::ServiceWorkerEmbeddedWorkerStatus> initial_running_status() const {
    if (!data_->initial_running_status_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerEmbeddedWorkerStatus>(data_->initial_running_status_$value));
  }
  template <typename UserType>
  UserType TakeRunningStatusReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::ServiceWorkerRunningStatusCallbackInterfaceBase>>(
            &data_->running_status_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeRemoteCacheStorage() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::CacheStorageInterfaceBase>>(
            &data_->remote_cache_storage, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ServiceWorkerRouterData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ControllerServiceWorkerInfoDataView {
 public:
  ControllerServiceWorkerInfoDataView() = default;

  ControllerServiceWorkerInfoDataView(
      internal::ControllerServiceWorkerInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::blink::mojom::ControllerServiceWorkerMode>(
        data_value, output);
  }
  ::blink::mojom::ControllerServiceWorkerMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ControllerServiceWorkerMode>(data_->mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFetchHandlerType(UserType* output) const {
    auto data_value = data_->fetch_handler_type;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerFetchHandlerType>(
        data_value, output);
  }
  ::blink::mojom::ServiceWorkerFetchHandlerType fetch_handler_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerFetchHandlerType>(data_->fetch_handler_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFetchHandlerBypassOption(UserType* output) const {
    auto data_value = data_->fetch_handler_bypass_option;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerFetchHandlerBypassOption>(
        data_value, output);
  }
  ::blink::mojom::ServiceWorkerFetchHandlerBypassOption fetch_handler_bypass_option() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerFetchHandlerBypassOption>(data_->fetch_handler_bypass_option));
  }
  inline void GetSha256ScriptChecksumDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSha256ScriptChecksum(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `sha256_script_checksum` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSha256ScriptChecksum` instead "
    "of `ReadSha256ScriptChecksum if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sha256_script_checksum.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool need_router_evaluate() const {
    return data_->need_router_evaluate;
  }
  inline void GetRouterDataDataView(
      ServiceWorkerRouterDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouterData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerRouterDataDataView, UserType>(),
    "Attempting to read the optional `router_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRouterData` instead "
    "of `ReadRouterData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->router_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterDataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeRemoteController() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::ControllerServiceWorkerInterfaceBase>>(
            &data_->remote_controller, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetClientIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientId(UserType* output) {
    
    auto* pointer = data_->client_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFetchRequestWindowIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFetchRequestWindowId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `fetch_request_window_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFetchRequestWindowId` instead "
    "of `ReadFetchRequestWindowId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fetch_request_window_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetObjectInfoDataView(
      ::blink::mojom::ServiceWorkerObjectInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadObjectInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerObjectInfoDataView, UserType>(),
    "Attempting to read the optional `object_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadObjectInfo` instead "
    "of `ReadObjectInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->object_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
        pointer, output, message_);
  }
  inline void GetUsedFeaturesDataView(
      mojo::ArrayDataView<::blink::mojom::WebFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsedFeatures(UserType* output) {
    
    auto* pointer = data_->used_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
        pointer, output, message_);
  }
 private:
  internal::ControllerServiceWorkerInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_DATA_VIEW_H_