// third_party/blink/public/mojom/render_accessibility.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.RenderAccessibilityHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.RenderAccessibilityHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.RenderAccessibilityHostInterface }
 */
blink.mojom.RenderAccessibilityHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.RenderAccessibilityHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.RenderAccessibilityHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.RenderAccessibilityHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ax.mojom.AXUpdatesAndEvents } eventsAndUpdates
   * @param { !ax.mojom.AXLocationAndScrollUpdates } locationAndScrollUpdates
   * @param { !number } resetToken
   * @return {!Promise}
   */

  handleAXEvents(
      eventsAndUpdates,
      locationAndScrollUpdates,
      resetToken) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.RenderAccessibilityHost_HandleAXEvents_ParamsSpec.$,
        blink.mojom.RenderAccessibilityHost_HandleAXEvents_ResponseParamsSpec.$,
        [
          eventsAndUpdates,
          locationAndScrollUpdates,
          resetToken
        ],
        false);
  }

  
  /**
   * @param { !ax.mojom.AXLocationAndScrollUpdates } changes
   * @param { !number } resetToken
   */

  handleAXLocationChanges(
      changes,
      resetToken) {
    this.proxy.sendMessage(
        1,
        blink.mojom.RenderAccessibilityHost_HandleAXLocationChanges_ParamsSpec.$,
        null,
        [
          changes,
          resetToken
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RenderAccessibilityHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.RenderAccessibilityHostReceiver = class {
  /**
   * @param {!blink.mojom.RenderAccessibilityHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.RenderAccessibilityHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.RenderAccessibilityHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RenderAccessibilityHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RenderAccessibilityHost_HandleAXEvents_ParamsSpec.$,
        blink.mojom.RenderAccessibilityHost_HandleAXEvents_ResponseParamsSpec.$,
        impl.handleAXEvents.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RenderAccessibilityHost_HandleAXLocationChanges_ParamsSpec.$,
        null,
        impl.handleAXLocationChanges.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.RenderAccessibilityHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RenderAccessibilityHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.RenderAccessibilityHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.RenderAccessibilityHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RenderAccessibilityHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.RenderAccessibilityHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.RenderAccessibilityHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RenderAccessibilityHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.handleAXEvents =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RenderAccessibilityHost_HandleAXEvents_ParamsSpec.$,
        blink.mojom.RenderAccessibilityHost_HandleAXEvents_ResponseParamsSpec.$,
        this.handleAXEvents.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.handleAXLocationChanges =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RenderAccessibilityHost_HandleAXLocationChanges_ParamsSpec.$,
        null,
        this.handleAXLocationChanges.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.RenderAccessibilityPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.RenderAccessibility.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.RenderAccessibilityInterface }
 */
blink.mojom.RenderAccessibilityRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.RenderAccessibilityPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.RenderAccessibilityPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.RenderAccessibilityPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ax.mojom.AXMode } axMode
   * @param { !number } resetToken
   */

  setMode(
      axMode,
      resetToken) {
    this.proxy.sendMessage(
        0,
        blink.mojom.RenderAccessibility_SetMode_ParamsSpec.$,
        null,
        [
          axMode,
          resetToken
        ],
        false);
  }

  
  /**
   */

  fatalError() {
    this.proxy.sendMessage(
        1,
        blink.mojom.RenderAccessibility_FatalError_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Point } point
   * @param { !ax.mojom.Event } eventToFire
   * @param { !number } requestId
   * @return {!Promise<{
        hitTestResponse: ?blink.mojom.HitTestResponse,
   *  }>}
   */

  hitTest(
      point,
      eventToFire,
      requestId) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.RenderAccessibility_HitTest_ParamsSpec.$,
        blink.mojom.RenderAccessibility_HitTest_ResponseParamsSpec.$,
        [
          point,
          eventToFire,
          requestId
        ],
        false);
  }

  
  /**
   * @param { !ax.mojom.AXActionData } actionData
   */

  performAction(
      actionData) {
    this.proxy.sendMessage(
        3,
        blink.mojom.RenderAccessibility_PerformAction_ParamsSpec.$,
        null,
        [
          actionData
        ],
        false);
  }

  
  /**
   * @param { !number } resetToken
   */

  reset(
      resetToken) {
    this.proxy.sendMessage(
        4,
        blink.mojom.RenderAccessibility_Reset_ParamsSpec.$,
        null,
        [
          resetToken
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RenderAccessibility
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.RenderAccessibilityReceiver = class {
  /**
   * @param {!blink.mojom.RenderAccessibilityInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.RenderAccessibilityRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.RenderAccessibilityRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RenderAccessibilityRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RenderAccessibility_SetMode_ParamsSpec.$,
        null,
        impl.setMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RenderAccessibility_FatalError_ParamsSpec.$,
        null,
        impl.fatalError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.RenderAccessibility_HitTest_ParamsSpec.$,
        blink.mojom.RenderAccessibility_HitTest_ResponseParamsSpec.$,
        impl.hitTest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.RenderAccessibility_PerformAction_ParamsSpec.$,
        null,
        impl.performAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.RenderAccessibility_Reset_ParamsSpec.$,
        null,
        impl.reset.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.RenderAccessibility = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RenderAccessibility";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.RenderAccessibilityRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.RenderAccessibilityRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RenderAccessibility
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.RenderAccessibilityCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.RenderAccessibilityRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RenderAccessibilityRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RenderAccessibility_SetMode_ParamsSpec.$,
        null,
        this.setMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fatalError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RenderAccessibility_FatalError_ParamsSpec.$,
        null,
        this.fatalError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hitTest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.RenderAccessibility_HitTest_ParamsSpec.$,
        blink.mojom.RenderAccessibility_HitTest_ResponseParamsSpec.$,
        this.hitTest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.performAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.RenderAccessibility_PerformAction_ParamsSpec.$,
        null,
        this.performAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.RenderAccessibility_Reset_ParamsSpec.$,
        null,
        this.reset.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.HitTestResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RenderAccessibilityHost_HandleAXEvents_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RenderAccessibilityHost_HandleAXEvents_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RenderAccessibilityHost_HandleAXLocationChanges_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RenderAccessibility_SetMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RenderAccessibility_FatalError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RenderAccessibility_HitTest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RenderAccessibility_HitTest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RenderAccessibility_PerformAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RenderAccessibility_Reset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.HitTestResponseSpec.$,
    'HitTestResponse',
    [
      mojo.internal.StructField(
        'stitchedChildTreeId', 0,
        0,
        ax.mojom.AXTreeIDSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hitFrameToken', 16,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hitFrameTransformedPoint', 32,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hitNodeId', 40,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.HitTestResponse = class {
  constructor() {
    /** @export { !ax.mojom.AXTreeID } */
    this.stitchedChildTreeId;
    /** @export { !blink.mojom.FrameToken } */
    this.hitFrameToken;
    /** @export { !gfx.mojom.Point } */
    this.hitFrameTransformedPoint;
    /** @export { !number } */
    this.hitNodeId;
  }
};



mojo.internal.Struct(
    blink.mojom.RenderAccessibilityHost_HandleAXEvents_ParamsSpec.$,
    'RenderAccessibilityHost_HandleAXEvents_Params',
    [
      mojo.internal.StructField(
        'eventsAndUpdates', 0,
        0,
        ax.mojom.AXUpdatesAndEventsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'locationAndScrollUpdates', 8,
        0,
        ax.mojom.AXLocationAndScrollUpdatesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resetToken', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.RenderAccessibilityHost_HandleAXEvents_Params = class {
  constructor() {
    /** @export { !ax.mojom.AXUpdatesAndEvents } */
    this.eventsAndUpdates;
    /** @export { !ax.mojom.AXLocationAndScrollUpdates } */
    this.locationAndScrollUpdates;
    /** @export { !number } */
    this.resetToken;
  }
};



mojo.internal.Struct(
    blink.mojom.RenderAccessibilityHost_HandleAXEvents_ResponseParamsSpec.$,
    'RenderAccessibilityHost_HandleAXEvents_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RenderAccessibilityHost_HandleAXEvents_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RenderAccessibilityHost_HandleAXLocationChanges_ParamsSpec.$,
    'RenderAccessibilityHost_HandleAXLocationChanges_Params',
    [
      mojo.internal.StructField(
        'changes', 0,
        0,
        ax.mojom.AXLocationAndScrollUpdatesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resetToken', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RenderAccessibilityHost_HandleAXLocationChanges_Params = class {
  constructor() {
    /** @export { !ax.mojom.AXLocationAndScrollUpdates } */
    this.changes;
    /** @export { !number } */
    this.resetToken;
  }
};



mojo.internal.Struct(
    blink.mojom.RenderAccessibility_SetMode_ParamsSpec.$,
    'RenderAccessibility_SetMode_Params',
    [
      mojo.internal.StructField(
        'axMode', 0,
        0,
        ax.mojom.AXModeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resetToken', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RenderAccessibility_SetMode_Params = class {
  constructor() {
    /** @export { !ax.mojom.AXMode } */
    this.axMode;
    /** @export { !number } */
    this.resetToken;
  }
};



mojo.internal.Struct(
    blink.mojom.RenderAccessibility_FatalError_ParamsSpec.$,
    'RenderAccessibility_FatalError_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RenderAccessibility_FatalError_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RenderAccessibility_HitTest_ParamsSpec.$,
    'RenderAccessibility_HitTest_Params',
    [
      mojo.internal.StructField(
        'point', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventToFire', 8,
        0,
        ax.mojom.EventSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestId', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RenderAccessibility_HitTest_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.point;
    /** @export { !ax.mojom.Event } */
    this.eventToFire;
    /** @export { !number } */
    this.requestId;
  }
};



mojo.internal.Struct(
    blink.mojom.RenderAccessibility_HitTest_ResponseParamsSpec.$,
    'RenderAccessibility_HitTest_ResponseParams',
    [
      mojo.internal.StructField(
        'hitTestResponse', 0,
        0,
        blink.mojom.HitTestResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RenderAccessibility_HitTest_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.HitTestResponse|undefined) } */
    this.hitTestResponse;
  }
};



mojo.internal.Struct(
    blink.mojom.RenderAccessibility_PerformAction_ParamsSpec.$,
    'RenderAccessibility_PerformAction_Params',
    [
      mojo.internal.StructField(
        'actionData', 0,
        0,
        ax.mojom.AXActionDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RenderAccessibility_PerformAction_Params = class {
  constructor() {
    /** @export { !ax.mojom.AXActionData } */
    this.actionData;
  }
};



mojo.internal.Struct(
    blink.mojom.RenderAccessibility_Reset_ParamsSpec.$,
    'RenderAccessibility_Reset_Params',
    [
      mojo.internal.StructField(
        'resetToken', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RenderAccessibility_Reset_Params = class {
  constructor() {
    /** @export { !number } */
    this.resetToken;
  }
};

