// third_party/blink/public/mojom/quota/quota_manager_host.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  QuotaStatusCodeSpec as blink_mojom_QuotaStatusCodeSpec,
  QuotaStatusCode as blink_mojom_QuotaStatusCode,
  UsageBreakdownSpec as blink_mojom_UsageBreakdownSpec,
  UsageBreakdown as blink_mojom_UsageBreakdown
} from './quota_types.mojom-webui.js';







export type QuotaManagerHostPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<QuotaManagerHostPendingReceiver>;

export class QuotaManagerHostPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<QuotaManagerHost> {

  handle: mojo.internal.interfaceSupport.Endpoint<QuotaManagerHostPendingReceiver>;
  constructor(handle: MojoHandle|QuotaManagerHostPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'blink.mojom.QuotaManagerHost',
        scope);
  }
}

export interface QuotaManagerHostInterface {
  queryStorageUsageAndQuota(): Promise<{
        error: blink_mojom_QuotaStatusCode,
        currentUsage: bigint,
        currentQuota: bigint,
        usageBreakdown: blink_mojom_UsageBreakdown, }>;
}

export class QuotaManagerHostRemote implements QuotaManagerHostInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<QuotaManagerHostPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<QuotaManagerHostPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|QuotaManagerHostPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          QuotaManagerHostPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  queryStorageUsageAndQuota(): Promise<{
        error: blink_mojom_QuotaStatusCode,
        currentUsage: bigint,
        currentQuota: bigint,
        usageBreakdown: blink_mojom_UsageBreakdown, }> {
    return this.proxy.sendMessage(
        0,
        QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec.$,
        QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the QuotaManagerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class QuotaManagerHostReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    QuotaManagerHostRemote, QuotaManagerHostPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    QuotaManagerHostRemote, QuotaManagerHostPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: QuotaManagerHostInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        QuotaManagerHostRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec.$,
        QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec.$,
        impl.queryStorageUsageAndQuota.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class QuotaManagerHost {
  static get $interfaceName(): string {
    return "blink.mojom.QuotaManagerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): QuotaManagerHostRemote {
    let remote = new QuotaManagerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the QuotaManagerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class QuotaManagerHostCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    QuotaManagerHostRemote, QuotaManagerHostPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    QuotaManagerHostRemote, QuotaManagerHostPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  queryStorageUsageAndQuota: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      QuotaManagerHostRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.queryStorageUsageAndQuota =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec.$,
        QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec.$,
        this.queryStorageUsageAndQuota.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface QuotaManagerHost_QueryStorageUsageAndQuota_ParamsMojoType {
}


export type QuotaManagerHost_QueryStorageUsageAndQuota_Params = QuotaManagerHost_QueryStorageUsageAndQuota_ParamsMojoType;
mojo.internal.Struct<QuotaManagerHost_QueryStorageUsageAndQuota_ParamsMojoType>(
    QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec.$,
    'QuotaManagerHost_QueryStorageUsageAndQuota_Params',
    [
    ],
    [[0, 8],]);





export interface QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsMojoType {
  error: blink_mojom_QuotaStatusCode;
  currentUsage: bigint;
  currentQuota: bigint;
  usageBreakdown: blink_mojom_UsageBreakdown;
}


export type QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams = QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsMojoType;
mojo.internal.Struct<QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsMojoType>(
    QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec.$,
    'QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams',
    [
      mojo.internal.StructField<QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsMojoType, blink_mojom_QuotaStatusCode>(
        'error', 0,
        0,
        blink_mojom_QuotaStatusCodeSpec.$,
        -1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsMojoType, bigint>(
        'currentUsage', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsMojoType, bigint>(
        'currentQuota', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsMojoType, blink_mojom_UsageBreakdown>(
        'usageBreakdown', 24,
        0,
        blink_mojom_UsageBreakdownSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);



