// third_party/blink/public/mojom/printing/web_printing.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  BlobRemote as blink_mojom_BlobRemote,
  BlobPendingReceiver as blink_mojom_BlobPendingReceiver
} from '../blob/blob.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebPrintingMultipleDocumentHandlingSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebPrintingMultipleDocumentHandling = {
  
  kSeparateDocumentsCollatedCopies: 0,
  kSeparateDocumentsUncollatedCopies: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebPrintingSidesSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebPrintingSides = {
  
  kOneSided: 0,
  kTwoSidedLongEdge: 1,
  kTwoSidedShortEdge: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebPrintQualitySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebPrintQuality = {
  
  kDraft: 0,
  kNormal: 1,
  kHigh: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebPrintColorModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebPrintColorMode = {
  
  kColor: 0,
  kMonochrome: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebPrintingOrientationRequestedSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebPrintingOrientationRequested = {
  
  kPortrait: 0,
  kLandscape: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebPrinterStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebPrinterState = {
  
  kIdle: 0,
  kProcessing: 1,
  kStopped: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebPrinterStateReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebPrinterStateReason = {
  
  kNone: 0,
  kOther: 1,
  kConnectingToDevice: 2,
  kCoverOpen: 3,
  kDeveloperEmpty: 4,
  kDeveloperLow: 5,
  kDoorOpen: 6,
  kFuserOverTemp: 7,
  kFuserUnderTemp: 8,
  kInputTrayMissing: 9,
  kInterlockOpen: 10,
  kInterpreterResourceUnavailable: 11,
  kMarkerSupplyEmpty: 12,
  kMarkerSupplyLow: 13,
  kMarkerWasteAlmostFull: 14,
  kMarkerWasteFull: 15,
  kMediaEmpty: 16,
  kMediaJam: 17,
  kMediaLow: 18,
  kMediaNeeded: 19,
  kMovingToPaused: 20,
  kOpcLifeOver: 21,
  kOpcNearEol: 22,
  kOutputAreaAlmostFull: 23,
  kOutputAreaFull: 24,
  kOutputTrayMissing: 25,
  kPaused: 26,
  kShutdown: 27,
  kSpoolAreaFull: 28,
  kStoppedPartly: 29,
  kStopping: 30,
  kTimedOut: 31,
  kTonerEmpty: 32,
  kTonerLow: 33,
  kCupsPkiExpired: 34,
  MIN_VALUE: 0,
  MAX_VALUE: 34,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebPrintJobStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebPrintJobState = {
  
  kPending: 0,
  kProcessing: 1,
  kCompleted: 2,
  kCanceled: 3,
  kAborted: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const GetPrintersErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const GetPrintersError = {
  
  kUserPermissionDenied: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebPrinterFetchErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebPrinterFetchError = {
  
  kPrinterUnreachable: 0,
  kUserPermissionDenied: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebPrintErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebPrintError = {
  
  kPrinterUnreachable: 0,
  kDocumentMalformed: 1,
  kPrintJobTemplateAttributesMismatch: 2,
  kUserPermissionDenied: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebPrintJobStateObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WebPrintJobStateObserver', scope);
  }
}

/** @interface */
export class WebPrintJobStateObserverInterface {
  
  /**
   * @param { !WebPrintJobUpdate } update
   */

  onWebPrintJobUpdate(update) {}
}

/**
 * @implements { WebPrintJobStateObserverInterface }
 */
export class WebPrintJobStateObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebPrintJobStateObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebPrintJobStateObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebPrintJobStateObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !WebPrintJobUpdate } update
   */

  onWebPrintJobUpdate(
      update) {
    this.proxy.sendMessage(
        0,
        WebPrintJobStateObserver_OnWebPrintJobUpdate_ParamsSpec.$,
        null,
        [
          update
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebPrintJobStateObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebPrintJobStateObserverReceiver {
  /**
   * @param {!WebPrintJobStateObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebPrintJobStateObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebPrintJobStateObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebPrintJobStateObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebPrintJobStateObserver_OnWebPrintJobUpdate_ParamsSpec.$,
        null,
        impl.onWebPrintJobUpdate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebPrintJobStateObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebPrintJobStateObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebPrintJobStateObserverRemote}
   */
  static getRemote() {
    let remote = new WebPrintJobStateObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebPrintJobStateObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebPrintJobStateObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebPrintJobStateObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebPrintJobStateObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWebPrintJobUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebPrintJobStateObserver_OnWebPrintJobUpdate_ParamsSpec.$,
        null,
        this.onWebPrintJobUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebPrintJobControllerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WebPrintJobController', scope);
  }
}

/** @interface */
export class WebPrintJobControllerInterface {
  
  /**
   */

  cancel() {}
}

/**
 * @implements { WebPrintJobControllerInterface }
 */
export class WebPrintJobControllerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebPrintJobControllerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebPrintJobControllerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebPrintJobControllerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        0,
        WebPrintJobController_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebPrintJobController
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebPrintJobControllerReceiver {
  /**
   * @param {!WebPrintJobControllerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebPrintJobControllerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebPrintJobControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebPrintJobControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebPrintJobController_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebPrintJobController {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebPrintJobController";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebPrintJobControllerRemote}
   */
  static getRemote() {
    let remote = new WebPrintJobControllerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebPrintJobController
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebPrintJobControllerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebPrintJobControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebPrintJobControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebPrintJobController_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebPrinterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WebPrinter', scope);
  }
}

/** @interface */
export class WebPrinterInterface {
  
  /**
   * @return {!Promise<{
        result: !WebPrinterFetchResult,
   *  }>}
   */

  fetchAttributes() {}
  
  /**
   * @param { !blink_mojom_BlobRemote } document
   * @param { !WebPrintJobTemplateAttributes } attributes
   * @return {!Promise<{
        result: !WebPrintResult,
   *  }>}
   */

  print(document, attributes) {}
}

/**
 * @implements { WebPrinterInterface }
 */
export class WebPrinterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebPrinterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebPrinterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebPrinterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !WebPrinterFetchResult,
   *  }>}
   */

  fetchAttributes() {
    return this.proxy.sendMessage(
        0,
        WebPrinter_FetchAttributes_ParamsSpec.$,
        WebPrinter_FetchAttributes_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_BlobRemote } document
   * @param { !WebPrintJobTemplateAttributes } attributes
   * @return {!Promise<{
        result: !WebPrintResult,
   *  }>}
   */

  print(
      document,
      attributes) {
    return this.proxy.sendMessage(
        1,
        WebPrinter_Print_ParamsSpec.$,
        WebPrinter_Print_ResponseParamsSpec.$,
        [
          document,
          attributes
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebPrinter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebPrinterReceiver {
  /**
   * @param {!WebPrinterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebPrinterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebPrinterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebPrinterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebPrinter_FetchAttributes_ParamsSpec.$,
        WebPrinter_FetchAttributes_ResponseParamsSpec.$,
        impl.fetchAttributes.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebPrinter_Print_ParamsSpec.$,
        WebPrinter_Print_ResponseParamsSpec.$,
        impl.print.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebPrinter {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebPrinter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebPrinterRemote}
   */
  static getRemote() {
    let remote = new WebPrinterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebPrinter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebPrinterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebPrinterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebPrinterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fetchAttributes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebPrinter_FetchAttributes_ParamsSpec.$,
        WebPrinter_FetchAttributes_ResponseParamsSpec.$,
        this.fetchAttributes.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.print =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebPrinter_Print_ParamsSpec.$,
        WebPrinter_Print_ResponseParamsSpec.$,
        this.print.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebPrintingServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WebPrintingService', scope);
  }
}

/** @interface */
export class WebPrintingServiceInterface {
  
  /**
   * @return {!Promise<{
        result: !GetPrintersResult,
   *  }>}
   */

  getPrinters() {}
}

/**
 * @implements { WebPrintingServiceInterface }
 */
export class WebPrintingServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebPrintingServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebPrintingServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebPrintingServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !GetPrintersResult,
   *  }>}
   */

  getPrinters() {
    return this.proxy.sendMessage(
        0,
        WebPrintingService_GetPrinters_ParamsSpec.$,
        WebPrintingService_GetPrinters_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebPrintingService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebPrintingServiceReceiver {
  /**
   * @param {!WebPrintingServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebPrintingServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebPrintingServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebPrintingServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebPrintingService_GetPrinters_ParamsSpec.$,
        WebPrintingService_GetPrinters_ResponseParamsSpec.$,
        impl.getPrinters.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebPrintingService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebPrintingService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebPrintingServiceRemote}
   */
  static getRemote() {
    let remote = new WebPrintingServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebPrintingService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebPrintingServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebPrintingServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebPrintingServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPrinters =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebPrintingService_GetPrinters_ParamsSpec.$,
        WebPrintingService_GetPrinters_ResponseParamsSpec.$,
        this.getPrinters.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrinterInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrintingRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrintingMediaSizeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrintingMediaCollectionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrinterAttributesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrintingMediaCollectionRequestedSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrintJobTemplateAttributesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrintJobUpdateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrintJobInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrintJobStateObserver_OnWebPrintJobUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrintJobController_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrinter_FetchAttributes_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrinter_FetchAttributes_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrinter_Print_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrinter_Print_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrintingService_GetPrinters_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPrintingService_GetPrinters_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const WebPrintingMediaSizeDimensionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const GetPrintersResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const WebPrinterFetchResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const WebPrintResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WebPrinterInfoSpec.$,
    'WebPrinterInfo',
    [
      mojo.internal.StructField(
        'printerName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'printerId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'printerRemote', 16,
        0,
        mojo.internal.InterfaceProxy(WebPrinterRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class WebPrinterInfo {
  constructor() {
    /** @type { !string } */
    this.printerName;
    /** @type { !string } */
    this.printerId;
    /** @type { !WebPrinterRemote } */
    this.printerRemote;
  }
}



mojo.internal.Struct(
    WebPrintingRangeSpec.$,
    'WebPrintingRange',
    [
      mojo.internal.StructField(
        'from', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'to', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebPrintingRange {
  constructor() {
    /** @type { !number } */
    this.from;
    /** @type { !number } */
    this.to;
  }
}



mojo.internal.Struct(
    WebPrintingMediaSizeSpec.$,
    'WebPrintingMediaSize',
    [
      mojo.internal.StructField(
        'xDimension', 0,
        0,
        WebPrintingMediaSizeDimensionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'yDimension', 16,
        0,
        WebPrintingMediaSizeDimensionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class WebPrintingMediaSize {
  constructor() {
    /** @type { !WebPrintingMediaSizeDimension } */
    this.xDimension;
    /** @type { !WebPrintingMediaSizeDimension } */
    this.yDimension;
  }
}



mojo.internal.Struct(
    WebPrintingMediaCollectionSpec.$,
    'WebPrintingMediaCollection',
    [
      mojo.internal.StructField(
        'mediaSize', 0,
        0,
        WebPrintingMediaSizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaSizeName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebPrintingMediaCollection {
  constructor() {
    /** @type { !WebPrintingMediaSize } */
    this.mediaSize;
    /** @type { !string } */
    this.mediaSizeName;
  }
}



mojo.internal.Struct(
    WebPrinterAttributesSpec.$,
    'WebPrinterAttributes',
    [
      mojo.internal.StructField(
        'copiesDefault', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'copiesSupported', 8,
        0,
        WebPrintingRangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaColDefault', 16,
        0,
        WebPrintingMediaCollectionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaColDatabase', 24,
        0,
        mojo.internal.Array(WebPrintingMediaCollectionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaSourceDefault', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaSourceSupported', 40,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'multipleDocumentHandlingDefault', 4,
        0,
        WebPrintingMultipleDocumentHandlingSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'multipleDocumentHandlingSupported', 48,
        0,
        mojo.internal.Array(WebPrintingMultipleDocumentHandlingSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'orientationRequestedDefault', 56,
        0,
        WebPrintingOrientationRequestedSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'orientationRequestedSupported', 64,
        0,
        mojo.internal.Array(WebPrintingOrientationRequestedSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'printerResolutionDefault', 72,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'printerResolutionSupported', 80,
        0,
        mojo.internal.Array(gfx_mojom_SizeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'printColorModeDefault', 60,
        0,
        WebPrintColorModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'printColorModeSupported', 88,
        0,
        mojo.internal.Array(WebPrintColorModeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'print_quality_default_$flag', 96,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "print_quality_default_$value",
          originalFieldName: "printQualityDefault",
        }
      ),
      mojo.internal.StructField(
        'print_quality_default_$value', 100,
        0,
        WebPrintQualitySpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "printQualityDefault",
        }
      ),
      mojo.internal.StructField(
        'printQualitySupported', 104,
        0,
        mojo.internal.Array(WebPrintQualitySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'printerState', 112,
        0,
        WebPrinterStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'printerStateMessage', 120,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'printerStateReasons', 128,
        0,
        mojo.internal.Array(WebPrinterStateReasonSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sides_default_$flag', 96,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "sides_default_$value",
          originalFieldName: "sidesDefault",
        }
      ),
      mojo.internal.StructField(
        'sides_default_$value', 116,
        0,
        WebPrintingSidesSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "sidesDefault",
        }
      ),
      mojo.internal.StructField(
        'sidesSupported', 136,
        0,
        mojo.internal.Array(WebPrintingSidesSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'printerId', 144,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 160],]);



/**
 * @record
 */
export class WebPrinterAttributes {
  constructor() {
    /** @type { !number } */
    this.copiesDefault;
    /** @type { !WebPrintingRange } */
    this.copiesSupported;
    /** @type { !WebPrintingMediaCollection } */
    this.mediaColDefault;
    /** @type { !Array<!WebPrintingMediaCollection> } */
    this.mediaColDatabase;
    /** @type { (string|undefined) } */
    this.mediaSourceDefault;
    /** @type { !Array<!string> } */
    this.mediaSourceSupported;
    /** @type { !WebPrintingMultipleDocumentHandling } */
    this.multipleDocumentHandlingDefault;
    /** @type { !Array<!WebPrintingMultipleDocumentHandling> } */
    this.multipleDocumentHandlingSupported;
    /** @type { !WebPrintingOrientationRequested } */
    this.orientationRequestedDefault;
    /** @type { !Array<!WebPrintingOrientationRequested> } */
    this.orientationRequestedSupported;
    /** @type { !gfx_mojom_Size } */
    this.printerResolutionDefault;
    /** @type { !Array<!gfx_mojom_Size> } */
    this.printerResolutionSupported;
    /** @type { !WebPrintColorMode } */
    this.printColorModeDefault;
    /** @type { !Array<!WebPrintColorMode> } */
    this.printColorModeSupported;
    /** @type { (WebPrintQuality|undefined) } */
    this.printQualityDefault;
    /** @type { !Array<!WebPrintQuality> } */
    this.printQualitySupported;
    /** @type { !WebPrinterState } */
    this.printerState;
    /** @type { !string } */
    this.printerStateMessage;
    /** @type { !Array<!WebPrinterStateReason> } */
    this.printerStateReasons;
    /** @type { (WebPrintingSides|undefined) } */
    this.sidesDefault;
    /** @type { !Array<!WebPrintingSides> } */
    this.sidesSupported;
    /** @type { !string } */
    this.printerId;
  }
}



mojo.internal.Struct(
    WebPrintingMediaCollectionRequestedSpec.$,
    'WebPrintingMediaCollectionRequested',
    [
      mojo.internal.StructField(
        'mediaSize', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebPrintingMediaCollectionRequested {
  constructor() {
    /** @type { !gfx_mojom_Size } */
    this.mediaSize;
  }
}



mojo.internal.Struct(
    WebPrintJobTemplateAttributesSpec.$,
    'WebPrintJobTemplateAttributes',
    [
      mojo.internal.StructField(
        'jobName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'copies', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaCol', 16,
        0,
        WebPrintingMediaCollectionRequestedSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaSource', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'multiple_document_handling_$flag', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "multiple_document_handling_$value",
          originalFieldName: "multipleDocumentHandling",
        }
      ),
      mojo.internal.StructField(
        'multiple_document_handling_$value', 32,
        0,
        WebPrintingMultipleDocumentHandlingSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "multipleDocumentHandling",
        }
      ),
      mojo.internal.StructField(
        'orientation_requested_$flag', 12,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "orientation_requested_$value",
          originalFieldName: "orientationRequested",
        }
      ),
      mojo.internal.StructField(
        'orientation_requested_$value', 36,
        0,
        WebPrintingOrientationRequestedSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "orientationRequested",
        }
      ),
      mojo.internal.StructField(
        'printerResolution', 40,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'print_color_mode_$flag', 12,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "print_color_mode_$value",
          originalFieldName: "printColorMode",
        }
      ),
      mojo.internal.StructField(
        'print_color_mode_$value', 48,
        0,
        WebPrintColorModeSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "printColorMode",
        }
      ),
      mojo.internal.StructField(
        'print_quality_$flag', 12,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "print_quality_$value",
          originalFieldName: "printQuality",
        }
      ),
      mojo.internal.StructField(
        'print_quality_$value', 52,
        0,
        WebPrintQualitySpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "printQuality",
        }
      ),
      mojo.internal.StructField(
        'sides_$flag', 12,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "sides_$value",
          originalFieldName: "sides",
        }
      ),
      mojo.internal.StructField(
        'sides_$value', 56,
        0,
        WebPrintingSidesSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "sides",
        }
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class WebPrintJobTemplateAttributes {
  constructor() {
    /** @type { !string } */
    this.jobName;
    /** @type { !number } */
    this.copies;
    /** @type { (WebPrintingMediaCollectionRequested|undefined) } */
    this.mediaCol;
    /** @type { (string|undefined) } */
    this.mediaSource;
    /** @type { (WebPrintingMultipleDocumentHandling|undefined) } */
    this.multipleDocumentHandling;
    /** @type { (WebPrintingOrientationRequested|undefined) } */
    this.orientationRequested;
    /** @type { (gfx_mojom_Size|undefined) } */
    this.printerResolution;
    /** @type { (WebPrintColorMode|undefined) } */
    this.printColorMode;
    /** @type { (WebPrintQuality|undefined) } */
    this.printQuality;
    /** @type { (WebPrintingSides|undefined) } */
    this.sides;
  }
}



mojo.internal.Struct(
    WebPrintJobUpdateSpec.$,
    'WebPrintJobUpdate',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        WebPrintJobStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pagesPrinted', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebPrintJobUpdate {
  constructor() {
    /** @type { !WebPrintJobState } */
    this.state;
    /** @type { !number } */
    this.pagesPrinted;
  }
}



mojo.internal.Struct(
    WebPrintJobInfoSpec.$,
    'WebPrintJobInfo',
    [
      mojo.internal.StructField(
        'jobName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'jobPages', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceRequest(WebPrintJobStateObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'controller', 16,
        0,
        mojo.internal.InterfaceProxy(WebPrintJobControllerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class WebPrintJobInfo {
  constructor() {
    /** @type { !string } */
    this.jobName;
    /** @type { !number } */
    this.jobPages;
    /** @type { !WebPrintJobStateObserverPendingReceiver } */
    this.observer;
    /** @type { !WebPrintJobControllerRemote } */
    this.controller;
  }
}



mojo.internal.Struct(
    WebPrintJobStateObserver_OnWebPrintJobUpdate_ParamsSpec.$,
    'WebPrintJobStateObserver_OnWebPrintJobUpdate_Params',
    [
      mojo.internal.StructField(
        'update', 0,
        0,
        WebPrintJobUpdateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebPrintJobStateObserver_OnWebPrintJobUpdate_Params {
  constructor() {
    /** @type { !WebPrintJobUpdate } */
    this.update;
  }
}



mojo.internal.Struct(
    WebPrintJobController_Cancel_ParamsSpec.$,
    'WebPrintJobController_Cancel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebPrintJobController_Cancel_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebPrinter_FetchAttributes_ParamsSpec.$,
    'WebPrinter_FetchAttributes_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebPrinter_FetchAttributes_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebPrinter_FetchAttributes_ResponseParamsSpec.$,
    'WebPrinter_FetchAttributes_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        WebPrinterFetchResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebPrinter_FetchAttributes_ResponseParams {
  constructor() {
    /** @type { !WebPrinterFetchResult } */
    this.result;
  }
}



mojo.internal.Struct(
    WebPrinter_Print_ParamsSpec.$,
    'WebPrinter_Print_Params',
    [
      mojo.internal.StructField(
        'document', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_BlobRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attributes', 8,
        0,
        WebPrintJobTemplateAttributesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebPrinter_Print_Params {
  constructor() {
    /** @type { !blink_mojom_BlobRemote } */
    this.document;
    /** @type { !WebPrintJobTemplateAttributes } */
    this.attributes;
  }
}



mojo.internal.Struct(
    WebPrinter_Print_ResponseParamsSpec.$,
    'WebPrinter_Print_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        WebPrintResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebPrinter_Print_ResponseParams {
  constructor() {
    /** @type { !WebPrintResult } */
    this.result;
  }
}



mojo.internal.Struct(
    WebPrintingService_GetPrinters_ParamsSpec.$,
    'WebPrintingService_GetPrinters_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebPrintingService_GetPrinters_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebPrintingService_GetPrinters_ResponseParamsSpec.$,
    'WebPrintingService_GetPrinters_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        GetPrintersResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebPrintingService_GetPrinters_ResponseParams {
  constructor() {
    /** @type { !GetPrintersResult } */
    this.result;
  }
}

mojo.internal.Union(
    WebPrintingMediaSizeDimensionSpec.$, 'WebPrintingMediaSizeDimension',
    {
      'range': {
        'ordinal': 0,
        'type': WebPrintingRangeSpec.$,
      },
      'value': {
        'ordinal': 1,
        'type': mojo.internal.Uint32,
      },
    });

/**
 * @typedef { {
 *   range: (!WebPrintingRange|undefined),
 *   value: (!number|undefined),
 * } }
 */
export const WebPrintingMediaSizeDimension = {};
mojo.internal.Union(
    GetPrintersResultSpec.$, 'GetPrintersResult',
    {
      'printers': {
        'ordinal': 0,
        'type': mojo.internal.Array(WebPrinterInfoSpec.$, false),
      },
      'error': {
        'ordinal': 1,
        'type': GetPrintersErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   printers: (!Array<!WebPrinterInfo>|undefined),
 *   error: (!GetPrintersError|undefined),
 * } }
 */
export const GetPrintersResult = {};
mojo.internal.Union(
    WebPrinterFetchResultSpec.$, 'WebPrinterFetchResult',
    {
      'printerAttributes': {
        'ordinal': 0,
        'type': WebPrinterAttributesSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': WebPrinterFetchErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   printerAttributes: (!WebPrinterAttributes|undefined),
 *   error: (!WebPrinterFetchError|undefined),
 * } }
 */
export const WebPrinterFetchResult = {};
mojo.internal.Union(
    WebPrintResultSpec.$, 'WebPrintResult',
    {
      'printJobInfo': {
        'ordinal': 0,
        'type': WebPrintJobInfoSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': WebPrintErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   printJobInfo: (!WebPrintJobInfo|undefined),
 *   error: (!WebPrintError|undefined),
 * } }
 */
export const WebPrintResult = {};
