// third_party/blink/public/mojom/presentation/presentation.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/presentation/presentation.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/presentation/presentation.mojom-params-data.h"
#include "third_party/blink/public/mojom/presentation/presentation.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/presentation/presentation.mojom-import-headers.h"
#include "third_party/blink/public/mojom/presentation/presentation.mojom-test-utils.h"


namespace blink::mojom {
PresentationInfo::PresentationInfo()
    : url(),
      id() {}

PresentationInfo::PresentationInfo(
    const ::GURL& url_in,
    const std::string& id_in)
    : url(std::move(url_in)),
      id(std::move(id_in)) {}

PresentationInfo::~PresentationInfo() = default;

void PresentationInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PresentationInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PresentationError::PresentationError()
    : error_type(),
      message() {}

PresentationError::PresentationError(
    PresentationErrorType error_type_in,
    const std::string& message_in)
    : error_type(std::move(error_type_in)),
      message(std::move(message_in)) {}

PresentationError::~PresentationError() = default;
size_t PresentationError::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->error_type);
  seed = mojo::internal::Hash(seed, this->message);
  return seed;
}

void PresentationError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_type"), this->error_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PresentationErrorType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PresentationError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PresentationConnectionResult::PresentationConnectionResult()
    : presentation_info(),
      connection_remote(),
      connection_receiver() {}

PresentationConnectionResult::PresentationConnectionResult(
    PresentationInfoPtr presentation_info_in,
    ::mojo::PendingRemote<PresentationConnection> connection_remote_in,
    ::mojo::PendingReceiver<PresentationConnection> connection_receiver_in)
    : presentation_info(std::move(presentation_info_in)),
      connection_remote(std::move(connection_remote_in)),
      connection_receiver(std::move(connection_receiver_in)) {}

PresentationConnectionResult::~PresentationConnectionResult() = default;

void PresentationConnectionResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "presentation_info"), this->presentation_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PresentationInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection_remote"), this->connection_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<PresentationConnection>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection_receiver"), this->connection_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<PresentationConnection>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PresentationConnectionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PresentationConnectionMessagePtr
PresentationConnectionMessage::NewMessage(
    const std::string& value) {
  return PresentationConnectionMessagePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kMessage)>,
      std::move(value));
}

PresentationConnectionMessagePtr
PresentationConnectionMessage::NewData(
    std::vector<uint8_t> value) {
  return PresentationConnectionMessagePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kData)>,
      std::move(value));
}

PresentationConnectionMessage::PresentationConnectionMessage(
    std::in_place_index_t<static_cast<size_t>(Tag::kMessage)>,
    const std::string& value)
    : tag_(Tag::kMessage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kMessage)>,
            std::move(value)) {}

PresentationConnectionMessage::PresentationConnectionMessage(
    std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
    std::vector<uint8_t> value)
    : tag_(Tag::kData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kData)>,
            std::move(value)) {}
PresentationConnectionMessage::~PresentationConnectionMessage() {
  DestroyActive();
}

void PresentationConnectionMessage::set_message(const std::string& message) {
  if (tag_ == Tag::kMessage) {
    data_.message = std::move(message);
  } else {
    DestroyActive();
    tag_ = Tag::kMessage;
    new (&data_.message) std::string(
        std::move(message));
  }
}

void PresentationConnectionMessage::set_data(std::vector<uint8_t> data) {
  if (tag_ == Tag::kData) {
    data_.data = std::move(data);
  } else {
    DestroyActive();
    tag_ = Tag::kData;
    new (&data_.data) std::vector<uint8_t>(
        std::move(data));
  }
}


PresentationConnectionMessage::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kMessage)>,
    const std::string& value)
    : message(std::move(value)) {}

PresentationConnectionMessage::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
    std::vector<uint8_t> value)
    : data(std::move(value)) {}

void PresentationConnectionMessage::DestroyActive() {
  switch (tag_) {

    case Tag::kMessage:
      std::destroy_at(&data_.message);
      break;
    case Tag::kData:
      std::destroy_at(&data_.data);
      break;
  }
}

bool PresentationConnectionMessage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

PresentationConnection::IPCStableHashFunction PresentationConnection::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PresentationConnection>(message.name())) {
    case messages::PresentationConnection::kOnMessage: {
      return &PresentationConnection::OnMessage_Sym::IPCStableHash;
    }
    case messages::PresentationConnection::kDidChangeState: {
      return &PresentationConnection::DidChangeState_Sym::IPCStableHash;
    }
    case messages::PresentationConnection::kDidClose: {
      return &PresentationConnection::DidClose_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PresentationConnection::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PresentationConnection>(message.name())) {
      case messages::PresentationConnection::kOnMessage:
            return "Receive blink::mojom::PresentationConnection::OnMessage";
      case messages::PresentationConnection::kDidChangeState:
            return "Receive blink::mojom::PresentationConnection::DidChangeState";
      case messages::PresentationConnection::kDidClose:
            return "Receive blink::mojom::PresentationConnection::DidClose";
    }
  } else {
    switch (static_cast<messages::PresentationConnection>(message.name())) {
      case messages::PresentationConnection::kOnMessage:
            return "Receive reply blink::mojom::PresentationConnection::OnMessage";
      case messages::PresentationConnection::kDidChangeState:
            return "Receive reply blink::mojom::PresentationConnection::DidChangeState";
      case messages::PresentationConnection::kDidClose:
            return "Receive reply blink::mojom::PresentationConnection::DidClose";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PresentationConnection::OnMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0142d040;  // IPCStableHash for blink::mojom::PresentationConnection::OnMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationConnection::DidChangeState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x327ebdf1;  // IPCStableHash for blink::mojom::PresentationConnection::DidChangeState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationConnection::DidClose_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x350b77eb;  // IPCStableHash for blink::mojom::PresentationConnection::DidClose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PresentationConnectionProxy::PresentationConnectionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PresentationConnectionProxy::OnMessage(
    PresentationConnectionMessagePtr in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationConnection::OnMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type PresentationConnectionMessagePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationConnection::kOnMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationConnection_OnMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->message)>
      message_fragment(params.message());
  message_fragment.Claim(&params->message);
  
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionMessageDataView>(
    in_message,
    message_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in PresentationConnection.OnMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationConnection::Name_);
  message.set_method_name("OnMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PresentationConnectionProxy::DidChangeState(
    PresentationConnectionState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationConnection::DidChangeState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type PresentationConnectionState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationConnection::kDidChangeState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationConnection_DidChangeState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionState>(
    in_state,
    &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationConnection::Name_);
  message.set_method_name("DidChangeState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PresentationConnectionProxy::DidClose(
    PresentationConnectionCloseReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationConnection::DidClose", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type PresentationConnectionCloseReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationConnection::kDidClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationConnection_DidClose_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionCloseReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationConnection::Name_);
  message.set_method_name("DidClose");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PresentationConnectionStubDispatch::Accept(
    PresentationConnection* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PresentationConnection>(message->header()->name)) {
    case messages::PresentationConnection::kOnMessage: {
      DCHECK(message->is_serialized());
      internal::PresentationConnection_OnMessage_Params_Data* params =
          reinterpret_cast<internal::PresentationConnection_OnMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationConnection.0
      bool success = true;
      PresentationConnectionMessagePtr p_message{};
      PresentationConnection_OnMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationConnection::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMessage(        
        std::move(p_message));
      return true;
    }
    case messages::PresentationConnection::kDidChangeState: {
      DCHECK(message->is_serialized());
      internal::PresentationConnection_DidChangeState_Params_Data* params =
          reinterpret_cast<internal::PresentationConnection_DidChangeState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationConnection.1
      bool success = true;
      PresentationConnectionState p_state{};
      PresentationConnection_DidChangeState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationConnection::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeState(        
        std::move(p_state));
      return true;
    }
    case messages::PresentationConnection::kDidClose: {
      DCHECK(message->is_serialized());
      internal::PresentationConnection_DidClose_Params_Data* params =
          reinterpret_cast<internal::PresentationConnection_DidClose_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationConnection.2
      bool success = true;
      PresentationConnectionCloseReason p_reason{};
      PresentationConnection_DidClose_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationConnection::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidClose(        
        std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool PresentationConnectionStubDispatch::AcceptWithResponder(
    PresentationConnection* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PresentationConnection>(message->header()->name)) {
    case messages::PresentationConnection::kOnMessage: {
      break;
    }
    case messages::PresentationConnection::kDidChangeState: {
      break;
    }
    case messages::PresentationConnection::kDidClose: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPresentationConnectionValidationInfo[] = {
    { &internal::PresentationConnection_OnMessage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PresentationConnection_DidChangeState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PresentationConnection_DidClose_Params_Data::Validate,
     nullptr /* no response */},
};

bool PresentationConnectionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::PresentationConnection::Name_,
    kPresentationConnectionValidationInfo);
}

// The declaration includes the definition on other builds.

PresentationService::IPCStableHashFunction PresentationService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PresentationService>(message.name())) {
    case messages::PresentationService::kSetController: {
      return &PresentationService::SetController_Sym::IPCStableHash;
    }
    case messages::PresentationService::kSetReceiver: {
      return &PresentationService::SetReceiver_Sym::IPCStableHash;
    }
    case messages::PresentationService::kSetDefaultPresentationUrls: {
      return &PresentationService::SetDefaultPresentationUrls_Sym::IPCStableHash;
    }
    case messages::PresentationService::kListenForScreenAvailability: {
      return &PresentationService::ListenForScreenAvailability_Sym::IPCStableHash;
    }
    case messages::PresentationService::kStopListeningForScreenAvailability: {
      return &PresentationService::StopListeningForScreenAvailability_Sym::IPCStableHash;
    }
    case messages::PresentationService::kStartPresentation: {
      return &PresentationService::StartPresentation_Sym::IPCStableHash;
    }
    case messages::PresentationService::kReconnectPresentation: {
      return &PresentationService::ReconnectPresentation_Sym::IPCStableHash;
    }
    case messages::PresentationService::kCloseConnection: {
      return &PresentationService::CloseConnection_Sym::IPCStableHash;
    }
    case messages::PresentationService::kTerminate: {
      return &PresentationService::Terminate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PresentationService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PresentationService>(message.name())) {
      case messages::PresentationService::kSetController:
            return "Receive blink::mojom::PresentationService::SetController";
      case messages::PresentationService::kSetReceiver:
            return "Receive blink::mojom::PresentationService::SetReceiver";
      case messages::PresentationService::kSetDefaultPresentationUrls:
            return "Receive blink::mojom::PresentationService::SetDefaultPresentationUrls";
      case messages::PresentationService::kListenForScreenAvailability:
            return "Receive blink::mojom::PresentationService::ListenForScreenAvailability";
      case messages::PresentationService::kStopListeningForScreenAvailability:
            return "Receive blink::mojom::PresentationService::StopListeningForScreenAvailability";
      case messages::PresentationService::kStartPresentation:
            return "Receive blink::mojom::PresentationService::StartPresentation";
      case messages::PresentationService::kReconnectPresentation:
            return "Receive blink::mojom::PresentationService::ReconnectPresentation";
      case messages::PresentationService::kCloseConnection:
            return "Receive blink::mojom::PresentationService::CloseConnection";
      case messages::PresentationService::kTerminate:
            return "Receive blink::mojom::PresentationService::Terminate";
    }
  } else {
    switch (static_cast<messages::PresentationService>(message.name())) {
      case messages::PresentationService::kSetController:
            return "Receive reply blink::mojom::PresentationService::SetController";
      case messages::PresentationService::kSetReceiver:
            return "Receive reply blink::mojom::PresentationService::SetReceiver";
      case messages::PresentationService::kSetDefaultPresentationUrls:
            return "Receive reply blink::mojom::PresentationService::SetDefaultPresentationUrls";
      case messages::PresentationService::kListenForScreenAvailability:
            return "Receive reply blink::mojom::PresentationService::ListenForScreenAvailability";
      case messages::PresentationService::kStopListeningForScreenAvailability:
            return "Receive reply blink::mojom::PresentationService::StopListeningForScreenAvailability";
      case messages::PresentationService::kStartPresentation:
            return "Receive reply blink::mojom::PresentationService::StartPresentation";
      case messages::PresentationService::kReconnectPresentation:
            return "Receive reply blink::mojom::PresentationService::ReconnectPresentation";
      case messages::PresentationService::kCloseConnection:
            return "Receive reply blink::mojom::PresentationService::CloseConnection";
      case messages::PresentationService::kTerminate:
            return "Receive reply blink::mojom::PresentationService::Terminate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PresentationService::SetController_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71881a86;  // IPCStableHash for blink::mojom::PresentationService::SetController
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationService::SetReceiver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb9d3470;  // IPCStableHash for blink::mojom::PresentationService::SetReceiver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationService::SetDefaultPresentationUrls_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b8b80a6;  // IPCStableHash for blink::mojom::PresentationService::SetDefaultPresentationUrls
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationService::ListenForScreenAvailability_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7106c3ee;  // IPCStableHash for blink::mojom::PresentationService::ListenForScreenAvailability
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationService::StopListeningForScreenAvailability_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x903b322f;  // IPCStableHash for blink::mojom::PresentationService::StopListeningForScreenAvailability
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationService::StartPresentation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3d18dc4;  // IPCStableHash for blink::mojom::PresentationService::StartPresentation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationService::ReconnectPresentation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb6aaf91a;  // IPCStableHash for blink::mojom::PresentationService::ReconnectPresentation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationService::CloseConnection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x58092f51;  // IPCStableHash for blink::mojom::PresentationService::CloseConnection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationService::Terminate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8c994c8b;  // IPCStableHash for blink::mojom::PresentationService::Terminate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PresentationService_StartPresentation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PresentationService_StartPresentation_ForwardToCallback(
      PresentationService::StartPresentationCallback callback
      ) : callback_(std::move(callback)) {
  }

  PresentationService_StartPresentation_ForwardToCallback(const PresentationService_StartPresentation_ForwardToCallback&) = delete;
  PresentationService_StartPresentation_ForwardToCallback& operator=(const PresentationService_StartPresentation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PresentationService::StartPresentationCallback callback_;
};

class PresentationService_ReconnectPresentation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PresentationService_ReconnectPresentation_ForwardToCallback(
      PresentationService::ReconnectPresentationCallback callback
      ) : callback_(std::move(callback)) {
  }

  PresentationService_ReconnectPresentation_ForwardToCallback(const PresentationService_ReconnectPresentation_ForwardToCallback&) = delete;
  PresentationService_ReconnectPresentation_ForwardToCallback& operator=(const PresentationService_ReconnectPresentation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PresentationService::ReconnectPresentationCallback callback_;
};

PresentationServiceProxy::PresentationServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PresentationServiceProxy::SetController(
    ::mojo::PendingRemote<PresentationController> in_controller) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationService::SetController", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller"), in_controller,
                        "<value of type ::mojo::PendingRemote<PresentationController>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationService::kSetController), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_SetController_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PresentationControllerInterfaceBase>>(
    in_controller,
    &params->controller,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->controller)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid controller in PresentationService.SetController request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("SetController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PresentationServiceProxy::SetReceiver(
    ::mojo::PendingRemote<PresentationReceiver> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationService::SetReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingRemote<PresentationReceiver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationService::kSetReceiver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_SetReceiver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PresentationReceiverInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in PresentationService.SetReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("SetReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PresentationServiceProxy::SetDefaultPresentationUrls(
    const std::vector<::GURL>& in_presentation_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationService::SetDefaultPresentationUrls", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_urls"), in_presentation_urls,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationService::kSetDefaultPresentationUrls), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_SetDefaultPresentationUrls_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_urls)::BaseType>
      presentation_urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& presentation_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_presentation_urls,
    presentation_urls_fragment,
    &presentation_urls_validate_params);

  params->presentation_urls.Set(
      presentation_urls_fragment.is_null() ? nullptr : presentation_urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->presentation_urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null presentation_urls in PresentationService.SetDefaultPresentationUrls request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("SetDefaultPresentationUrls");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PresentationServiceProxy::ListenForScreenAvailability(
    const ::GURL& in_availability_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationService::ListenForScreenAvailability", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("availability_url"), in_availability_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationService::kListenForScreenAvailability), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_ListenForScreenAvailability_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->availability_url)::BaseType> availability_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_availability_url,
    availability_url_fragment);

  params->availability_url.Set(
      availability_url_fragment.is_null() ? nullptr : availability_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->availability_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null availability_url in PresentationService.ListenForScreenAvailability request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("ListenForScreenAvailability");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PresentationServiceProxy::StopListeningForScreenAvailability(
    const ::GURL& in_availability_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationService::StopListeningForScreenAvailability", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("availability_url"), in_availability_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationService::kStopListeningForScreenAvailability), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_StopListeningForScreenAvailability_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->availability_url)::BaseType> availability_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_availability_url,
    availability_url_fragment);

  params->availability_url.Set(
      availability_url_fragment.is_null() ? nullptr : availability_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->availability_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null availability_url in PresentationService.StopListeningForScreenAvailability request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("StopListeningForScreenAvailability");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PresentationServiceProxy::StartPresentation(
    const std::vector<::GURL>& in_presentation_urls, StartPresentationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationService::StartPresentation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_urls"), in_presentation_urls,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationService::kStartPresentation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_StartPresentation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_urls)::BaseType>
      presentation_urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& presentation_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_presentation_urls,
    presentation_urls_fragment,
    &presentation_urls_validate_params);

  params->presentation_urls.Set(
      presentation_urls_fragment.is_null() ? nullptr : presentation_urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->presentation_urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null presentation_urls in PresentationService.StartPresentation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("StartPresentation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PresentationService_StartPresentation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PresentationServiceProxy::ReconnectPresentation(
    const std::vector<::GURL>& in_presentation_urls, const std::string& in_presentation_id, ReconnectPresentationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationService::ReconnectPresentation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_urls"), in_presentation_urls,
                        "<value of type const std::vector<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_id"), in_presentation_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationService::kReconnectPresentation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_ReconnectPresentation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_urls)::BaseType>
      presentation_urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& presentation_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_presentation_urls,
    presentation_urls_fragment,
    &presentation_urls_validate_params);

  params->presentation_urls.Set(
      presentation_urls_fragment.is_null() ? nullptr : presentation_urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->presentation_urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null presentation_urls in PresentationService.ReconnectPresentation request");
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_id)::BaseType> presentation_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_presentation_id,
    presentation_id_fragment);

  params->presentation_id.Set(
      presentation_id_fragment.is_null() ? nullptr : presentation_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->presentation_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null presentation_id in PresentationService.ReconnectPresentation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("ReconnectPresentation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PresentationService_ReconnectPresentation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PresentationServiceProxy::CloseConnection(
    const ::GURL& in_presentation_url, const std::string& in_presentation_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationService::CloseConnection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_url"), in_presentation_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_id"), in_presentation_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationService::kCloseConnection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_CloseConnection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_url)::BaseType> presentation_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_presentation_url,
    presentation_url_fragment);

  params->presentation_url.Set(
      presentation_url_fragment.is_null() ? nullptr : presentation_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->presentation_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null presentation_url in PresentationService.CloseConnection request");
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_id)::BaseType> presentation_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_presentation_id,
    presentation_id_fragment);

  params->presentation_id.Set(
      presentation_id_fragment.is_null() ? nullptr : presentation_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->presentation_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null presentation_id in PresentationService.CloseConnection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("CloseConnection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PresentationServiceProxy::Terminate(
    const ::GURL& in_presentation_url, const std::string& in_presentation_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationService::Terminate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_url"), in_presentation_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_id"), in_presentation_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationService::kTerminate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_Terminate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_url)::BaseType> presentation_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_presentation_url,
    presentation_url_fragment);

  params->presentation_url.Set(
      presentation_url_fragment.is_null() ? nullptr : presentation_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->presentation_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null presentation_url in PresentationService.Terminate request");
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_id)::BaseType> presentation_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_presentation_id,
    presentation_id_fragment);

  params->presentation_id.Set(
      presentation_id_fragment.is_null() ? nullptr : presentation_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->presentation_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null presentation_id in PresentationService.Terminate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("Terminate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PresentationService_StartPresentation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PresentationService::StartPresentationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PresentationService_StartPresentation_ProxyToResponder> proxy(
        new PresentationService_StartPresentation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PresentationService_StartPresentation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PresentationService_StartPresentation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PresentationService_StartPresentation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PresentationService::StartPresentationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PresentationConnectionResultPtr in_result, PresentationErrorPtr in_error);
};

bool PresentationService_StartPresentation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PresentationService_StartPresentation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PresentationService_StartPresentation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PresentationService.5
  bool success = true;
  PresentationConnectionResultPtr p_result{};
  PresentationErrorPtr p_error{};
  PresentationService_StartPresentation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PresentationService::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_error));
  }
  return true;
}

void PresentationService_StartPresentation_ProxyToResponder::Run(
    PresentationConnectionResultPtr in_result, PresentationErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PresentationService::StartPresentation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PresentationConnectionResultPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type PresentationErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationService::kStartPresentation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_StartPresentation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PresentationErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("StartPresentation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PresentationService_ReconnectPresentation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PresentationService::ReconnectPresentationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PresentationService_ReconnectPresentation_ProxyToResponder> proxy(
        new PresentationService_ReconnectPresentation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PresentationService_ReconnectPresentation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PresentationService_ReconnectPresentation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PresentationService_ReconnectPresentation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PresentationService::ReconnectPresentationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PresentationConnectionResultPtr in_result, PresentationErrorPtr in_error);
};

bool PresentationService_ReconnectPresentation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PresentationService_ReconnectPresentation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PresentationService_ReconnectPresentation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PresentationService.6
  bool success = true;
  PresentationConnectionResultPtr p_result{};
  PresentationErrorPtr p_error{};
  PresentationService_ReconnectPresentation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PresentationService::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_error));
  }
  return true;
}

void PresentationService_ReconnectPresentation_ProxyToResponder::Run(
    PresentationConnectionResultPtr in_result, PresentationErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PresentationService::ReconnectPresentation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PresentationConnectionResultPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type PresentationErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationService::kReconnectPresentation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_ReconnectPresentation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PresentationErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("ReconnectPresentation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PresentationServiceStubDispatch::Accept(
    PresentationService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PresentationService>(message->header()->name)) {
    case messages::PresentationService::kSetController: {
      DCHECK(message->is_serialized());
      internal::PresentationService_SetController_Params_Data* params =
          reinterpret_cast<internal::PresentationService_SetController_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationService.0
      bool success = true;
      ::mojo::PendingRemote<PresentationController> p_controller{};
      PresentationService_SetController_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_controller =
            input_data_view.TakeController<decltype(p_controller)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetController(        
        std::move(p_controller));
      return true;
    }
    case messages::PresentationService::kSetReceiver: {
      DCHECK(message->is_serialized());
      internal::PresentationService_SetReceiver_Params_Data* params =
          reinterpret_cast<internal::PresentationService_SetReceiver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationService.1
      bool success = true;
      ::mojo::PendingRemote<PresentationReceiver> p_receiver{};
      PresentationService_SetReceiver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReceiver(        
        std::move(p_receiver));
      return true;
    }
    case messages::PresentationService::kSetDefaultPresentationUrls: {
      DCHECK(message->is_serialized());
      internal::PresentationService_SetDefaultPresentationUrls_Params_Data* params =
          reinterpret_cast<internal::PresentationService_SetDefaultPresentationUrls_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationService.2
      bool success = true;
      std::vector<::GURL> p_presentation_urls{};
      PresentationService_SetDefaultPresentationUrls_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationUrls(&p_presentation_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDefaultPresentationUrls(        
        std::move(p_presentation_urls));
      return true;
    }
    case messages::PresentationService::kListenForScreenAvailability: {
      DCHECK(message->is_serialized());
      internal::PresentationService_ListenForScreenAvailability_Params_Data* params =
          reinterpret_cast<internal::PresentationService_ListenForScreenAvailability_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationService.3
      bool success = true;
      ::GURL p_availability_url{};
      PresentationService_ListenForScreenAvailability_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAvailabilityUrl(&p_availability_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListenForScreenAvailability(        
        std::move(p_availability_url));
      return true;
    }
    case messages::PresentationService::kStopListeningForScreenAvailability: {
      DCHECK(message->is_serialized());
      internal::PresentationService_StopListeningForScreenAvailability_Params_Data* params =
          reinterpret_cast<internal::PresentationService_StopListeningForScreenAvailability_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationService.4
      bool success = true;
      ::GURL p_availability_url{};
      PresentationService_StopListeningForScreenAvailability_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAvailabilityUrl(&p_availability_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopListeningForScreenAvailability(        
        std::move(p_availability_url));
      return true;
    }
    case messages::PresentationService::kStartPresentation: {
      break;
    }
    case messages::PresentationService::kReconnectPresentation: {
      break;
    }
    case messages::PresentationService::kCloseConnection: {
      DCHECK(message->is_serialized());
      internal::PresentationService_CloseConnection_Params_Data* params =
          reinterpret_cast<internal::PresentationService_CloseConnection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationService.7
      bool success = true;
      ::GURL p_presentation_url{};
      std::string p_presentation_id{};
      PresentationService_CloseConnection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationUrl(&p_presentation_url))
        success = false;
      if (success && !input_data_view.ReadPresentationId(&p_presentation_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseConnection(        
        std::move(p_presentation_url), 
        std::move(p_presentation_id));
      return true;
    }
    case messages::PresentationService::kTerminate: {
      DCHECK(message->is_serialized());
      internal::PresentationService_Terminate_Params_Data* params =
          reinterpret_cast<internal::PresentationService_Terminate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationService.8
      bool success = true;
      ::GURL p_presentation_url{};
      std::string p_presentation_id{};
      PresentationService_Terminate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationUrl(&p_presentation_url))
        success = false;
      if (success && !input_data_view.ReadPresentationId(&p_presentation_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Terminate(        
        std::move(p_presentation_url), 
        std::move(p_presentation_id));
      return true;
    }
  }
  return false;
}

// static
bool PresentationServiceStubDispatch::AcceptWithResponder(
    PresentationService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PresentationService>(message->header()->name)) {
    case messages::PresentationService::kSetController: {
      break;
    }
    case messages::PresentationService::kSetReceiver: {
      break;
    }
    case messages::PresentationService::kSetDefaultPresentationUrls: {
      break;
    }
    case messages::PresentationService::kListenForScreenAvailability: {
      break;
    }
    case messages::PresentationService::kStopListeningForScreenAvailability: {
      break;
    }
    case messages::PresentationService::kStartPresentation: {
      internal::PresentationService_StartPresentation_Params_Data* params =
          reinterpret_cast<
              internal::PresentationService_StartPresentation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PresentationService.5
      bool success = true;
      std::vector<::GURL> p_presentation_urls{};
      PresentationService_StartPresentation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationUrls(&p_presentation_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 5, false);
        return false;
      }
      auto callback =
          PresentationService_StartPresentation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartPresentation(        
        std::move(p_presentation_urls), std::move(callback));
      return true;
    }
    case messages::PresentationService::kReconnectPresentation: {
      internal::PresentationService_ReconnectPresentation_Params_Data* params =
          reinterpret_cast<
              internal::PresentationService_ReconnectPresentation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PresentationService.6
      bool success = true;
      std::vector<::GURL> p_presentation_urls{};
      std::string p_presentation_id{};
      PresentationService_ReconnectPresentation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationUrls(&p_presentation_urls))
        success = false;
      if (success && !input_data_view.ReadPresentationId(&p_presentation_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 6, false);
        return false;
      }
      auto callback =
          PresentationService_ReconnectPresentation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReconnectPresentation(        
        std::move(p_presentation_urls), 
        std::move(p_presentation_id), std::move(callback));
      return true;
    }
    case messages::PresentationService::kCloseConnection: {
      break;
    }
    case messages::PresentationService::kTerminate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPresentationServiceValidationInfo[] = {
    { &internal::PresentationService_SetController_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PresentationService_SetReceiver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PresentationService_SetDefaultPresentationUrls_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PresentationService_ListenForScreenAvailability_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PresentationService_StopListeningForScreenAvailability_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PresentationService_StartPresentation_Params_Data::Validate,
     &internal::PresentationService_StartPresentation_ResponseParams_Data::Validate},
    { &internal::PresentationService_ReconnectPresentation_Params_Data::Validate,
     &internal::PresentationService_ReconnectPresentation_ResponseParams_Data::Validate},
    { &internal::PresentationService_CloseConnection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PresentationService_Terminate_Params_Data::Validate,
     nullptr /* no response */},
};

bool PresentationServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::PresentationService::Name_,
    kPresentationServiceValidationInfo);
}

bool PresentationServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::PresentationService::Name_,
    kPresentationServiceValidationInfo);
}
// The declaration includes the definition on other builds.

PresentationController::IPCStableHashFunction PresentationController::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PresentationController>(message.name())) {
    case messages::PresentationController::kOnScreenAvailabilityUpdated: {
      return &PresentationController::OnScreenAvailabilityUpdated_Sym::IPCStableHash;
    }
    case messages::PresentationController::kOnDefaultPresentationStarted: {
      return &PresentationController::OnDefaultPresentationStarted_Sym::IPCStableHash;
    }
    case messages::PresentationController::kOnConnectionStateChanged: {
      return &PresentationController::OnConnectionStateChanged_Sym::IPCStableHash;
    }
    case messages::PresentationController::kOnConnectionClosed: {
      return &PresentationController::OnConnectionClosed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PresentationController::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PresentationController>(message.name())) {
      case messages::PresentationController::kOnScreenAvailabilityUpdated:
            return "Receive blink::mojom::PresentationController::OnScreenAvailabilityUpdated";
      case messages::PresentationController::kOnDefaultPresentationStarted:
            return "Receive blink::mojom::PresentationController::OnDefaultPresentationStarted";
      case messages::PresentationController::kOnConnectionStateChanged:
            return "Receive blink::mojom::PresentationController::OnConnectionStateChanged";
      case messages::PresentationController::kOnConnectionClosed:
            return "Receive blink::mojom::PresentationController::OnConnectionClosed";
    }
  } else {
    switch (static_cast<messages::PresentationController>(message.name())) {
      case messages::PresentationController::kOnScreenAvailabilityUpdated:
            return "Receive reply blink::mojom::PresentationController::OnScreenAvailabilityUpdated";
      case messages::PresentationController::kOnDefaultPresentationStarted:
            return "Receive reply blink::mojom::PresentationController::OnDefaultPresentationStarted";
      case messages::PresentationController::kOnConnectionStateChanged:
            return "Receive reply blink::mojom::PresentationController::OnConnectionStateChanged";
      case messages::PresentationController::kOnConnectionClosed:
            return "Receive reply blink::mojom::PresentationController::OnConnectionClosed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PresentationController::OnScreenAvailabilityUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x585978d1;  // IPCStableHash for blink::mojom::PresentationController::OnScreenAvailabilityUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationController::OnDefaultPresentationStarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7b826970;  // IPCStableHash for blink::mojom::PresentationController::OnDefaultPresentationStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationController::OnConnectionStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x57c96f8f;  // IPCStableHash for blink::mojom::PresentationController::OnConnectionStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PresentationController::OnConnectionClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xced55e00;  // IPCStableHash for blink::mojom::PresentationController::OnConnectionClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PresentationControllerProxy::PresentationControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PresentationControllerProxy::OnScreenAvailabilityUpdated(
    const ::GURL& in_url, ScreenAvailability in_availability) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationController::OnScreenAvailabilityUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("availability"), in_availability,
                        "<value of type ScreenAvailability>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationController::kOnScreenAvailabilityUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationController_OnScreenAvailabilityUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PresentationController.OnScreenAvailabilityUpdated request");

  
  mojo::internal::Serialize<::blink::mojom::ScreenAvailability>(
    in_availability,
    &params->availability);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationController::Name_);
  message.set_method_name("OnScreenAvailabilityUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PresentationControllerProxy::OnDefaultPresentationStarted(
    PresentationConnectionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationController::OnDefaultPresentationStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PresentationConnectionResultPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationController::kOnDefaultPresentationStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationController_OnDefaultPresentationStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in PresentationController.OnDefaultPresentationStarted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationController::Name_);
  message.set_method_name("OnDefaultPresentationStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PresentationControllerProxy::OnConnectionStateChanged(
    PresentationInfoPtr in_presentation_info, PresentationConnectionState in_newState) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationController::OnConnectionStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_info"), in_presentation_info,
                        "<value of type PresentationInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("newState"), in_newState,
                        "<value of type PresentationConnectionState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationController::kOnConnectionStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationController_OnConnectionStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_info)::BaseType> presentation_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PresentationInfoDataView>(
    in_presentation_info,
    presentation_info_fragment);

  params->presentation_info.Set(
      presentation_info_fragment.is_null() ? nullptr : presentation_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->presentation_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null presentation_info in PresentationController.OnConnectionStateChanged request");

  
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionState>(
    in_newState,
    &params->newState);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationController::Name_);
  message.set_method_name("OnConnectionStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PresentationControllerProxy::OnConnectionClosed(
    PresentationInfoPtr in_presentation_info, PresentationConnectionCloseReason in_reason, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationController::OnConnectionClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_info"), in_presentation_info,
                        "<value of type PresentationInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type PresentationConnectionCloseReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationController::kOnConnectionClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationController_OnConnectionClosed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_info)::BaseType> presentation_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PresentationInfoDataView>(
    in_presentation_info,
    presentation_info_fragment);

  params->presentation_info.Set(
      presentation_info_fragment.is_null() ? nullptr : presentation_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->presentation_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null presentation_info in PresentationController.OnConnectionClosed request");

  
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionCloseReason>(
    in_reason,
    &params->reason);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in PresentationController.OnConnectionClosed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationController::Name_);
  message.set_method_name("OnConnectionClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PresentationControllerStubDispatch::Accept(
    PresentationController* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PresentationController>(message->header()->name)) {
    case messages::PresentationController::kOnScreenAvailabilityUpdated: {
      DCHECK(message->is_serialized());
      internal::PresentationController_OnScreenAvailabilityUpdated_Params_Data* params =
          reinterpret_cast<internal::PresentationController_OnScreenAvailabilityUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationController.0
      bool success = true;
      ::GURL p_url{};
      ScreenAvailability p_availability{};
      PresentationController_OnScreenAvailabilityUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadAvailability(&p_availability))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScreenAvailabilityUpdated(        
        std::move(p_url), 
        std::move(p_availability));
      return true;
    }
    case messages::PresentationController::kOnDefaultPresentationStarted: {
      DCHECK(message->is_serialized());
      internal::PresentationController_OnDefaultPresentationStarted_Params_Data* params =
          reinterpret_cast<internal::PresentationController_OnDefaultPresentationStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationController.1
      bool success = true;
      PresentationConnectionResultPtr p_result{};
      PresentationController_OnDefaultPresentationStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationController::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDefaultPresentationStarted(        
        std::move(p_result));
      return true;
    }
    case messages::PresentationController::kOnConnectionStateChanged: {
      DCHECK(message->is_serialized());
      internal::PresentationController_OnConnectionStateChanged_Params_Data* params =
          reinterpret_cast<internal::PresentationController_OnConnectionStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationController.2
      bool success = true;
      PresentationInfoPtr p_presentation_info{};
      PresentationConnectionState p_newState{};
      PresentationController_OnConnectionStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationInfo(&p_presentation_info))
        success = false;
      if (success && !input_data_view.ReadNewState(&p_newState))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationController::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnectionStateChanged(        
        std::move(p_presentation_info), 
        std::move(p_newState));
      return true;
    }
    case messages::PresentationController::kOnConnectionClosed: {
      DCHECK(message->is_serialized());
      internal::PresentationController_OnConnectionClosed_Params_Data* params =
          reinterpret_cast<internal::PresentationController_OnConnectionClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationController.3
      bool success = true;
      PresentationInfoPtr p_presentation_info{};
      PresentationConnectionCloseReason p_reason{};
      std::string p_message{};
      PresentationController_OnConnectionClosed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationInfo(&p_presentation_info))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationController::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnectionClosed(        
        std::move(p_presentation_info), 
        std::move(p_reason), 
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool PresentationControllerStubDispatch::AcceptWithResponder(
    PresentationController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PresentationController>(message->header()->name)) {
    case messages::PresentationController::kOnScreenAvailabilityUpdated: {
      break;
    }
    case messages::PresentationController::kOnDefaultPresentationStarted: {
      break;
    }
    case messages::PresentationController::kOnConnectionStateChanged: {
      break;
    }
    case messages::PresentationController::kOnConnectionClosed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPresentationControllerValidationInfo[] = {
    { &internal::PresentationController_OnScreenAvailabilityUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PresentationController_OnDefaultPresentationStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PresentationController_OnConnectionStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PresentationController_OnConnectionClosed_Params_Data::Validate,
     nullptr /* no response */},
};

bool PresentationControllerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::PresentationController::Name_,
    kPresentationControllerValidationInfo);
}

// The declaration includes the definition on other builds.

PresentationReceiver::IPCStableHashFunction PresentationReceiver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PresentationReceiver>(message.name())) {
    case messages::PresentationReceiver::kOnReceiverConnectionAvailable: {
      return &PresentationReceiver::OnReceiverConnectionAvailable_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PresentationReceiver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PresentationReceiver>(message.name())) {
      case messages::PresentationReceiver::kOnReceiverConnectionAvailable:
            return "Receive blink::mojom::PresentationReceiver::OnReceiverConnectionAvailable";
    }
  } else {
    switch (static_cast<messages::PresentationReceiver>(message.name())) {
      case messages::PresentationReceiver::kOnReceiverConnectionAvailable:
            return "Receive reply blink::mojom::PresentationReceiver::OnReceiverConnectionAvailable";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PresentationReceiver::OnReceiverConnectionAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43046c12;  // IPCStableHash for blink::mojom::PresentationReceiver::OnReceiverConnectionAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PresentationReceiverProxy::PresentationReceiverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PresentationReceiverProxy::OnReceiverConnectionAvailable(
    PresentationConnectionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PresentationReceiver::OnReceiverConnectionAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PresentationConnectionResultPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PresentationReceiver::kOnReceiverConnectionAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationReceiver_OnReceiverConnectionAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in PresentationReceiver.OnReceiverConnectionAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationReceiver::Name_);
  message.set_method_name("OnReceiverConnectionAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PresentationReceiverStubDispatch::Accept(
    PresentationReceiver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PresentationReceiver>(message->header()->name)) {
    case messages::PresentationReceiver::kOnReceiverConnectionAvailable: {
      DCHECK(message->is_serialized());
      internal::PresentationReceiver_OnReceiverConnectionAvailable_Params_Data* params =
          reinterpret_cast<internal::PresentationReceiver_OnReceiverConnectionAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PresentationReceiver.0
      bool success = true;
      PresentationConnectionResultPtr p_result{};
      PresentationReceiver_OnReceiverConnectionAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationReceiver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiverConnectionAvailable(        
        std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool PresentationReceiverStubDispatch::AcceptWithResponder(
    PresentationReceiver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PresentationReceiver>(message->header()->name)) {
    case messages::PresentationReceiver::kOnReceiverConnectionAvailable: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPresentationReceiverValidationInfo[] = {
    { &internal::PresentationReceiver_OnReceiverConnectionAvailable_Params_Data::Validate,
     nullptr /* no response */},
};

bool PresentationReceiverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::PresentationReceiver::Name_,
    kPresentationReceiverValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::PresentationInfo::DataView, ::blink::mojom::PresentationInfoPtr>::Read(
    ::blink::mojom::PresentationInfo::DataView input,
    ::blink::mojom::PresentationInfoPtr* output) {
  bool success = true;
  ::blink::mojom::PresentationInfoPtr result(::blink::mojom::PresentationInfo::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PresentationError::DataView, ::blink::mojom::PresentationErrorPtr>::Read(
    ::blink::mojom::PresentationError::DataView input,
    ::blink::mojom::PresentationErrorPtr* output) {
  bool success = true;
  ::blink::mojom::PresentationErrorPtr result(::blink::mojom::PresentationError::New());
  
      if (success && !input.ReadErrorType(&result->error_type))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PresentationConnectionResult::DataView, ::blink::mojom::PresentationConnectionResultPtr>::Read(
    ::blink::mojom::PresentationConnectionResult::DataView input,
    ::blink::mojom::PresentationConnectionResultPtr* output) {
  bool success = true;
  ::blink::mojom::PresentationConnectionResultPtr result(::blink::mojom::PresentationConnectionResult::New());
  
      if (success && !input.ReadPresentationInfo(&result->presentation_info))
        success = false;
      if (success) {
        result->connection_remote =
            input.TakeConnectionRemote<decltype(result->connection_remote)>();
      }
      if (success) {
        result->connection_receiver =
            input.TakeConnectionReceiver<decltype(result->connection_receiver)>();
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::PresentationConnectionMessage::DataView, ::blink::mojom::PresentationConnectionMessagePtr>::Read(
    ::blink::mojom::PresentationConnectionMessage::DataView input,
    ::blink::mojom::PresentationConnectionMessagePtr* output) {
  using UnionType = ::blink::mojom::PresentationConnectionMessage;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kMessage: {
      std::string result_message{};
      if (!input.ReadMessage(&result_message))
        return false;

      *output = UnionType::NewMessage(
          std::move(result_message));
      break;
    }
    case Tag::kData: {
      std::vector<uint8_t> result_data{};
      if (!input.ReadData(&result_data))
        return false;

      *output = UnionType::NewData(
          std::move(result_data));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void PresentationConnectionInterceptorForTesting::OnMessage(PresentationConnectionMessagePtr message) {
  GetForwardingInterface()->OnMessage(
    std::move(message)
    );
}
void PresentationConnectionInterceptorForTesting::DidChangeState(PresentationConnectionState state) {
  GetForwardingInterface()->DidChangeState(
    std::move(state)
    );
}
void PresentationConnectionInterceptorForTesting::DidClose(PresentationConnectionCloseReason reason) {
  GetForwardingInterface()->DidClose(
    std::move(reason)
    );
}
PresentationConnectionAsyncWaiter::PresentationConnectionAsyncWaiter(
    PresentationConnection* proxy) : proxy_(proxy) {}

PresentationConnectionAsyncWaiter::~PresentationConnectionAsyncWaiter() = default;





void PresentationServiceInterceptorForTesting::SetController(::mojo::PendingRemote<PresentationController> controller) {
  GetForwardingInterface()->SetController(
    std::move(controller)
    );
}
void PresentationServiceInterceptorForTesting::SetReceiver(::mojo::PendingRemote<PresentationReceiver> receiver) {
  GetForwardingInterface()->SetReceiver(
    std::move(receiver)
    );
}
void PresentationServiceInterceptorForTesting::SetDefaultPresentationUrls(const std::vector<::GURL>& presentation_urls) {
  GetForwardingInterface()->SetDefaultPresentationUrls(
    std::move(presentation_urls)
    );
}
void PresentationServiceInterceptorForTesting::ListenForScreenAvailability(const ::GURL& availability_url) {
  GetForwardingInterface()->ListenForScreenAvailability(
    std::move(availability_url)
    );
}
void PresentationServiceInterceptorForTesting::StopListeningForScreenAvailability(const ::GURL& availability_url) {
  GetForwardingInterface()->StopListeningForScreenAvailability(
    std::move(availability_url)
    );
}
void PresentationServiceInterceptorForTesting::StartPresentation(const std::vector<::GURL>& presentation_urls, StartPresentationCallback callback) {
  GetForwardingInterface()->StartPresentation(
    std::move(presentation_urls)
    , std::move(callback));
}
void PresentationServiceInterceptorForTesting::ReconnectPresentation(const std::vector<::GURL>& presentation_urls, const std::string& presentation_id, ReconnectPresentationCallback callback) {
  GetForwardingInterface()->ReconnectPresentation(
    std::move(presentation_urls)
    , 
    std::move(presentation_id)
    , std::move(callback));
}
void PresentationServiceInterceptorForTesting::CloseConnection(const ::GURL& presentation_url, const std::string& presentation_id) {
  GetForwardingInterface()->CloseConnection(
    std::move(presentation_url)
    , 
    std::move(presentation_id)
    );
}
void PresentationServiceInterceptorForTesting::Terminate(const ::GURL& presentation_url, const std::string& presentation_id) {
  GetForwardingInterface()->Terminate(
    std::move(presentation_url)
    , 
    std::move(presentation_id)
    );
}
PresentationServiceAsyncWaiter::PresentationServiceAsyncWaiter(
    PresentationService* proxy) : proxy_(proxy) {}

PresentationServiceAsyncWaiter::~PresentationServiceAsyncWaiter() = default;


void PresentationServiceAsyncWaiter::StartPresentation(
    const std::vector<::GURL>& presentation_urls, PresentationConnectionResultPtr* out_result, PresentationErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->StartPresentation(
      std::move(presentation_urls),
      base::BindOnce(
          [](base::RunLoop* loop,
             PresentationConnectionResultPtr* out_result
,
             PresentationErrorPtr* out_error
,
             PresentationConnectionResultPtr result,
             PresentationErrorPtr error) {*out_result = std::move(result);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_result,
          out_error));
  loop.Run();
}



void PresentationServiceAsyncWaiter::ReconnectPresentation(
    const std::vector<::GURL>& presentation_urls, const std::string& presentation_id, PresentationConnectionResultPtr* out_result, PresentationErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->ReconnectPresentation(
      std::move(presentation_urls),
      std::move(presentation_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             PresentationConnectionResultPtr* out_result
,
             PresentationErrorPtr* out_error
,
             PresentationConnectionResultPtr result,
             PresentationErrorPtr error) {*out_result = std::move(result);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_result,
          out_error));
  loop.Run();
}






void PresentationControllerInterceptorForTesting::OnScreenAvailabilityUpdated(const ::GURL& url, ScreenAvailability availability) {
  GetForwardingInterface()->OnScreenAvailabilityUpdated(
    std::move(url)
    , 
    std::move(availability)
    );
}
void PresentationControllerInterceptorForTesting::OnDefaultPresentationStarted(PresentationConnectionResultPtr result) {
  GetForwardingInterface()->OnDefaultPresentationStarted(
    std::move(result)
    );
}
void PresentationControllerInterceptorForTesting::OnConnectionStateChanged(PresentationInfoPtr presentation_info, PresentationConnectionState newState) {
  GetForwardingInterface()->OnConnectionStateChanged(
    std::move(presentation_info)
    , 
    std::move(newState)
    );
}
void PresentationControllerInterceptorForTesting::OnConnectionClosed(PresentationInfoPtr presentation_info, PresentationConnectionCloseReason reason, const std::string& message) {
  GetForwardingInterface()->OnConnectionClosed(
    std::move(presentation_info)
    , 
    std::move(reason)
    , 
    std::move(message)
    );
}
PresentationControllerAsyncWaiter::PresentationControllerAsyncWaiter(
    PresentationController* proxy) : proxy_(proxy) {}

PresentationControllerAsyncWaiter::~PresentationControllerAsyncWaiter() = default;





void PresentationReceiverInterceptorForTesting::OnReceiverConnectionAvailable(PresentationConnectionResultPtr result) {
  GetForwardingInterface()->OnReceiverConnectionAvailable(
    std::move(result)
    );
}
PresentationReceiverAsyncWaiter::PresentationReceiverAsyncWaiter(
    PresentationReceiver* proxy) : proxy_(proxy) {}

PresentationReceiverAsyncWaiter::~PresentationReceiverAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif