// third_party/blink/public/mojom/presentation/presentation.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('url.mojom.Url');




goog.provide('blink.mojom.ScreenAvailability');
goog.provide('blink.mojom.ScreenAvailabilitySpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ScreenAvailabilitySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ScreenAvailability = {
  
  UNKNOWN: 0,
  UNAVAILABLE: 1,
  SOURCE_NOT_SUPPORTED: 2,
  DISABLED: 3,
  AVAILABLE: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

goog.provide('blink.mojom.PresentationConnectionState');
goog.provide('blink.mojom.PresentationConnectionStateSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PresentationConnectionStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PresentationConnectionState = {
  
  CONNECTING: 0,
  CONNECTED: 1,
  CLOSED: 2,
  TERMINATED: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('blink.mojom.PresentationConnectionCloseReason');
goog.provide('blink.mojom.PresentationConnectionCloseReasonSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PresentationConnectionCloseReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PresentationConnectionCloseReason = {
  
  CONNECTION_ERROR: 0,
  CLOSED: 1,
  WENT_AWAY: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.PresentationErrorType');
goog.provide('blink.mojom.PresentationErrorTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PresentationErrorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PresentationErrorType = {
  
  NO_AVAILABLE_SCREENS: 0,
  PRESENTATION_REQUEST_CANCELLED: 1,
  NO_PRESENTATION_FOUND: 2,
  PREVIOUS_START_IN_PROGRESS: 3,
  UNKNOWN: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



goog.provide('blink.mojom.PresentationConnection');
goog.provide('blink.mojom.PresentationConnectionReceiver');
goog.provide('blink.mojom.PresentationConnectionCallbackRouter');
goog.provide('blink.mojom.PresentationConnectionInterface');
goog.provide('blink.mojom.PresentationConnectionRemote');
goog.provide('blink.mojom.PresentationConnectionPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PresentationConnectionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PresentationConnection.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.PresentationConnectionInterface = class {
  
  /**
   * @param { !blink.mojom.PresentationConnectionMessage } message
   */

  onMessage(message) {}
  
  /**
   * @param { !blink.mojom.PresentationConnectionState } state
   */

  didChangeState(state) {}
  
  /**
   * @param { !blink.mojom.PresentationConnectionCloseReason } reason
   */

  didClose(reason) {}
};

/**
 * @export
 * @implements { blink.mojom.PresentationConnectionInterface }
 */
blink.mojom.PresentationConnectionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PresentationConnectionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PresentationConnectionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PresentationConnectionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.PresentationConnectionMessage } message
   */

  onMessage(
      message) {
    this.proxy.sendMessage(
        0,
        blink.mojom.PresentationConnection_OnMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PresentationConnectionState } state
   */

  didChangeState(
      state) {
    this.proxy.sendMessage(
        1,
        blink.mojom.PresentationConnection_DidChangeState_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PresentationConnectionCloseReason } reason
   */

  didClose(
      reason) {
    this.proxy.sendMessage(
        2,
        blink.mojom.PresentationConnection_DidClose_ParamsSpec.$,
        null,
        [
          reason
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PresentationConnection
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PresentationConnectionReceiver = class {
  /**
   * @param {!blink.mojom.PresentationConnectionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PresentationConnectionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PresentationConnectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PresentationConnectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PresentationConnection_OnMessage_ParamsSpec.$,
        null,
        impl.onMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PresentationConnection_DidChangeState_ParamsSpec.$,
        null,
        impl.didChangeState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PresentationConnection_DidClose_ParamsSpec.$,
        null,
        impl.didClose.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PresentationConnection = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PresentationConnection";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PresentationConnectionRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PresentationConnectionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PresentationConnection
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PresentationConnectionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PresentationConnectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PresentationConnectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PresentationConnection_OnMessage_ParamsSpec.$,
        null,
        this.onMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PresentationConnection_DidChangeState_ParamsSpec.$,
        null,
        this.didChangeState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didClose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PresentationConnection_DidClose_ParamsSpec.$,
        null,
        this.didClose.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.PresentationService');
goog.provide('blink.mojom.PresentationServiceReceiver');
goog.provide('blink.mojom.PresentationServiceCallbackRouter');
goog.provide('blink.mojom.PresentationServiceInterface');
goog.provide('blink.mojom.PresentationServiceRemote');
goog.provide('blink.mojom.PresentationServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PresentationServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PresentationService.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.PresentationServiceInterface = class {
  
  /**
   * @param { !blink.mojom.PresentationControllerRemote } controller
   */

  setController(controller) {}
  
  /**
   * @param { !blink.mojom.PresentationReceiverRemote } receiver
   */

  setReceiver(receiver) {}
  
  /**
   * @param { !Array<!url.mojom.Url> } presentationUrls
   */

  setDefaultPresentationUrls(presentationUrls) {}
  
  /**
   * @param { !url.mojom.Url } availabilityUrl
   */

  listenForScreenAvailability(availabilityUrl) {}
  
  /**
   * @param { !url.mojom.Url } availabilityUrl
   */

  stopListeningForScreenAvailability(availabilityUrl) {}
  
  /**
   * @param { !Array<!url.mojom.Url> } presentationUrls
   * @return {!Promise<{
        result: ?blink.mojom.PresentationConnectionResult,
        error: ?blink.mojom.PresentationError,
   *  }>}
   */

  startPresentation(presentationUrls) {}
  
  /**
   * @param { !Array<!url.mojom.Url> } presentationUrls
   * @param { !string } presentationId
   * @return {!Promise<{
        result: ?blink.mojom.PresentationConnectionResult,
        error: ?blink.mojom.PresentationError,
   *  }>}
   */

  reconnectPresentation(presentationUrls, presentationId) {}
  
  /**
   * @param { !url.mojom.Url } presentationUrl
   * @param { !string } presentationId
   */

  closeConnection(presentationUrl, presentationId) {}
  
  /**
   * @param { !url.mojom.Url } presentationUrl
   * @param { !string } presentationId
   */

  terminate(presentationUrl, presentationId) {}
};

/**
 * @export
 * @implements { blink.mojom.PresentationServiceInterface }
 */
blink.mojom.PresentationServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PresentationServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PresentationServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PresentationServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.PresentationControllerRemote } controller
   */

  setController(
      controller) {
    this.proxy.sendMessage(
        0,
        blink.mojom.PresentationService_SetController_ParamsSpec.$,
        null,
        [
          controller
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PresentationReceiverRemote } receiver
   */

  setReceiver(
      receiver) {
    this.proxy.sendMessage(
        1,
        blink.mojom.PresentationService_SetReceiver_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !Array<!url.mojom.Url> } presentationUrls
   */

  setDefaultPresentationUrls(
      presentationUrls) {
    this.proxy.sendMessage(
        2,
        blink.mojom.PresentationService_SetDefaultPresentationUrls_ParamsSpec.$,
        null,
        [
          presentationUrls
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } availabilityUrl
   */

  listenForScreenAvailability(
      availabilityUrl) {
    this.proxy.sendMessage(
        3,
        blink.mojom.PresentationService_ListenForScreenAvailability_ParamsSpec.$,
        null,
        [
          availabilityUrl
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } availabilityUrl
   */

  stopListeningForScreenAvailability(
      availabilityUrl) {
    this.proxy.sendMessage(
        4,
        blink.mojom.PresentationService_StopListeningForScreenAvailability_ParamsSpec.$,
        null,
        [
          availabilityUrl
        ],
        false);
  }

  
  /**
   * @param { !Array<!url.mojom.Url> } presentationUrls
   * @return {!Promise<{
        result: ?blink.mojom.PresentationConnectionResult,
        error: ?blink.mojom.PresentationError,
   *  }>}
   */

  startPresentation(
      presentationUrls) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.PresentationService_StartPresentation_ParamsSpec.$,
        blink.mojom.PresentationService_StartPresentation_ResponseParamsSpec.$,
        [
          presentationUrls
        ],
        false);
  }

  
  /**
   * @param { !Array<!url.mojom.Url> } presentationUrls
   * @param { !string } presentationId
   * @return {!Promise<{
        result: ?blink.mojom.PresentationConnectionResult,
        error: ?blink.mojom.PresentationError,
   *  }>}
   */

  reconnectPresentation(
      presentationUrls,
      presentationId) {
    return this.proxy.sendMessage(
        6,
        blink.mojom.PresentationService_ReconnectPresentation_ParamsSpec.$,
        blink.mojom.PresentationService_ReconnectPresentation_ResponseParamsSpec.$,
        [
          presentationUrls,
          presentationId
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } presentationUrl
   * @param { !string } presentationId
   */

  closeConnection(
      presentationUrl,
      presentationId) {
    this.proxy.sendMessage(
        7,
        blink.mojom.PresentationService_CloseConnection_ParamsSpec.$,
        null,
        [
          presentationUrl,
          presentationId
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } presentationUrl
   * @param { !string } presentationId
   */

  terminate(
      presentationUrl,
      presentationId) {
    this.proxy.sendMessage(
        8,
        blink.mojom.PresentationService_Terminate_ParamsSpec.$,
        null,
        [
          presentationUrl,
          presentationId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PresentationService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PresentationServiceReceiver = class {
  /**
   * @param {!blink.mojom.PresentationServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PresentationServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PresentationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PresentationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PresentationService_SetController_ParamsSpec.$,
        null,
        impl.setController.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PresentationService_SetReceiver_ParamsSpec.$,
        null,
        impl.setReceiver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PresentationService_SetDefaultPresentationUrls_ParamsSpec.$,
        null,
        impl.setDefaultPresentationUrls.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.PresentationService_ListenForScreenAvailability_ParamsSpec.$,
        null,
        impl.listenForScreenAvailability.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.PresentationService_StopListeningForScreenAvailability_ParamsSpec.$,
        null,
        impl.stopListeningForScreenAvailability.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.PresentationService_StartPresentation_ParamsSpec.$,
        blink.mojom.PresentationService_StartPresentation_ResponseParamsSpec.$,
        impl.startPresentation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.PresentationService_ReconnectPresentation_ParamsSpec.$,
        blink.mojom.PresentationService_ReconnectPresentation_ResponseParamsSpec.$,
        impl.reconnectPresentation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.PresentationService_CloseConnection_ParamsSpec.$,
        null,
        impl.closeConnection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.PresentationService_Terminate_ParamsSpec.$,
        null,
        impl.terminate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PresentationService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PresentationService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PresentationServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PresentationServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PresentationService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PresentationServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PresentationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PresentationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setController =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PresentationService_SetController_ParamsSpec.$,
        null,
        this.setController.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReceiver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PresentationService_SetReceiver_ParamsSpec.$,
        null,
        this.setReceiver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setDefaultPresentationUrls =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PresentationService_SetDefaultPresentationUrls_ParamsSpec.$,
        null,
        this.setDefaultPresentationUrls.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.listenForScreenAvailability =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.PresentationService_ListenForScreenAvailability_ParamsSpec.$,
        null,
        this.listenForScreenAvailability.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopListeningForScreenAvailability =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.PresentationService_StopListeningForScreenAvailability_ParamsSpec.$,
        null,
        this.stopListeningForScreenAvailability.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startPresentation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.PresentationService_StartPresentation_ParamsSpec.$,
        blink.mojom.PresentationService_StartPresentation_ResponseParamsSpec.$,
        this.startPresentation.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reconnectPresentation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.PresentationService_ReconnectPresentation_ParamsSpec.$,
        blink.mojom.PresentationService_ReconnectPresentation_ResponseParamsSpec.$,
        this.reconnectPresentation.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeConnection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.PresentationService_CloseConnection_ParamsSpec.$,
        null,
        this.closeConnection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.terminate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.PresentationService_Terminate_ParamsSpec.$,
        null,
        this.terminate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.PresentationController');
goog.provide('blink.mojom.PresentationControllerReceiver');
goog.provide('blink.mojom.PresentationControllerCallbackRouter');
goog.provide('blink.mojom.PresentationControllerInterface');
goog.provide('blink.mojom.PresentationControllerRemote');
goog.provide('blink.mojom.PresentationControllerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PresentationControllerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PresentationController.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.PresentationControllerInterface = class {
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !blink.mojom.ScreenAvailability } availability
   */

  onScreenAvailabilityUpdated(url, availability) {}
  
  /**
   * @param { !blink.mojom.PresentationConnectionResult } result
   */

  onDefaultPresentationStarted(result) {}
  
  /**
   * @param { !blink.mojom.PresentationInfo } presentationInfo
   * @param { !blink.mojom.PresentationConnectionState } newState
   */

  onConnectionStateChanged(presentationInfo, newState) {}
  
  /**
   * @param { !blink.mojom.PresentationInfo } presentationInfo
   * @param { !blink.mojom.PresentationConnectionCloseReason } reason
   * @param { !string } message
   */

  onConnectionClosed(presentationInfo, reason, message) {}
};

/**
 * @export
 * @implements { blink.mojom.PresentationControllerInterface }
 */
blink.mojom.PresentationControllerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PresentationControllerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PresentationControllerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PresentationControllerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !blink.mojom.ScreenAvailability } availability
   */

  onScreenAvailabilityUpdated(
      url,
      availability) {
    this.proxy.sendMessage(
        0,
        blink.mojom.PresentationController_OnScreenAvailabilityUpdated_ParamsSpec.$,
        null,
        [
          url,
          availability
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PresentationConnectionResult } result
   */

  onDefaultPresentationStarted(
      result) {
    this.proxy.sendMessage(
        1,
        blink.mojom.PresentationController_OnDefaultPresentationStarted_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PresentationInfo } presentationInfo
   * @param { !blink.mojom.PresentationConnectionState } newState
   */

  onConnectionStateChanged(
      presentationInfo,
      newState) {
    this.proxy.sendMessage(
        2,
        blink.mojom.PresentationController_OnConnectionStateChanged_ParamsSpec.$,
        null,
        [
          presentationInfo,
          newState
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PresentationInfo } presentationInfo
   * @param { !blink.mojom.PresentationConnectionCloseReason } reason
   * @param { !string } message
   */

  onConnectionClosed(
      presentationInfo,
      reason,
      message) {
    this.proxy.sendMessage(
        3,
        blink.mojom.PresentationController_OnConnectionClosed_ParamsSpec.$,
        null,
        [
          presentationInfo,
          reason,
          message
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PresentationController
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PresentationControllerReceiver = class {
  /**
   * @param {!blink.mojom.PresentationControllerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PresentationControllerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PresentationControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PresentationControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PresentationController_OnScreenAvailabilityUpdated_ParamsSpec.$,
        null,
        impl.onScreenAvailabilityUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PresentationController_OnDefaultPresentationStarted_ParamsSpec.$,
        null,
        impl.onDefaultPresentationStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PresentationController_OnConnectionStateChanged_ParamsSpec.$,
        null,
        impl.onConnectionStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.PresentationController_OnConnectionClosed_ParamsSpec.$,
        null,
        impl.onConnectionClosed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PresentationController = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PresentationController";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PresentationControllerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PresentationControllerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PresentationController
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PresentationControllerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PresentationControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PresentationControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScreenAvailabilityUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PresentationController_OnScreenAvailabilityUpdated_ParamsSpec.$,
        null,
        this.onScreenAvailabilityUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDefaultPresentationStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PresentationController_OnDefaultPresentationStarted_ParamsSpec.$,
        null,
        this.onDefaultPresentationStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnectionStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PresentationController_OnConnectionStateChanged_ParamsSpec.$,
        null,
        this.onConnectionStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnectionClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.PresentationController_OnConnectionClosed_ParamsSpec.$,
        null,
        this.onConnectionClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.PresentationReceiver');
goog.provide('blink.mojom.PresentationReceiverReceiver');
goog.provide('blink.mojom.PresentationReceiverCallbackRouter');
goog.provide('blink.mojom.PresentationReceiverInterface');
goog.provide('blink.mojom.PresentationReceiverRemote');
goog.provide('blink.mojom.PresentationReceiverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PresentationReceiverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PresentationReceiver.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.PresentationReceiverInterface = class {
  
  /**
   * @param { !blink.mojom.PresentationConnectionResult } result
   */

  onReceiverConnectionAvailable(result) {}
};

/**
 * @export
 * @implements { blink.mojom.PresentationReceiverInterface }
 */
blink.mojom.PresentationReceiverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PresentationReceiverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PresentationReceiverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PresentationReceiverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.PresentationConnectionResult } result
   */

  onReceiverConnectionAvailable(
      result) {
    this.proxy.sendMessage(
        0,
        blink.mojom.PresentationReceiver_OnReceiverConnectionAvailable_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PresentationReceiver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PresentationReceiverReceiver = class {
  /**
   * @param {!blink.mojom.PresentationReceiverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PresentationReceiverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PresentationReceiverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PresentationReceiverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PresentationReceiver_OnReceiverConnectionAvailable_ParamsSpec.$,
        null,
        impl.onReceiverConnectionAvailable.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PresentationReceiver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PresentationReceiver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PresentationReceiverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PresentationReceiverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PresentationReceiver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PresentationReceiverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PresentationReceiverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PresentationReceiverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceiverConnectionAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PresentationReceiver_OnReceiverConnectionAvailable_ParamsSpec.$,
        null,
        this.onReceiverConnectionAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.PresentationInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationErrorSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationConnectionResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationConnectionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationConnection_OnMessage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationConnection_OnMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationConnection_DidChangeState_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationConnection_DidChangeState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationConnection_DidClose_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationConnection_DidClose_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationService_SetController_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationService_SetController_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationService_SetReceiver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationService_SetReceiver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationService_SetDefaultPresentationUrls_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationService_SetDefaultPresentationUrls_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationService_ListenForScreenAvailability_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationService_ListenForScreenAvailability_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationService_StopListeningForScreenAvailability_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationService_StopListeningForScreenAvailability_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationService_StartPresentation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationService_StartPresentation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationService_StartPresentation_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationService_StartPresentation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationService_ReconnectPresentation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationService_ReconnectPresentation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationService_ReconnectPresentation_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationService_ReconnectPresentation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationService_CloseConnection_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationService_CloseConnection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationService_Terminate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationService_Terminate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationController_OnScreenAvailabilityUpdated_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationController_OnScreenAvailabilityUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationController_OnDefaultPresentationStarted_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationController_OnDefaultPresentationStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationController_OnConnectionStateChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationController_OnConnectionStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationController_OnConnectionClosed_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationController_OnConnectionClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationReceiver_OnReceiverConnectionAvailable_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PresentationReceiver_OnReceiverConnectionAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PresentationConnectionMessageSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PresentationConnectionMessageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.PresentationInfoSpec.$,
    'PresentationInfo',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PresentationInfo');

/** @record */
blink.mojom.PresentationInfo = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationErrorSpec.$,
    'PresentationError',
    [
      mojo.internal.StructField(
        'errorType', 0,
        0,
        blink.mojom.PresentationErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PresentationError');

/** @record */
blink.mojom.PresentationError = class {
  constructor() {
    /** @export { !blink.mojom.PresentationErrorType } */
    this.errorType;
    /** @export { !string } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationConnectionResultSpec.$,
    'PresentationConnectionResult',
    [
      mojo.internal.StructField(
        'presentationInfo', 0,
        0,
        blink.mojom.PresentationInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'connectionRemote', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.PresentationConnectionRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'connectionReceiver', 16,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.PresentationConnectionPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.PresentationConnectionResult');

/** @record */
blink.mojom.PresentationConnectionResult = class {
  constructor() {
    /** @export { !blink.mojom.PresentationInfo } */
    this.presentationInfo;
    /** @export { !blink.mojom.PresentationConnectionRemote } */
    this.connectionRemote;
    /** @export { !blink.mojom.PresentationConnectionPendingReceiver } */
    this.connectionReceiver;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationConnection_OnMessage_ParamsSpec.$,
    'PresentationConnection_OnMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        blink.mojom.PresentationConnectionMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PresentationConnection_OnMessage_Params');

/** @record */
blink.mojom.PresentationConnection_OnMessage_Params = class {
  constructor() {
    /** @export { !blink.mojom.PresentationConnectionMessage } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationConnection_DidChangeState_ParamsSpec.$,
    'PresentationConnection_DidChangeState_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        blink.mojom.PresentationConnectionStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PresentationConnection_DidChangeState_Params');

/** @record */
blink.mojom.PresentationConnection_DidChangeState_Params = class {
  constructor() {
    /** @export { !blink.mojom.PresentationConnectionState } */
    this.state;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationConnection_DidClose_ParamsSpec.$,
    'PresentationConnection_DidClose_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        blink.mojom.PresentationConnectionCloseReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PresentationConnection_DidClose_Params');

/** @record */
blink.mojom.PresentationConnection_DidClose_Params = class {
  constructor() {
    /** @export { !blink.mojom.PresentationConnectionCloseReason } */
    this.reason;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationService_SetController_ParamsSpec.$,
    'PresentationService_SetController_Params',
    [
      mojo.internal.StructField(
        'controller', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.PresentationControllerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PresentationService_SetController_Params');

/** @record */
blink.mojom.PresentationService_SetController_Params = class {
  constructor() {
    /** @export { !blink.mojom.PresentationControllerRemote } */
    this.controller;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationService_SetReceiver_ParamsSpec.$,
    'PresentationService_SetReceiver_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.PresentationReceiverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PresentationService_SetReceiver_Params');

/** @record */
blink.mojom.PresentationService_SetReceiver_Params = class {
  constructor() {
    /** @export { !blink.mojom.PresentationReceiverRemote } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationService_SetDefaultPresentationUrls_ParamsSpec.$,
    'PresentationService_SetDefaultPresentationUrls_Params',
    [
      mojo.internal.StructField(
        'presentationUrls', 0,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PresentationService_SetDefaultPresentationUrls_Params');

/** @record */
blink.mojom.PresentationService_SetDefaultPresentationUrls_Params = class {
  constructor() {
    /** @export { !Array<!url.mojom.Url> } */
    this.presentationUrls;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationService_ListenForScreenAvailability_ParamsSpec.$,
    'PresentationService_ListenForScreenAvailability_Params',
    [
      mojo.internal.StructField(
        'availabilityUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PresentationService_ListenForScreenAvailability_Params');

/** @record */
blink.mojom.PresentationService_ListenForScreenAvailability_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.availabilityUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationService_StopListeningForScreenAvailability_ParamsSpec.$,
    'PresentationService_StopListeningForScreenAvailability_Params',
    [
      mojo.internal.StructField(
        'availabilityUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PresentationService_StopListeningForScreenAvailability_Params');

/** @record */
blink.mojom.PresentationService_StopListeningForScreenAvailability_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.availabilityUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationService_StartPresentation_ParamsSpec.$,
    'PresentationService_StartPresentation_Params',
    [
      mojo.internal.StructField(
        'presentationUrls', 0,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PresentationService_StartPresentation_Params');

/** @record */
blink.mojom.PresentationService_StartPresentation_Params = class {
  constructor() {
    /** @export { !Array<!url.mojom.Url> } */
    this.presentationUrls;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationService_StartPresentation_ResponseParamsSpec.$,
    'PresentationService_StartPresentation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.PresentationConnectionResultSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        blink.mojom.PresentationErrorSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PresentationService_StartPresentation_ResponseParams');

/** @record */
blink.mojom.PresentationService_StartPresentation_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.PresentationConnectionResult|undefined) } */
    this.result;
    /** @export { (blink.mojom.PresentationError|undefined) } */
    this.error;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationService_ReconnectPresentation_ParamsSpec.$,
    'PresentationService_ReconnectPresentation_Params',
    [
      mojo.internal.StructField(
        'presentationUrls', 0,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'presentationId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PresentationService_ReconnectPresentation_Params');

/** @record */
blink.mojom.PresentationService_ReconnectPresentation_Params = class {
  constructor() {
    /** @export { !Array<!url.mojom.Url> } */
    this.presentationUrls;
    /** @export { !string } */
    this.presentationId;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationService_ReconnectPresentation_ResponseParamsSpec.$,
    'PresentationService_ReconnectPresentation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.PresentationConnectionResultSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        blink.mojom.PresentationErrorSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PresentationService_ReconnectPresentation_ResponseParams');

/** @record */
blink.mojom.PresentationService_ReconnectPresentation_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.PresentationConnectionResult|undefined) } */
    this.result;
    /** @export { (blink.mojom.PresentationError|undefined) } */
    this.error;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationService_CloseConnection_ParamsSpec.$,
    'PresentationService_CloseConnection_Params',
    [
      mojo.internal.StructField(
        'presentationUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'presentationId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PresentationService_CloseConnection_Params');

/** @record */
blink.mojom.PresentationService_CloseConnection_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.presentationUrl;
    /** @export { !string } */
    this.presentationId;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationService_Terminate_ParamsSpec.$,
    'PresentationService_Terminate_Params',
    [
      mojo.internal.StructField(
        'presentationUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'presentationId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PresentationService_Terminate_Params');

/** @record */
blink.mojom.PresentationService_Terminate_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.presentationUrl;
    /** @export { !string } */
    this.presentationId;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationController_OnScreenAvailabilityUpdated_ParamsSpec.$,
    'PresentationController_OnScreenAvailabilityUpdated_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'availability', 8,
        0,
        blink.mojom.ScreenAvailabilitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PresentationController_OnScreenAvailabilityUpdated_Params');

/** @record */
blink.mojom.PresentationController_OnScreenAvailabilityUpdated_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !blink.mojom.ScreenAvailability } */
    this.availability;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationController_OnDefaultPresentationStarted_ParamsSpec.$,
    'PresentationController_OnDefaultPresentationStarted_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.PresentationConnectionResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PresentationController_OnDefaultPresentationStarted_Params');

/** @record */
blink.mojom.PresentationController_OnDefaultPresentationStarted_Params = class {
  constructor() {
    /** @export { !blink.mojom.PresentationConnectionResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationController_OnConnectionStateChanged_ParamsSpec.$,
    'PresentationController_OnConnectionStateChanged_Params',
    [
      mojo.internal.StructField(
        'presentationInfo', 0,
        0,
        blink.mojom.PresentationInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newState', 8,
        0,
        blink.mojom.PresentationConnectionStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PresentationController_OnConnectionStateChanged_Params');

/** @record */
blink.mojom.PresentationController_OnConnectionStateChanged_Params = class {
  constructor() {
    /** @export { !blink.mojom.PresentationInfo } */
    this.presentationInfo;
    /** @export { !blink.mojom.PresentationConnectionState } */
    this.newState;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationController_OnConnectionClosed_ParamsSpec.$,
    'PresentationController_OnConnectionClosed_Params',
    [
      mojo.internal.StructField(
        'presentationInfo', 0,
        0,
        blink.mojom.PresentationInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        blink.mojom.PresentationConnectionCloseReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.PresentationController_OnConnectionClosed_Params');

/** @record */
blink.mojom.PresentationController_OnConnectionClosed_Params = class {
  constructor() {
    /** @export { !blink.mojom.PresentationInfo } */
    this.presentationInfo;
    /** @export { !blink.mojom.PresentationConnectionCloseReason } */
    this.reason;
    /** @export { !string } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.PresentationReceiver_OnReceiverConnectionAvailable_ParamsSpec.$,
    'PresentationReceiver_OnReceiverConnectionAvailable_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.PresentationConnectionResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PresentationReceiver_OnReceiverConnectionAvailable_Params');

/** @record */
blink.mojom.PresentationReceiver_OnReceiverConnectionAvailable_Params = class {
  constructor() {
    /** @export { !blink.mojom.PresentationConnectionResult } */
    this.result;
  }
};

goog.provide('blink.mojom.PresentationConnectionMessage');


mojo.internal.Union(
    blink.mojom.PresentationConnectionMessageSpec.$, 'PresentationConnectionMessage',
    {
      'message': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'data': {
        'ordinal': 1,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
      },
    });

/**
 * @typedef { {
 *   message: (!string|undefined),
 *   data: (!Array<!number>|undefined),
 * } }
 */
blink.mojom.PresentationConnectionMessage;
