// third_party/blink/public/mojom/prerender/prerender.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.Referrer');
goog.require('gfx.mojom.Size');
goog.require('url.mojom.Url');




goog.provide('blink.mojom.PrerenderTriggerType');
goog.provide('blink.mojom.PrerenderTriggerTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PrerenderTriggerTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PrerenderTriggerType = {
  
  kLinkRelPrerender: 0,
  kLinkRelNext: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('blink.mojom.NoStatePrefetchProcessor');
goog.provide('blink.mojom.NoStatePrefetchProcessorReceiver');
goog.provide('blink.mojom.NoStatePrefetchProcessorCallbackRouter');
goog.provide('blink.mojom.NoStatePrefetchProcessorInterface');
goog.provide('blink.mojom.NoStatePrefetchProcessorRemote');
goog.provide('blink.mojom.NoStatePrefetchProcessorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.NoStatePrefetchProcessorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.NoStatePrefetchProcessor.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.NoStatePrefetchProcessorInterface = class {
  
  /**
   * @param { !blink.mojom.PrerenderAttributes } prerenderAttribute
   */

  start(prerenderAttribute) {}
  
  /**
   */

  cancel() {}
};

/**
 * @export
 * @implements { blink.mojom.NoStatePrefetchProcessorInterface }
 */
blink.mojom.NoStatePrefetchProcessorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.NoStatePrefetchProcessorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.NoStatePrefetchProcessorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.NoStatePrefetchProcessorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.PrerenderAttributes } prerenderAttribute
   */

  start(
      prerenderAttribute) {
    this.proxy.sendMessage(
        0,
        blink.mojom.NoStatePrefetchProcessor_Start_ParamsSpec.$,
        null,
        [
          prerenderAttribute
        ],
        false);
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        1,
        blink.mojom.NoStatePrefetchProcessor_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NoStatePrefetchProcessor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.NoStatePrefetchProcessorReceiver = class {
  /**
   * @param {!blink.mojom.NoStatePrefetchProcessorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.NoStatePrefetchProcessorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.NoStatePrefetchProcessorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.NoStatePrefetchProcessorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.NoStatePrefetchProcessor_Start_ParamsSpec.$,
        null,
        impl.start.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.NoStatePrefetchProcessor_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.NoStatePrefetchProcessor = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.NoStatePrefetchProcessor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.NoStatePrefetchProcessorRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.NoStatePrefetchProcessorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NoStatePrefetchProcessor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.NoStatePrefetchProcessorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.NoStatePrefetchProcessorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.NoStatePrefetchProcessorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.start =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.NoStatePrefetchProcessor_Start_ParamsSpec.$,
        null,
        this.start.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.NoStatePrefetchProcessor_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.PrerenderAttributesSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PrerenderAttributesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.NoStatePrefetchProcessor_Start_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NoStatePrefetchProcessor_Start_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.NoStatePrefetchProcessor_Cancel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NoStatePrefetchProcessor_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.PrerenderAttributesSpec.$,
    'PrerenderAttributes',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'triggerType', 8,
        0,
        blink.mojom.PrerenderTriggerTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referrer', 16,
        0,
        blink.mojom.ReferrerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'viewSize', 24,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.PrerenderAttributes');

/** @record */
blink.mojom.PrerenderAttributes = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !blink.mojom.PrerenderTriggerType } */
    this.triggerType;
    /** @export { !blink.mojom.Referrer } */
    this.referrer;
    /** @export { !gfx.mojom.Size } */
    this.viewSize;
  }
};



mojo.internal.Struct(
    blink.mojom.NoStatePrefetchProcessor_Start_ParamsSpec.$,
    'NoStatePrefetchProcessor_Start_Params',
    [
      mojo.internal.StructField(
        'prerenderAttribute', 0,
        0,
        blink.mojom.PrerenderAttributesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.NoStatePrefetchProcessor_Start_Params');

/** @record */
blink.mojom.NoStatePrefetchProcessor_Start_Params = class {
  constructor() {
    /** @export { !blink.mojom.PrerenderAttributes } */
    this.prerenderAttribute;
  }
};



mojo.internal.Struct(
    blink.mojom.NoStatePrefetchProcessor_Cancel_ParamsSpec.$,
    'NoStatePrefetchProcessor_Cancel_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.NoStatePrefetchProcessor_Cancel_Params');

/** @record */
blink.mojom.NoStatePrefetchProcessor_Cancel_Params = class {
  constructor() {
  }
};

