// third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function AnchorElementPointerData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementPointerData.prototype.initDefaults_ = function() {
    this.isMousePointer = false;
    this.mouseVelocity = 0;
    this.mouseAcceleration = 0;
  };
  AnchorElementPointerData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementPointerData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  AnchorElementPointerData.encodedSize = codec.kStructHeaderSize + 24;

  AnchorElementPointerData.decode = function(decoder) {
    var packed;
    var val = new AnchorElementPointerData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isMousePointer = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.mouseVelocity =
        decoder.decodeStruct(codec.Double);
    val.mouseAcceleration =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  AnchorElementPointerData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementPointerData.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isMousePointer & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Double, val.mouseVelocity);
    encoder.encodeStruct(codec.Double, val.mouseAcceleration);
  };
  function AnchorElementInteractionHost_OnPointerDown_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementInteractionHost_OnPointerDown_Params.prototype.initDefaults_ = function() {
    this.target = null;
  };
  AnchorElementInteractionHost_OnPointerDown_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementInteractionHost_OnPointerDown_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementInteractionHost_OnPointerDown_Params.target
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementInteractionHost_OnPointerDown_Params.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementInteractionHost_OnPointerDown_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementInteractionHost_OnPointerDown_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.target =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  AnchorElementInteractionHost_OnPointerDown_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementInteractionHost_OnPointerDown_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.target);
  };
  function AnchorElementInteractionHost_OnPointerHoverEager_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementInteractionHost_OnPointerHoverEager_Params.prototype.initDefaults_ = function() {
    this.target = null;
    this.mouseData = null;
  };
  AnchorElementInteractionHost_OnPointerHoverEager_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementInteractionHost_OnPointerHoverEager_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementInteractionHost_OnPointerHoverEager_Params.target
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementInteractionHost_OnPointerHoverEager_Params.mouseData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AnchorElementPointerData, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementInteractionHost_OnPointerHoverEager_Params.encodedSize = codec.kStructHeaderSize + 16;

  AnchorElementInteractionHost_OnPointerHoverEager_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementInteractionHost_OnPointerHoverEager_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.target =
        decoder.decodeStructPointer(url$.Url);
    val.mouseData =
        decoder.decodeStructPointer(AnchorElementPointerData);
    return val;
  };

  AnchorElementInteractionHost_OnPointerHoverEager_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementInteractionHost_OnPointerHoverEager_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.target);
    encoder.encodeStructPointer(AnchorElementPointerData, val.mouseData);
  };
  function AnchorElementInteractionHost_OnPointerHoverModerate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementInteractionHost_OnPointerHoverModerate_Params.prototype.initDefaults_ = function() {
    this.target = null;
    this.mouseData = null;
  };
  AnchorElementInteractionHost_OnPointerHoverModerate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementInteractionHost_OnPointerHoverModerate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementInteractionHost_OnPointerHoverModerate_Params.target
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementInteractionHost_OnPointerHoverModerate_Params.mouseData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AnchorElementPointerData, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementInteractionHost_OnPointerHoverModerate_Params.encodedSize = codec.kStructHeaderSize + 16;

  AnchorElementInteractionHost_OnPointerHoverModerate_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementInteractionHost_OnPointerHoverModerate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.target =
        decoder.decodeStructPointer(url$.Url);
    val.mouseData =
        decoder.decodeStructPointer(AnchorElementPointerData);
    return val;
  };

  AnchorElementInteractionHost_OnPointerHoverModerate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementInteractionHost_OnPointerHoverModerate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.target);
    encoder.encodeStructPointer(AnchorElementPointerData, val.mouseData);
  };
  function AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params.prototype.initDefaults_ = function() {
    this.target = null;
  };
  AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params.target
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.target =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.target);
  };
  function AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params.prototype.initDefaults_ = function() {
    this.targets = null;
  };
  AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params.targets
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.targets =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    return val;
  };

  AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.targets);
  };
  var kAnchorElementInteractionHost_OnPointerDown_Name = 0;
  var kAnchorElementInteractionHost_OnPointerHoverEager_Name = 1;
  var kAnchorElementInteractionHost_OnPointerHoverModerate_Name = 2;
  var kAnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Name = 3;
  var kAnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Name = 4;

  function AnchorElementInteractionHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AnchorElementInteractionHost,
                                                   handleOrPtrInfo);
  }

  function AnchorElementInteractionHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AnchorElementInteractionHost, associatedInterfacePtrInfo);
  }

  AnchorElementInteractionHostAssociatedPtr.prototype =
      Object.create(AnchorElementInteractionHostPtr.prototype);
  AnchorElementInteractionHostAssociatedPtr.prototype.constructor =
      AnchorElementInteractionHostAssociatedPtr;

  function AnchorElementInteractionHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  AnchorElementInteractionHostPtr.prototype.onPointerDown = function() {
    return AnchorElementInteractionHostProxy.prototype.onPointerDown
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementInteractionHostProxy.prototype.onPointerDown = function(target) {
    var params_ = new AnchorElementInteractionHost_OnPointerDown_Params();
    params_.target = target;
    var builder = new codec.MessageV0Builder(
        kAnchorElementInteractionHost_OnPointerDown_Name,
        codec.align(AnchorElementInteractionHost_OnPointerDown_Params.encodedSize));
    builder.encodeStruct(AnchorElementInteractionHost_OnPointerDown_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementInteractionHostPtr.prototype.onPointerHoverEager = function() {
    return AnchorElementInteractionHostProxy.prototype.onPointerHoverEager
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementInteractionHostProxy.prototype.onPointerHoverEager = function(target, mouseData) {
    var params_ = new AnchorElementInteractionHost_OnPointerHoverEager_Params();
    params_.target = target;
    params_.mouseData = mouseData;
    var builder = new codec.MessageV0Builder(
        kAnchorElementInteractionHost_OnPointerHoverEager_Name,
        codec.align(AnchorElementInteractionHost_OnPointerHoverEager_Params.encodedSize));
    builder.encodeStruct(AnchorElementInteractionHost_OnPointerHoverEager_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementInteractionHostPtr.prototype.onPointerHoverModerate = function() {
    return AnchorElementInteractionHostProxy.prototype.onPointerHoverModerate
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementInteractionHostProxy.prototype.onPointerHoverModerate = function(target, mouseData) {
    var params_ = new AnchorElementInteractionHost_OnPointerHoverModerate_Params();
    params_.target = target;
    params_.mouseData = mouseData;
    var builder = new codec.MessageV0Builder(
        kAnchorElementInteractionHost_OnPointerHoverModerate_Name,
        codec.align(AnchorElementInteractionHost_OnPointerHoverModerate_Params.encodedSize));
    builder.encodeStruct(AnchorElementInteractionHost_OnPointerHoverModerate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementInteractionHostPtr.prototype.onModerateViewportHeuristicTriggered = function() {
    return AnchorElementInteractionHostProxy.prototype.onModerateViewportHeuristicTriggered
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementInteractionHostProxy.prototype.onModerateViewportHeuristicTriggered = function(target) {
    var params_ = new AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params();
    params_.target = target;
    var builder = new codec.MessageV0Builder(
        kAnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Name,
        codec.align(AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params.encodedSize));
    builder.encodeStruct(AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementInteractionHostPtr.prototype.onEagerViewportHeuristicTriggered = function() {
    return AnchorElementInteractionHostProxy.prototype.onEagerViewportHeuristicTriggered
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementInteractionHostProxy.prototype.onEagerViewportHeuristicTriggered = function(targets) {
    var params_ = new AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params();
    params_.targets = targets;
    var builder = new codec.MessageV0Builder(
        kAnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Name,
        codec.align(AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params.encodedSize));
    builder.encodeStruct(AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AnchorElementInteractionHostStub(delegate) {
    this.delegate_ = delegate;
  }
  AnchorElementInteractionHostStub.prototype.onPointerDown = function(target) {
    return this.delegate_ && this.delegate_.onPointerDown && this.delegate_.onPointerDown(target);
  }
  AnchorElementInteractionHostStub.prototype.onPointerHoverEager = function(target, mouseData) {
    return this.delegate_ && this.delegate_.onPointerHoverEager && this.delegate_.onPointerHoverEager(target, mouseData);
  }
  AnchorElementInteractionHostStub.prototype.onPointerHoverModerate = function(target, mouseData) {
    return this.delegate_ && this.delegate_.onPointerHoverModerate && this.delegate_.onPointerHoverModerate(target, mouseData);
  }
  AnchorElementInteractionHostStub.prototype.onModerateViewportHeuristicTriggered = function(target) {
    return this.delegate_ && this.delegate_.onModerateViewportHeuristicTriggered && this.delegate_.onModerateViewportHeuristicTriggered(target);
  }
  AnchorElementInteractionHostStub.prototype.onEagerViewportHeuristicTriggered = function(targets) {
    return this.delegate_ && this.delegate_.onEagerViewportHeuristicTriggered && this.delegate_.onEagerViewportHeuristicTriggered(targets);
  }

  AnchorElementInteractionHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAnchorElementInteractionHost_OnPointerDown_Name:
      var params = reader.decodeStruct(AnchorElementInteractionHost_OnPointerDown_Params);
      this.onPointerDown(params.target);
      return true;
    case kAnchorElementInteractionHost_OnPointerHoverEager_Name:
      var params = reader.decodeStruct(AnchorElementInteractionHost_OnPointerHoverEager_Params);
      this.onPointerHoverEager(params.target, params.mouseData);
      return true;
    case kAnchorElementInteractionHost_OnPointerHoverModerate_Name:
      var params = reader.decodeStruct(AnchorElementInteractionHost_OnPointerHoverModerate_Params);
      this.onPointerHoverModerate(params.target, params.mouseData);
      return true;
    case kAnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Name:
      var params = reader.decodeStruct(AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params);
      this.onModerateViewportHeuristicTriggered(params.target);
      return true;
    case kAnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Name:
      var params = reader.decodeStruct(AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params);
      this.onEagerViewportHeuristicTriggered(params.targets);
      return true;
    default:
      return false;
    }
  };

  AnchorElementInteractionHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAnchorElementInteractionHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAnchorElementInteractionHost_OnPointerDown_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementInteractionHost_OnPointerDown_Params;
      break;
      case kAnchorElementInteractionHost_OnPointerHoverEager_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementInteractionHost_OnPointerHoverEager_Params;
      break;
      case kAnchorElementInteractionHost_OnPointerHoverModerate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementInteractionHost_OnPointerHoverModerate_Params;
      break;
      case kAnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params;
      break;
      case kAnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAnchorElementInteractionHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AnchorElementInteractionHost = {
    name: 'blink.mojom.AnchorElementInteractionHost',
    kVersion: 0,
    ptrClass: AnchorElementInteractionHostPtr,
    proxyClass: AnchorElementInteractionHostProxy,
    stubClass: AnchorElementInteractionHostStub,
    validateRequest: validateAnchorElementInteractionHostRequest,
    validateResponse: null,
  };
  AnchorElementInteractionHostStub.prototype.validator = validateAnchorElementInteractionHostRequest;
  AnchorElementInteractionHostProxy.prototype.validator = null;
  exports.AnchorElementPointerData = AnchorElementPointerData;
  exports.AnchorElementInteractionHost = AnchorElementInteractionHost;
  exports.AnchorElementInteractionHostPtr = AnchorElementInteractionHostPtr;
  exports.AnchorElementInteractionHostAssociatedPtr = AnchorElementInteractionHostAssociatedPtr;
})();