// third_party/blink/public/mojom/permissions_policy/policy_value.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_POLICY_POLICY_VALUE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_POLICY_POLICY_VALUE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/permissions_policy/policy_value.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/permissions_policy/policy_value.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/permissions_policy/policy_value.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "third_party/blink/common/permissions_policy/policy_value_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {





class BLINK_COMMON_EXPORT PolicyValue {
 public:
  using DataView = PolicyValueDataView;
  using Data_ = internal::PolicyValue_Data;
  using Tag = Data_::PolicyValue_Tag;

  template <typename... Args>
  static PolicyValuePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |null_value|.
  static PolicyValuePtr NewNullValue(
      bool value);
  // Construct an instance holding |bool_value|.
  static PolicyValuePtr NewBoolValue(
      bool value);
  // Construct an instance holding |dec_double_value|.
  static PolicyValuePtr NewDecDoubleValue(
      double value);
  // Construct an instance holding |enum_value|.
  static PolicyValuePtr NewEnumValue(
      int32_t value);

  template <typename U>
  static PolicyValuePtr From(const U& u) {
    return mojo::TypeConverter<PolicyValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PolicyValue>::Convert(*this);
  }
  ~PolicyValue();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PolicyValuePtr>
  PolicyValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PolicyValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PolicyValue>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_null_value() const { return tag_ == Tag::kNullValue; }
  bool get_null_value() const {
    CHECK(tag_ == Tag::kNullValue);
    return data_.null_value;
  }
  void set_null_value(bool null_value);

  bool is_bool_value() const { return tag_ == Tag::kBoolValue; }
  bool get_bool_value() const {
    CHECK(tag_ == Tag::kBoolValue);
    return data_.bool_value;
  }
  void set_bool_value(bool bool_value);

  bool is_dec_double_value() const { return tag_ == Tag::kDecDoubleValue; }
  double get_dec_double_value() const {
    CHECK(tag_ == Tag::kDecDoubleValue);
    return data_.dec_double_value;
  }
  void set_dec_double_value(double dec_double_value);

  bool is_enum_value() const { return tag_ == Tag::kEnumValue; }
  int32_t get_enum_value() const {
    CHECK(tag_ == Tag::kEnumValue);
    return data_.enum_value;
  }
  void set_enum_value(int32_t enum_value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PolicyValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PolicyValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNullValue)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDecDoubleValue)>,
        double value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEnumValue)>,
        int32_t value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    bool null_value;
    bool bool_value;
    double dec_double_value;
    int32_t enum_value;
  };

  PolicyValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kNullValue)>,
      bool value);
  PolicyValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
      bool value);
  PolicyValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kDecDoubleValue)>,
      double value);
  PolicyValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kEnumValue)>,
      int32_t value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
PolicyValuePtr PolicyValue::Clone() const {
  switch (tag_) {
    case Tag::kNullValue:
      return NewNullValue(
          mojo::Clone(data_.null_value));
    case Tag::kBoolValue:
      return NewBoolValue(
          mojo::Clone(data_.bool_value));
    case Tag::kDecDoubleValue:
      return NewDecDoubleValue(
          mojo::Clone(data_.dec_double_value));
    case Tag::kEnumValue:
      return NewEnumValue(
          mojo::Clone(data_.enum_value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PolicyValue>::value>::type*>
bool PolicyValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNullValue:
      return mojo::Equals(data_.null_value, other.data_.null_value);
    case Tag::kBoolValue:
      return mojo::Equals(data_.bool_value, other.data_.bool_value);
    case Tag::kDecDoubleValue:
      return mojo::Equals(data_.dec_double_value, other.data_.dec_double_value);
    case Tag::kEnumValue:
      return mojo::Equals(data_.enum_value, other.data_.enum_value);
  }

  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::PolicyValue::DataView,
                                        ::blink::mojom::PolicyValuePtr> {
  static bool IsNull(const ::blink::mojom::PolicyValuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PolicyValuePtr* output) { output->reset(); }

  static ::blink::mojom::PolicyValue::Tag GetTag(const ::blink::mojom::PolicyValuePtr& input) {
    return input->which();
  }

  static  bool null_value(const ::blink::mojom::PolicyValuePtr& input) {
    return input->get_null_value();
  }

  static  bool bool_value(const ::blink::mojom::PolicyValuePtr& input) {
    return input->get_bool_value();
  }

  static  double dec_double_value(const ::blink::mojom::PolicyValuePtr& input) {
    return input->get_dec_double_value();
  }

  static  int32_t enum_value(const ::blink::mojom::PolicyValuePtr& input) {
    return input->get_enum_value();
  }

  static bool Read(::blink::mojom::PolicyValue::DataView input, ::blink::mojom::PolicyValuePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_POLICY_POLICY_VALUE_MOJOM_H_