// third_party/blink/public/mojom/permissions/permission.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/permissions/permission.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/permissions/permission.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::PermissionName>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PermissionName> {};

template <>
struct hash<::blink::mojom::EmbeddedPermissionControlResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::EmbeddedPermissionControlResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PermissionName, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PermissionName, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::PermissionName>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EmbeddedPermissionControlResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::EmbeddedPermissionControlResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::EmbeddedPermissionControlResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MidiPermissionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MidiPermissionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MidiPermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->sysex = Traits::sysex(input);
  }

  static bool Deserialize(::blink::mojom::internal::MidiPermissionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MidiPermissionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ClipboardPermissionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ClipboardPermissionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ClipboardPermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->has_user_gesture = Traits::has_user_gesture(input);

    fragment->will_be_sanitized = Traits::will_be_sanitized(input);
  }

  static bool Deserialize(::blink::mojom::internal::ClipboardPermissionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ClipboardPermissionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CameraDevicePermissionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CameraDevicePermissionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CameraDevicePermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->panTiltZoom = Traits::panTiltZoom(input);
  }

  static bool Deserialize(::blink::mojom::internal::CameraDevicePermissionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CameraDevicePermissionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TopLevelStorageAccessPermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::requestedOrigin(input)) in_requestedOrigin = Traits::requestedOrigin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->requestedOrigin)::BaseType> requestedOrigin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_requestedOrigin,
      requestedOrigin_fragment);

    fragment->requestedOrigin.Set(
        requestedOrigin_fragment.is_null() ? nullptr : requestedOrigin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->requestedOrigin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requestedOrigin in TopLevelStorageAccessPermissionDescriptor struct");
  }

  static bool Deserialize(::blink::mojom::internal::TopLevelStorageAccessPermissionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FullscreenPermissionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FullscreenPermissionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FullscreenPermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->allow_without_user_gesture = Traits::allow_without_user_gesture(input);
  }

  static bool Deserialize(::blink::mojom::internal::FullscreenPermissionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FullscreenPermissionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PermissionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PermissionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::PermissionName>(
      Traits::name(input),
      &fragment->name);

    decltype(Traits::extension(input)) in_extension = Traits::extension(input);
    mojo::internal::MessageFragment<decltype(fragment->extension)>
        extension_fragment(fragment.message());
    extension_fragment.Claim(&fragment->extension);
    
    mojo::internal::Serialize<::blink::mojom::PermissionDescriptorExtensionDataView>(
      in_extension,
      extension_fragment,
      true);
  }

  static bool Deserialize(::blink::mojom::internal::PermissionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PermissionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::GeolocationEmbeddedPermissionRequestDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->autolocate = Traits::autolocate(input);
  }

  static bool Deserialize(::blink::mojom::internal::GeolocationEmbeddedPermissionRequestDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EmbeddedPermissionRequestDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::EmbeddedPermissionRequestDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::EmbeddedPermissionRequestDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::element_position(input)) in_element_position = Traits::element_position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->element_position)::BaseType> element_position_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_element_position,
      element_position_fragment);

    fragment->element_position.Set(
        element_position_fragment.is_null() ? nullptr : element_position_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->element_position.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null element_position in EmbeddedPermissionRequestDescriptor struct");

    decltype(Traits::geolocation(input)) in_geolocation = Traits::geolocation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->geolocation)::BaseType> geolocation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorDataView>(
      in_geolocation,
      geolocation_fragment);

    fragment->geolocation.Set(
        geolocation_fragment.is_null() ? nullptr : geolocation_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::EmbeddedPermissionRequestDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::EmbeddedPermissionRequestDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PermissionDescriptorExtensionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PermissionDescriptorExtensionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PermissionDescriptorExtension_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kMidi: {
    decltype(Traits::midi(input))
    in_midi = Traits::midi(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_midi)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::MidiPermissionDescriptorDataView>(
  in_midi,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null midi in PermissionDescriptorExtension union");
    fragment->data.f_midi.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kClipboard: {
    decltype(Traits::clipboard(input))
    in_clipboard = Traits::clipboard(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_clipboard)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::ClipboardPermissionDescriptorDataView>(
  in_clipboard,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null clipboard in PermissionDescriptorExtension union");
    fragment->data.f_clipboard.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kCameraDevice: {
    decltype(Traits::camera_device(input))
    in_camera_device = Traits::camera_device(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_camera_device)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::CameraDevicePermissionDescriptorDataView>(
  in_camera_device,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null camera_device in PermissionDescriptorExtension union");
    fragment->data.f_camera_device.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kTopLevelStorageAccess: {
    decltype(Traits::top_level_storage_access(input))
    in_top_level_storage_access = Traits::top_level_storage_access(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_top_level_storage_access)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView>(
  in_top_level_storage_access,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null top_level_storage_access in PermissionDescriptorExtension union");
    fragment->data.f_top_level_storage_access.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kFullscreen: {
    decltype(Traits::fullscreen(input))
    in_fullscreen = Traits::fullscreen(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_fullscreen)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::FullscreenPermissionDescriptorDataView>(
  in_fullscreen,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null fullscreen in PermissionDescriptorExtension union");
    fragment->data.f_fullscreen.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::PermissionDescriptorExtension_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PermissionDescriptorExtensionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {







inline void TopLevelStorageAccessPermissionDescriptorDataView::GetRequestedOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->requestedOrigin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}




inline void PermissionDescriptorDataView::GetExtensionDataView(
    PermissionDescriptorExtensionDataView* output) {
  auto pointer = &data_->extension;
  *output = PermissionDescriptorExtensionDataView(pointer, message_);
}




inline void EmbeddedPermissionRequestDescriptorDataView::GetElementPositionDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->element_position.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void EmbeddedPermissionRequestDescriptorDataView::GetGeolocationDataView(
    GeolocationEmbeddedPermissionRequestDescriptorDataView* output) {
  auto pointer = data_->geolocation.Get();
  *output = GeolocationEmbeddedPermissionRequestDescriptorDataView(pointer, message_);
}


inline void PermissionDescriptorExtensionDataView::GetMidiDataView(
    MidiPermissionDescriptorDataView* output) const {
  CHECK(is_midi());
  *output = MidiPermissionDescriptorDataView(data_->data.f_midi.Get(), message_);
}
inline void PermissionDescriptorExtensionDataView::GetClipboardDataView(
    ClipboardPermissionDescriptorDataView* output) const {
  CHECK(is_clipboard());
  *output = ClipboardPermissionDescriptorDataView(data_->data.f_clipboard.Get(), message_);
}
inline void PermissionDescriptorExtensionDataView::GetCameraDeviceDataView(
    CameraDevicePermissionDescriptorDataView* output) const {
  CHECK(is_camera_device());
  *output = CameraDevicePermissionDescriptorDataView(data_->data.f_camera_device.Get(), message_);
}
inline void PermissionDescriptorExtensionDataView::GetTopLevelStorageAccessDataView(
    TopLevelStorageAccessPermissionDescriptorDataView* output) const {
  CHECK(is_top_level_storage_access());
  *output = TopLevelStorageAccessPermissionDescriptorDataView(data_->data.f_top_level_storage_access.Get(), message_);
}
inline void PermissionDescriptorExtensionDataView::GetFullscreenDataView(
    FullscreenPermissionDescriptorDataView* output) const {
  CHECK(is_fullscreen());
  *output = FullscreenPermissionDescriptorDataView(data_->data.f_fullscreen.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::PermissionName> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::PermissionName value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::EmbeddedPermissionControlResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::EmbeddedPermissionControlResult value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_SHARED_H_