// third_party/blink/public/mojom/permissions/permission.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/permissions/permission.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace blink::mojom {
class MidiPermissionDescriptorDataView;

class ClipboardPermissionDescriptorDataView;

class CameraDevicePermissionDescriptorDataView;

class TopLevelStorageAccessPermissionDescriptorDataView;

class FullscreenPermissionDescriptorDataView;

class PermissionDescriptorDataView;

class GeolocationEmbeddedPermissionRequestDescriptorDataView;

class EmbeddedPermissionRequestDescriptorDataView;

class PermissionDescriptorExtensionDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::MidiPermissionDescriptorDataView> {
  using Data = ::blink::mojom::internal::MidiPermissionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ClipboardPermissionDescriptorDataView> {
  using Data = ::blink::mojom::internal::ClipboardPermissionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CameraDevicePermissionDescriptorDataView> {
  using Data = ::blink::mojom::internal::CameraDevicePermissionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView> {
  using Data = ::blink::mojom::internal::TopLevelStorageAccessPermissionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FullscreenPermissionDescriptorDataView> {
  using Data = ::blink::mojom::internal::FullscreenPermissionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PermissionDescriptorDataView> {
  using Data = ::blink::mojom::internal::PermissionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorDataView> {
  using Data = ::blink::mojom::internal::GeolocationEmbeddedPermissionRequestDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::EmbeddedPermissionRequestDescriptorDataView> {
  using Data = ::blink::mojom::internal::EmbeddedPermissionRequestDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PermissionDescriptorExtensionDataView> {
  using Data = ::blink::mojom::internal::PermissionDescriptorExtension_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class PermissionName : int32_t {
  
  GEOLOCATION = 0,
  
  NOTIFICATIONS = 1,
  
  MIDI = 2,
  
  PROTECTED_MEDIA_IDENTIFIER = 3,
  
  DURABLE_STORAGE = 4,
  
  AUDIO_CAPTURE = 5,
  
  VIDEO_CAPTURE = 6,
  
  BACKGROUND_SYNC = 7,
  
  SENSORS = 8,
  
  CLIPBOARD_READ = 9,
  
  CLIPBOARD_WRITE = 10,
  
  PAYMENT_HANDLER = 11,
  
  BACKGROUND_FETCH = 12,
  
  IDLE_DETECTION = 13,
  
  PERIODIC_BACKGROUND_SYNC = 14,
  
  SCREEN_WAKE_LOCK = 15,
  
  SYSTEM_WAKE_LOCK = 16,
  
  NFC = 17,
  
  STORAGE_ACCESS = 18,
  
  WINDOW_MANAGEMENT = 19,
  
  LOCAL_FONTS = 20,
  
  DISPLAY_CAPTURE = 21,
  
  TOP_LEVEL_STORAGE_ACCESS = 22,
  
  CAPTURED_SURFACE_CONTROL = 23,
  
  SPEAKER_SELECTION = 24,
  
  KEYBOARD_LOCK = 25,
  
  POINTER_LOCK = 26,
  
  FULLSCREEN = 27,
  
  WEB_APP_INSTALLATION = 28,
  
  LOCAL_NETWORK_ACCESS = 29,
  
  VR = 30,
  
  AR = 31,
  
  HAND_TRACKING = 32,
  
  WEB_PRINTING = 33,
  
  SMART_CARD = 34,
  kMinValue = 0,
  kMaxValue = 34,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PermissionName value);
inline bool IsKnownEnumValue(PermissionName value) {
  return internal::PermissionName_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EmbeddedPermissionControlResult : int32_t {
  
  kDismissed = 0,
  
  kGranted = 1,
  
  kDenied = 2,
  
  kNotSupported = 3,
  
  kResolvedNoUserGesture = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, EmbeddedPermissionControlResult value);
inline bool IsKnownEnumValue(EmbeddedPermissionControlResult value) {
  return internal::EmbeddedPermissionControlResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PermissionObserverInterfaceBase {};

using PermissionObserverPtrDataView =
    mojo::InterfacePtrDataView<PermissionObserverInterfaceBase>;
using PermissionObserverRequestDataView =
    mojo::InterfaceRequestDataView<PermissionObserverInterfaceBase>;
using PermissionObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PermissionObserverInterfaceBase>;
using PermissionObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PermissionObserverInterfaceBase>;
class EmbeddedPermissionControlClientInterfaceBase {};

using EmbeddedPermissionControlClientPtrDataView =
    mojo::InterfacePtrDataView<EmbeddedPermissionControlClientInterfaceBase>;
using EmbeddedPermissionControlClientRequestDataView =
    mojo::InterfaceRequestDataView<EmbeddedPermissionControlClientInterfaceBase>;
using EmbeddedPermissionControlClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<EmbeddedPermissionControlClientInterfaceBase>;
using EmbeddedPermissionControlClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<EmbeddedPermissionControlClientInterfaceBase>;
class PermissionServiceInterfaceBase {};

using PermissionServicePtrDataView =
    mojo::InterfacePtrDataView<PermissionServiceInterfaceBase>;
using PermissionServiceRequestDataView =
    mojo::InterfaceRequestDataView<PermissionServiceInterfaceBase>;
using PermissionServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PermissionServiceInterfaceBase>;
using PermissionServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PermissionServiceInterfaceBase>;


class MidiPermissionDescriptorDataView {
 public:
  MidiPermissionDescriptorDataView() = default;

  MidiPermissionDescriptorDataView(
      internal::MidiPermissionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool sysex() const {
    return data_->sysex;
  }
 private:
  internal::MidiPermissionDescriptor_Data* data_ = nullptr;
};


class ClipboardPermissionDescriptorDataView {
 public:
  ClipboardPermissionDescriptorDataView() = default;

  ClipboardPermissionDescriptorDataView(
      internal::ClipboardPermissionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool has_user_gesture() const {
    return data_->has_user_gesture;
  }
  bool will_be_sanitized() const {
    return data_->will_be_sanitized;
  }
 private:
  internal::ClipboardPermissionDescriptor_Data* data_ = nullptr;
};


class CameraDevicePermissionDescriptorDataView {
 public:
  CameraDevicePermissionDescriptorDataView() = default;

  CameraDevicePermissionDescriptorDataView(
      internal::CameraDevicePermissionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool panTiltZoom() const {
    return data_->panTiltZoom;
  }
 private:
  internal::CameraDevicePermissionDescriptor_Data* data_ = nullptr;
};


class TopLevelStorageAccessPermissionDescriptorDataView {
 public:
  TopLevelStorageAccessPermissionDescriptorDataView() = default;

  TopLevelStorageAccessPermissionDescriptorDataView(
      internal::TopLevelStorageAccessPermissionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestedOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestedOrigin(UserType* output) {
    
    auto* pointer = data_->requestedOrigin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::TopLevelStorageAccessPermissionDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FullscreenPermissionDescriptorDataView {
 public:
  FullscreenPermissionDescriptorDataView() = default;

  FullscreenPermissionDescriptorDataView(
      internal::FullscreenPermissionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool allow_without_user_gesture() const {
    return data_->allow_without_user_gesture;
  }
 private:
  internal::FullscreenPermissionDescriptor_Data* data_ = nullptr;
};


class PermissionDescriptorDataView {
 public:
  PermissionDescriptorDataView() = default;

  PermissionDescriptorDataView(
      internal::PermissionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) const {
    auto data_value = data_->name;
    return mojo::internal::Deserialize<::blink::mojom::PermissionName>(
        data_value, output);
  }
  PermissionName name() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PermissionName>(data_->name));
  }
  inline void GetExtensionDataView(
      PermissionDescriptorExtensionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtension(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PermissionDescriptorExtensionDataView, UserType>(),
    "Attempting to read the optional `extension` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExtension` instead "
    "of `ReadExtension if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->extension.is_null() ? &data_->extension : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PermissionDescriptorExtensionDataView>(
        pointer, output, message_);
  }
 private:
  internal::PermissionDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeolocationEmbeddedPermissionRequestDescriptorDataView {
 public:
  GeolocationEmbeddedPermissionRequestDescriptorDataView() = default;

  GeolocationEmbeddedPermissionRequestDescriptorDataView(
      internal::GeolocationEmbeddedPermissionRequestDescriptor_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool autolocate() const {
    return data_->autolocate;
  }
 private:
  internal::GeolocationEmbeddedPermissionRequestDescriptor_Data* data_ = nullptr;
};


class EmbeddedPermissionRequestDescriptorDataView {
 public:
  EmbeddedPermissionRequestDescriptorDataView() = default;

  EmbeddedPermissionRequestDescriptorDataView(
      internal::EmbeddedPermissionRequestDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetElementPositionDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementPosition(UserType* output) {
    
    auto* pointer = data_->element_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetGeolocationDataView(
      GeolocationEmbeddedPermissionRequestDescriptorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeolocation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorDataView, UserType>(),
    "Attempting to read the optional `geolocation` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGeolocation` instead "
    "of `ReadGeolocation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->geolocation.Get();
    return mojo::internal::Deserialize<::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorDataView>(
        pointer, output, message_);
  }
 private:
  internal::EmbeddedPermissionRequestDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PermissionDescriptorExtensionDataView {
 public:
  using Tag = internal::PermissionDescriptorExtension_Data::PermissionDescriptorExtension_Tag;

  PermissionDescriptorExtensionDataView() = default;

  PermissionDescriptorExtensionDataView(
      internal::PermissionDescriptorExtension_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_midi() const { return data_->tag == Tag::kMidi; }
  inline void GetMidiDataView(
      MidiPermissionDescriptorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadMidi(UserType* output) const {
    
    CHECK(is_midi());
    return mojo::internal::Deserialize<::blink::mojom::MidiPermissionDescriptorDataView>(
        data_->data.f_midi.Get(), output, message_);
  }
  bool is_clipboard() const { return data_->tag == Tag::kClipboard; }
  inline void GetClipboardDataView(
      ClipboardPermissionDescriptorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadClipboard(UserType* output) const {
    
    CHECK(is_clipboard());
    return mojo::internal::Deserialize<::blink::mojom::ClipboardPermissionDescriptorDataView>(
        data_->data.f_clipboard.Get(), output, message_);
  }
  bool is_camera_device() const { return data_->tag == Tag::kCameraDevice; }
  inline void GetCameraDeviceDataView(
      CameraDevicePermissionDescriptorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCameraDevice(UserType* output) const {
    
    CHECK(is_camera_device());
    return mojo::internal::Deserialize<::blink::mojom::CameraDevicePermissionDescriptorDataView>(
        data_->data.f_camera_device.Get(), output, message_);
  }
  bool is_top_level_storage_access() const { return data_->tag == Tag::kTopLevelStorageAccess; }
  inline void GetTopLevelStorageAccessDataView(
      TopLevelStorageAccessPermissionDescriptorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTopLevelStorageAccess(UserType* output) const {
    
    CHECK(is_top_level_storage_access());
    return mojo::internal::Deserialize<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView>(
        data_->data.f_top_level_storage_access.Get(), output, message_);
  }
  bool is_fullscreen() const { return data_->tag == Tag::kFullscreen; }
  inline void GetFullscreenDataView(
      FullscreenPermissionDescriptorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFullscreen(UserType* output) const {
    
    CHECK(is_fullscreen());
    return mojo::internal::Deserialize<::blink::mojom::FullscreenPermissionDescriptorDataView>(
        data_->data.f_fullscreen.Get(), output, message_);
  }

 private:
  internal::PermissionDescriptorExtension_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_DATA_VIEW_H_