// third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.ByteCount');
goog.require('blink.mojom.ExecutionContextToken');






goog.provide('blink.mojom.V8DetailedMemoryReporter');
goog.provide('blink.mojom.V8DetailedMemoryReporterReceiver');
goog.provide('blink.mojom.V8DetailedMemoryReporterCallbackRouter');
goog.provide('blink.mojom.V8DetailedMemoryReporterInterface');
goog.provide('blink.mojom.V8DetailedMemoryReporterRemote');
goog.provide('blink.mojom.V8DetailedMemoryReporterPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.V8DetailedMemoryReporterPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.V8DetailedMemoryReporter.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.V8DetailedMemoryReporterInterface = class {
  
  /**
   * @param { !blink.mojom.V8DetailedMemoryReporter_Mode } mode
   * @return {!Promise<{
        memoryUsage: !blink.mojom.PerProcessV8MemoryUsage,
   *  }>}
   */

  getV8MemoryUsage(mode) {}
};

/**
 * @export
 * @implements { blink.mojom.V8DetailedMemoryReporterInterface }
 */
blink.mojom.V8DetailedMemoryReporterRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.V8DetailedMemoryReporterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.V8DetailedMemoryReporterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.V8DetailedMemoryReporterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.V8DetailedMemoryReporter_Mode } mode
   * @return {!Promise<{
        memoryUsage: !blink.mojom.PerProcessV8MemoryUsage,
   *  }>}
   */

  getV8MemoryUsage(
      mode) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsSpec.$,
        blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }
};

/**
 * An object which receives request messages for the V8DetailedMemoryReporter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.V8DetailedMemoryReporterReceiver = class {
  /**
   * @param {!blink.mojom.V8DetailedMemoryReporterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.V8DetailedMemoryReporterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.V8DetailedMemoryReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.V8DetailedMemoryReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsSpec.$,
        blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsSpec.$,
        impl.getV8MemoryUsage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.V8DetailedMemoryReporter = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.V8DetailedMemoryReporter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.V8DetailedMemoryReporterRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.V8DetailedMemoryReporterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};

goog.provide('blink.mojom.V8DetailedMemoryReporter_Mode');
goog.provide('blink.mojom.V8DetailedMemoryReporter.ModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.V8DetailedMemoryReporter.ModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.V8DetailedMemoryReporter_Mode = {
  
  DEFAULT: 0,
  EAGER: 1,
  LAZY: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * An object which receives request messages for the V8DetailedMemoryReporter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.V8DetailedMemoryReporterCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.V8DetailedMemoryReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.V8DetailedMemoryReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getV8MemoryUsage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsSpec.$,
        blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsSpec.$,
        this.getV8MemoryUsage.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.PerContextV8MemoryUsageSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PerContextV8MemoryUsageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PerContextCanvasMemoryUsageSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PerContextCanvasMemoryUsageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PerIsolateV8MemoryUsageSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PerIsolateV8MemoryUsageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PerProcessV8MemoryUsageSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PerProcessV8MemoryUsageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.PerContextV8MemoryUsageSpec.$,
    'PerContextV8MemoryUsage',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink.mojom.ExecutionContextTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'memoryUsed', 16,
        0,
        mojoBase.mojom.ByteCountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.PerContextV8MemoryUsage');

/** @record */
blink.mojom.PerContextV8MemoryUsage = class {
  constructor() {
    /** @export { !blink.mojom.ExecutionContextToken } */
    this.token;
    /** @export { !mojoBase.mojom.ByteCount } */
    this.memoryUsed;
    /** @export { (string|undefined) } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.PerContextCanvasMemoryUsageSpec.$,
    'PerContextCanvasMemoryUsage',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink.mojom.ExecutionContextTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'memoryUsed', 16,
        0,
        mojoBase.mojom.ByteCountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.PerContextCanvasMemoryUsage');

/** @record */
blink.mojom.PerContextCanvasMemoryUsage = class {
  constructor() {
    /** @export { !blink.mojom.ExecutionContextToken } */
    this.token;
    /** @export { !mojoBase.mojom.ByteCount } */
    this.memoryUsed;
  }
};



mojo.internal.Struct(
    blink.mojom.PerIsolateV8MemoryUsageSpec.$,
    'PerIsolateV8MemoryUsage',
    [
      mojo.internal.StructField(
        'numDetachedContexts', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'detachedMemoryUsed', 8,
        0,
        mojoBase.mojom.ByteCountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sharedMemoryUsed', 16,
        0,
        mojoBase.mojom.ByteCountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blinkMemoryUsed', 24,
        0,
        mojoBase.mojom.ByteCountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contexts', 32,
        0,
        mojo.internal.Array(blink.mojom.PerContextV8MemoryUsageSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'canvasContexts', 40,
        0,
        mojo.internal.Array(blink.mojom.PerContextCanvasMemoryUsageSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.PerIsolateV8MemoryUsage');

/** @record */
blink.mojom.PerIsolateV8MemoryUsage = class {
  constructor() {
    /** @export { !bigint } */
    this.numDetachedContexts;
    /** @export { !mojoBase.mojom.ByteCount } */
    this.detachedMemoryUsed;
    /** @export { !mojoBase.mojom.ByteCount } */
    this.sharedMemoryUsed;
    /** @export { !mojoBase.mojom.ByteCount } */
    this.blinkMemoryUsed;
    /** @export { !Array<!blink.mojom.PerContextV8MemoryUsage> } */
    this.contexts;
    /** @export { !Array<!blink.mojom.PerContextCanvasMemoryUsage> } */
    this.canvasContexts;
  }
};



mojo.internal.Struct(
    blink.mojom.PerProcessV8MemoryUsageSpec.$,
    'PerProcessV8MemoryUsage',
    [
      mojo.internal.StructField(
        'isolates', 0,
        0,
        mojo.internal.Array(blink.mojom.PerIsolateV8MemoryUsageSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PerProcessV8MemoryUsage');

/** @record */
blink.mojom.PerProcessV8MemoryUsage = class {
  constructor() {
    /** @export { !Array<!blink.mojom.PerIsolateV8MemoryUsage> } */
    this.isolates;
  }
};



mojo.internal.Struct(
    blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsSpec.$,
    'V8DetailedMemoryReporter_GetV8MemoryUsage_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink.mojom.V8DetailedMemoryReporter.ModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_Params');

/** @record */
blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_Params = class {
  constructor() {
    /** @export { !blink.mojom.V8DetailedMemoryReporter_Mode } */
    this.mode;
  }
};



mojo.internal.Struct(
    blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsSpec.$,
    'V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams',
    [
      mojo.internal.StructField(
        'memoryUsage', 0,
        0,
        blink.mojom.PerProcessV8MemoryUsageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams');

/** @record */
blink.mojom.V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PerProcessV8MemoryUsage } */
    this.memoryUsage;
  }
};

