// third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-params-data.h"
#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
PerContextV8MemoryUsage::PerContextV8MemoryUsage()
    : token(),
      memory_used(),
      url() {}

PerContextV8MemoryUsage::PerContextV8MemoryUsage(
    const ::blink::ExecutionContextToken& token_in,
    ::base::ByteCount memory_used_in,
    const ::blink::String& url_in)
    : token(std::move(token_in)),
      memory_used(std::move(memory_used_in)),
      url(std::move(url_in)) {}

PerContextV8MemoryUsage::~PerContextV8MemoryUsage() = default;

void PerContextV8MemoryUsage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::ExecutionContextToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "memory_used"), this->memory_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ByteCount>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PerContextV8MemoryUsage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PerContextCanvasMemoryUsage::PerContextCanvasMemoryUsage()
    : token(),
      memory_used() {}

PerContextCanvasMemoryUsage::PerContextCanvasMemoryUsage(
    const ::blink::ExecutionContextToken& token_in,
    ::base::ByteCount memory_used_in)
    : token(std::move(token_in)),
      memory_used(std::move(memory_used_in)) {}

PerContextCanvasMemoryUsage::~PerContextCanvasMemoryUsage() = default;

void PerContextCanvasMemoryUsage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::ExecutionContextToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "memory_used"), this->memory_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ByteCount>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PerContextCanvasMemoryUsage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PerIsolateV8MemoryUsage::PerIsolateV8MemoryUsage()
    : num_detached_contexts(),
      detached_memory_used(),
      shared_memory_used(),
      blink_memory_used(),
      contexts(),
      canvas_contexts() {}

PerIsolateV8MemoryUsage::PerIsolateV8MemoryUsage(
    uint64_t num_detached_contexts_in,
    ::base::ByteCount detached_memory_used_in,
    ::base::ByteCount shared_memory_used_in,
    ::base::ByteCount blink_memory_used_in,
    ::blink::Vector<PerContextV8MemoryUsagePtr> contexts_in,
    ::blink::Vector<PerContextCanvasMemoryUsagePtr> canvas_contexts_in)
    : num_detached_contexts(std::move(num_detached_contexts_in)),
      detached_memory_used(std::move(detached_memory_used_in)),
      shared_memory_used(std::move(shared_memory_used_in)),
      blink_memory_used(std::move(blink_memory_used_in)),
      contexts(std::move(contexts_in)),
      canvas_contexts(std::move(canvas_contexts_in)) {}

PerIsolateV8MemoryUsage::~PerIsolateV8MemoryUsage() = default;

void PerIsolateV8MemoryUsage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_detached_contexts"), this->num_detached_contexts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "detached_memory_used"), this->detached_memory_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ByteCount>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_memory_used"), this->shared_memory_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ByteCount>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blink_memory_used"), this->blink_memory_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ByteCount>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contexts"), this->contexts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<PerContextV8MemoryUsagePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "canvas_contexts"), this->canvas_contexts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<PerContextCanvasMemoryUsagePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PerIsolateV8MemoryUsage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PerProcessV8MemoryUsage::PerProcessV8MemoryUsage()
    : isolates() {}

PerProcessV8MemoryUsage::PerProcessV8MemoryUsage(
    ::blink::Vector<PerIsolateV8MemoryUsagePtr> isolates_in)
    : isolates(std::move(isolates_in)) {}

PerProcessV8MemoryUsage::~PerProcessV8MemoryUsage() = default;

void PerProcessV8MemoryUsage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isolates"), this->isolates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<PerIsolateV8MemoryUsagePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PerProcessV8MemoryUsage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

V8DetailedMemoryReporter::IPCStableHashFunction V8DetailedMemoryReporter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::V8DetailedMemoryReporter>(message.name())) {
    case messages::V8DetailedMemoryReporter::kGetV8MemoryUsage: {
      return &V8DetailedMemoryReporter::GetV8MemoryUsage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* V8DetailedMemoryReporter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::V8DetailedMemoryReporter>(message.name())) {
      case messages::V8DetailedMemoryReporter::kGetV8MemoryUsage:
            return "Receive blink::mojom::V8DetailedMemoryReporter::GetV8MemoryUsage";
    }
  } else {
    switch (static_cast<messages::V8DetailedMemoryReporter>(message.name())) {
      case messages::V8DetailedMemoryReporter::kGetV8MemoryUsage:
            return "Receive reply blink::mojom::V8DetailedMemoryReporter::GetV8MemoryUsage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t V8DetailedMemoryReporter::GetV8MemoryUsage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x03c65e3f;  // IPCStableHash for blink::mojom::V8DetailedMemoryReporter::GetV8MemoryUsage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback(
      V8DetailedMemoryReporter::GetV8MemoryUsageCallback callback
      ) : callback_(std::move(callback)) {
  }

  V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback(const V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback&) = delete;
  V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback& operator=(const V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  V8DetailedMemoryReporter::GetV8MemoryUsageCallback callback_;
};

V8DetailedMemoryReporterProxy::V8DetailedMemoryReporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void V8DetailedMemoryReporterProxy::GetV8MemoryUsage(
    V8DetailedMemoryReporter::Mode in_mode, GetV8MemoryUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::V8DetailedMemoryReporter::GetV8MemoryUsage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type V8DetailedMemoryReporter::Mode>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::V8DetailedMemoryReporter::kGetV8MemoryUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::V8DetailedMemoryReporter_Mode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(V8DetailedMemoryReporter::Name_);
  message.set_method_name("GetV8MemoryUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static V8DetailedMemoryReporter::GetV8MemoryUsageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder> proxy(
        new V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "V8DetailedMemoryReporter::GetV8MemoryUsageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PerProcessV8MemoryUsagePtr in_memory_usage);
};

bool V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for V8DetailedMemoryReporter.0
  bool success = true;
  PerProcessV8MemoryUsagePtr p_memory_usage{};
  V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMemoryUsage(&p_memory_usage))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        V8DetailedMemoryReporter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_memory_usage));
  }
  return true;
}

void V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder::Run(
    PerProcessV8MemoryUsagePtr in_memory_usage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::V8DetailedMemoryReporter::GetV8MemoryUsage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_usage"), in_memory_usage,
                        "<value of type PerProcessV8MemoryUsagePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::V8DetailedMemoryReporter::kGetV8MemoryUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->memory_usage)::BaseType> memory_usage_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PerProcessV8MemoryUsageDataView>(
    in_memory_usage,
    memory_usage_fragment);

  params->memory_usage.Set(
      memory_usage_fragment.is_null() ? nullptr : memory_usage_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->memory_usage.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null memory_usage in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(V8DetailedMemoryReporter::Name_);
  message.set_method_name("GetV8MemoryUsage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool V8DetailedMemoryReporterStubDispatch::Accept(
    V8DetailedMemoryReporter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::V8DetailedMemoryReporter>(message->header()->name)) {
    case messages::V8DetailedMemoryReporter::kGetV8MemoryUsage: {
      break;
    }
  }
  return false;
}

// static
bool V8DetailedMemoryReporterStubDispatch::AcceptWithResponder(
    V8DetailedMemoryReporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::V8DetailedMemoryReporter>(message->header()->name)) {
    case messages::V8DetailedMemoryReporter::kGetV8MemoryUsage: {
      internal::V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data* params =
          reinterpret_cast<
              internal::V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for V8DetailedMemoryReporter.0
      bool success = true;
      V8DetailedMemoryReporter::Mode p_mode{};
      V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            V8DetailedMemoryReporter::Name_, 0, false);
        return false;
      }
      auto callback =
          V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetV8MemoryUsage(        
        std::move(p_mode), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kV8DetailedMemoryReporterValidationInfo[] = {
    { &internal::V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data::Validate,
     &internal::V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data::Validate},
};

bool V8DetailedMemoryReporterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::V8DetailedMemoryReporter::Name_,
    kV8DetailedMemoryReporterValidationInfo);
}

bool V8DetailedMemoryReporterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::V8DetailedMemoryReporter::Name_,
    kV8DetailedMemoryReporterValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::PerContextV8MemoryUsage::DataView, ::blink::mojom::blink::PerContextV8MemoryUsagePtr>::Read(
    ::blink::mojom::blink::PerContextV8MemoryUsage::DataView input,
    ::blink::mojom::blink::PerContextV8MemoryUsagePtr* output) {
  bool success = true;
  ::blink::mojom::blink::PerContextV8MemoryUsagePtr result(::blink::mojom::blink::PerContextV8MemoryUsage::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success && !input.ReadMemoryUsed(&result->memory_used))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PerContextCanvasMemoryUsage::DataView, ::blink::mojom::blink::PerContextCanvasMemoryUsagePtr>::Read(
    ::blink::mojom::blink::PerContextCanvasMemoryUsage::DataView input,
    ::blink::mojom::blink::PerContextCanvasMemoryUsagePtr* output) {
  bool success = true;
  ::blink::mojom::blink::PerContextCanvasMemoryUsagePtr result(::blink::mojom::blink::PerContextCanvasMemoryUsage::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success && !input.ReadMemoryUsed(&result->memory_used))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PerIsolateV8MemoryUsage::DataView, ::blink::mojom::blink::PerIsolateV8MemoryUsagePtr>::Read(
    ::blink::mojom::blink::PerIsolateV8MemoryUsage::DataView input,
    ::blink::mojom::blink::PerIsolateV8MemoryUsagePtr* output) {
  bool success = true;
  ::blink::mojom::blink::PerIsolateV8MemoryUsagePtr result(::blink::mojom::blink::PerIsolateV8MemoryUsage::New());
  
      if (success)
        result->num_detached_contexts = input.num_detached_contexts();
      if (success && !input.ReadDetachedMemoryUsed(&result->detached_memory_used))
        success = false;
      if (success && !input.ReadSharedMemoryUsed(&result->shared_memory_used))
        success = false;
      if (success && !input.ReadBlinkMemoryUsed(&result->blink_memory_used))
        success = false;
      if (success && !input.ReadContexts(&result->contexts))
        success = false;
      if (success && !input.ReadCanvasContexts(&result->canvas_contexts))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PerProcessV8MemoryUsage::DataView, ::blink::mojom::blink::PerProcessV8MemoryUsagePtr>::Read(
    ::blink::mojom::blink::PerProcessV8MemoryUsage::DataView input,
    ::blink::mojom::blink::PerProcessV8MemoryUsagePtr* output) {
  bool success = true;
  ::blink::mojom::blink::PerProcessV8MemoryUsagePtr result(::blink::mojom::blink::PerProcessV8MemoryUsage::New());
  
      if (success && !input.ReadIsolates(&result->isolates))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void V8DetailedMemoryReporterInterceptorForTesting::GetV8MemoryUsage(V8DetailedMemoryReporter::Mode mode, GetV8MemoryUsageCallback callback) {
  GetForwardingInterface()->GetV8MemoryUsage(
    std::move(mode)
    , std::move(callback));
}
V8DetailedMemoryReporterAsyncWaiter::V8DetailedMemoryReporterAsyncWaiter(
    V8DetailedMemoryReporter* proxy) : proxy_(proxy) {}

V8DetailedMemoryReporterAsyncWaiter::~V8DetailedMemoryReporterAsyncWaiter() = default;


void V8DetailedMemoryReporterAsyncWaiter::GetV8MemoryUsage(
    V8DetailedMemoryReporter::Mode mode, PerProcessV8MemoryUsagePtr* out_memory_usage) {
  base::RunLoop loop;
  proxy_->GetV8MemoryUsage(
      std::move(mode),
      base::BindOnce(
          [](base::RunLoop* loop,
             PerProcessV8MemoryUsagePtr* out_memory_usage
,
             PerProcessV8MemoryUsagePtr memory_usage) {*out_memory_usage = std::move(memory_usage);
            loop->Quit();
          },
          &loop,
          out_memory_usage));
  loop.Run();
}

PerProcessV8MemoryUsagePtr V8DetailedMemoryReporterAsyncWaiter::GetV8MemoryUsage(
    V8DetailedMemoryReporter::Mode mode) {
  PerProcessV8MemoryUsagePtr async_wait_result;
  GetV8MemoryUsage(std::move(mode),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif