// third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_PEER_CONNECTION_TRACKER_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_PEER_CONNECTION_TRACKER_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT PeerConnectionManagerInterceptorForTesting : public PeerConnectionManager {
  virtual PeerConnectionManager* GetForwardingInterface() = 0;
  void OnSuspend() override;
  void OnThermalStateChange(DeviceThermalState thermal_state) override;
  void StartEventLog(int32_t peer_connection_local_id, int32_t output_period_ms) override;
  void StopEventLog(int32_t peer_connection_local_id) override;
  void StartDataChannelLog(int32_t peer_connection_local_id) override;
  void StopDataChannelLog(int32_t peer_connection_local_id) override;
  void GetStandardStats() override;
  void GetCurrentState() override;
};
class BLINK_COMMON_EXPORT PeerConnectionManagerAsyncWaiter {
 public:
  explicit PeerConnectionManagerAsyncWaiter(PeerConnectionManager* proxy);

  PeerConnectionManagerAsyncWaiter(const PeerConnectionManagerAsyncWaiter&) = delete;
  PeerConnectionManagerAsyncWaiter& operator=(const PeerConnectionManagerAsyncWaiter&) = delete;

  ~PeerConnectionManagerAsyncWaiter();

 private:
  PeerConnectionManager* const proxy_;
};


class BLINK_COMMON_EXPORT PeerConnectionTrackerHostInterceptorForTesting : public PeerConnectionTrackerHost {
  virtual PeerConnectionTrackerHost* GetForwardingInterface() = 0;
  void AddPeerConnection(PeerConnectionInfoPtr info) override;
  void RemovePeerConnection(int32_t lid) override;
  void UpdatePeerConnection(int32_t lid, const std::string& type, const std::string& value) override;
  void OnPeerConnectionSessionIdSet(int32_t lid, const std::string& session_id) override;
  void GetUserMedia(int32_t request_id, bool audio, bool video, const std::string& audio_constraints, const std::string& video_constraints) override;
  void GetUserMediaSuccess(int32_t request_id, const std::string& stream_id, const std::string& audio_track_info, const std::string& video_track_info) override;
  void GetUserMediaFailure(int32_t request_id, const std::string& error, const std::string& error_message) override;
  void GetDisplayMedia(int32_t request_id, bool audio, bool video, const std::string& audio_constraints, const std::string& video_constraints) override;
  void GetDisplayMediaSuccess(int32_t request_id, const std::string& stream_id, const std::string& audio_track_info, const std::string& video_track_info) override;
  void GetDisplayMediaFailure(int32_t request_id, const std::string& error, const std::string& error_message) override;
  void WebRtcEventLogWrite(int32_t lid, const std::vector<uint8_t>& output) override;
  void WebRtcDataChannelLogWrite(int32_t lid, const std::vector<uint8_t>& output) override;
  void AddStandardStats(int32_t lid, ::base::Value::List value) override;
};
class BLINK_COMMON_EXPORT PeerConnectionTrackerHostAsyncWaiter {
 public:
  explicit PeerConnectionTrackerHostAsyncWaiter(PeerConnectionTrackerHost* proxy);

  PeerConnectionTrackerHostAsyncWaiter(const PeerConnectionTrackerHostAsyncWaiter&) = delete;
  PeerConnectionTrackerHostAsyncWaiter& operator=(const PeerConnectionTrackerHostAsyncWaiter&) = delete;

  ~PeerConnectionTrackerHostAsyncWaiter();

 private:
  PeerConnectionTrackerHost* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_PEER_CONNECTION_TRACKER_MOJOM_TEST_UTILS_H_