// third_party/blink/public/mojom/payments/payment_handler_host.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-shared-internal.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared.h"


namespace payments::mojom {
class PaymentHandlerMethodDataDataView;

class PaymentHandlerModifierDataView;

class PaymentRequestDetailsUpdateDataView;



}  // payments::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::payments::mojom::PaymentHandlerMethodDataDataView> {
  using Data = ::payments::mojom::internal::PaymentHandlerMethodData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentHandlerModifierDataView> {
  using Data = ::payments::mojom::internal::PaymentHandlerModifier_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentRequestDetailsUpdateDataView> {
  using Data = ::payments::mojom::internal::PaymentRequestDetailsUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace payments::mojom {
// Interface base classes. They are used for type safety check.
class PaymentHandlerHostInterfaceBase {};

using PaymentHandlerHostPtrDataView =
    mojo::InterfacePtrDataView<PaymentHandlerHostInterfaceBase>;
using PaymentHandlerHostRequestDataView =
    mojo::InterfaceRequestDataView<PaymentHandlerHostInterfaceBase>;
using PaymentHandlerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PaymentHandlerHostInterfaceBase>;
using PaymentHandlerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PaymentHandlerHostInterfaceBase>;


class PaymentHandlerMethodDataDataView {
 public:
  PaymentHandlerMethodDataDataView() = default;

  PaymentHandlerMethodDataDataView(
      internal::PaymentHandlerMethodData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMethodNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethodName(UserType* output) {
    
    auto* pointer = data_->method_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStringifiedDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringifiedData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `stringified_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStringifiedData` instead "
    "of `ReadStringifiedData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->stringified_data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentHandlerMethodData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentHandlerModifierDataView {
 public:
  PaymentHandlerModifierDataView() = default;

  PaymentHandlerModifierDataView(
      internal::PaymentHandlerModifier_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTotalDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotal(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::PaymentCurrencyAmountDataView, UserType>(),
    "Attempting to read the optional `total` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTotal` instead "
    "of `ReadTotal if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->total.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, message_);
  }
  inline void GetMethodDataDataView(
      PaymentHandlerMethodDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethodData(UserType* output) {
    
    auto* pointer = data_->method_data.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentHandlerMethodDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentHandlerModifier_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentRequestDetailsUpdateDataView {
 public:
  PaymentRequestDetailsUpdateDataView() = default;

  PaymentRequestDetailsUpdateDataView(
      internal::PaymentRequestDetailsUpdate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTotalDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotal(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::PaymentCurrencyAmountDataView, UserType>(),
    "Attempting to read the optional `total` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTotal` instead "
    "of `ReadTotal if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->total.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, message_);
  }
  inline void GetShippingOptionsDataView(
      mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>, UserType>(),
    "Attempting to read the optional `shipping_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingOptions` instead "
    "of `ReadShippingOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_options.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>>(
        pointer, output, message_);
  }
  inline void GetModifiersDataView(
      mojo::ArrayDataView<PaymentHandlerModifierDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModifiers(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::payments::mojom::PaymentHandlerModifierDataView>, UserType>(),
    "Attempting to read the optional `modifiers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadModifiers` instead "
    "of `ReadModifiers if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->modifiers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentHandlerModifierDataView>>(
        pointer, output, message_);
  }
  inline void GetErrorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) {
    
    auto* pointer = data_->error.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStringifiedPaymentMethodErrorsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringifiedPaymentMethodErrors(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `stringified_payment_method_errors` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStringifiedPaymentMethodErrors` instead "
    "of `ReadStringifiedPaymentMethodErrors if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->stringified_payment_method_errors.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetShippingAddressErrorsDataView(
      ::payments::mojom::AddressErrorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingAddressErrors(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::AddressErrorsDataView, UserType>(),
    "Attempting to read the optional `shipping_address_errors` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingAddressErrors` instead "
    "of `ReadShippingAddressErrors if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_address_errors.Get();
    return mojo::internal::Deserialize<::payments::mojom::AddressErrorsDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentRequestDetailsUpdate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // payments::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_DATA_VIEW_H_