// third_party/blink/public/mojom/payments/payment_app.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('payments.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.PaymentHandlerStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.PaymentHandlerStatus = {
  
  SUCCESS: 0,
  NOT_FOUND: 1,
  NO_ACTIVE_WORKER: 2,
  STORAGE_OPERATION_FAILED: 3,
  FETCH_INSTRUMENT_ICON_FAILED: 4,
  FETCH_PAYMENT_APP_INFO_FAILED: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.CanMakePaymentEventResponseTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.CanMakePaymentEventResponseType = {
  
  INCOGNITO: 0,
  NO_EXPLICITLY_VERIFIED_METHODS: 1,
  NOT_INSTALLED: 2,
  NO_URL_BASED_PAYMENT_METHODS: 3,
  BOOLEAN_CONVERSION_ERROR: 4,
  BROWSER_ERROR: 5,
  INTERNAL_ERROR: 6,
  NO_RESPONSE: 7,
  REJECT: 8,
  SUCCESS: 9,
  TIMEOUT: 10,
  MIN_VALUE: 0,
  MAX_VALUE: 10,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.PaymentEventResponseTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.PaymentEventResponseType = {
  
  PAYER_NAME_EMPTY: 0,
  PAYER_EMAIL_EMPTY: 1,
  PAYER_PHONE_EMPTY: 2,
  PAYMENT_DETAILS_ABSENT: 3,
  PAYMENT_DETAILS_NOT_OBJECT: 4,
  PAYMENT_DETAILS_STRINGIFY_ERROR: 5,
  PAYMENT_EVENT_BROWSER_ERROR: 6,
  PAYMENT_EVENT_INTERNAL_ERROR: 7,
  PAYMENT_EVENT_NO_RESPONSE: 8,
  PAYMENT_EVENT_REJECT: 9,
  PAYMENT_EVENT_SERVICE_WORKER_ERROR: 10,
  PAYMENT_EVENT_SUCCESS: 11,
  PAYMENT_EVENT_TIMEOUT: 12,
  PAYMENT_HANDLER_ACTIVITY_DIED: 13,
  PAYMENT_HANDLER_FAIL_TO_LOAD_MAIN_FRAME: 14,
  PAYMENT_HANDLER_INSECURE_NAVIGATION: 15,
  PAYMENT_HANDLER_INSTALL_FAILED: 16,
  PAYMENT_HANDLER_WINDOW_CLOSING: 17,
  PAYMENT_METHOD_NAME_EMPTY: 18,
  SHIPPING_ADDRESS_INVALID: 19,
  SHIPPING_OPTION_EMPTY: 20,
  MIN_VALUE: 0,
  MAX_VALUE: 20,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.PaymentDelegationSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.PaymentDelegation = {
  
  SHIPPING_ADDRESS: 0,
  PAYER_NAME: 1,
  PAYER_PHONE: 2,
  PAYER_EMAIL: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
payments.mojom.PaymentManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        payments.mojom.PaymentManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { payments.mojom.PaymentManagerInterface }
 */
payments.mojom.PaymentManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!payments.mojom.PaymentManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          payments.mojom.PaymentManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!payments.mojom.PaymentManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } contextUrl
   * @param { !string } serviceWorkerScope
   */

  init(
      contextUrl,
      serviceWorkerScope) {
    this.proxy.sendMessage(
        0,
        payments.mojom.PaymentManager_Init_ParamsSpec.$,
        null,
        [
          contextUrl,
          serviceWorkerScope
        ],
        false);
  }

  
  /**
   * @param { !string } instrumentKey
   * @return {!Promise<{
        status: !payments.mojom.PaymentHandlerStatus,
   *  }>}
   */

  deletePaymentInstrument(
      instrumentKey) {
    return this.proxy.sendMessage(
        1,
        payments.mojom.PaymentManager_DeletePaymentInstrument_ParamsSpec.$,
        payments.mojom.PaymentManager_DeletePaymentInstrument_ResponseParamsSpec.$,
        [
          instrumentKey
        ],
        false);
  }

  
  /**
   * @param { !string } instrumentKey
   * @return {!Promise<{
        instrument: !payments.mojom.PaymentInstrument,
        status: !payments.mojom.PaymentHandlerStatus,
   *  }>}
   */

  getPaymentInstrument(
      instrumentKey) {
    return this.proxy.sendMessage(
        2,
        payments.mojom.PaymentManager_GetPaymentInstrument_ParamsSpec.$,
        payments.mojom.PaymentManager_GetPaymentInstrument_ResponseParamsSpec.$,
        [
          instrumentKey
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        keys: !Array<!string>,
        status: !payments.mojom.PaymentHandlerStatus,
   *  }>}
   */

  keysOfPaymentInstruments() {
    return this.proxy.sendMessage(
        3,
        payments.mojom.PaymentManager_KeysOfPaymentInstruments_ParamsSpec.$,
        payments.mojom.PaymentManager_KeysOfPaymentInstruments_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } instrumentKey
   * @return {!Promise<{
        status: !payments.mojom.PaymentHandlerStatus,
   *  }>}
   */

  hasPaymentInstrument(
      instrumentKey) {
    return this.proxy.sendMessage(
        4,
        payments.mojom.PaymentManager_HasPaymentInstrument_ParamsSpec.$,
        payments.mojom.PaymentManager_HasPaymentInstrument_ResponseParamsSpec.$,
        [
          instrumentKey
        ],
        false);
  }

  
  /**
   * @param { !string } instrumentKey
   * @param { !payments.mojom.PaymentInstrument } instrument
   * @return {!Promise<{
        status: !payments.mojom.PaymentHandlerStatus,
   *  }>}
   */

  setPaymentInstrument(
      instrumentKey,
      instrument) {
    return this.proxy.sendMessage(
        5,
        payments.mojom.PaymentManager_SetPaymentInstrument_ParamsSpec.$,
        payments.mojom.PaymentManager_SetPaymentInstrument_ResponseParamsSpec.$,
        [
          instrumentKey,
          instrument
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        status: !payments.mojom.PaymentHandlerStatus,
   *  }>}
   */

  clearPaymentInstruments() {
    return this.proxy.sendMessage(
        6,
        payments.mojom.PaymentManager_ClearPaymentInstruments_ParamsSpec.$,
        payments.mojom.PaymentManager_ClearPaymentInstruments_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } userHint
   */

  setUserHint(
      userHint) {
    this.proxy.sendMessage(
        7,
        payments.mojom.PaymentManager_SetUserHint_ParamsSpec.$,
        null,
        [
          userHint
        ],
        false);
  }

  
  /**
   * @param { !Array<!payments.mojom.PaymentDelegation> } delegations
   * @return {!Promise<{
        status: !payments.mojom.PaymentHandlerStatus,
   *  }>}
   */

  enableDelegations(
      delegations) {
    return this.proxy.sendMessage(
        8,
        payments.mojom.PaymentManager_EnableDelegations_ParamsSpec.$,
        payments.mojom.PaymentManager_EnableDelegations_ResponseParamsSpec.$,
        [
          delegations
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PaymentManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
payments.mojom.PaymentManagerReceiver = class {
  /**
   * @param {!payments.mojom.PaymentManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!payments.mojom.PaymentManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        payments.mojom.PaymentManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.PaymentManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        payments.mojom.PaymentManager_Init_ParamsSpec.$,
        null,
        impl.init.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        payments.mojom.PaymentManager_DeletePaymentInstrument_ParamsSpec.$,
        payments.mojom.PaymentManager_DeletePaymentInstrument_ResponseParamsSpec.$,
        impl.deletePaymentInstrument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        payments.mojom.PaymentManager_GetPaymentInstrument_ParamsSpec.$,
        payments.mojom.PaymentManager_GetPaymentInstrument_ResponseParamsSpec.$,
        impl.getPaymentInstrument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        payments.mojom.PaymentManager_KeysOfPaymentInstruments_ParamsSpec.$,
        payments.mojom.PaymentManager_KeysOfPaymentInstruments_ResponseParamsSpec.$,
        impl.keysOfPaymentInstruments.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        payments.mojom.PaymentManager_HasPaymentInstrument_ParamsSpec.$,
        payments.mojom.PaymentManager_HasPaymentInstrument_ResponseParamsSpec.$,
        impl.hasPaymentInstrument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        payments.mojom.PaymentManager_SetPaymentInstrument_ParamsSpec.$,
        payments.mojom.PaymentManager_SetPaymentInstrument_ResponseParamsSpec.$,
        impl.setPaymentInstrument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        payments.mojom.PaymentManager_ClearPaymentInstruments_ParamsSpec.$,
        payments.mojom.PaymentManager_ClearPaymentInstruments_ResponseParamsSpec.$,
        impl.clearPaymentInstruments.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        payments.mojom.PaymentManager_SetUserHint_ParamsSpec.$,
        null,
        impl.setUserHint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        payments.mojom.PaymentManager_EnableDelegations_ParamsSpec.$,
        payments.mojom.PaymentManager_EnableDelegations_ResponseParamsSpec.$,
        impl.enableDelegations.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
payments.mojom.PaymentManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.PaymentManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!payments.mojom.PaymentManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new payments.mojom.PaymentManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PaymentManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
payments.mojom.PaymentManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      payments.mojom.PaymentManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.PaymentManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.init =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        payments.mojom.PaymentManager_Init_ParamsSpec.$,
        null,
        this.init.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deletePaymentInstrument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        payments.mojom.PaymentManager_DeletePaymentInstrument_ParamsSpec.$,
        payments.mojom.PaymentManager_DeletePaymentInstrument_ResponseParamsSpec.$,
        this.deletePaymentInstrument.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPaymentInstrument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        payments.mojom.PaymentManager_GetPaymentInstrument_ParamsSpec.$,
        payments.mojom.PaymentManager_GetPaymentInstrument_ResponseParamsSpec.$,
        this.getPaymentInstrument.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keysOfPaymentInstruments =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        payments.mojom.PaymentManager_KeysOfPaymentInstruments_ParamsSpec.$,
        payments.mojom.PaymentManager_KeysOfPaymentInstruments_ResponseParamsSpec.$,
        this.keysOfPaymentInstruments.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasPaymentInstrument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        payments.mojom.PaymentManager_HasPaymentInstrument_ParamsSpec.$,
        payments.mojom.PaymentManager_HasPaymentInstrument_ResponseParamsSpec.$,
        this.hasPaymentInstrument.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPaymentInstrument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        payments.mojom.PaymentManager_SetPaymentInstrument_ParamsSpec.$,
        payments.mojom.PaymentManager_SetPaymentInstrument_ResponseParamsSpec.$,
        this.setPaymentInstrument.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearPaymentInstruments =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        payments.mojom.PaymentManager_ClearPaymentInstruments_ParamsSpec.$,
        payments.mojom.PaymentManager_ClearPaymentInstruments_ResponseParamsSpec.$,
        this.clearPaymentInstruments.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setUserHint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        payments.mojom.PaymentManager_SetUserHint_ParamsSpec.$,
        null,
        this.setUserHint.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableDelegations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        payments.mojom.PaymentManager_EnableDelegations_ParamsSpec.$,
        payments.mojom.PaymentManager_EnableDelegations_ResponseParamsSpec.$,
        this.enableDelegations.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
payments.mojom.PaymentHandlerResponseCallbackPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        payments.mojom.PaymentHandlerResponseCallback.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { payments.mojom.PaymentHandlerResponseCallbackInterface }
 */
payments.mojom.PaymentHandlerResponseCallbackRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!payments.mojom.PaymentHandlerResponseCallbackPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          payments.mojom.PaymentHandlerResponseCallbackPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!payments.mojom.PaymentHandlerResponseCallbackPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } paymentAborted
   */

  onResponseForAbortPayment(
      paymentAborted) {
    this.proxy.sendMessage(
        0,
        payments.mojom.PaymentHandlerResponseCallback_OnResponseForAbortPayment_ParamsSpec.$,
        null,
        [
          paymentAborted
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.CanMakePaymentResponse } response
   */

  onResponseForCanMakePayment(
      response) {
    this.proxy.sendMessage(
        1,
        payments.mojom.PaymentHandlerResponseCallback_OnResponseForCanMakePayment_ParamsSpec.$,
        null,
        [
          response
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.PaymentHandlerResponse } response
   */

  onResponseForPaymentRequest(
      response) {
    this.proxy.sendMessage(
        2,
        payments.mojom.PaymentHandlerResponseCallback_OnResponseForPaymentRequest_ParamsSpec.$,
        null,
        [
          response
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PaymentHandlerResponseCallback
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
payments.mojom.PaymentHandlerResponseCallbackReceiver = class {
  /**
   * @param {!payments.mojom.PaymentHandlerResponseCallbackInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!payments.mojom.PaymentHandlerResponseCallbackRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        payments.mojom.PaymentHandlerResponseCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.PaymentHandlerResponseCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        payments.mojom.PaymentHandlerResponseCallback_OnResponseForAbortPayment_ParamsSpec.$,
        null,
        impl.onResponseForAbortPayment.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        payments.mojom.PaymentHandlerResponseCallback_OnResponseForCanMakePayment_ParamsSpec.$,
        null,
        impl.onResponseForCanMakePayment.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        payments.mojom.PaymentHandlerResponseCallback_OnResponseForPaymentRequest_ParamsSpec.$,
        null,
        impl.onResponseForPaymentRequest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
payments.mojom.PaymentHandlerResponseCallback = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.PaymentHandlerResponseCallback";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!payments.mojom.PaymentHandlerResponseCallbackRemote}
   * @export
   */
  static getRemote() {
    let remote = new payments.mojom.PaymentHandlerResponseCallbackRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PaymentHandlerResponseCallback
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
payments.mojom.PaymentHandlerResponseCallbackCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      payments.mojom.PaymentHandlerResponseCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.PaymentHandlerResponseCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponseForAbortPayment =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        payments.mojom.PaymentHandlerResponseCallback_OnResponseForAbortPayment_ParamsSpec.$,
        null,
        this.onResponseForAbortPayment.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponseForCanMakePayment =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        payments.mojom.PaymentHandlerResponseCallback_OnResponseForCanMakePayment_ParamsSpec.$,
        null,
        this.onResponseForCanMakePayment.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponseForPaymentRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        payments.mojom.PaymentHandlerResponseCallback_OnResponseForPaymentRequest_ParamsSpec.$,
        null,
        this.onResponseForPaymentRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentInstrumentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.CanMakePaymentEventDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestEventDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.CanMakePaymentResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentHandlerResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_Init_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_DeletePaymentInstrument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_DeletePaymentInstrument_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_GetPaymentInstrument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_GetPaymentInstrument_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_KeysOfPaymentInstruments_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_KeysOfPaymentInstruments_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_HasPaymentInstrument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_HasPaymentInstrument_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_SetPaymentInstrument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_SetPaymentInstrument_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_ClearPaymentInstruments_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_ClearPaymentInstruments_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_SetUserHint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_EnableDelegations_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentManager_EnableDelegations_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentHandlerResponseCallback_OnResponseForAbortPayment_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentHandlerResponseCallback_OnResponseForCanMakePayment_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentHandlerResponseCallback_OnResponseForPaymentRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    payments.mojom.PaymentInstrumentSpec.$,
    'PaymentInstrument',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'icons', 8,
        0,
        mojo.internal.Array(blink.mojom.ManifestImageResourceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'method', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
payments.mojom.PaymentInstrument = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !Array<!blink.mojom.ManifestImageResource> } */
    this.icons;
    /** @export { !string } */
    this.method;
  }
};



mojo.internal.Struct(
    payments.mojom.CanMakePaymentEventDataSpec.$,
    'CanMakePaymentEventData',
    [
      mojo.internal.StructField(
        'topOrigin', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paymentRequestOrigin', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'methodData', 16,
        0,
        mojo.internal.Array(payments.mojom.PaymentMethodDataSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modifiers', 24,
        0,
        mojo.internal.Array(payments.mojom.PaymentDetailsModifierSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
payments.mojom.CanMakePaymentEventData = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.topOrigin;
    /** @export { !url.mojom.Url } */
    this.paymentRequestOrigin;
    /** @export { !Array<!payments.mojom.PaymentMethodData> } */
    this.methodData;
    /** @export { !Array<!payments.mojom.PaymentDetailsModifier> } */
    this.modifiers;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestEventDataSpec.$,
    'PaymentRequestEventData',
    [
      mojo.internal.StructField(
        'topOrigin', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paymentRequestOrigin', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paymentRequestId', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'methodData', 24,
        0,
        mojo.internal.Array(payments.mojom.PaymentMethodDataSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'total', 32,
        0,
        payments.mojom.PaymentCurrencyAmountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modifiers', 40,
        0,
        mojo.internal.Array(payments.mojom.PaymentDetailsModifierSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'instrumentKey', 48,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paymentOptions', 56,
        0,
        payments.mojom.PaymentOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shippingOptions', 64,
        0,
        mojo.internal.Array(payments.mojom.PaymentShippingOptionSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paymentHandlerHost', 72,
        0,
        mojo.internal.InterfaceProxy(payments.mojom.PaymentHandlerHostRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 88],]);





/** @record */
payments.mojom.PaymentRequestEventData = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.topOrigin;
    /** @export { !url.mojom.Url } */
    this.paymentRequestOrigin;
    /** @export { !string } */
    this.paymentRequestId;
    /** @export { !Array<!payments.mojom.PaymentMethodData> } */
    this.methodData;
    /** @export { !payments.mojom.PaymentCurrencyAmount } */
    this.total;
    /** @export { !Array<!payments.mojom.PaymentDetailsModifier> } */
    this.modifiers;
    /** @export { !string } */
    this.instrumentKey;
    /** @export { (payments.mojom.PaymentOptions|undefined) } */
    this.paymentOptions;
    /** @export { (Array<!payments.mojom.PaymentShippingOption>|undefined) } */
    this.shippingOptions;
    /** @export { (payments.mojom.PaymentHandlerHostRemote|undefined) } */
    this.paymentHandlerHost;
  }
};



mojo.internal.Struct(
    payments.mojom.CanMakePaymentResponseSpec.$,
    'CanMakePaymentResponse',
    [
      mojo.internal.StructField(
        'responseType', 0,
        0,
        payments.mojom.CanMakePaymentEventResponseTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'canMakePayment', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.CanMakePaymentResponse = class {
  constructor() {
    /** @export { !payments.mojom.CanMakePaymentEventResponseType } */
    this.responseType;
    /** @export { !boolean } */
    this.canMakePayment;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentHandlerResponseSpec.$,
    'PaymentHandlerResponse',
    [
      mojo.internal.StructField(
        'methodName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stringifiedDetails', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseType', 16,
        0,
        payments.mojom.PaymentEventResponseTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payerName', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payerEmail', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payerPhone', 40,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shippingAddress', 48,
        0,
        payments.mojom.PaymentAddressSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shippingOption', 56,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 72],]);





/** @record */
payments.mojom.PaymentHandlerResponse = class {
  constructor() {
    /** @export { !string } */
    this.methodName;
    /** @export { !string } */
    this.stringifiedDetails;
    /** @export { !payments.mojom.PaymentEventResponseType } */
    this.responseType;
    /** @export { (string|undefined) } */
    this.payerName;
    /** @export { (string|undefined) } */
    this.payerEmail;
    /** @export { (string|undefined) } */
    this.payerPhone;
    /** @export { (payments.mojom.PaymentAddress|undefined) } */
    this.shippingAddress;
    /** @export { (string|undefined) } */
    this.shippingOption;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_Init_ParamsSpec.$,
    'PaymentManager_Init_Params',
    [
      mojo.internal.StructField(
        'contextUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerScope', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
payments.mojom.PaymentManager_Init_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.contextUrl;
    /** @export { !string } */
    this.serviceWorkerScope;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_DeletePaymentInstrument_ParamsSpec.$,
    'PaymentManager_DeletePaymentInstrument_Params',
    [
      mojo.internal.StructField(
        'instrumentKey', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentManager_DeletePaymentInstrument_Params = class {
  constructor() {
    /** @export { !string } */
    this.instrumentKey;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_DeletePaymentInstrument_ResponseParamsSpec.$,
    'PaymentManager_DeletePaymentInstrument_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        payments.mojom.PaymentHandlerStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentManager_DeletePaymentInstrument_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.PaymentHandlerStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_GetPaymentInstrument_ParamsSpec.$,
    'PaymentManager_GetPaymentInstrument_Params',
    [
      mojo.internal.StructField(
        'instrumentKey', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentManager_GetPaymentInstrument_Params = class {
  constructor() {
    /** @export { !string } */
    this.instrumentKey;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_GetPaymentInstrument_ResponseParamsSpec.$,
    'PaymentManager_GetPaymentInstrument_ResponseParams',
    [
      mojo.internal.StructField(
        'instrument', 0,
        0,
        payments.mojom.PaymentInstrumentSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        payments.mojom.PaymentHandlerStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
payments.mojom.PaymentManager_GetPaymentInstrument_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.PaymentInstrument } */
    this.instrument;
    /** @export { !payments.mojom.PaymentHandlerStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_KeysOfPaymentInstruments_ParamsSpec.$,
    'PaymentManager_KeysOfPaymentInstruments_Params',
    [
    ],
    [[0, 8],]);





/** @record */
payments.mojom.PaymentManager_KeysOfPaymentInstruments_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_KeysOfPaymentInstruments_ResponseParamsSpec.$,
    'PaymentManager_KeysOfPaymentInstruments_ResponseParams',
    [
      mojo.internal.StructField(
        'keys', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        payments.mojom.PaymentHandlerStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
payments.mojom.PaymentManager_KeysOfPaymentInstruments_ResponseParams = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.keys;
    /** @export { !payments.mojom.PaymentHandlerStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_HasPaymentInstrument_ParamsSpec.$,
    'PaymentManager_HasPaymentInstrument_Params',
    [
      mojo.internal.StructField(
        'instrumentKey', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentManager_HasPaymentInstrument_Params = class {
  constructor() {
    /** @export { !string } */
    this.instrumentKey;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_HasPaymentInstrument_ResponseParamsSpec.$,
    'PaymentManager_HasPaymentInstrument_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        payments.mojom.PaymentHandlerStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentManager_HasPaymentInstrument_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.PaymentHandlerStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_SetPaymentInstrument_ParamsSpec.$,
    'PaymentManager_SetPaymentInstrument_Params',
    [
      mojo.internal.StructField(
        'instrumentKey', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'instrument', 8,
        0,
        payments.mojom.PaymentInstrumentSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
payments.mojom.PaymentManager_SetPaymentInstrument_Params = class {
  constructor() {
    /** @export { !string } */
    this.instrumentKey;
    /** @export { !payments.mojom.PaymentInstrument } */
    this.instrument;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_SetPaymentInstrument_ResponseParamsSpec.$,
    'PaymentManager_SetPaymentInstrument_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        payments.mojom.PaymentHandlerStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentManager_SetPaymentInstrument_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.PaymentHandlerStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_ClearPaymentInstruments_ParamsSpec.$,
    'PaymentManager_ClearPaymentInstruments_Params',
    [
    ],
    [[0, 8],]);





/** @record */
payments.mojom.PaymentManager_ClearPaymentInstruments_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_ClearPaymentInstruments_ResponseParamsSpec.$,
    'PaymentManager_ClearPaymentInstruments_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        payments.mojom.PaymentHandlerStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentManager_ClearPaymentInstruments_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.PaymentHandlerStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_SetUserHint_ParamsSpec.$,
    'PaymentManager_SetUserHint_Params',
    [
      mojo.internal.StructField(
        'userHint', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentManager_SetUserHint_Params = class {
  constructor() {
    /** @export { !string } */
    this.userHint;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_EnableDelegations_ParamsSpec.$,
    'PaymentManager_EnableDelegations_Params',
    [
      mojo.internal.StructField(
        'delegations', 0,
        0,
        mojo.internal.Array(payments.mojom.PaymentDelegationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentManager_EnableDelegations_Params = class {
  constructor() {
    /** @export { !Array<!payments.mojom.PaymentDelegation> } */
    this.delegations;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentManager_EnableDelegations_ResponseParamsSpec.$,
    'PaymentManager_EnableDelegations_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        payments.mojom.PaymentHandlerStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentManager_EnableDelegations_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.PaymentHandlerStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentHandlerResponseCallback_OnResponseForAbortPayment_ParamsSpec.$,
    'PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params',
    [
      mojo.internal.StructField(
        'paymentAborted', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.paymentAborted;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentHandlerResponseCallback_OnResponseForCanMakePayment_ParamsSpec.$,
    'PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        payments.mojom.CanMakePaymentResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params = class {
  constructor() {
    /** @export { !payments.mojom.CanMakePaymentResponse } */
    this.response;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentHandlerResponseCallback_OnResponseForPaymentRequest_ParamsSpec.$,
    'PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        payments.mojom.PaymentHandlerResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params = class {
  constructor() {
    /** @export { !payments.mojom.PaymentHandlerResponse } */
    this.response;
  }
};

