// third_party/blink/public/mojom/payments/payment_app.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/payments/payment_app.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/payments/payment_app.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/payments/payment_app.mojom-blink-forward.h"  // IWYU pragma: export
#include "components/payments/mojom/payment_request_data.mojom-blink.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-blink.h"
#include "third_party/blink/public/mojom/payments/payment_request.mojom-blink.h"
#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace payments::mojom::blink {

class PaymentManagerProxy;

template <typename ImplRefTraits>
class PaymentManagerStub;

class PaymentManagerRequestValidator;
class PaymentManagerResponseValidator;


class PLATFORM_EXPORT PaymentManager
    : public PaymentManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "payments.mojom.PaymentManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PaymentManagerInterfaceBase;
  using Proxy_ = PaymentManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PaymentManagerStub<ImplRefTraits>;

  using RequestValidator_ = PaymentManagerRequestValidator;
  using ResponseValidator_ = PaymentManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitMinVersion = 0,
    kDeletePaymentInstrumentMinVersion = 0,
    kGetPaymentInstrumentMinVersion = 0,
    kKeysOfPaymentInstrumentsMinVersion = 0,
    kHasPaymentInstrumentMinVersion = 0,
    kSetPaymentInstrumentMinVersion = 0,
    kClearPaymentInstrumentsMinVersion = 0,
    kSetUserHintMinVersion = 0,
    kEnableDelegationsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Init_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeletePaymentInstrument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPaymentInstrument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct KeysOfPaymentInstruments_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HasPaymentInstrument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPaymentInstrument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearPaymentInstruments_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUserHint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableDelegations_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PaymentManager() = default;

  virtual void Init(const ::blink::KURL& context_url, const ::blink::String& service_worker_scope) = 0;

  using DeletePaymentInstrumentCallback = base::OnceCallback<void(PaymentHandlerStatus)>;
  using DeletePaymentInstrumentMojoCallback = base::OnceCallback<void(PaymentHandlerStatus)>;

  virtual void DeletePaymentInstrument(const ::blink::String& instrument_key, DeletePaymentInstrumentCallback callback) = 0;

  using GetPaymentInstrumentCallback = base::OnceCallback<void(PaymentInstrumentPtr, PaymentHandlerStatus)>;
  using GetPaymentInstrumentMojoCallback = base::OnceCallback<void(PaymentInstrumentPtr, PaymentHandlerStatus)>;

  virtual void GetPaymentInstrument(const ::blink::String& instrument_key, GetPaymentInstrumentCallback callback) = 0;

  using KeysOfPaymentInstrumentsCallback = base::OnceCallback<void(const ::blink::Vector<::blink::String>&, PaymentHandlerStatus)>;
  using KeysOfPaymentInstrumentsMojoCallback = base::OnceCallback<void(const ::blink::Vector<::blink::String>&, PaymentHandlerStatus)>;

  virtual void KeysOfPaymentInstruments(KeysOfPaymentInstrumentsCallback callback) = 0;

  using HasPaymentInstrumentCallback = base::OnceCallback<void(PaymentHandlerStatus)>;
  using HasPaymentInstrumentMojoCallback = base::OnceCallback<void(PaymentHandlerStatus)>;

  virtual void HasPaymentInstrument(const ::blink::String& instrument_key, HasPaymentInstrumentCallback callback) = 0;

  using SetPaymentInstrumentCallback = base::OnceCallback<void(PaymentHandlerStatus)>;
  using SetPaymentInstrumentMojoCallback = base::OnceCallback<void(PaymentHandlerStatus)>;

  virtual void SetPaymentInstrument(const ::blink::String& instrument_key, PaymentInstrumentPtr instrument, SetPaymentInstrumentCallback callback) = 0;

  using ClearPaymentInstrumentsCallback = base::OnceCallback<void(PaymentHandlerStatus)>;
  using ClearPaymentInstrumentsMojoCallback = base::OnceCallback<void(PaymentHandlerStatus)>;

  virtual void ClearPaymentInstruments(ClearPaymentInstrumentsCallback callback) = 0;

  virtual void SetUserHint(const ::blink::String& user_hint) = 0;

  using EnableDelegationsCallback = base::OnceCallback<void(PaymentHandlerStatus)>;
  using EnableDelegationsMojoCallback = base::OnceCallback<void(PaymentHandlerStatus)>;

  virtual void EnableDelegations(const ::blink::Vector<PaymentDelegation>& delegations, EnableDelegationsCallback callback) = 0;
};

class PaymentHandlerResponseCallbackProxy;

template <typename ImplRefTraits>
class PaymentHandlerResponseCallbackStub;

class PaymentHandlerResponseCallbackRequestValidator;


class PLATFORM_EXPORT PaymentHandlerResponseCallback
    : public PaymentHandlerResponseCallbackInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "payments.mojom.PaymentHandlerResponseCallback";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PaymentHandlerResponseCallbackInterfaceBase;
  using Proxy_ = PaymentHandlerResponseCallbackProxy;

  template <typename ImplRefTraits>
  using Stub_ = PaymentHandlerResponseCallbackStub<ImplRefTraits>;

  using RequestValidator_ = PaymentHandlerResponseCallbackRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnResponseForAbortPaymentMinVersion = 0,
    kOnResponseForCanMakePaymentMinVersion = 0,
    kOnResponseForPaymentRequestMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnResponseForAbortPayment_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnResponseForCanMakePayment_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnResponseForPaymentRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PaymentHandlerResponseCallback() = default;

  virtual void OnResponseForAbortPayment(bool payment_aborted) = 0;

  virtual void OnResponseForCanMakePayment(CanMakePaymentResponsePtr response) = 0;

  virtual void OnResponseForPaymentRequest(PaymentHandlerResponsePtr response) = 0;
};



class PLATFORM_EXPORT PaymentManagerProxy
    : public PaymentManager {
 public:
  using InterfaceType = PaymentManager;

  explicit PaymentManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Init(const ::blink::KURL& context_url, const ::blink::String& service_worker_scope) final;
  
  void DeletePaymentInstrument(const ::blink::String& instrument_key, DeletePaymentInstrumentCallback callback) final;
  
  void GetPaymentInstrument(const ::blink::String& instrument_key, GetPaymentInstrumentCallback callback) final;
  
  void KeysOfPaymentInstruments(KeysOfPaymentInstrumentsCallback callback) final;
  
  void HasPaymentInstrument(const ::blink::String& instrument_key, HasPaymentInstrumentCallback callback) final;
  
  void SetPaymentInstrument(const ::blink::String& instrument_key, PaymentInstrumentPtr instrument, SetPaymentInstrumentCallback callback) final;
  
  void ClearPaymentInstruments(ClearPaymentInstrumentsCallback callback) final;
  
  void SetUserHint(const ::blink::String& user_hint) final;
  
  void EnableDelegations(const ::blink::Vector<PaymentDelegation>& delegations, EnableDelegationsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT PaymentHandlerResponseCallbackProxy
    : public PaymentHandlerResponseCallback {
 public:
  using InterfaceType = PaymentHandlerResponseCallback;

  explicit PaymentHandlerResponseCallbackProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnResponseForAbortPayment(bool payment_aborted) final;
  
  void OnResponseForCanMakePayment(CanMakePaymentResponsePtr response) final;
  
  void OnResponseForPaymentRequest(PaymentHandlerResponsePtr response) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT PaymentManagerStubDispatch {
 public:
  static bool Accept(PaymentManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PaymentManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PaymentManager>>
class PaymentManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PaymentManagerStub() = default;
  ~PaymentManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PaymentHandlerResponseCallbackStubDispatch {
 public:
  static bool Accept(PaymentHandlerResponseCallback* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PaymentHandlerResponseCallback* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PaymentHandlerResponseCallback>>
class PaymentHandlerResponseCallbackStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PaymentHandlerResponseCallbackStub() = default;
  ~PaymentHandlerResponseCallbackStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentHandlerResponseCallbackStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentHandlerResponseCallbackStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PaymentManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PaymentHandlerResponseCallbackRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PaymentManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT CanMakePaymentResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CanMakePaymentResponse, T>::value>;
  using DataView = CanMakePaymentResponseDataView;
  using Data_ = internal::CanMakePaymentResponse_Data;

  template <typename... Args>
  static CanMakePaymentResponsePtr New(Args&&... args) {
    return CanMakePaymentResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CanMakePaymentResponsePtr From(const U& u) {
    return mojo::TypeConverter<CanMakePaymentResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CanMakePaymentResponse>::Convert(*this);
  }


  CanMakePaymentResponse();

  CanMakePaymentResponse(
      CanMakePaymentEventResponseType response_type,
      bool can_make_payment);


  ~CanMakePaymentResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CanMakePaymentResponsePtr>
  CanMakePaymentResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CanMakePaymentResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CanMakePaymentResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CanMakePaymentResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CanMakePaymentResponse::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CanMakePaymentResponse::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CanMakePaymentResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CanMakePaymentResponse_UnserializedMessageContext<
            UserType, CanMakePaymentResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CanMakePaymentResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CanMakePaymentResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CanMakePaymentResponse_UnserializedMessageContext<
            UserType, CanMakePaymentResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CanMakePaymentResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CanMakePaymentEventResponseType response_type;
  
  bool can_make_payment;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CanMakePaymentResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CanMakePaymentResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CanMakePaymentResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CanMakePaymentResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class PLATFORM_EXPORT PaymentInstrument {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentInstrument, T>::value>;
  using DataView = PaymentInstrumentDataView;
  using Data_ = internal::PaymentInstrument_Data;

  template <typename... Args>
  static PaymentInstrumentPtr New(Args&&... args) {
    return PaymentInstrumentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentInstrumentPtr From(const U& u) {
    return mojo::TypeConverter<PaymentInstrumentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentInstrument>::Convert(*this);
  }


  PaymentInstrument();

  PaymentInstrument(
      const ::blink::String& name,
      ::blink::Vector<::blink::mojom::blink::ManifestImageResourcePtr> icons,
      const ::blink::String& method);

PaymentInstrument(const PaymentInstrument&) = delete;
PaymentInstrument& operator=(const PaymentInstrument&) = delete;

  ~PaymentInstrument();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentInstrumentPtr>
  PaymentInstrumentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentInstrument::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentInstrument::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentInstrument::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentInstrument::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentInstrument::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentInstrument::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentInstrument_UnserializedMessageContext<
            UserType, PaymentInstrument::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentInstrument::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentInstrument::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentInstrument_UnserializedMessageContext<
            UserType, PaymentInstrument::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentInstrument::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String name;
  
  ::blink::Vector<::blink::mojom::blink::ManifestImageResourcePtr> icons;
  
  ::blink::String method;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentInstrument::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentInstrument::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentInstrument::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentInstrument::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT CanMakePaymentEventData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CanMakePaymentEventData, T>::value>;
  using DataView = CanMakePaymentEventDataDataView;
  using Data_ = internal::CanMakePaymentEventData_Data;

  template <typename... Args>
  static CanMakePaymentEventDataPtr New(Args&&... args) {
    return CanMakePaymentEventDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CanMakePaymentEventDataPtr From(const U& u) {
    return mojo::TypeConverter<CanMakePaymentEventDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CanMakePaymentEventData>::Convert(*this);
  }


  CanMakePaymentEventData();

  CanMakePaymentEventData(
      const ::blink::KURL& top_origin,
      const ::blink::KURL& payment_request_origin,
      ::blink::Vector<::payments::mojom::blink::PaymentMethodDataPtr> method_data,
      ::blink::Vector<::payments::mojom::blink::PaymentDetailsModifierPtr> modifiers);

CanMakePaymentEventData(const CanMakePaymentEventData&) = delete;
CanMakePaymentEventData& operator=(const CanMakePaymentEventData&) = delete;

  ~CanMakePaymentEventData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CanMakePaymentEventDataPtr>
  CanMakePaymentEventDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CanMakePaymentEventData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CanMakePaymentEventData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CanMakePaymentEventData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CanMakePaymentEventData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CanMakePaymentEventData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CanMakePaymentEventData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CanMakePaymentEventData_UnserializedMessageContext<
            UserType, CanMakePaymentEventData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CanMakePaymentEventData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CanMakePaymentEventData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CanMakePaymentEventData_UnserializedMessageContext<
            UserType, CanMakePaymentEventData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CanMakePaymentEventData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL top_origin;
  
  ::blink::KURL payment_request_origin;
  
  ::blink::Vector<::payments::mojom::blink::PaymentMethodDataPtr> method_data;
  
  ::blink::Vector<::payments::mojom::blink::PaymentDetailsModifierPtr> modifiers;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CanMakePaymentEventData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CanMakePaymentEventData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CanMakePaymentEventData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CanMakePaymentEventData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PaymentRequestEventData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentRequestEventData, T>::value>;
  using DataView = PaymentRequestEventDataDataView;
  using Data_ = internal::PaymentRequestEventData_Data;

  template <typename... Args>
  static PaymentRequestEventDataPtr New(Args&&... args) {
    return PaymentRequestEventDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentRequestEventDataPtr From(const U& u) {
    return mojo::TypeConverter<PaymentRequestEventDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentRequestEventData>::Convert(*this);
  }


  PaymentRequestEventData();

  PaymentRequestEventData(
      const ::blink::KURL& top_origin,
      const ::blink::KURL& payment_request_origin,
      const ::blink::String& payment_request_id,
      ::blink::Vector<::payments::mojom::blink::PaymentMethodDataPtr> method_data,
      ::payments::mojom::blink::PaymentCurrencyAmountPtr total,
      ::blink::Vector<::payments::mojom::blink::PaymentDetailsModifierPtr> modifiers,
      const ::blink::String& instrument_key,
      ::payments::mojom::blink::PaymentOptionsPtr payment_options,
      std::optional<::blink::Vector<::payments::mojom::blink::PaymentShippingOptionPtr>> shipping_options,
      ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerHost> payment_handler_host);

PaymentRequestEventData(const PaymentRequestEventData&) = delete;
PaymentRequestEventData& operator=(const PaymentRequestEventData&) = delete;

  ~PaymentRequestEventData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentRequestEventDataPtr>
  PaymentRequestEventDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentRequestEventData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentRequestEventData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentRequestEventData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentRequestEventData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentRequestEventData_UnserializedMessageContext<
            UserType, PaymentRequestEventData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentRequestEventData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentRequestEventData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentRequestEventData_UnserializedMessageContext<
            UserType, PaymentRequestEventData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentRequestEventData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL top_origin;
  
  ::blink::KURL payment_request_origin;
  
  ::blink::String payment_request_id;
  
  ::blink::Vector<::payments::mojom::blink::PaymentMethodDataPtr> method_data;
  
  ::payments::mojom::blink::PaymentCurrencyAmountPtr total;
  
  ::blink::Vector<::payments::mojom::blink::PaymentDetailsModifierPtr> modifiers;
  
  ::blink::String instrument_key;
  
  ::payments::mojom::blink::PaymentOptionsPtr payment_options;
  
  std::optional<::blink::Vector<::payments::mojom::blink::PaymentShippingOptionPtr>> shipping_options;
  
  ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerHost> payment_handler_host;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentRequestEventData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentRequestEventData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentRequestEventData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentRequestEventData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT PaymentHandlerResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentHandlerResponse, T>::value>;
  using DataView = PaymentHandlerResponseDataView;
  using Data_ = internal::PaymentHandlerResponse_Data;

  template <typename... Args>
  static PaymentHandlerResponsePtr New(Args&&... args) {
    return PaymentHandlerResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentHandlerResponsePtr From(const U& u) {
    return mojo::TypeConverter<PaymentHandlerResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentHandlerResponse>::Convert(*this);
  }


  PaymentHandlerResponse();

  PaymentHandlerResponse(
      const ::blink::String& method_name,
      const ::blink::String& stringified_details,
      PaymentEventResponseType response_type,
      const ::blink::String& payer_name,
      const ::blink::String& payer_email,
      const ::blink::String& payer_phone,
      ::payments::mojom::blink::PaymentAddressPtr shipping_address,
      const ::blink::String& shipping_option);

PaymentHandlerResponse(const PaymentHandlerResponse&) = delete;
PaymentHandlerResponse& operator=(const PaymentHandlerResponse&) = delete;

  ~PaymentHandlerResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentHandlerResponsePtr>
  PaymentHandlerResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentHandlerResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentHandlerResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentHandlerResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentHandlerResponse::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentHandlerResponse::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentHandlerResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentHandlerResponse_UnserializedMessageContext<
            UserType, PaymentHandlerResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentHandlerResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentHandlerResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentHandlerResponse_UnserializedMessageContext<
            UserType, PaymentHandlerResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentHandlerResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String method_name;
  
  ::blink::String stringified_details;
  
  PaymentEventResponseType response_type;
  
  ::blink::String payer_name;
  
  ::blink::String payer_email;
  
  ::blink::String payer_phone;
  
  ::payments::mojom::blink::PaymentAddressPtr shipping_address;
  
  ::blink::String shipping_option;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentHandlerResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentHandlerResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentHandlerResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentHandlerResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PaymentInstrumentPtr PaymentInstrument::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(icons),
      mojo::Clone(method)
  );
}

template <typename T, PaymentInstrument::EnableIfSame<T>*>
bool PaymentInstrument::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  return true;
}

template <typename T, PaymentInstrument::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.icons < rhs.icons)
    return true;
  if (rhs.icons < lhs.icons)
    return false;
  if (lhs.method < rhs.method)
    return true;
  if (rhs.method < lhs.method)
    return false;
  return false;
}
template <typename StructPtrType>
CanMakePaymentEventDataPtr CanMakePaymentEventData::Clone() const {
  return New(
      mojo::Clone(top_origin),
      mojo::Clone(payment_request_origin),
      mojo::Clone(method_data),
      mojo::Clone(modifiers)
  );
}

template <typename T, CanMakePaymentEventData::EnableIfSame<T>*>
bool CanMakePaymentEventData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top_origin, other_struct.top_origin))
    return false;
  if (!mojo::Equals(this->payment_request_origin, other_struct.payment_request_origin))
    return false;
  if (!mojo::Equals(this->method_data, other_struct.method_data))
    return false;
  if (!mojo::Equals(this->modifiers, other_struct.modifiers))
    return false;
  return true;
}

template <typename T, CanMakePaymentEventData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.top_origin < rhs.top_origin)
    return true;
  if (rhs.top_origin < lhs.top_origin)
    return false;
  if (lhs.payment_request_origin < rhs.payment_request_origin)
    return true;
  if (rhs.payment_request_origin < lhs.payment_request_origin)
    return false;
  if (lhs.method_data < rhs.method_data)
    return true;
  if (rhs.method_data < lhs.method_data)
    return false;
  if (lhs.modifiers < rhs.modifiers)
    return true;
  if (rhs.modifiers < lhs.modifiers)
    return false;
  return false;
}
template <typename StructPtrType>
PaymentRequestEventDataPtr PaymentRequestEventData::Clone() const {
  return New(
      mojo::Clone(top_origin),
      mojo::Clone(payment_request_origin),
      mojo::Clone(payment_request_id),
      mojo::Clone(method_data),
      mojo::Clone(total),
      mojo::Clone(modifiers),
      mojo::Clone(instrument_key),
      mojo::Clone(payment_options),
      mojo::Clone(shipping_options),
      mojo::Clone(payment_handler_host)
  );
}

template <typename T, PaymentRequestEventData::EnableIfSame<T>*>
bool PaymentRequestEventData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top_origin, other_struct.top_origin))
    return false;
  if (!mojo::Equals(this->payment_request_origin, other_struct.payment_request_origin))
    return false;
  if (!mojo::Equals(this->payment_request_id, other_struct.payment_request_id))
    return false;
  if (!mojo::Equals(this->method_data, other_struct.method_data))
    return false;
  if (!mojo::Equals(this->total, other_struct.total))
    return false;
  if (!mojo::Equals(this->modifiers, other_struct.modifiers))
    return false;
  if (!mojo::Equals(this->instrument_key, other_struct.instrument_key))
    return false;
  if (!mojo::Equals(this->payment_options, other_struct.payment_options))
    return false;
  if (!mojo::Equals(this->shipping_options, other_struct.shipping_options))
    return false;
  if (!mojo::Equals(this->payment_handler_host, other_struct.payment_handler_host))
    return false;
  return true;
}

template <typename T, PaymentRequestEventData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.top_origin < rhs.top_origin)
    return true;
  if (rhs.top_origin < lhs.top_origin)
    return false;
  if (lhs.payment_request_origin < rhs.payment_request_origin)
    return true;
  if (rhs.payment_request_origin < lhs.payment_request_origin)
    return false;
  if (lhs.payment_request_id < rhs.payment_request_id)
    return true;
  if (rhs.payment_request_id < lhs.payment_request_id)
    return false;
  if (lhs.method_data < rhs.method_data)
    return true;
  if (rhs.method_data < lhs.method_data)
    return false;
  if (lhs.total < rhs.total)
    return true;
  if (rhs.total < lhs.total)
    return false;
  if (lhs.modifiers < rhs.modifiers)
    return true;
  if (rhs.modifiers < lhs.modifiers)
    return false;
  if (lhs.instrument_key < rhs.instrument_key)
    return true;
  if (rhs.instrument_key < lhs.instrument_key)
    return false;
  if (lhs.payment_options < rhs.payment_options)
    return true;
  if (rhs.payment_options < lhs.payment_options)
    return false;
  if (lhs.shipping_options < rhs.shipping_options)
    return true;
  if (rhs.shipping_options < lhs.shipping_options)
    return false;
  if (lhs.payment_handler_host < rhs.payment_handler_host)
    return true;
  if (rhs.payment_handler_host < lhs.payment_handler_host)
    return false;
  return false;
}
template <typename StructPtrType>
CanMakePaymentResponsePtr CanMakePaymentResponse::Clone() const {
  return New(
      mojo::Clone(response_type),
      mojo::Clone(can_make_payment)
  );
}

template <typename T, CanMakePaymentResponse::EnableIfSame<T>*>
bool CanMakePaymentResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->response_type, other_struct.response_type))
    return false;
  if (!mojo::Equals(this->can_make_payment, other_struct.can_make_payment))
    return false;
  return true;
}

template <typename T, CanMakePaymentResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.response_type < rhs.response_type)
    return true;
  if (rhs.response_type < lhs.response_type)
    return false;
  if (lhs.can_make_payment < rhs.can_make_payment)
    return true;
  if (rhs.can_make_payment < lhs.can_make_payment)
    return false;
  return false;
}
template <typename StructPtrType>
PaymentHandlerResponsePtr PaymentHandlerResponse::Clone() const {
  return New(
      mojo::Clone(method_name),
      mojo::Clone(stringified_details),
      mojo::Clone(response_type),
      mojo::Clone(payer_name),
      mojo::Clone(payer_email),
      mojo::Clone(payer_phone),
      mojo::Clone(shipping_address),
      mojo::Clone(shipping_option)
  );
}

template <typename T, PaymentHandlerResponse::EnableIfSame<T>*>
bool PaymentHandlerResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->method_name, other_struct.method_name))
    return false;
  if (!mojo::Equals(this->stringified_details, other_struct.stringified_details))
    return false;
  if (!mojo::Equals(this->response_type, other_struct.response_type))
    return false;
  if (!mojo::Equals(this->payer_name, other_struct.payer_name))
    return false;
  if (!mojo::Equals(this->payer_email, other_struct.payer_email))
    return false;
  if (!mojo::Equals(this->payer_phone, other_struct.payer_phone))
    return false;
  if (!mojo::Equals(this->shipping_address, other_struct.shipping_address))
    return false;
  if (!mojo::Equals(this->shipping_option, other_struct.shipping_option))
    return false;
  return true;
}

template <typename T, PaymentHandlerResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.method_name < rhs.method_name)
    return true;
  if (rhs.method_name < lhs.method_name)
    return false;
  if (lhs.stringified_details < rhs.stringified_details)
    return true;
  if (rhs.stringified_details < lhs.stringified_details)
    return false;
  if (lhs.response_type < rhs.response_type)
    return true;
  if (rhs.response_type < lhs.response_type)
    return false;
  if (lhs.payer_name < rhs.payer_name)
    return true;
  if (rhs.payer_name < lhs.payer_name)
    return false;
  if (lhs.payer_email < rhs.payer_email)
    return true;
  if (rhs.payer_email < lhs.payer_email)
    return false;
  if (lhs.payer_phone < rhs.payer_phone)
    return true;
  if (rhs.payer_phone < lhs.payer_phone)
    return false;
  if (lhs.shipping_address < rhs.shipping_address)
    return true;
  if (rhs.shipping_address < lhs.shipping_address)
    return false;
  if (lhs.shipping_option < rhs.shipping_option)
    return true;
  if (rhs.shipping_option < lhs.shipping_option)
    return false;
  return false;
}


}  // payments::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::PaymentInstrument::DataView,
                                         ::payments::mojom::blink::PaymentInstrumentPtr> {
  static bool IsNull(const ::payments::mojom::blink::PaymentInstrumentPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::PaymentInstrumentPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::blink::PaymentInstrument::name)& name(
      const ::payments::mojom::blink::PaymentInstrumentPtr& input) {
    return input->name;
  }

  static const decltype(::payments::mojom::blink::PaymentInstrument::icons)& icons(
      const ::payments::mojom::blink::PaymentInstrumentPtr& input) {
    return input->icons;
  }

  static const decltype(::payments::mojom::blink::PaymentInstrument::method)& method(
      const ::payments::mojom::blink::PaymentInstrumentPtr& input) {
    return input->method;
  }

  static bool Read(::payments::mojom::blink::PaymentInstrument::DataView input, ::payments::mojom::blink::PaymentInstrumentPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::CanMakePaymentEventData::DataView,
                                         ::payments::mojom::blink::CanMakePaymentEventDataPtr> {
  static bool IsNull(const ::payments::mojom::blink::CanMakePaymentEventDataPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::CanMakePaymentEventDataPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::blink::CanMakePaymentEventData::top_origin)& top_origin(
      const ::payments::mojom::blink::CanMakePaymentEventDataPtr& input) {
    return input->top_origin;
  }

  static const decltype(::payments::mojom::blink::CanMakePaymentEventData::payment_request_origin)& payment_request_origin(
      const ::payments::mojom::blink::CanMakePaymentEventDataPtr& input) {
    return input->payment_request_origin;
  }

  static const decltype(::payments::mojom::blink::CanMakePaymentEventData::method_data)& method_data(
      const ::payments::mojom::blink::CanMakePaymentEventDataPtr& input) {
    return input->method_data;
  }

  static const decltype(::payments::mojom::blink::CanMakePaymentEventData::modifiers)& modifiers(
      const ::payments::mojom::blink::CanMakePaymentEventDataPtr& input) {
    return input->modifiers;
  }

  static bool Read(::payments::mojom::blink::CanMakePaymentEventData::DataView input, ::payments::mojom::blink::CanMakePaymentEventDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::PaymentRequestEventData::DataView,
                                         ::payments::mojom::blink::PaymentRequestEventDataPtr> {
  static bool IsNull(const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::PaymentRequestEventDataPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::top_origin)& top_origin(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->top_origin;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::payment_request_origin)& payment_request_origin(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->payment_request_origin;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::payment_request_id)& payment_request_id(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->payment_request_id;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::method_data)& method_data(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->method_data;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::total)& total(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->total;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::modifiers)& modifiers(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->modifiers;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::instrument_key)& instrument_key(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->instrument_key;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::payment_options)& payment_options(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->payment_options;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::shipping_options)& shipping_options(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->shipping_options;
  }

  static  decltype(::payments::mojom::blink::PaymentRequestEventData::payment_handler_host)& payment_handler_host(
       ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->payment_handler_host;
  }

  static bool Read(::payments::mojom::blink::PaymentRequestEventData::DataView input, ::payments::mojom::blink::PaymentRequestEventDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::CanMakePaymentResponse::DataView,
                                         ::payments::mojom::blink::CanMakePaymentResponsePtr> {
  static bool IsNull(const ::payments::mojom::blink::CanMakePaymentResponsePtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::CanMakePaymentResponsePtr* output) { output->reset(); }

  static decltype(::payments::mojom::blink::CanMakePaymentResponse::response_type) response_type(
      const ::payments::mojom::blink::CanMakePaymentResponsePtr& input) {
    return input->response_type;
  }

  static decltype(::payments::mojom::blink::CanMakePaymentResponse::can_make_payment) can_make_payment(
      const ::payments::mojom::blink::CanMakePaymentResponsePtr& input) {
    return input->can_make_payment;
  }

  static bool Read(::payments::mojom::blink::CanMakePaymentResponse::DataView input, ::payments::mojom::blink::CanMakePaymentResponsePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::PaymentHandlerResponse::DataView,
                                         ::payments::mojom::blink::PaymentHandlerResponsePtr> {
  static bool IsNull(const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::PaymentHandlerResponsePtr* output) { output->reset(); }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::method_name)& method_name(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->method_name;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::stringified_details)& stringified_details(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->stringified_details;
  }

  static decltype(::payments::mojom::blink::PaymentHandlerResponse::response_type) response_type(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->response_type;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::payer_name)& payer_name(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->payer_name;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::payer_email)& payer_email(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->payer_email;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::payer_phone)& payer_phone(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->payer_phone;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::shipping_address)& shipping_address(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->shipping_address;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::shipping_option)& shipping_option(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->shipping_option;
  }

  static bool Read(::payments::mojom::blink::PaymentHandlerResponse::DataView input, ::payments::mojom::blink::PaymentHandlerResponsePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_BLINK_H_