// third_party/blink/public/mojom/partitioned_popins/partitioned_popin_params.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/partitioned_popins/partitioned_popin_params.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var site_for_cookies$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/site_for_cookies.mojom', '../../../../../services/network/public/mojom/site_for_cookies.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }



  function PartitionedPopinParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PartitionedPopinParams.prototype.initDefaults_ = function() {
    this.openerTopFrameOrigin = null;
    this.openerSiteForCookies = null;
  };
  PartitionedPopinParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PartitionedPopinParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PartitionedPopinParams.openerTopFrameOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PartitionedPopinParams.openerSiteForCookies
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, site_for_cookies$.SiteForCookies, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PartitionedPopinParams.encodedSize = codec.kStructHeaderSize + 16;

  PartitionedPopinParams.decode = function(decoder) {
    var packed;
    var val = new PartitionedPopinParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.openerTopFrameOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.openerSiteForCookies =
        decoder.decodeStructPointer(site_for_cookies$.SiteForCookies);
    return val;
  };

  PartitionedPopinParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PartitionedPopinParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.openerTopFrameOrigin);
    encoder.encodeStructPointer(site_for_cookies$.SiteForCookies, val.openerSiteForCookies);
  };
  exports.PartitionedPopinParams = PartitionedPopinParams;
})();