// third_party/blink/public/mojom/page_state/page_state.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/page_state/page_state.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "third_party/blink/public/mojom/page_state/page_state.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::ScrollRestorationType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DEPRECATED_FileSystemFileDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DEPRECATED_FileSystemFileDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DEPRECATED_FileSystemFile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::filesystem_url(input)) in_filesystem_url = Traits::filesystem_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filesystem_url)::BaseType> filesystem_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_filesystem_url,
        filesystem_url_fragment);

      fragment->filesystem_url.Set(
          filesystem_url_fragment.is_null() ? nullptr : filesystem_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filesystem_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filesystem_url in DEPRECATED_FileSystemFile struct");

      fragment->offset = Traits::offset(input);

      fragment->length = Traits::length(input);

      decltype(Traits::modification_time(input)) in_modification_time = Traits::modification_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->modification_time)::BaseType> modification_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_modification_time,
        modification_time_fragment);

      fragment->modification_time.Set(
          modification_time_fragment.is_null() ? nullptr : modification_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->modification_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null modification_time in DEPRECATED_FileSystemFile struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FileDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FileDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::File_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::path(input)) in_path = Traits::path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->path)::BaseType> path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_path,
        path_fragment);

      fragment->path.Set(
          path_fragment.is_null() ? nullptr : path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in File struct");

      fragment->offset = Traits::offset(input);

      fragment->length = Traits::length(input);

      decltype(Traits::modification_time(input)) in_modification_time = Traits::modification_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->modification_time)::BaseType> modification_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_modification_time,
        modification_time_fragment);

      fragment->modification_time.Set(
          modification_time_fragment.is_null() ? nullptr : modification_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->modification_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null modification_time in File struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::RequestBodyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::RequestBodyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::RequestBody_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::elements(input)) in_elements = Traits::elements(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->elements)::BaseType>
          elements_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ElementDataView>, send_validation>(
        in_elements,
        elements_fragment,
        &elements_validate_params);

      fragment->elements.Set(
          elements_fragment.is_null() ? nullptr : elements_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->elements.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null elements in RequestBody struct");

      fragment->identifier = Traits::identifier(input);

      fragment->contains_sensitive_info = Traits::contains_sensitive_info(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::HttpBodyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::HttpBodyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::HttpBody_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::http_content_type(input)) in_http_content_type = Traits::http_content_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->http_content_type)::BaseType> http_content_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_http_content_type,
        http_content_type_fragment);

      fragment->http_content_type.Set(
          http_content_type_fragment.is_null() ? nullptr : http_content_type_fragment.data());

      decltype(Traits::request_body(input)) in_request_body = Traits::request_body(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->request_body)::BaseType> request_body_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::RequestBodyDataView, send_validation>(
        in_request_body,
        request_body_fragment);

      fragment->request_body.Set(
          request_body_fragment.is_null() ? nullptr : request_body_fragment.data());

      fragment->contains_passwords = Traits::contains_passwords(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ViewStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ViewStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ViewState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::visual_viewport_scroll_offset(input)) in_visual_viewport_scroll_offset = Traits::visual_viewport_scroll_offset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->visual_viewport_scroll_offset)::BaseType> visual_viewport_scroll_offset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_visual_viewport_scroll_offset,
        visual_viewport_scroll_offset_fragment);

      fragment->visual_viewport_scroll_offset.Set(
          visual_viewport_scroll_offset_fragment.is_null() ? nullptr : visual_viewport_scroll_offset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->visual_viewport_scroll_offset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visual_viewport_scroll_offset in ViewState struct");

      decltype(Traits::scroll_offset(input)) in_scroll_offset = Traits::scroll_offset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scroll_offset)::BaseType> scroll_offset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_scroll_offset,
        scroll_offset_fragment);

      fragment->scroll_offset.Set(
          scroll_offset_fragment.is_null() ? nullptr : scroll_offset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scroll_offset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_offset in ViewState struct");

      fragment->page_scale_factor = Traits::page_scale_factor(input);

      decltype(Traits::scroll_anchor_selector(input)) in_scroll_anchor_selector = Traits::scroll_anchor_selector(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scroll_anchor_selector)::BaseType> scroll_anchor_selector_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_scroll_anchor_selector,
        scroll_anchor_selector_fragment);

      fragment->scroll_anchor_selector.Set(
          scroll_anchor_selector_fragment.is_null() ? nullptr : scroll_anchor_selector_fragment.data());

      decltype(Traits::scroll_anchor_offset(input)) in_scroll_anchor_offset = Traits::scroll_anchor_offset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scroll_anchor_offset)::BaseType> scroll_anchor_offset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_scroll_anchor_offset,
        scroll_anchor_offset_fragment);

      fragment->scroll_anchor_offset.Set(
          scroll_anchor_offset_fragment.is_null() ? nullptr : scroll_anchor_offset_fragment.data());

      fragment->scroll_anchor_simhash = Traits::scroll_anchor_simhash(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FrameStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FrameStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FrameState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url_string(input)) in_url_string = Traits::url_string(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url_string)::BaseType> url_string_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_url_string,
        url_string_fragment);

      fragment->url_string.Set(
          url_string_fragment.is_null() ? nullptr : url_string_fragment.data());

      decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->referrer)::BaseType> referrer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_referrer,
        referrer_fragment);

      fragment->referrer.Set(
          referrer_fragment.is_null() ? nullptr : referrer_fragment.data());

      decltype(Traits::target(input)) in_target = Traits::target(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->target)::BaseType> target_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_target,
        target_fragment);

      fragment->target.Set(
          target_fragment.is_null() ? nullptr : target_fragment.data());

      decltype(Traits::state_object(input)) in_state_object = Traits::state_object(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->state_object)::BaseType> state_object_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_state_object,
        state_object_fragment);

      fragment->state_object.Set(
          state_object_fragment.is_null() ? nullptr : state_object_fragment.data());

      decltype(Traits::document_state(input)) in_document_state = Traits::document_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->document_state)::BaseType>
          document_state_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& document_state_validate_params =
          mojo::internal::GetArrayValidator<0, true, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>, send_validation>(
        in_document_state,
        document_state_fragment,
        &document_state_validate_params);

      fragment->document_state.Set(
          document_state_fragment.is_null() ? nullptr : document_state_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->document_state.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null document_state in FrameState struct");

      
      mojo::internal::Serialize<::blink::mojom::ScrollRestorationType>(
        Traits::scroll_restoration_type(input),
        &fragment->scroll_restoration_type);

      decltype(Traits::view_state(input)) in_view_state = Traits::view_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->view_state)::BaseType> view_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ViewStateDataView, send_validation>(
        in_view_state,
        view_state_fragment);

      fragment->view_state.Set(
          view_state_fragment.is_null() ? nullptr : view_state_fragment.data());

      fragment->item_sequence_number = Traits::item_sequence_number(input);

      fragment->document_sequence_number = Traits::document_sequence_number(input);

      
      mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
        Traits::referrer_policy(input),
        &fragment->referrer_policy);

      decltype(Traits::http_body(input)) in_http_body = Traits::http_body(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->http_body)::BaseType> http_body_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::HttpBodyDataView, send_validation>(
        in_http_body,
        http_body_fragment);

      fragment->http_body.Set(
          http_body_fragment.is_null() ? nullptr : http_body_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->http_body.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null http_body in FrameState struct");

      decltype(Traits::children(input)) in_children = Traits::children(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->children)::BaseType>
          children_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FrameStateDataView>, send_validation>(
        in_children,
        children_fragment,
        &children_validate_params);

      fragment->children.Set(
          children_fragment.is_null() ? nullptr : children_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->children.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null children in FrameState struct");

      decltype(Traits::initiator_origin(input)) in_initiator_origin = Traits::initiator_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->initiator_origin)::BaseType> initiator_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_initiator_origin,
        initiator_origin_fragment);

      fragment->initiator_origin.Set(
          initiator_origin_fragment.is_null() ? nullptr : initiator_origin_fragment.data());

      decltype(Traits::navigation_api_key(input)) in_navigation_api_key = Traits::navigation_api_key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->navigation_api_key)::BaseType> navigation_api_key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_navigation_api_key,
        navigation_api_key_fragment);

      fragment->navigation_api_key.Set(
          navigation_api_key_fragment.is_null() ? nullptr : navigation_api_key_fragment.data());

      decltype(Traits::navigation_api_id(input)) in_navigation_api_id = Traits::navigation_api_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->navigation_api_id)::BaseType> navigation_api_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_navigation_api_id,
        navigation_api_id_fragment);

      fragment->navigation_api_id.Set(
          navigation_api_id_fragment.is_null() ? nullptr : navigation_api_id_fragment.data());

      decltype(Traits::navigation_api_state(input)) in_navigation_api_state = Traits::navigation_api_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->navigation_api_state)::BaseType> navigation_api_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_navigation_api_state,
        navigation_api_state_fragment);

      fragment->navigation_api_state.Set(
          navigation_api_state_fragment.is_null() ? nullptr : navigation_api_state_fragment.data());

      fragment->protect_url_in_navigation_api = Traits::protect_url_in_navigation_api(input);

      decltype(Traits::initiator_base_url_string(input)) in_initiator_base_url_string = Traits::initiator_base_url_string(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->initiator_base_url_string)::BaseType> initiator_base_url_string_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_initiator_base_url_string,
        initiator_base_url_string_fragment);

      fragment->initiator_base_url_string.Set(
          initiator_base_url_string_fragment.is_null() ? nullptr : initiator_base_url_string_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PageStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PageStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PageState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::referenced_files(input)) in_referenced_files = Traits::referenced_files(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->referenced_files)::BaseType>
          referenced_files_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& referenced_files_validate_params =
          mojo::internal::GetArrayValidator<0, true, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>, send_validation>(
        in_referenced_files,
        referenced_files_fragment,
        &referenced_files_validate_params);

      fragment->referenced_files.Set(
          referenced_files_fragment.is_null() ? nullptr : referenced_files_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->referenced_files.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referenced_files in PageState struct");

      decltype(Traits::top(input)) in_top = Traits::top(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->top)::BaseType> top_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::FrameStateDataView, send_validation>(
        in_top,
        top_fragment);

      fragment->top.Set(
          top_fragment.is_null() ? nullptr : top_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->top.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top in PageState struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ElementDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::ElementDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::Element_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::ElementDataView::Tag::kBlobUuid: {
    decltype(Traits::blob_uuid(input))
    in_blob_uuid = Traits::blob_uuid(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_blob_uuid)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_blob_uuid,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null blob_uuid in Element union");
    fragment->data.f_blob_uuid.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::ElementDataView::Tag::kBytes: {
    decltype(Traits::bytes(input))
    in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_bytes)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
  in_bytes,
  value_fragment,
  &bytes_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null bytes in Element union");
    fragment->data.f_bytes.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::ElementDataView::Tag::kFile: {
    decltype(Traits::file(input))
    in_file = Traits::file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::FileDataView, send_validation>(
  in_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file in Element union");
    fragment->data.f_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::ElementDataView::Tag::kDeprecatedFileSystemFile: {
    decltype(Traits::DEPRECATED_file_system_file(input))
    in_DEPRECATED_file_system_file = Traits::DEPRECATED_file_system_file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_DEPRECATED_file_system_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DEPRECATED_FileSystemFileDataView, send_validation>(
  in_DEPRECATED_file_system_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null DEPRECATED_file_system_file in Element union");
    fragment->data.f_DEPRECATED_file_system_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_SEND_VALIDATION_H_