// third_party/blink/public/mojom/page/widget.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/page/widget.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/page/widget.mojom-params-data.h"
#include "third_party/blink/public/mojom/page/widget.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/page/widget.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/page/widget.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
StylusWritingFocusResult::StylusWritingFocusResult()
    : focused_edit_bounds(),
      caret_bounds() {}

StylusWritingFocusResult::StylusWritingFocusResult(
    const ::gfx::Rect& focused_edit_bounds_in,
    const ::gfx::Rect& caret_bounds_in)
    : focused_edit_bounds(std::move(focused_edit_bounds_in)),
      caret_bounds(std::move(caret_bounds_in)) {}

StylusWritingFocusResult::~StylusWritingFocusResult() = default;

void StylusWritingFocusResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "focused_edit_bounds"), this->focused_edit_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "caret_bounds"), this->caret_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StylusWritingFocusResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

FrameWidget::IPCStableHashFunction FrameWidget::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameWidget>(message.name())) {
    case messages::FrameWidget::kDragTargetDragEnter: {
      return &FrameWidget::DragTargetDragEnter_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kDragTargetDragOver: {
      return &FrameWidget::DragTargetDragOver_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kDragTargetDragLeave: {
      return &FrameWidget::DragTargetDragLeave_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kDragTargetDrop: {
      return &FrameWidget::DragTargetDrop_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kDragSourceEndedAt: {
      return &FrameWidget::DragSourceEndedAt_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kDragSourceSystemDragEnded: {
      return &FrameWidget::DragSourceSystemDragEnded_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kOnStartStylusWriting: {
      return &FrameWidget::OnStartStylusWriting_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kSetBackgroundOpaque: {
      return &FrameWidget::SetBackgroundOpaque_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kSetTextDirection: {
      return &FrameWidget::SetTextDirection_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kSetActive: {
      return &FrameWidget::SetActive_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kSetInheritedEffectiveTouchActionForSubFrame: {
      return &FrameWidget::SetInheritedEffectiveTouchActionForSubFrame_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kUpdateRenderThrottlingStatusForSubFrame: {
      return &FrameWidget::UpdateRenderThrottlingStatusForSubFrame_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kSetIsInertForSubFrame: {
      return &FrameWidget::SetIsInertForSubFrame_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kGetStringAtPoint: {
      return &FrameWidget::GetStringAtPoint_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kEnableDeviceEmulation: {
      return &FrameWidget::EnableDeviceEmulation_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kDisableDeviceEmulation: {
      return &FrameWidget::DisableDeviceEmulation_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kBindWidgetCompositor: {
      return &FrameWidget::BindWidgetCompositor_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kSetViewportIntersection: {
      return &FrameWidget::SetViewportIntersection_Sym::IPCStableHash;
    }
    case messages::FrameWidget::kNotifyClearedDisplayedGraphics: {
      return &FrameWidget::NotifyClearedDisplayedGraphics_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameWidget::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameWidget>(message.name())) {
      case messages::FrameWidget::kDragTargetDragEnter:
            return "Receive blink::mojom::FrameWidget::DragTargetDragEnter";
      case messages::FrameWidget::kDragTargetDragOver:
            return "Receive blink::mojom::FrameWidget::DragTargetDragOver";
      case messages::FrameWidget::kDragTargetDragLeave:
            return "Receive blink::mojom::FrameWidget::DragTargetDragLeave";
      case messages::FrameWidget::kDragTargetDrop:
            return "Receive blink::mojom::FrameWidget::DragTargetDrop";
      case messages::FrameWidget::kDragSourceEndedAt:
            return "Receive blink::mojom::FrameWidget::DragSourceEndedAt";
      case messages::FrameWidget::kDragSourceSystemDragEnded:
            return "Receive blink::mojom::FrameWidget::DragSourceSystemDragEnded";
      case messages::FrameWidget::kOnStartStylusWriting:
            return "Receive blink::mojom::FrameWidget::OnStartStylusWriting";
      case messages::FrameWidget::kSetBackgroundOpaque:
            return "Receive blink::mojom::FrameWidget::SetBackgroundOpaque";
      case messages::FrameWidget::kSetTextDirection:
            return "Receive blink::mojom::FrameWidget::SetTextDirection";
      case messages::FrameWidget::kSetActive:
            return "Receive blink::mojom::FrameWidget::SetActive";
      case messages::FrameWidget::kSetInheritedEffectiveTouchActionForSubFrame:
            return "Receive blink::mojom::FrameWidget::SetInheritedEffectiveTouchActionForSubFrame";
      case messages::FrameWidget::kUpdateRenderThrottlingStatusForSubFrame:
            return "Receive blink::mojom::FrameWidget::UpdateRenderThrottlingStatusForSubFrame";
      case messages::FrameWidget::kSetIsInertForSubFrame:
            return "Receive blink::mojom::FrameWidget::SetIsInertForSubFrame";
      case messages::FrameWidget::kGetStringAtPoint:
            return "Receive blink::mojom::FrameWidget::GetStringAtPoint";
      case messages::FrameWidget::kEnableDeviceEmulation:
            return "Receive blink::mojom::FrameWidget::EnableDeviceEmulation";
      case messages::FrameWidget::kDisableDeviceEmulation:
            return "Receive blink::mojom::FrameWidget::DisableDeviceEmulation";
      case messages::FrameWidget::kBindWidgetCompositor:
            return "Receive blink::mojom::FrameWidget::BindWidgetCompositor";
      case messages::FrameWidget::kSetViewportIntersection:
            return "Receive blink::mojom::FrameWidget::SetViewportIntersection";
      case messages::FrameWidget::kNotifyClearedDisplayedGraphics:
            return "Receive blink::mojom::FrameWidget::NotifyClearedDisplayedGraphics";
    }
  } else {
    switch (static_cast<messages::FrameWidget>(message.name())) {
      case messages::FrameWidget::kDragTargetDragEnter:
            return "Receive reply blink::mojom::FrameWidget::DragTargetDragEnter";
      case messages::FrameWidget::kDragTargetDragOver:
            return "Receive reply blink::mojom::FrameWidget::DragTargetDragOver";
      case messages::FrameWidget::kDragTargetDragLeave:
            return "Receive reply blink::mojom::FrameWidget::DragTargetDragLeave";
      case messages::FrameWidget::kDragTargetDrop:
            return "Receive reply blink::mojom::FrameWidget::DragTargetDrop";
      case messages::FrameWidget::kDragSourceEndedAt:
            return "Receive reply blink::mojom::FrameWidget::DragSourceEndedAt";
      case messages::FrameWidget::kDragSourceSystemDragEnded:
            return "Receive reply blink::mojom::FrameWidget::DragSourceSystemDragEnded";
      case messages::FrameWidget::kOnStartStylusWriting:
            return "Receive reply blink::mojom::FrameWidget::OnStartStylusWriting";
      case messages::FrameWidget::kSetBackgroundOpaque:
            return "Receive reply blink::mojom::FrameWidget::SetBackgroundOpaque";
      case messages::FrameWidget::kSetTextDirection:
            return "Receive reply blink::mojom::FrameWidget::SetTextDirection";
      case messages::FrameWidget::kSetActive:
            return "Receive reply blink::mojom::FrameWidget::SetActive";
      case messages::FrameWidget::kSetInheritedEffectiveTouchActionForSubFrame:
            return "Receive reply blink::mojom::FrameWidget::SetInheritedEffectiveTouchActionForSubFrame";
      case messages::FrameWidget::kUpdateRenderThrottlingStatusForSubFrame:
            return "Receive reply blink::mojom::FrameWidget::UpdateRenderThrottlingStatusForSubFrame";
      case messages::FrameWidget::kSetIsInertForSubFrame:
            return "Receive reply blink::mojom::FrameWidget::SetIsInertForSubFrame";
      case messages::FrameWidget::kGetStringAtPoint:
            return "Receive reply blink::mojom::FrameWidget::GetStringAtPoint";
      case messages::FrameWidget::kEnableDeviceEmulation:
            return "Receive reply blink::mojom::FrameWidget::EnableDeviceEmulation";
      case messages::FrameWidget::kDisableDeviceEmulation:
            return "Receive reply blink::mojom::FrameWidget::DisableDeviceEmulation";
      case messages::FrameWidget::kBindWidgetCompositor:
            return "Receive reply blink::mojom::FrameWidget::BindWidgetCompositor";
      case messages::FrameWidget::kSetViewportIntersection:
            return "Receive reply blink::mojom::FrameWidget::SetViewportIntersection";
      case messages::FrameWidget::kNotifyClearedDisplayedGraphics:
            return "Receive reply blink::mojom::FrameWidget::NotifyClearedDisplayedGraphics";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameWidget::DragTargetDragEnter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7f02f14f;  // IPCStableHash for blink::mojom::FrameWidget::DragTargetDragEnter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::DragTargetDragOver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xca061108;  // IPCStableHash for blink::mojom::FrameWidget::DragTargetDragOver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::DragTargetDragLeave_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2315cdae;  // IPCStableHash for blink::mojom::FrameWidget::DragTargetDragLeave
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::DragTargetDrop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc6b5e1dc;  // IPCStableHash for blink::mojom::FrameWidget::DragTargetDrop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::DragSourceEndedAt_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcb2ac78a;  // IPCStableHash for blink::mojom::FrameWidget::DragSourceEndedAt
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::DragSourceSystemDragEnded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x692736aa;  // IPCStableHash for blink::mojom::FrameWidget::DragSourceSystemDragEnded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::OnStartStylusWriting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5e92078a;  // IPCStableHash for blink::mojom::FrameWidget::OnStartStylusWriting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::SetBackgroundOpaque_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf40904bd;  // IPCStableHash for blink::mojom::FrameWidget::SetBackgroundOpaque
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::SetTextDirection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8c8719de;  // IPCStableHash for blink::mojom::FrameWidget::SetTextDirection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::SetActive_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa85d30ad;  // IPCStableHash for blink::mojom::FrameWidget::SetActive
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::SetInheritedEffectiveTouchActionForSubFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x736c01c0;  // IPCStableHash for blink::mojom::FrameWidget::SetInheritedEffectiveTouchActionForSubFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::UpdateRenderThrottlingStatusForSubFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5b2932bc;  // IPCStableHash for blink::mojom::FrameWidget::UpdateRenderThrottlingStatusForSubFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::SetIsInertForSubFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ddaec07;  // IPCStableHash for blink::mojom::FrameWidget::SetIsInertForSubFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::GetStringAtPoint_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf4d675bc;  // IPCStableHash for blink::mojom::FrameWidget::GetStringAtPoint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::EnableDeviceEmulation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0d9fb990;  // IPCStableHash for blink::mojom::FrameWidget::EnableDeviceEmulation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::DisableDeviceEmulation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f64b98f;  // IPCStableHash for blink::mojom::FrameWidget::DisableDeviceEmulation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::BindWidgetCompositor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x658092bc;  // IPCStableHash for blink::mojom::FrameWidget::BindWidgetCompositor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::SetViewportIntersection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x62b090e3;  // IPCStableHash for blink::mojom::FrameWidget::SetViewportIntersection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidget::NotifyClearedDisplayedGraphics_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x38258701;  // IPCStableHash for blink::mojom::FrameWidget::NotifyClearedDisplayedGraphics
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FrameWidget_DragTargetDragEnter_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameWidget_DragTargetDragEnter_ForwardToCallback(
      FrameWidget::DragTargetDragEnterCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameWidget_DragTargetDragEnter_ForwardToCallback(const FrameWidget_DragTargetDragEnter_ForwardToCallback&) = delete;
  FrameWidget_DragTargetDragEnter_ForwardToCallback& operator=(const FrameWidget_DragTargetDragEnter_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameWidget::DragTargetDragEnterCallback callback_;
};

class FrameWidget_DragTargetDragOver_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameWidget_DragTargetDragOver_ForwardToCallback(
      FrameWidget::DragTargetDragOverCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameWidget_DragTargetDragOver_ForwardToCallback(const FrameWidget_DragTargetDragOver_ForwardToCallback&) = delete;
  FrameWidget_DragTargetDragOver_ForwardToCallback& operator=(const FrameWidget_DragTargetDragOver_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameWidget::DragTargetDragOverCallback callback_;
};

class FrameWidget_DragTargetDrop_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameWidget_DragTargetDrop_ForwardToCallback(
      FrameWidget::DragTargetDropCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameWidget_DragTargetDrop_ForwardToCallback(const FrameWidget_DragTargetDrop_ForwardToCallback&) = delete;
  FrameWidget_DragTargetDrop_ForwardToCallback& operator=(const FrameWidget_DragTargetDrop_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameWidget::DragTargetDropCallback callback_;
};

class FrameWidget_DragSourceEndedAt_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameWidget_DragSourceEndedAt_ForwardToCallback(
      FrameWidget::DragSourceEndedAtCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameWidget_DragSourceEndedAt_ForwardToCallback(const FrameWidget_DragSourceEndedAt_ForwardToCallback&) = delete;
  FrameWidget_DragSourceEndedAt_ForwardToCallback& operator=(const FrameWidget_DragSourceEndedAt_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameWidget::DragSourceEndedAtCallback callback_;
};

class FrameWidget_OnStartStylusWriting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameWidget_OnStartStylusWriting_ForwardToCallback(
      FrameWidget::OnStartStylusWritingCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameWidget_OnStartStylusWriting_ForwardToCallback(const FrameWidget_OnStartStylusWriting_ForwardToCallback&) = delete;
  FrameWidget_OnStartStylusWriting_ForwardToCallback& operator=(const FrameWidget_OnStartStylusWriting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameWidget::OnStartStylusWritingCallback callback_;
};

class FrameWidget_GetStringAtPoint_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameWidget_GetStringAtPoint_ForwardToCallback(
      FrameWidget::GetStringAtPointCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameWidget_GetStringAtPoint_ForwardToCallback(const FrameWidget_GetStringAtPoint_ForwardToCallback&) = delete;
  FrameWidget_GetStringAtPoint_ForwardToCallback& operator=(const FrameWidget_GetStringAtPoint_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameWidget::GetStringAtPointCallback callback_;
};

FrameWidgetProxy::FrameWidgetProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameWidgetProxy::DragTargetDragEnter(
    const ::blink::WebDragData& in_drag_data, const ::gfx::PointF& in_point_in_viewport, const ::gfx::PointF& in_screen_point, ::blink::DragOperationsMask in_operations_allowed, uint32_t in_key_modifiers, DragTargetDragEnterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::DragTargetDragEnter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drag_data"), in_drag_data,
                        "<value of type const ::blink::WebDragData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point_in_viewport"), in_point_in_viewport,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("screen_point"), in_screen_point,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operations_allowed"), in_operations_allowed,
                        "<value of type ::blink::DragOperationsMask>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_modifiers"), in_key_modifiers,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kDragTargetDragEnter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_DragTargetDragEnter_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->drag_data)::BaseType> drag_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DragDataDataView>(
    in_drag_data,
    drag_data_fragment);

  params->drag_data.Set(
      drag_data_fragment.is_null() ? nullptr : drag_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->drag_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null drag_data in FrameWidget.DragTargetDragEnter request");
  mojo::internal::MessageFragment<
      typename decltype(params->point_in_viewport)::BaseType> point_in_viewport_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_point_in_viewport,
    point_in_viewport_fragment);

  params->point_in_viewport.Set(
      point_in_viewport_fragment.is_null() ? nullptr : point_in_viewport_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point_in_viewport.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point_in_viewport in FrameWidget.DragTargetDragEnter request");
  mojo::internal::MessageFragment<
      typename decltype(params->screen_point)::BaseType> screen_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_screen_point,
    screen_point_fragment);

  params->screen_point.Set(
      screen_point_fragment.is_null() ? nullptr : screen_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->screen_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null screen_point in FrameWidget.DragTargetDragEnter request");
  mojo::internal::MessageFragment<
      typename decltype(params->operations_allowed)::BaseType> operations_allowed_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AllowedDragOperationsDataView>(
    in_operations_allowed,
    operations_allowed_fragment);

  params->operations_allowed.Set(
      operations_allowed_fragment.is_null() ? nullptr : operations_allowed_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->operations_allowed.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null operations_allowed in FrameWidget.DragTargetDragEnter request");

  params->key_modifiers = in_key_modifiers;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragTargetDragEnter");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameWidget_DragTargetDragEnter_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameWidgetProxy::DragTargetDragOver(
    const ::gfx::PointF& in_point_in_viewport, const ::gfx::PointF& in_screen_point, ::blink::DragOperationsMask in_operations_allowed, uint32_t in_key_modifiers, DragTargetDragOverCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::DragTargetDragOver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point_in_viewport"), in_point_in_viewport,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("screen_point"), in_screen_point,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operations_allowed"), in_operations_allowed,
                        "<value of type ::blink::DragOperationsMask>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_modifiers"), in_key_modifiers,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kDragTargetDragOver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_DragTargetDragOver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point_in_viewport)::BaseType> point_in_viewport_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_point_in_viewport,
    point_in_viewport_fragment);

  params->point_in_viewport.Set(
      point_in_viewport_fragment.is_null() ? nullptr : point_in_viewport_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point_in_viewport.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point_in_viewport in FrameWidget.DragTargetDragOver request");
  mojo::internal::MessageFragment<
      typename decltype(params->screen_point)::BaseType> screen_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_screen_point,
    screen_point_fragment);

  params->screen_point.Set(
      screen_point_fragment.is_null() ? nullptr : screen_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->screen_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null screen_point in FrameWidget.DragTargetDragOver request");
  mojo::internal::MessageFragment<
      typename decltype(params->operations_allowed)::BaseType> operations_allowed_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AllowedDragOperationsDataView>(
    in_operations_allowed,
    operations_allowed_fragment);

  params->operations_allowed.Set(
      operations_allowed_fragment.is_null() ? nullptr : operations_allowed_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->operations_allowed.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null operations_allowed in FrameWidget.DragTargetDragOver request");

  params->key_modifiers = in_key_modifiers;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragTargetDragOver");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameWidget_DragTargetDragOver_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameWidgetProxy::DragTargetDragLeave(
    const ::gfx::PointF& in_point_in_viewport, const ::gfx::PointF& in_screen_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::DragTargetDragLeave", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point_in_viewport"), in_point_in_viewport,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("screen_point"), in_screen_point,
                        "<value of type const ::gfx::PointF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kDragTargetDragLeave), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_DragTargetDragLeave_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point_in_viewport)::BaseType> point_in_viewport_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_point_in_viewport,
    point_in_viewport_fragment);

  params->point_in_viewport.Set(
      point_in_viewport_fragment.is_null() ? nullptr : point_in_viewport_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point_in_viewport.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point_in_viewport in FrameWidget.DragTargetDragLeave request");
  mojo::internal::MessageFragment<
      typename decltype(params->screen_point)::BaseType> screen_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_screen_point,
    screen_point_fragment);

  params->screen_point.Set(
      screen_point_fragment.is_null() ? nullptr : screen_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->screen_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null screen_point in FrameWidget.DragTargetDragLeave request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragTargetDragLeave");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetProxy::DragTargetDrop(
    const ::blink::WebDragData& in_drag_data, const ::gfx::PointF& in_point_in_viewport, const ::gfx::PointF& in_screen_point, uint32_t in_key_modifiers, DragTargetDropCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::DragTargetDrop", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drag_data"), in_drag_data,
                        "<value of type const ::blink::WebDragData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point_in_viewport"), in_point_in_viewport,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("screen_point"), in_screen_point,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_modifiers"), in_key_modifiers,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kDragTargetDrop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_DragTargetDrop_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->drag_data)::BaseType> drag_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DragDataDataView>(
    in_drag_data,
    drag_data_fragment);

  params->drag_data.Set(
      drag_data_fragment.is_null() ? nullptr : drag_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->drag_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null drag_data in FrameWidget.DragTargetDrop request");
  mojo::internal::MessageFragment<
      typename decltype(params->point_in_viewport)::BaseType> point_in_viewport_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_point_in_viewport,
    point_in_viewport_fragment);

  params->point_in_viewport.Set(
      point_in_viewport_fragment.is_null() ? nullptr : point_in_viewport_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point_in_viewport.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point_in_viewport in FrameWidget.DragTargetDrop request");
  mojo::internal::MessageFragment<
      typename decltype(params->screen_point)::BaseType> screen_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_screen_point,
    screen_point_fragment);

  params->screen_point.Set(
      screen_point_fragment.is_null() ? nullptr : screen_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->screen_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null screen_point in FrameWidget.DragTargetDrop request");

  params->key_modifiers = in_key_modifiers;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragTargetDrop");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameWidget_DragTargetDrop_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameWidgetProxy::DragSourceEndedAt(
    const ::gfx::PointF& in_point_in_viewport, const ::gfx::PointF& in_screen_point, ::ui::mojom::blink::DragOperation in_drag_operation, DragSourceEndedAtCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::DragSourceEndedAt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point_in_viewport"), in_point_in_viewport,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("screen_point"), in_screen_point,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drag_operation"), in_drag_operation,
                        "<value of type ::ui::mojom::blink::DragOperation>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kDragSourceEndedAt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_DragSourceEndedAt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point_in_viewport)::BaseType> point_in_viewport_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_point_in_viewport,
    point_in_viewport_fragment);

  params->point_in_viewport.Set(
      point_in_viewport_fragment.is_null() ? nullptr : point_in_viewport_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point_in_viewport.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point_in_viewport in FrameWidget.DragSourceEndedAt request");
  mojo::internal::MessageFragment<
      typename decltype(params->screen_point)::BaseType> screen_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_screen_point,
    screen_point_fragment);

  params->screen_point.Set(
      screen_point_fragment.is_null() ? nullptr : screen_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->screen_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null screen_point in FrameWidget.DragSourceEndedAt request");

  
  mojo::internal::Serialize<::ui::mojom::DragOperation>(
    in_drag_operation,
    &params->drag_operation);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragSourceEndedAt");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameWidget_DragSourceEndedAt_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameWidgetProxy::DragSourceSystemDragEnded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidget::DragSourceSystemDragEnded");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kDragSourceSystemDragEnded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_DragSourceSystemDragEnded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragSourceSystemDragEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetProxy::OnStartStylusWriting(
    OnStartStylusWritingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidget::OnStartStylusWriting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kOnStartStylusWriting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_OnStartStylusWriting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("OnStartStylusWriting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameWidget_OnStartStylusWriting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameWidgetProxy::SetBackgroundOpaque(
    bool in_opaque) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::SetBackgroundOpaque", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opaque"), in_opaque,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kSetBackgroundOpaque), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_SetBackgroundOpaque_Params_Data> params(
          message);
  params.Allocate();

  params->opaque = in_opaque;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("SetBackgroundOpaque");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetProxy::SetTextDirection(
    ::base::i18n::TextDirection in_direction) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::SetTextDirection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direction"), in_direction,
                        "<value of type ::base::i18n::TextDirection>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kSetTextDirection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_SetTextDirection_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
    in_direction,
    &params->direction);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("SetTextDirection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetProxy::SetActive(
    bool in_active) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::SetActive", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active"), in_active,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kSetActive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_SetActive_Params_Data> params(
          message);
  params.Allocate();

  params->active = in_active;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("SetActive");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetProxy::SetInheritedEffectiveTouchActionForSubFrame(
    ::cc::TouchAction in_touch_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::SetInheritedEffectiveTouchActionForSubFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("touch_action"), in_touch_action,
                        "<value of type ::cc::TouchAction>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kSetInheritedEffectiveTouchActionForSubFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::cc::mojom::TouchAction>(
    in_touch_action,
    &params->touch_action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("SetInheritedEffectiveTouchActionForSubFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetProxy::UpdateRenderThrottlingStatusForSubFrame(
    bool in_is_throttled, bool in_subtree_throttled, bool in_display_locked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::UpdateRenderThrottlingStatusForSubFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_throttled"), in_is_throttled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subtree_throttled"), in_subtree_throttled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_locked"), in_display_locked,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kUpdateRenderThrottlingStatusForSubFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params_Data> params(
          message);
  params.Allocate();

  params->is_throttled = in_is_throttled;

  params->subtree_throttled = in_subtree_throttled;

  params->display_locked = in_display_locked;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("UpdateRenderThrottlingStatusForSubFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetProxy::SetIsInertForSubFrame(
    bool in_inert) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::SetIsInertForSubFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("inert"), in_inert,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kSetIsInertForSubFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_SetIsInertForSubFrame_Params_Data> params(
          message);
  params.Allocate();

  params->inert = in_inert;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("SetIsInertForSubFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetProxy::GetStringAtPoint(
    const ::gfx::Point& in_point_in_local_root, GetStringAtPointCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::GetStringAtPoint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point_in_local_root"), in_point_in_local_root,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kGetStringAtPoint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_GetStringAtPoint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point_in_local_root)::BaseType> point_in_local_root_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_point_in_local_root,
    point_in_local_root_fragment);

  params->point_in_local_root.Set(
      point_in_local_root_fragment.is_null() ? nullptr : point_in_local_root_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point_in_local_root.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point_in_local_root in FrameWidget.GetStringAtPoint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("GetStringAtPoint");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameWidget_GetStringAtPoint_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameWidgetProxy::EnableDeviceEmulation(
    const ::blink::DeviceEmulationParams& in_parameters, DeviceEmulationCacheBehavior in_cache_behavior) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::EnableDeviceEmulation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parameters"), in_parameters,
                        "<value of type const ::blink::DeviceEmulationParams&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_behavior"), in_cache_behavior,
                        "<value of type DeviceEmulationCacheBehavior>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kEnableDeviceEmulation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_EnableDeviceEmulation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parameters)::BaseType> parameters_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DeviceEmulationParamsDataView>(
    in_parameters,
    parameters_fragment);

  params->parameters.Set(
      parameters_fragment.is_null() ? nullptr : parameters_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parameters.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parameters in FrameWidget.EnableDeviceEmulation request");

  
  mojo::internal::Serialize<::blink::mojom::DeviceEmulationCacheBehavior>(
    in_cache_behavior,
    &params->cache_behavior);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("EnableDeviceEmulation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetProxy::DisableDeviceEmulation(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidget::DisableDeviceEmulation");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kDisableDeviceEmulation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_DisableDeviceEmulation_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DisableDeviceEmulation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetProxy::BindWidgetCompositor(
    ::mojo::PendingReceiver<::blink::mojom::blink::WidgetCompositor> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::BindWidgetCompositor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::WidgetCompositor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kBindWidgetCompositor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_BindWidgetCompositor_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::WidgetCompositorInterfaceBase>>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host in FrameWidget.BindWidgetCompositor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("BindWidgetCompositor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetProxy::SetViewportIntersection(
    ::blink::mojom::blink::ViewportIntersectionStatePtr in_intersection_state, const std::optional<::blink::VisualProperties>& in_visual_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidget::SetViewportIntersection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intersection_state"), in_intersection_state,
                        "<value of type ::blink::mojom::blink::ViewportIntersectionStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visual_properties"), in_visual_properties,
                        "<value of type const std::optional<::blink::VisualProperties>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kSetViewportIntersection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_SetViewportIntersection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->intersection_state)::BaseType> intersection_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ViewportIntersectionStateDataView>(
    in_intersection_state,
    intersection_state_fragment);

  params->intersection_state.Set(
      intersection_state_fragment.is_null() ? nullptr : intersection_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->intersection_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null intersection_state in FrameWidget.SetViewportIntersection request");
  mojo::internal::MessageFragment<
      typename decltype(params->visual_properties)::BaseType> visual_properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::VisualPropertiesDataView>(
    in_visual_properties,
    visual_properties_fragment);

  params->visual_properties.Set(
      visual_properties_fragment.is_null() ? nullptr : visual_properties_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("SetViewportIntersection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetProxy::NotifyClearedDisplayedGraphics(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidget::NotifyClearedDisplayedGraphics");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kNotifyClearedDisplayedGraphics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_NotifyClearedDisplayedGraphics_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("NotifyClearedDisplayedGraphics");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class FrameWidget_DragTargetDragEnter_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameWidget::DragTargetDragEnterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameWidget_DragTargetDragEnter_ProxyToResponder> proxy(
        new FrameWidget_DragTargetDragEnter_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameWidget_DragTargetDragEnter_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameWidget_DragTargetDragEnter_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameWidget_DragTargetDragEnter_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameWidget::DragTargetDragEnterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::ui::mojom::blink::DragOperation in_operation, bool in_document_is_handling_drag);
};

bool FrameWidget_DragTargetDragEnter_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameWidget_DragTargetDragEnter_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameWidget_DragTargetDragEnter_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameWidget.0
  bool success = true;
  ::ui::mojom::blink::DragOperation p_operation{};
  bool p_document_is_handling_drag{};
  FrameWidget_DragTargetDragEnter_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOperation(&p_operation))
    success = false;
  if (success)
    p_document_is_handling_drag = input_data_view.document_is_handling_drag();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameWidget::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_operation), 
std::move(p_document_is_handling_drag));
  }
  return true;
}

void FrameWidget_DragTargetDragEnter_ProxyToResponder::Run(
    ::ui::mojom::blink::DragOperation in_operation, bool in_document_is_handling_drag) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FrameWidget::DragTargetDragEnter", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operation"), in_operation,
                        "<value of type ::ui::mojom::blink::DragOperation>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_is_handling_drag"), in_document_is_handling_drag,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kDragTargetDragEnter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_DragTargetDragEnter_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ui::mojom::DragOperation>(
    in_operation,
    &params->operation);

  params->document_is_handling_drag = in_document_is_handling_drag;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragTargetDragEnter");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameWidget_DragTargetDragOver_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameWidget::DragTargetDragOverCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameWidget_DragTargetDragOver_ProxyToResponder> proxy(
        new FrameWidget_DragTargetDragOver_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameWidget_DragTargetDragOver_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameWidget_DragTargetDragOver_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameWidget_DragTargetDragOver_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameWidget::DragTargetDragOverCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::ui::mojom::blink::DragOperation in_operation, bool in_document_is_handling_drag);
};

bool FrameWidget_DragTargetDragOver_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameWidget_DragTargetDragOver_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameWidget_DragTargetDragOver_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameWidget.1
  bool success = true;
  ::ui::mojom::blink::DragOperation p_operation{};
  bool p_document_is_handling_drag{};
  FrameWidget_DragTargetDragOver_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOperation(&p_operation))
    success = false;
  if (success)
    p_document_is_handling_drag = input_data_view.document_is_handling_drag();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameWidget::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_operation), 
std::move(p_document_is_handling_drag));
  }
  return true;
}

void FrameWidget_DragTargetDragOver_ProxyToResponder::Run(
    ::ui::mojom::blink::DragOperation in_operation, bool in_document_is_handling_drag) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FrameWidget::DragTargetDragOver", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operation"), in_operation,
                        "<value of type ::ui::mojom::blink::DragOperation>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_is_handling_drag"), in_document_is_handling_drag,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kDragTargetDragOver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_DragTargetDragOver_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ui::mojom::DragOperation>(
    in_operation,
    &params->operation);

  params->document_is_handling_drag = in_document_is_handling_drag;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragTargetDragOver");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameWidget_DragTargetDrop_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameWidget::DragTargetDropCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameWidget_DragTargetDrop_ProxyToResponder> proxy(
        new FrameWidget_DragTargetDrop_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameWidget_DragTargetDrop_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameWidget_DragTargetDrop_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameWidget_DragTargetDrop_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameWidget::DragTargetDropCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FrameWidget_DragTargetDrop_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameWidget_DragTargetDrop_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameWidget_DragTargetDrop_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameWidget.3
  bool success = true;
  FrameWidget_DragTargetDrop_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameWidget::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FrameWidget_DragTargetDrop_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::FrameWidget::DragTargetDrop");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kDragTargetDrop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_DragTargetDrop_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragTargetDrop");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameWidget_DragSourceEndedAt_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameWidget::DragSourceEndedAtCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameWidget_DragSourceEndedAt_ProxyToResponder> proxy(
        new FrameWidget_DragSourceEndedAt_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameWidget_DragSourceEndedAt_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameWidget_DragSourceEndedAt_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameWidget_DragSourceEndedAt_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameWidget::DragSourceEndedAtCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FrameWidget_DragSourceEndedAt_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameWidget_DragSourceEndedAt_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameWidget_DragSourceEndedAt_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameWidget.4
  bool success = true;
  FrameWidget_DragSourceEndedAt_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameWidget::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FrameWidget_DragSourceEndedAt_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::FrameWidget::DragSourceEndedAt");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kDragSourceEndedAt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_DragSourceEndedAt_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragSourceEndedAt");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameWidget_OnStartStylusWriting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameWidget::OnStartStylusWritingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameWidget_OnStartStylusWriting_ProxyToResponder> proxy(
        new FrameWidget_OnStartStylusWriting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameWidget_OnStartStylusWriting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameWidget_OnStartStylusWriting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameWidget_OnStartStylusWriting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameWidget::OnStartStylusWritingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      StylusWritingFocusResultPtr in_focus_result);
};

bool FrameWidget_OnStartStylusWriting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameWidget_OnStartStylusWriting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameWidget_OnStartStylusWriting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameWidget.6
  bool success = true;
  StylusWritingFocusResultPtr p_focus_result{};
  FrameWidget_OnStartStylusWriting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFocusResult(&p_focus_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameWidget::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_focus_result));
  }
  return true;
}

void FrameWidget_OnStartStylusWriting_ProxyToResponder::Run(
    StylusWritingFocusResultPtr in_focus_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FrameWidget::OnStartStylusWriting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_result"), in_focus_result,
                        "<value of type StylusWritingFocusResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kOnStartStylusWriting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_OnStartStylusWriting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->focus_result)::BaseType> focus_result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StylusWritingFocusResultDataView>(
    in_focus_result,
    focus_result_fragment);

  params->focus_result.Set(
      focus_result_fragment.is_null() ? nullptr : focus_result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("OnStartStylusWriting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameWidget_GetStringAtPoint_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameWidget::GetStringAtPointCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameWidget_GetStringAtPoint_ProxyToResponder> proxy(
        new FrameWidget_GetStringAtPoint_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameWidget_GetStringAtPoint_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameWidget_GetStringAtPoint_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameWidget_GetStringAtPoint_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameWidget::GetStringAtPointCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::ui::mojom::blink::AttributedStringPtr in_string, const ::gfx::Point& in_baseline_point);
};

bool FrameWidget_GetStringAtPoint_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameWidget_GetStringAtPoint_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameWidget_GetStringAtPoint_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameWidget.13
  bool success = true;
  ::ui::mojom::blink::AttributedStringPtr p_string{};
  ::gfx::Point p_baseline_point{};
  FrameWidget_GetStringAtPoint_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadString(&p_string))
    success = false;
  if (success && !input_data_view.ReadBaselinePoint(&p_baseline_point))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameWidget::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_string), 
std::move(p_baseline_point));
  }
  return true;
}

void FrameWidget_GetStringAtPoint_ProxyToResponder::Run(
    ::ui::mojom::blink::AttributedStringPtr in_string, const ::gfx::Point& in_baseline_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FrameWidget::GetStringAtPoint", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("string"), in_string,
                        "<value of type ::ui::mojom::blink::AttributedStringPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("baseline_point"), in_baseline_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidget::kGetStringAtPoint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidget_GetStringAtPoint_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->string)::BaseType> string_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::AttributedStringDataView>(
    in_string,
    string_fragment);

  params->string.Set(
      string_fragment.is_null() ? nullptr : string_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->baseline_point)::BaseType> baseline_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_baseline_point,
    baseline_point_fragment);

  params->baseline_point.Set(
      baseline_point_fragment.is_null() ? nullptr : baseline_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->baseline_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null baseline_point in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("GetStringAtPoint");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FrameWidgetStubDispatch::Accept(
    FrameWidget* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameWidget>(message->header()->name)) {
    case messages::FrameWidget::kDragTargetDragEnter: {
      break;
    }
    case messages::FrameWidget::kDragTargetDragOver: {
      break;
    }
    case messages::FrameWidget::kDragTargetDragLeave: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_DragTargetDragLeave_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_DragTargetDragLeave_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.2
      bool success = true;
      ::gfx::PointF p_point_in_viewport{};
      ::gfx::PointF p_screen_point{};
      FrameWidget_DragTargetDragLeave_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPointInViewport(&p_point_in_viewport))
        success = false;
      if (success && !input_data_view.ReadScreenPoint(&p_screen_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DragTargetDragLeave(        
        std::move(p_point_in_viewport), 
        std::move(p_screen_point));
      return true;
    }
    case messages::FrameWidget::kDragTargetDrop: {
      break;
    }
    case messages::FrameWidget::kDragSourceEndedAt: {
      break;
    }
    case messages::FrameWidget::kDragSourceSystemDragEnded: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_DragSourceSystemDragEnded_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_DragSourceSystemDragEnded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.5
      bool success = true;
      FrameWidget_DragSourceSystemDragEnded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DragSourceSystemDragEnded(        );
      return true;
    }
    case messages::FrameWidget::kOnStartStylusWriting: {
      break;
    }
    case messages::FrameWidget::kSetBackgroundOpaque: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_SetBackgroundOpaque_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_SetBackgroundOpaque_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.7
      bool success = true;
      bool p_opaque{};
      FrameWidget_SetBackgroundOpaque_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_opaque = input_data_view.opaque();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackgroundOpaque(        
        std::move(p_opaque));
      return true;
    }
    case messages::FrameWidget::kSetTextDirection: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_SetTextDirection_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_SetTextDirection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.8
      bool success = true;
      ::base::i18n::TextDirection p_direction{};
      FrameWidget_SetTextDirection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTextDirection(        
        std::move(p_direction));
      return true;
    }
    case messages::FrameWidget::kSetActive: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_SetActive_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_SetActive_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.9
      bool success = true;
      bool p_active{};
      FrameWidget_SetActive_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_active = input_data_view.active();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetActive(        
        std::move(p_active));
      return true;
    }
    case messages::FrameWidget::kSetInheritedEffectiveTouchActionForSubFrame: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.10
      bool success = true;
      ::cc::TouchAction p_touch_action{};
      FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTouchAction(&p_touch_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInheritedEffectiveTouchActionForSubFrame(        
        std::move(p_touch_action));
      return true;
    }
    case messages::FrameWidget::kUpdateRenderThrottlingStatusForSubFrame: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.11
      bool success = true;
      bool p_is_throttled{};
      bool p_subtree_throttled{};
      bool p_display_locked{};
      FrameWidget_UpdateRenderThrottlingStatusForSubFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_throttled = input_data_view.is_throttled();
      if (success)
        p_subtree_throttled = input_data_view.subtree_throttled();
      if (success)
        p_display_locked = input_data_view.display_locked();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateRenderThrottlingStatusForSubFrame(        
        std::move(p_is_throttled), 
        std::move(p_subtree_throttled), 
        std::move(p_display_locked));
      return true;
    }
    case messages::FrameWidget::kSetIsInertForSubFrame: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_SetIsInertForSubFrame_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_SetIsInertForSubFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.12
      bool success = true;
      bool p_inert{};
      FrameWidget_SetIsInertForSubFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_inert = input_data_view.inert();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsInertForSubFrame(        
        std::move(p_inert));
      return true;
    }
    case messages::FrameWidget::kGetStringAtPoint: {
      break;
    }
    case messages::FrameWidget::kEnableDeviceEmulation: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_EnableDeviceEmulation_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_EnableDeviceEmulation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.14
      bool success = true;
      ::blink::DeviceEmulationParams p_parameters{};
      DeviceEmulationCacheBehavior p_cache_behavior{};
      FrameWidget_EnableDeviceEmulation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParameters(&p_parameters))
        success = false;
      if (success && !input_data_view.ReadCacheBehavior(&p_cache_behavior))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableDeviceEmulation(        
        std::move(p_parameters), 
        std::move(p_cache_behavior));
      return true;
    }
    case messages::FrameWidget::kDisableDeviceEmulation: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_DisableDeviceEmulation_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_DisableDeviceEmulation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.15
      bool success = true;
      FrameWidget_DisableDeviceEmulation_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableDeviceEmulation(        );
      return true;
    }
    case messages::FrameWidget::kBindWidgetCompositor: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_BindWidgetCompositor_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_BindWidgetCompositor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.16
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::blink::WidgetCompositor> p_host{};
      FrameWidget_BindWidgetCompositor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindWidgetCompositor(        
        std::move(p_host));
      return true;
    }
    case messages::FrameWidget::kSetViewportIntersection: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_SetViewportIntersection_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_SetViewportIntersection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.17
      bool success = true;
      ::blink::mojom::blink::ViewportIntersectionStatePtr p_intersection_state{};
      std::optional<::blink::VisualProperties> p_visual_properties{};
      FrameWidget_SetViewportIntersection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIntersectionState(&p_intersection_state))
        success = false;
      if (success && !input_data_view.ReadVisualProperties(&p_visual_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetViewportIntersection(        
        std::move(p_intersection_state), 
        std::move(p_visual_properties));
      return true;
    }
    case messages::FrameWidget::kNotifyClearedDisplayedGraphics: {
      DCHECK(message->is_serialized());
      internal::FrameWidget_NotifyClearedDisplayedGraphics_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_NotifyClearedDisplayedGraphics_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidget.18
      bool success = true;
      FrameWidget_NotifyClearedDisplayedGraphics_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyClearedDisplayedGraphics(        );
      return true;
    }
  }
  return false;
}

// static
bool FrameWidgetStubDispatch::AcceptWithResponder(
    FrameWidget* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameWidget>(message->header()->name)) {
    case messages::FrameWidget::kDragTargetDragEnter: {
      internal::FrameWidget_DragTargetDragEnter_Params_Data* params =
          reinterpret_cast<
              internal::FrameWidget_DragTargetDragEnter_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameWidget.0
      bool success = true;
      ::blink::WebDragData p_drag_data{};
      ::gfx::PointF p_point_in_viewport{};
      ::gfx::PointF p_screen_point{};
      ::blink::DragOperationsMask p_operations_allowed{};
      uint32_t p_key_modifiers{};
      FrameWidget_DragTargetDragEnter_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDragData(&p_drag_data))
        success = false;
      if (success && !input_data_view.ReadPointInViewport(&p_point_in_viewport))
        success = false;
      if (success && !input_data_view.ReadScreenPoint(&p_screen_point))
        success = false;
      if (success && !input_data_view.ReadOperationsAllowed(&p_operations_allowed))
        success = false;
      if (success)
        p_key_modifiers = input_data_view.key_modifiers();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 0, false);
        return false;
      }
      auto callback =
          FrameWidget_DragTargetDragEnter_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DragTargetDragEnter(        
        std::move(p_drag_data), 
        std::move(p_point_in_viewport), 
        std::move(p_screen_point), 
        std::move(p_operations_allowed), 
        std::move(p_key_modifiers), std::move(callback));
      return true;
    }
    case messages::FrameWidget::kDragTargetDragOver: {
      internal::FrameWidget_DragTargetDragOver_Params_Data* params =
          reinterpret_cast<
              internal::FrameWidget_DragTargetDragOver_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameWidget.1
      bool success = true;
      ::gfx::PointF p_point_in_viewport{};
      ::gfx::PointF p_screen_point{};
      ::blink::DragOperationsMask p_operations_allowed{};
      uint32_t p_key_modifiers{};
      FrameWidget_DragTargetDragOver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPointInViewport(&p_point_in_viewport))
        success = false;
      if (success && !input_data_view.ReadScreenPoint(&p_screen_point))
        success = false;
      if (success && !input_data_view.ReadOperationsAllowed(&p_operations_allowed))
        success = false;
      if (success)
        p_key_modifiers = input_data_view.key_modifiers();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 1, false);
        return false;
      }
      auto callback =
          FrameWidget_DragTargetDragOver_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DragTargetDragOver(        
        std::move(p_point_in_viewport), 
        std::move(p_screen_point), 
        std::move(p_operations_allowed), 
        std::move(p_key_modifiers), std::move(callback));
      return true;
    }
    case messages::FrameWidget::kDragTargetDragLeave: {
      break;
    }
    case messages::FrameWidget::kDragTargetDrop: {
      internal::FrameWidget_DragTargetDrop_Params_Data* params =
          reinterpret_cast<
              internal::FrameWidget_DragTargetDrop_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameWidget.3
      bool success = true;
      ::blink::WebDragData p_drag_data{};
      ::gfx::PointF p_point_in_viewport{};
      ::gfx::PointF p_screen_point{};
      uint32_t p_key_modifiers{};
      FrameWidget_DragTargetDrop_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDragData(&p_drag_data))
        success = false;
      if (success && !input_data_view.ReadPointInViewport(&p_point_in_viewport))
        success = false;
      if (success && !input_data_view.ReadScreenPoint(&p_screen_point))
        success = false;
      if (success)
        p_key_modifiers = input_data_view.key_modifiers();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 3, false);
        return false;
      }
      auto callback =
          FrameWidget_DragTargetDrop_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DragTargetDrop(        
        std::move(p_drag_data), 
        std::move(p_point_in_viewport), 
        std::move(p_screen_point), 
        std::move(p_key_modifiers), std::move(callback));
      return true;
    }
    case messages::FrameWidget::kDragSourceEndedAt: {
      internal::FrameWidget_DragSourceEndedAt_Params_Data* params =
          reinterpret_cast<
              internal::FrameWidget_DragSourceEndedAt_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameWidget.4
      bool success = true;
      ::gfx::PointF p_point_in_viewport{};
      ::gfx::PointF p_screen_point{};
      ::ui::mojom::blink::DragOperation p_drag_operation{};
      FrameWidget_DragSourceEndedAt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPointInViewport(&p_point_in_viewport))
        success = false;
      if (success && !input_data_view.ReadScreenPoint(&p_screen_point))
        success = false;
      if (success && !input_data_view.ReadDragOperation(&p_drag_operation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 4, false);
        return false;
      }
      auto callback =
          FrameWidget_DragSourceEndedAt_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DragSourceEndedAt(        
        std::move(p_point_in_viewport), 
        std::move(p_screen_point), 
        std::move(p_drag_operation), std::move(callback));
      return true;
    }
    case messages::FrameWidget::kDragSourceSystemDragEnded: {
      break;
    }
    case messages::FrameWidget::kOnStartStylusWriting: {
      internal::FrameWidget_OnStartStylusWriting_Params_Data* params =
          reinterpret_cast<
              internal::FrameWidget_OnStartStylusWriting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameWidget.6
      bool success = true;
      FrameWidget_OnStartStylusWriting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 6, false);
        return false;
      }
      auto callback =
          FrameWidget_OnStartStylusWriting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStartStylusWriting(std::move(callback));
      return true;
    }
    case messages::FrameWidget::kSetBackgroundOpaque: {
      break;
    }
    case messages::FrameWidget::kSetTextDirection: {
      break;
    }
    case messages::FrameWidget::kSetActive: {
      break;
    }
    case messages::FrameWidget::kSetInheritedEffectiveTouchActionForSubFrame: {
      break;
    }
    case messages::FrameWidget::kUpdateRenderThrottlingStatusForSubFrame: {
      break;
    }
    case messages::FrameWidget::kSetIsInertForSubFrame: {
      break;
    }
    case messages::FrameWidget::kGetStringAtPoint: {
      internal::FrameWidget_GetStringAtPoint_Params_Data* params =
          reinterpret_cast<
              internal::FrameWidget_GetStringAtPoint_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameWidget.13
      bool success = true;
      ::gfx::Point p_point_in_local_root{};
      FrameWidget_GetStringAtPoint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPointInLocalRoot(&p_point_in_local_root))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 13, false);
        return false;
      }
      auto callback =
          FrameWidget_GetStringAtPoint_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStringAtPoint(        
        std::move(p_point_in_local_root), std::move(callback));
      return true;
    }
    case messages::FrameWidget::kEnableDeviceEmulation: {
      break;
    }
    case messages::FrameWidget::kDisableDeviceEmulation: {
      break;
    }
    case messages::FrameWidget::kBindWidgetCompositor: {
      break;
    }
    case messages::FrameWidget::kSetViewportIntersection: {
      break;
    }
    case messages::FrameWidget::kNotifyClearedDisplayedGraphics: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFrameWidgetValidationInfo[] = {
    { &internal::FrameWidget_DragTargetDragEnter_Params_Data::Validate,
     &internal::FrameWidget_DragTargetDragEnter_ResponseParams_Data::Validate},
    { &internal::FrameWidget_DragTargetDragOver_Params_Data::Validate,
     &internal::FrameWidget_DragTargetDragOver_ResponseParams_Data::Validate},
    { &internal::FrameWidget_DragTargetDragLeave_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidget_DragTargetDrop_Params_Data::Validate,
     &internal::FrameWidget_DragTargetDrop_ResponseParams_Data::Validate},
    { &internal::FrameWidget_DragSourceEndedAt_Params_Data::Validate,
     &internal::FrameWidget_DragSourceEndedAt_ResponseParams_Data::Validate},
    { &internal::FrameWidget_DragSourceSystemDragEnded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidget_OnStartStylusWriting_Params_Data::Validate,
     &internal::FrameWidget_OnStartStylusWriting_ResponseParams_Data::Validate},
    { &internal::FrameWidget_SetBackgroundOpaque_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidget_SetTextDirection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidget_SetActive_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidget_SetIsInertForSubFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidget_GetStringAtPoint_Params_Data::Validate,
     &internal::FrameWidget_GetStringAtPoint_ResponseParams_Data::Validate},
    { &internal::FrameWidget_EnableDeviceEmulation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidget_DisableDeviceEmulation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidget_BindWidgetCompositor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidget_SetViewportIntersection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidget_NotifyClearedDisplayedGraphics_Params_Data::Validate,
     nullptr /* no response */},
};

bool FrameWidgetRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FrameWidget::Name_,
    kFrameWidgetValidationInfo);
}

bool FrameWidgetResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::FrameWidget::Name_,
    kFrameWidgetValidationInfo);
}
// The declaration includes the definition on other builds.

FrameWidgetHost::IPCStableHashFunction FrameWidgetHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameWidgetHost>(message.name())) {
    case messages::FrameWidgetHost::kAnimateDoubleTapZoomInMainFrame: {
      return &FrameWidgetHost::AnimateDoubleTapZoomInMainFrame_Sym::IPCStableHash;
    }
    case messages::FrameWidgetHost::kZoomToFindInPageRectInMainFrame: {
      return &FrameWidgetHost::ZoomToFindInPageRectInMainFrame_Sym::IPCStableHash;
    }
    case messages::FrameWidgetHost::kSetHasTouchEventConsumers: {
      return &FrameWidgetHost::SetHasTouchEventConsumers_Sym::IPCStableHash;
    }
    case messages::FrameWidgetHost::kIntrinsicSizingInfoChanged: {
      return &FrameWidgetHost::IntrinsicSizingInfoChanged_Sym::IPCStableHash;
    }
    case messages::FrameWidgetHost::kAutoscrollStart: {
      return &FrameWidgetHost::AutoscrollStart_Sym::IPCStableHash;
    }
    case messages::FrameWidgetHost::kAutoscrollFling: {
      return &FrameWidgetHost::AutoscrollFling_Sym::IPCStableHash;
    }
    case messages::FrameWidgetHost::kAutoscrollEnd: {
      return &FrameWidgetHost::AutoscrollEnd_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameWidgetHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameWidgetHost>(message.name())) {
      case messages::FrameWidgetHost::kAnimateDoubleTapZoomInMainFrame:
            return "Receive blink::mojom::FrameWidgetHost::AnimateDoubleTapZoomInMainFrame";
      case messages::FrameWidgetHost::kZoomToFindInPageRectInMainFrame:
            return "Receive blink::mojom::FrameWidgetHost::ZoomToFindInPageRectInMainFrame";
      case messages::FrameWidgetHost::kSetHasTouchEventConsumers:
            return "Receive blink::mojom::FrameWidgetHost::SetHasTouchEventConsumers";
      case messages::FrameWidgetHost::kIntrinsicSizingInfoChanged:
            return "Receive blink::mojom::FrameWidgetHost::IntrinsicSizingInfoChanged";
      case messages::FrameWidgetHost::kAutoscrollStart:
            return "Receive blink::mojom::FrameWidgetHost::AutoscrollStart";
      case messages::FrameWidgetHost::kAutoscrollFling:
            return "Receive blink::mojom::FrameWidgetHost::AutoscrollFling";
      case messages::FrameWidgetHost::kAutoscrollEnd:
            return "Receive blink::mojom::FrameWidgetHost::AutoscrollEnd";
    }
  } else {
    switch (static_cast<messages::FrameWidgetHost>(message.name())) {
      case messages::FrameWidgetHost::kAnimateDoubleTapZoomInMainFrame:
            return "Receive reply blink::mojom::FrameWidgetHost::AnimateDoubleTapZoomInMainFrame";
      case messages::FrameWidgetHost::kZoomToFindInPageRectInMainFrame:
            return "Receive reply blink::mojom::FrameWidgetHost::ZoomToFindInPageRectInMainFrame";
      case messages::FrameWidgetHost::kSetHasTouchEventConsumers:
            return "Receive reply blink::mojom::FrameWidgetHost::SetHasTouchEventConsumers";
      case messages::FrameWidgetHost::kIntrinsicSizingInfoChanged:
            return "Receive reply blink::mojom::FrameWidgetHost::IntrinsicSizingInfoChanged";
      case messages::FrameWidgetHost::kAutoscrollStart:
            return "Receive reply blink::mojom::FrameWidgetHost::AutoscrollStart";
      case messages::FrameWidgetHost::kAutoscrollFling:
            return "Receive reply blink::mojom::FrameWidgetHost::AutoscrollFling";
      case messages::FrameWidgetHost::kAutoscrollEnd:
            return "Receive reply blink::mojom::FrameWidgetHost::AutoscrollEnd";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameWidgetHost::AnimateDoubleTapZoomInMainFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91d269eb;  // IPCStableHash for blink::mojom::FrameWidgetHost::AnimateDoubleTapZoomInMainFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetHost::ZoomToFindInPageRectInMainFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xccc033e9;  // IPCStableHash for blink::mojom::FrameWidgetHost::ZoomToFindInPageRectInMainFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetHost::SetHasTouchEventConsumers_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9c387e5;  // IPCStableHash for blink::mojom::FrameWidgetHost::SetHasTouchEventConsumers
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetHost::IntrinsicSizingInfoChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x69c058ed;  // IPCStableHash for blink::mojom::FrameWidgetHost::IntrinsicSizingInfoChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetHost::AutoscrollStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8c6f36d;  // IPCStableHash for blink::mojom::FrameWidgetHost::AutoscrollStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetHost::AutoscrollFling_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x966e6387;  // IPCStableHash for blink::mojom::FrameWidgetHost::AutoscrollFling
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetHost::AutoscrollEnd_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x001c4117;  // IPCStableHash for blink::mojom::FrameWidgetHost::AutoscrollEnd
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FrameWidgetHostProxy::FrameWidgetHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameWidgetHostProxy::AnimateDoubleTapZoomInMainFrame(
    const ::gfx::Point& in_tap_point, const ::gfx::Rect& in_rect_to_zoom) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetHost::AnimateDoubleTapZoomInMainFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tap_point"), in_tap_point,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect_to_zoom"), in_rect_to_zoom,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetHost::kAnimateDoubleTapZoomInMainFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tap_point)::BaseType> tap_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_tap_point,
    tap_point_fragment);

  params->tap_point.Set(
      tap_point_fragment.is_null() ? nullptr : tap_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tap_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tap_point in FrameWidgetHost.AnimateDoubleTapZoomInMainFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->rect_to_zoom)::BaseType> rect_to_zoom_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_rect_to_zoom,
    rect_to_zoom_fragment);

  params->rect_to_zoom.Set(
      rect_to_zoom_fragment.is_null() ? nullptr : rect_to_zoom_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rect_to_zoom.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rect_to_zoom in FrameWidgetHost.AnimateDoubleTapZoomInMainFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("AnimateDoubleTapZoomInMainFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetHostProxy::ZoomToFindInPageRectInMainFrame(
    const ::gfx::Rect& in_rect_to_zoom) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetHost::ZoomToFindInPageRectInMainFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect_to_zoom"), in_rect_to_zoom,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetHost::kZoomToFindInPageRectInMainFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rect_to_zoom)::BaseType> rect_to_zoom_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_rect_to_zoom,
    rect_to_zoom_fragment);

  params->rect_to_zoom.Set(
      rect_to_zoom_fragment.is_null() ? nullptr : rect_to_zoom_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rect_to_zoom.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rect_to_zoom in FrameWidgetHost.ZoomToFindInPageRectInMainFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("ZoomToFindInPageRectInMainFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetHostProxy::SetHasTouchEventConsumers(
    ::blink::mojom::blink::TouchEventConsumersPtr in_touch_event_consumers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetHost::SetHasTouchEventConsumers", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("touch_event_consumers"), in_touch_event_consumers,
                        "<value of type ::blink::mojom::blink::TouchEventConsumersPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetHost::kSetHasTouchEventConsumers), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetHost_SetHasTouchEventConsumers_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->touch_event_consumers)::BaseType> touch_event_consumers_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TouchEventConsumersDataView>(
    in_touch_event_consumers,
    touch_event_consumers_fragment);

  params->touch_event_consumers.Set(
      touch_event_consumers_fragment.is_null() ? nullptr : touch_event_consumers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->touch_event_consumers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null touch_event_consumers in FrameWidgetHost.SetHasTouchEventConsumers request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("SetHasTouchEventConsumers");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetHostProxy::IntrinsicSizingInfoChanged(
    ::blink::mojom::blink::IntrinsicSizingInfoPtr in_sizing_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetHost::IntrinsicSizingInfoChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sizing_info"), in_sizing_info,
                        "<value of type ::blink::mojom::blink::IntrinsicSizingInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetHost::kIntrinsicSizingInfoChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetHost_IntrinsicSizingInfoChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sizing_info)::BaseType> sizing_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IntrinsicSizingInfoDataView>(
    in_sizing_info,
    sizing_info_fragment);

  params->sizing_info.Set(
      sizing_info_fragment.is_null() ? nullptr : sizing_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sizing_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sizing_info in FrameWidgetHost.IntrinsicSizingInfoChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("IntrinsicSizingInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetHostProxy::AutoscrollStart(
    const ::gfx::PointF& in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetHost::AutoscrollStart", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type const ::gfx::PointF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetHost::kAutoscrollStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetHost_AutoscrollStart_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->position)::BaseType> position_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_position,
    position_fragment);

  params->position.Set(
      position_fragment.is_null() ? nullptr : position_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->position.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null position in FrameWidgetHost.AutoscrollStart request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("AutoscrollStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetHostProxy::AutoscrollFling(
    const ::gfx::Vector2dF& in_velocity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetHost::AutoscrollFling", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("velocity"), in_velocity,
                        "<value of type const ::gfx::Vector2dF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetHost::kAutoscrollFling), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetHost_AutoscrollFling_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->velocity)::BaseType> velocity_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
    in_velocity,
    velocity_fragment);

  params->velocity.Set(
      velocity_fragment.is_null() ? nullptr : velocity_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->velocity.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null velocity in FrameWidgetHost.AutoscrollFling request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("AutoscrollFling");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetHostProxy::AutoscrollEnd(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetHost::AutoscrollEnd");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetHost::kAutoscrollEnd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetHost_AutoscrollEnd_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("AutoscrollEnd");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FrameWidgetHostStubDispatch::Accept(
    FrameWidgetHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameWidgetHost>(message->header()->name)) {
    case messages::FrameWidgetHost::kAnimateDoubleTapZoomInMainFrame: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetHost.0
      bool success = true;
      ::gfx::Point p_tap_point{};
      ::gfx::Rect p_rect_to_zoom{};
      FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTapPoint(&p_tap_point))
        success = false;
      if (success && !input_data_view.ReadRectToZoom(&p_rect_to_zoom))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AnimateDoubleTapZoomInMainFrame(        
        std::move(p_tap_point), 
        std::move(p_rect_to_zoom));
      return true;
    }
    case messages::FrameWidgetHost::kZoomToFindInPageRectInMainFrame: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetHost.1
      bool success = true;
      ::gfx::Rect p_rect_to_zoom{};
      FrameWidgetHost_ZoomToFindInPageRectInMainFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRectToZoom(&p_rect_to_zoom))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ZoomToFindInPageRectInMainFrame(        
        std::move(p_rect_to_zoom));
      return true;
    }
    case messages::FrameWidgetHost::kSetHasTouchEventConsumers: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_SetHasTouchEventConsumers_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_SetHasTouchEventConsumers_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetHost.2
      bool success = true;
      ::blink::mojom::blink::TouchEventConsumersPtr p_touch_event_consumers{};
      FrameWidgetHost_SetHasTouchEventConsumers_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTouchEventConsumers(&p_touch_event_consumers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasTouchEventConsumers(        
        std::move(p_touch_event_consumers));
      return true;
    }
    case messages::FrameWidgetHost::kIntrinsicSizingInfoChanged: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_IntrinsicSizingInfoChanged_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_IntrinsicSizingInfoChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetHost.3
      bool success = true;
      ::blink::mojom::blink::IntrinsicSizingInfoPtr p_sizing_info{};
      FrameWidgetHost_IntrinsicSizingInfoChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSizingInfo(&p_sizing_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IntrinsicSizingInfoChanged(        
        std::move(p_sizing_info));
      return true;
    }
    case messages::FrameWidgetHost::kAutoscrollStart: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_AutoscrollStart_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_AutoscrollStart_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetHost.4
      bool success = true;
      ::gfx::PointF p_position{};
      FrameWidgetHost_AutoscrollStart_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AutoscrollStart(        
        std::move(p_position));
      return true;
    }
    case messages::FrameWidgetHost::kAutoscrollFling: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_AutoscrollFling_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_AutoscrollFling_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetHost.5
      bool success = true;
      ::gfx::Vector2dF p_velocity{};
      FrameWidgetHost_AutoscrollFling_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVelocity(&p_velocity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AutoscrollFling(        
        std::move(p_velocity));
      return true;
    }
    case messages::FrameWidgetHost::kAutoscrollEnd: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_AutoscrollEnd_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_AutoscrollEnd_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetHost.6
      bool success = true;
      FrameWidgetHost_AutoscrollEnd_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AutoscrollEnd(        );
      return true;
    }
  }
  return false;
}

// static
bool FrameWidgetHostStubDispatch::AcceptWithResponder(
    FrameWidgetHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameWidgetHost>(message->header()->name)) {
    case messages::FrameWidgetHost::kAnimateDoubleTapZoomInMainFrame: {
      break;
    }
    case messages::FrameWidgetHost::kZoomToFindInPageRectInMainFrame: {
      break;
    }
    case messages::FrameWidgetHost::kSetHasTouchEventConsumers: {
      break;
    }
    case messages::FrameWidgetHost::kIntrinsicSizingInfoChanged: {
      break;
    }
    case messages::FrameWidgetHost::kAutoscrollStart: {
      break;
    }
    case messages::FrameWidgetHost::kAutoscrollFling: {
      break;
    }
    case messages::FrameWidgetHost::kAutoscrollEnd: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFrameWidgetHostValidationInfo[] = {
    { &internal::FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetHost_SetHasTouchEventConsumers_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetHost_IntrinsicSizingInfoChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetHost_AutoscrollStart_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetHost_AutoscrollFling_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetHost_AutoscrollEnd_Params_Data::Validate,
     nullptr /* no response */},
};

bool FrameWidgetHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FrameWidgetHost::Name_,
    kFrameWidgetHostValidationInfo);
}

// The declaration includes the definition on other builds.

PopupWidgetHost::IPCStableHashFunction PopupWidgetHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PopupWidgetHost>(message.name())) {
    case messages::PopupWidgetHost::kRequestClosePopup: {
      return &PopupWidgetHost::RequestClosePopup_Sym::IPCStableHash;
    }
    case messages::PopupWidgetHost::kShowPopup: {
      return &PopupWidgetHost::ShowPopup_Sym::IPCStableHash;
    }
    case messages::PopupWidgetHost::kSetPopupBounds: {
      return &PopupWidgetHost::SetPopupBounds_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PopupWidgetHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PopupWidgetHost>(message.name())) {
      case messages::PopupWidgetHost::kRequestClosePopup:
            return "Receive blink::mojom::PopupWidgetHost::RequestClosePopup";
      case messages::PopupWidgetHost::kShowPopup:
            return "Receive blink::mojom::PopupWidgetHost::ShowPopup";
      case messages::PopupWidgetHost::kSetPopupBounds:
            return "Receive blink::mojom::PopupWidgetHost::SetPopupBounds";
    }
  } else {
    switch (static_cast<messages::PopupWidgetHost>(message.name())) {
      case messages::PopupWidgetHost::kRequestClosePopup:
            return "Receive reply blink::mojom::PopupWidgetHost::RequestClosePopup";
      case messages::PopupWidgetHost::kShowPopup:
            return "Receive reply blink::mojom::PopupWidgetHost::ShowPopup";
      case messages::PopupWidgetHost::kSetPopupBounds:
            return "Receive reply blink::mojom::PopupWidgetHost::SetPopupBounds";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PopupWidgetHost::RequestClosePopup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c77163b;  // IPCStableHash for blink::mojom::PopupWidgetHost::RequestClosePopup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PopupWidgetHost::ShowPopup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2402bfd2;  // IPCStableHash for blink::mojom::PopupWidgetHost::ShowPopup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PopupWidgetHost::SetPopupBounds_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdbfc25ea;  // IPCStableHash for blink::mojom::PopupWidgetHost::SetPopupBounds
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PopupWidgetHost_ShowPopup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PopupWidgetHost_ShowPopup_ForwardToCallback(
      PopupWidgetHost::ShowPopupCallback callback
      ) : callback_(std::move(callback)) {
  }

  PopupWidgetHost_ShowPopup_ForwardToCallback(const PopupWidgetHost_ShowPopup_ForwardToCallback&) = delete;
  PopupWidgetHost_ShowPopup_ForwardToCallback& operator=(const PopupWidgetHost_ShowPopup_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PopupWidgetHost::ShowPopupCallback callback_;
};

class PopupWidgetHost_SetPopupBounds_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PopupWidgetHost_SetPopupBounds_ForwardToCallback(
      PopupWidgetHost::SetPopupBoundsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PopupWidgetHost_SetPopupBounds_ForwardToCallback(const PopupWidgetHost_SetPopupBounds_ForwardToCallback&) = delete;
  PopupWidgetHost_SetPopupBounds_ForwardToCallback& operator=(const PopupWidgetHost_SetPopupBounds_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PopupWidgetHost::SetPopupBoundsCallback callback_;
};

PopupWidgetHostProxy::PopupWidgetHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PopupWidgetHostProxy::RequestClosePopup(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::PopupWidgetHost::RequestClosePopup");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PopupWidgetHost::kRequestClosePopup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PopupWidgetHost_RequestClosePopup_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PopupWidgetHost::Name_);
  message.set_method_name("RequestClosePopup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PopupWidgetHostProxy::ShowPopup(
    const ::gfx::Rect& in_initial_rect, const ::gfx::Rect& in_anchor_rect, ShowPopupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PopupWidgetHost::ShowPopup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initial_rect"), in_initial_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_rect"), in_anchor_rect,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PopupWidgetHost::kShowPopup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PopupWidgetHost_ShowPopup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->initial_rect)::BaseType> initial_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_initial_rect,
    initial_rect_fragment);

  params->initial_rect.Set(
      initial_rect_fragment.is_null() ? nullptr : initial_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->initial_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null initial_rect in PopupWidgetHost.ShowPopup request");
  mojo::internal::MessageFragment<
      typename decltype(params->anchor_rect)::BaseType> anchor_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_anchor_rect,
    anchor_rect_fragment);

  params->anchor_rect.Set(
      anchor_rect_fragment.is_null() ? nullptr : anchor_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->anchor_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null anchor_rect in PopupWidgetHost.ShowPopup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PopupWidgetHost::Name_);
  message.set_method_name("ShowPopup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PopupWidgetHost_ShowPopup_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PopupWidgetHostProxy::SetPopupBounds(
    const ::gfx::Rect& in_bounds, SetPopupBoundsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PopupWidgetHost::SetPopupBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PopupWidgetHost::kSetPopupBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PopupWidgetHost_SetPopupBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounds,
    bounds_fragment);

  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounds in PopupWidgetHost.SetPopupBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PopupWidgetHost::Name_);
  message.set_method_name("SetPopupBounds");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PopupWidgetHost_SetPopupBounds_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PopupWidgetHost_ShowPopup_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PopupWidgetHost::ShowPopupCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PopupWidgetHost_ShowPopup_ProxyToResponder> proxy(
        new PopupWidgetHost_ShowPopup_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PopupWidgetHost_ShowPopup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PopupWidgetHost_ShowPopup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PopupWidgetHost_ShowPopup_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PopupWidgetHost::ShowPopupCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PopupWidgetHost_ShowPopup_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PopupWidgetHost_ShowPopup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PopupWidgetHost_ShowPopup_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PopupWidgetHost.1
  bool success = true;
  PopupWidgetHost_ShowPopup_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PopupWidgetHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PopupWidgetHost_ShowPopup_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::PopupWidgetHost::ShowPopup");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PopupWidgetHost::kShowPopup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PopupWidgetHost_ShowPopup_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PopupWidgetHost::Name_);
  message.set_method_name("ShowPopup");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PopupWidgetHost_SetPopupBounds_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PopupWidgetHost::SetPopupBoundsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PopupWidgetHost_SetPopupBounds_ProxyToResponder> proxy(
        new PopupWidgetHost_SetPopupBounds_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PopupWidgetHost_SetPopupBounds_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PopupWidgetHost_SetPopupBounds_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PopupWidgetHost_SetPopupBounds_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PopupWidgetHost::SetPopupBoundsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PopupWidgetHost_SetPopupBounds_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PopupWidgetHost_SetPopupBounds_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PopupWidgetHost_SetPopupBounds_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PopupWidgetHost.2
  bool success = true;
  PopupWidgetHost_SetPopupBounds_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PopupWidgetHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PopupWidgetHost_SetPopupBounds_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::PopupWidgetHost::SetPopupBounds");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PopupWidgetHost::kSetPopupBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PopupWidgetHost_SetPopupBounds_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PopupWidgetHost::Name_);
  message.set_method_name("SetPopupBounds");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PopupWidgetHostStubDispatch::Accept(
    PopupWidgetHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PopupWidgetHost>(message->header()->name)) {
    case messages::PopupWidgetHost::kRequestClosePopup: {
      DCHECK(message->is_serialized());
      internal::PopupWidgetHost_RequestClosePopup_Params_Data* params =
          reinterpret_cast<internal::PopupWidgetHost_RequestClosePopup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PopupWidgetHost.0
      bool success = true;
      PopupWidgetHost_RequestClosePopup_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PopupWidgetHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestClosePopup(        );
      return true;
    }
    case messages::PopupWidgetHost::kShowPopup: {
      break;
    }
    case messages::PopupWidgetHost::kSetPopupBounds: {
      break;
    }
  }
  return false;
}

// static
bool PopupWidgetHostStubDispatch::AcceptWithResponder(
    PopupWidgetHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PopupWidgetHost>(message->header()->name)) {
    case messages::PopupWidgetHost::kRequestClosePopup: {
      break;
    }
    case messages::PopupWidgetHost::kShowPopup: {
      internal::PopupWidgetHost_ShowPopup_Params_Data* params =
          reinterpret_cast<
              internal::PopupWidgetHost_ShowPopup_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PopupWidgetHost.1
      bool success = true;
      ::gfx::Rect p_initial_rect{};
      ::gfx::Rect p_anchor_rect{};
      PopupWidgetHost_ShowPopup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInitialRect(&p_initial_rect))
        success = false;
      if (success && !input_data_view.ReadAnchorRect(&p_anchor_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PopupWidgetHost::Name_, 1, false);
        return false;
      }
      auto callback =
          PopupWidgetHost_ShowPopup_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowPopup(        
        std::move(p_initial_rect), 
        std::move(p_anchor_rect), std::move(callback));
      return true;
    }
    case messages::PopupWidgetHost::kSetPopupBounds: {
      internal::PopupWidgetHost_SetPopupBounds_Params_Data* params =
          reinterpret_cast<
              internal::PopupWidgetHost_SetPopupBounds_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PopupWidgetHost.2
      bool success = true;
      ::gfx::Rect p_bounds{};
      PopupWidgetHost_SetPopupBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PopupWidgetHost::Name_, 2, false);
        return false;
      }
      auto callback =
          PopupWidgetHost_SetPopupBounds_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPopupBounds(        
        std::move(p_bounds), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPopupWidgetHostValidationInfo[] = {
    { &internal::PopupWidgetHost_RequestClosePopup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PopupWidgetHost_ShowPopup_Params_Data::Validate,
     &internal::PopupWidgetHost_ShowPopup_ResponseParams_Data::Validate},
    { &internal::PopupWidgetHost_SetPopupBounds_Params_Data::Validate,
     &internal::PopupWidgetHost_SetPopupBounds_ResponseParams_Data::Validate},
};

bool PopupWidgetHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::PopupWidgetHost::Name_,
    kPopupWidgetHostValidationInfo);
}

bool PopupWidgetHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::PopupWidgetHost::Name_,
    kPopupWidgetHostValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::StylusWritingFocusResult::DataView, ::blink::mojom::blink::StylusWritingFocusResultPtr>::Read(
    ::blink::mojom::blink::StylusWritingFocusResult::DataView input,
    ::blink::mojom::blink::StylusWritingFocusResultPtr* output) {
  bool success = true;
  ::blink::mojom::blink::StylusWritingFocusResultPtr result(::blink::mojom::blink::StylusWritingFocusResult::New());
  
      if (success && !input.ReadFocusedEditBounds(&result->focused_edit_bounds))
        success = false;
      if (success && !input.ReadCaretBounds(&result->caret_bounds))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void FrameWidgetInterceptorForTesting::DragTargetDragEnter(const ::blink::WebDragData& drag_data, const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::blink::DragOperationsMask operations_allowed, uint32_t key_modifiers, DragTargetDragEnterCallback callback) {
  GetForwardingInterface()->DragTargetDragEnter(
    std::move(drag_data)
    , 
    std::move(point_in_viewport)
    , 
    std::move(screen_point)
    , 
    std::move(operations_allowed)
    , 
    std::move(key_modifiers)
    , std::move(callback));
}
void FrameWidgetInterceptorForTesting::DragTargetDragOver(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::blink::DragOperationsMask operations_allowed, uint32_t key_modifiers, DragTargetDragOverCallback callback) {
  GetForwardingInterface()->DragTargetDragOver(
    std::move(point_in_viewport)
    , 
    std::move(screen_point)
    , 
    std::move(operations_allowed)
    , 
    std::move(key_modifiers)
    , std::move(callback));
}
void FrameWidgetInterceptorForTesting::DragTargetDragLeave(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point) {
  GetForwardingInterface()->DragTargetDragLeave(
    std::move(point_in_viewport)
    , 
    std::move(screen_point)
    );
}
void FrameWidgetInterceptorForTesting::DragTargetDrop(const ::blink::WebDragData& drag_data, const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, uint32_t key_modifiers, DragTargetDropCallback callback) {
  GetForwardingInterface()->DragTargetDrop(
    std::move(drag_data)
    , 
    std::move(point_in_viewport)
    , 
    std::move(screen_point)
    , 
    std::move(key_modifiers)
    , std::move(callback));
}
void FrameWidgetInterceptorForTesting::DragSourceEndedAt(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::ui::mojom::blink::DragOperation drag_operation, DragSourceEndedAtCallback callback) {
  GetForwardingInterface()->DragSourceEndedAt(
    std::move(point_in_viewport)
    , 
    std::move(screen_point)
    , 
    std::move(drag_operation)
    , std::move(callback));
}
void FrameWidgetInterceptorForTesting::DragSourceSystemDragEnded() {
  GetForwardingInterface()->DragSourceSystemDragEnded();
}
void FrameWidgetInterceptorForTesting::OnStartStylusWriting(OnStartStylusWritingCallback callback) {
  GetForwardingInterface()->OnStartStylusWriting(std::move(callback));
}
void FrameWidgetInterceptorForTesting::SetBackgroundOpaque(bool opaque) {
  GetForwardingInterface()->SetBackgroundOpaque(
    std::move(opaque)
    );
}
void FrameWidgetInterceptorForTesting::SetTextDirection(::base::i18n::TextDirection direction) {
  GetForwardingInterface()->SetTextDirection(
    std::move(direction)
    );
}
void FrameWidgetInterceptorForTesting::SetActive(bool active) {
  GetForwardingInterface()->SetActive(
    std::move(active)
    );
}
void FrameWidgetInterceptorForTesting::SetInheritedEffectiveTouchActionForSubFrame(::cc::TouchAction touch_action) {
  GetForwardingInterface()->SetInheritedEffectiveTouchActionForSubFrame(
    std::move(touch_action)
    );
}
void FrameWidgetInterceptorForTesting::UpdateRenderThrottlingStatusForSubFrame(bool is_throttled, bool subtree_throttled, bool display_locked) {
  GetForwardingInterface()->UpdateRenderThrottlingStatusForSubFrame(
    std::move(is_throttled)
    , 
    std::move(subtree_throttled)
    , 
    std::move(display_locked)
    );
}
void FrameWidgetInterceptorForTesting::SetIsInertForSubFrame(bool inert) {
  GetForwardingInterface()->SetIsInertForSubFrame(
    std::move(inert)
    );
}
void FrameWidgetInterceptorForTesting::GetStringAtPoint(const ::gfx::Point& point_in_local_root, GetStringAtPointCallback callback) {
  GetForwardingInterface()->GetStringAtPoint(
    std::move(point_in_local_root)
    , std::move(callback));
}
void FrameWidgetInterceptorForTesting::EnableDeviceEmulation(const ::blink::DeviceEmulationParams& parameters, DeviceEmulationCacheBehavior cache_behavior) {
  GetForwardingInterface()->EnableDeviceEmulation(
    std::move(parameters)
    , 
    std::move(cache_behavior)
    );
}
void FrameWidgetInterceptorForTesting::DisableDeviceEmulation() {
  GetForwardingInterface()->DisableDeviceEmulation();
}
void FrameWidgetInterceptorForTesting::BindWidgetCompositor(::mojo::PendingReceiver<::blink::mojom::blink::WidgetCompositor> host) {
  GetForwardingInterface()->BindWidgetCompositor(
    std::move(host)
    );
}
void FrameWidgetInterceptorForTesting::SetViewportIntersection(::blink::mojom::blink::ViewportIntersectionStatePtr intersection_state, const std::optional<::blink::VisualProperties>& visual_properties) {
  GetForwardingInterface()->SetViewportIntersection(
    std::move(intersection_state)
    , 
    std::move(visual_properties)
    );
}
void FrameWidgetInterceptorForTesting::NotifyClearedDisplayedGraphics() {
  GetForwardingInterface()->NotifyClearedDisplayedGraphics();
}
FrameWidgetAsyncWaiter::FrameWidgetAsyncWaiter(
    FrameWidget* proxy) : proxy_(proxy) {}

FrameWidgetAsyncWaiter::~FrameWidgetAsyncWaiter() = default;


void FrameWidgetAsyncWaiter::DragTargetDragEnter(
    const ::blink::WebDragData& drag_data, const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::blink::DragOperationsMask operations_allowed, uint32_t key_modifiers, ::ui::mojom::blink::DragOperation* out_operation, bool* out_document_is_handling_drag) {
  base::RunLoop loop;
  proxy_->DragTargetDragEnter(
      std::move(drag_data),
      std::move(point_in_viewport),
      std::move(screen_point),
      std::move(operations_allowed),
      std::move(key_modifiers),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::ui::mojom::blink::DragOperation* out_operation
,
             bool* out_document_is_handling_drag
,
             ::ui::mojom::blink::DragOperation operation,
             bool document_is_handling_drag) {*out_operation = std::move(operation);*out_document_is_handling_drag = std::move(document_is_handling_drag);
            loop->Quit();
          },
          &loop,
          out_operation,
          out_document_is_handling_drag));
  loop.Run();
}



void FrameWidgetAsyncWaiter::DragTargetDragOver(
    const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::blink::DragOperationsMask operations_allowed, uint32_t key_modifiers, ::ui::mojom::blink::DragOperation* out_operation, bool* out_document_is_handling_drag) {
  base::RunLoop loop;
  proxy_->DragTargetDragOver(
      std::move(point_in_viewport),
      std::move(screen_point),
      std::move(operations_allowed),
      std::move(key_modifiers),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::ui::mojom::blink::DragOperation* out_operation
,
             bool* out_document_is_handling_drag
,
             ::ui::mojom::blink::DragOperation operation,
             bool document_is_handling_drag) {*out_operation = std::move(operation);*out_document_is_handling_drag = std::move(document_is_handling_drag);
            loop->Quit();
          },
          &loop,
          out_operation,
          out_document_is_handling_drag));
  loop.Run();
}



void FrameWidgetAsyncWaiter::DragTargetDrop(
    const ::blink::WebDragData& drag_data, const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, uint32_t key_modifiers) {
  base::RunLoop loop;
  proxy_->DragTargetDrop(
      std::move(drag_data),
      std::move(point_in_viewport),
      std::move(screen_point),
      std::move(key_modifiers),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void FrameWidgetAsyncWaiter::DragSourceEndedAt(
    const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::ui::mojom::blink::DragOperation drag_operation) {
  base::RunLoop loop;
  proxy_->DragSourceEndedAt(
      std::move(point_in_viewport),
      std::move(screen_point),
      std::move(drag_operation),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void FrameWidgetAsyncWaiter::OnStartStylusWriting(
    StylusWritingFocusResultPtr* out_focus_result) {
  base::RunLoop loop;
  proxy_->OnStartStylusWriting(
      base::BindOnce(
          [](base::RunLoop* loop,
             StylusWritingFocusResultPtr* out_focus_result
,
             StylusWritingFocusResultPtr focus_result) {*out_focus_result = std::move(focus_result);
            loop->Quit();
          },
          &loop,
          out_focus_result));
  loop.Run();
}

StylusWritingFocusResultPtr FrameWidgetAsyncWaiter::OnStartStylusWriting(
    ) {
  StylusWritingFocusResultPtr async_wait_result;
  OnStartStylusWriting(&async_wait_result);
  return async_wait_result;
}

void FrameWidgetAsyncWaiter::GetStringAtPoint(
    const ::gfx::Point& point_in_local_root, ::ui::mojom::blink::AttributedStringPtr* out_string, ::gfx::Point* out_baseline_point) {
  base::RunLoop loop;
  proxy_->GetStringAtPoint(
      std::move(point_in_local_root),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::ui::mojom::blink::AttributedStringPtr* out_string
,
             ::gfx::Point* out_baseline_point
,
             ::ui::mojom::blink::AttributedStringPtr string,
             const ::gfx::Point& baseline_point) {*out_string = std::move(string);*out_baseline_point = std::move(baseline_point);
            loop->Quit();
          },
          &loop,
          out_string,
          out_baseline_point));
  loop.Run();
}






void FrameWidgetHostInterceptorForTesting::AnimateDoubleTapZoomInMainFrame(const ::gfx::Point& tap_point, const ::gfx::Rect& rect_to_zoom) {
  GetForwardingInterface()->AnimateDoubleTapZoomInMainFrame(
    std::move(tap_point)
    , 
    std::move(rect_to_zoom)
    );
}
void FrameWidgetHostInterceptorForTesting::ZoomToFindInPageRectInMainFrame(const ::gfx::Rect& rect_to_zoom) {
  GetForwardingInterface()->ZoomToFindInPageRectInMainFrame(
    std::move(rect_to_zoom)
    );
}
void FrameWidgetHostInterceptorForTesting::SetHasTouchEventConsumers(::blink::mojom::blink::TouchEventConsumersPtr touch_event_consumers) {
  GetForwardingInterface()->SetHasTouchEventConsumers(
    std::move(touch_event_consumers)
    );
}
void FrameWidgetHostInterceptorForTesting::IntrinsicSizingInfoChanged(::blink::mojom::blink::IntrinsicSizingInfoPtr sizing_info) {
  GetForwardingInterface()->IntrinsicSizingInfoChanged(
    std::move(sizing_info)
    );
}
void FrameWidgetHostInterceptorForTesting::AutoscrollStart(const ::gfx::PointF& position) {
  GetForwardingInterface()->AutoscrollStart(
    std::move(position)
    );
}
void FrameWidgetHostInterceptorForTesting::AutoscrollFling(const ::gfx::Vector2dF& velocity) {
  GetForwardingInterface()->AutoscrollFling(
    std::move(velocity)
    );
}
void FrameWidgetHostInterceptorForTesting::AutoscrollEnd() {
  GetForwardingInterface()->AutoscrollEnd();
}
FrameWidgetHostAsyncWaiter::FrameWidgetHostAsyncWaiter(
    FrameWidgetHost* proxy) : proxy_(proxy) {}

FrameWidgetHostAsyncWaiter::~FrameWidgetHostAsyncWaiter() = default;





void PopupWidgetHostInterceptorForTesting::RequestClosePopup() {
  GetForwardingInterface()->RequestClosePopup();
}
void PopupWidgetHostInterceptorForTesting::ShowPopup(const ::gfx::Rect& initial_rect, const ::gfx::Rect& anchor_rect, ShowPopupCallback callback) {
  GetForwardingInterface()->ShowPopup(
    std::move(initial_rect)
    , 
    std::move(anchor_rect)
    , std::move(callback));
}
void PopupWidgetHostInterceptorForTesting::SetPopupBounds(const ::gfx::Rect& bounds, SetPopupBoundsCallback callback) {
  GetForwardingInterface()->SetPopupBounds(
    std::move(bounds)
    , std::move(callback));
}
PopupWidgetHostAsyncWaiter::PopupWidgetHostAsyncWaiter(
    PopupWidgetHost* proxy) : proxy_(proxy) {}

PopupWidgetHostAsyncWaiter::~PopupWidgetHostAsyncWaiter() = default;


void PopupWidgetHostAsyncWaiter::ShowPopup(
    const ::gfx::Rect& initial_rect, const ::gfx::Rect& anchor_rect) {
  base::RunLoop loop;
  proxy_->ShowPopup(
      std::move(initial_rect),
      std::move(anchor_rect),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PopupWidgetHostAsyncWaiter::SetPopupBounds(
    const ::gfx::Rect& bounds) {
  base::RunLoop loop;
  proxy_->SetPopupBounds(
      std::move(bounds),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif