// third_party/blink/public/mojom/page/display_cutout.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DISPLAY_CUTOUT_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DISPLAY_CUTOUT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/page/display_cutout.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/page/display_cutout.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/page/display_cutout.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class DisplayCutoutHostProxy;

template <typename ImplRefTraits>
class DisplayCutoutHostStub;

class DisplayCutoutHostRequestValidator;


class CORE_EXPORT DisplayCutoutHost
    : public DisplayCutoutHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.DisplayCutoutHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DisplayCutoutHostInterfaceBase;
  using Proxy_ = DisplayCutoutHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = DisplayCutoutHostStub<ImplRefTraits>;

  using RequestValidator_ = DisplayCutoutHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kNotifyViewportFitChangedMinVersion = 0,
    kNotifyComplexSafeAreaConstraintChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NotifyViewportFitChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyComplexSafeAreaConstraintChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DisplayCutoutHost() = default;

  virtual void NotifyViewportFitChanged(ViewportFit value) = 0;

  virtual void NotifyComplexSafeAreaConstraintChanged(bool value) = 0;
};

class DisplayCutoutClientProxy;

template <typename ImplRefTraits>
class DisplayCutoutClientStub;

class DisplayCutoutClientRequestValidator;


class CORE_EXPORT DisplayCutoutClient
    : public DisplayCutoutClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.DisplayCutoutClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DisplayCutoutClientInterfaceBase;
  using Proxy_ = DisplayCutoutClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = DisplayCutoutClientStub<ImplRefTraits>;

  using RequestValidator_ = DisplayCutoutClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetSafeAreaMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetSafeArea_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DisplayCutoutClient() = default;

  virtual void SetSafeArea(const ::gfx::Insets& safe_area) = 0;
};



class CORE_EXPORT DisplayCutoutHostProxy
    : public DisplayCutoutHost {
 public:
  using InterfaceType = DisplayCutoutHost;

  explicit DisplayCutoutHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotifyViewportFitChanged(ViewportFit value) final;
  
  void NotifyComplexSafeAreaConstraintChanged(bool value) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CORE_EXPORT DisplayCutoutClientProxy
    : public DisplayCutoutClient {
 public:
  using InterfaceType = DisplayCutoutClient;

  explicit DisplayCutoutClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetSafeArea(const ::gfx::Insets& safe_area) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CORE_EXPORT DisplayCutoutHostStubDispatch {
 public:
  static bool Accept(DisplayCutoutHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DisplayCutoutHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DisplayCutoutHost>>
class DisplayCutoutHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DisplayCutoutHostStub() = default;
  ~DisplayCutoutHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DisplayCutoutHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DisplayCutoutHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT DisplayCutoutClientStubDispatch {
 public:
  static bool Accept(DisplayCutoutClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DisplayCutoutClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DisplayCutoutClient>>
class DisplayCutoutClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DisplayCutoutClientStub() = default;
  ~DisplayCutoutClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DisplayCutoutClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DisplayCutoutClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT DisplayCutoutHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT DisplayCutoutClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DISPLAY_CUTOUT_MOJOM_BLINK_H_