// third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  RuntimeFeature as blink_mojom_RuntimeFeature,
  RuntimeFeatureSpec as blink_mojom_RuntimeFeatureSpec
} from '../runtime_feature_state/runtime_feature.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class OriginTrialStateHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.OriginTrialStateHost', scope);
  }
}

/** @interface */
export class OriginTrialStateHostInterface {
  
  /**
   * @param { !Object<!blink_mojom_RuntimeFeature, !OriginTrialFeatureState> } originTrialFeatures
   */

  applyFeatureDiffForOriginTrial(originTrialFeatures) {}
  
  /**
   * @param { !string } token
   * @param { !Array<!url_mojom_Origin> } scriptOrigins
   */

  enablePersistentTrial(token, scriptOrigins) {}
}

/**
 * @implements { OriginTrialStateHostInterface }
 */
export class OriginTrialStateHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!OriginTrialStateHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OriginTrialStateHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!OriginTrialStateHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object<!blink_mojom_RuntimeFeature, !OriginTrialFeatureState> } originTrialFeatures
   */

  applyFeatureDiffForOriginTrial(
      originTrialFeatures) {
    this.proxy.sendMessage(
        0,
        OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_ParamsSpec.$,
        null,
        [
          originTrialFeatures
        ],
        false);
  }

  
  /**
   * @param { !string } token
   * @param { !Array<!url_mojom_Origin> } scriptOrigins
   */

  enablePersistentTrial(
      token,
      scriptOrigins) {
    this.proxy.sendMessage(
        1,
        OriginTrialStateHost_EnablePersistentTrial_ParamsSpec.$,
        null,
        [
          token,
          scriptOrigins
        ],
        false);
  }
}

/**
 * An object which receives request messages for the OriginTrialStateHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OriginTrialStateHostReceiver {
  /**
   * @param {!OriginTrialStateHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!OriginTrialStateHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OriginTrialStateHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OriginTrialStateHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_ParamsSpec.$,
        null,
        impl.applyFeatureDiffForOriginTrial.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        OriginTrialStateHost_EnablePersistentTrial_ParamsSpec.$,
        null,
        impl.enablePersistentTrial.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OriginTrialStateHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.OriginTrialStateHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!OriginTrialStateHostRemote}
   */
  static getRemote() {
    let remote = new OriginTrialStateHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the OriginTrialStateHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OriginTrialStateHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OriginTrialStateHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OriginTrialStateHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.applyFeatureDiffForOriginTrial =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_ParamsSpec.$,
        null,
        this.applyFeatureDiffForOriginTrial.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enablePersistentTrial =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        OriginTrialStateHost_EnablePersistentTrial_ParamsSpec.$,
        null,
        this.enablePersistentTrial.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OriginTrialFeatureStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OriginTrialStateHost_EnablePersistentTrial_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    OriginTrialFeatureStateSpec.$,
    'OriginTrialFeatureState',
    [
      mojo.internal.StructField(
        'isEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tokens', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OriginTrialFeatureState {
  constructor() {
    /** @type { !boolean } */
    this.isEnabled;
    /** @type { !Array<!string> } */
    this.tokens;
  }
}



mojo.internal.Struct(
    OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_ParamsSpec.$,
    'OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params',
    [
      mojo.internal.StructField(
        'originTrialFeatures', 0,
        0,
        mojo.internal.Map(blink_mojom_RuntimeFeatureSpec.$, OriginTrialFeatureStateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params {
  constructor() {
    /** @type { !Object<!blink_mojom_RuntimeFeature, !OriginTrialFeatureState> } */
    this.originTrialFeatures;
  }
}



mojo.internal.Struct(
    OriginTrialStateHost_EnablePersistentTrial_ParamsSpec.$,
    'OriginTrialStateHost_EnablePersistentTrial_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scriptOrigins', 8,
        0,
        mojo.internal.Array(url_mojom_OriginSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OriginTrialStateHost_EnablePersistentTrial_Params {
  constructor() {
    /** @type { !string } */
    this.token;
    /** @type { !Array<!url_mojom_Origin> } */
    this.scriptOrigins;
  }
}

