// third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var byte_string$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/byte_string.mojom', '../../../../../mojo/public/mojom/base/byte_string.mojom.js');
  }
  var url_loader_factory$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader_factory.mojom', '../../../../../services/network/public/mojom/url_loader_factory.mojom.js');
  }
  var url_loader$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader.mojom', '../../../../../services/network/public/mojom/url_loader.mojom.js');
  }
  var url_response_head$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_response_head.mojom', '../../../../../services/network/public/mojom/url_response_head.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function SHA256HashValue(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SHA256HashValue.prototype.initDefaults_ = function() {
    this.data = null;
  };
  SHA256HashValue.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SHA256HashValue.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SHA256HashValue.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, byte_string$.ByteString, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SHA256HashValue.encodedSize = codec.kStructHeaderSize + 8;

  SHA256HashValue.decode = function(decoder) {
    var packed;
    var val = new SHA256HashValue();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStructPointer(byte_string$.ByteString);
    return val;
  };

  SHA256HashValue.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SHA256HashValue.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(byte_string$.ByteString, val.data);
  };
  function PrefetchedSignedExchangeInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PrefetchedSignedExchangeInfo.prototype.initDefaults_ = function() {
    this.outerUrl = null;
    this.headerIntegrity = null;
    this.innerUrl = null;
    this.innerResponse = null;
    this.loaderFactoryHandle = new url_loader_factory$.URLLoaderFactoryPtr();
  };
  PrefetchedSignedExchangeInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PrefetchedSignedExchangeInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrefetchedSignedExchangeInfo.outerUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrefetchedSignedExchangeInfo.headerIntegrity
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SHA256HashValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrefetchedSignedExchangeInfo.innerUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrefetchedSignedExchangeInfo.innerResponse
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url_response_head$.URLResponseHead, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrefetchedSignedExchangeInfo.loaderFactoryHandle
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 32, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PrefetchedSignedExchangeInfo.encodedSize = codec.kStructHeaderSize + 40;

  PrefetchedSignedExchangeInfo.decode = function(decoder) {
    var packed;
    var val = new PrefetchedSignedExchangeInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.outerUrl =
        decoder.decodeStructPointer(url$.Url);
    val.headerIntegrity =
        decoder.decodeStructPointer(SHA256HashValue);
    val.innerUrl =
        decoder.decodeStructPointer(url$.Url);
    val.innerResponse =
        decoder.decodeStructPointer(url_response_head$.URLResponseHead);
    val.loaderFactoryHandle =
        decoder.decodeStruct(new codec.Interface(url_loader_factory$.URLLoaderFactoryPtr));
    return val;
  };

  PrefetchedSignedExchangeInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PrefetchedSignedExchangeInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.outerUrl);
    encoder.encodeStructPointer(SHA256HashValue, val.headerIntegrity);
    encoder.encodeStructPointer(url$.Url, val.innerUrl);
    encoder.encodeStructPointer(url_response_head$.URLResponseHead, val.innerResponse);
    encoder.encodeStruct(new codec.Interface(url_loader_factory$.URLLoaderFactoryPtr), val.loaderFactoryHandle);
  };
  exports.SHA256HashValue = SHA256HashValue;
  exports.PrefetchedSignedExchangeInfo = PrefetchedSignedExchangeInfo;
})();