// third_party/blink/public/mojom/mime/mime_registry.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MimeRegistryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.MimeRegistry', scope);
  }
}

/** @interface */
export class MimeRegistryInterface {
  
  /**
   * @param { !string } extension
   * @return {!Promise<{
        mimeType: !string,
   *  }>}
   */

  getMimeTypeFromExtension(extension) {}
}

/**
 * @implements { MimeRegistryInterface }
 */
export class MimeRegistryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MimeRegistryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MimeRegistryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MimeRegistryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } extension
   * @return {!Promise<{
        mimeType: !string,
   *  }>}
   */

  getMimeTypeFromExtension(
      extension) {
    return this.proxy.sendMessage(
        0,
        MimeRegistry_GetMimeTypeFromExtension_ParamsSpec.$,
        MimeRegistry_GetMimeTypeFromExtension_ResponseParamsSpec.$,
        [
          extension
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MimeRegistry
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MimeRegistryReceiver {
  /**
   * @param {!MimeRegistryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MimeRegistryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MimeRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MimeRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MimeRegistry_GetMimeTypeFromExtension_ParamsSpec.$,
        MimeRegistry_GetMimeTypeFromExtension_ResponseParamsSpec.$,
        impl.getMimeTypeFromExtension.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MimeRegistry {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MimeRegistry";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MimeRegistryRemote}
   */
  static getRemote() {
    let remote = new MimeRegistryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MimeRegistry
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MimeRegistryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MimeRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MimeRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getMimeTypeFromExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MimeRegistry_GetMimeTypeFromExtension_ParamsSpec.$,
        MimeRegistry_GetMimeTypeFromExtension_ResponseParamsSpec.$,
        this.getMimeTypeFromExtension.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MimeRegistry_GetMimeTypeFromExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MimeRegistry_GetMimeTypeFromExtension_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MimeRegistry_GetMimeTypeFromExtension_ParamsSpec.$,
    'MimeRegistry_GetMimeTypeFromExtension_Params',
    [
      mojo.internal.StructField(
        'extension', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MimeRegistry_GetMimeTypeFromExtension_Params {
  constructor() {
    /** @type { !string } */
    this.extension;
  }
}



mojo.internal.Struct(
    MimeRegistry_GetMimeTypeFromExtension_ResponseParamsSpec.$,
    'MimeRegistry_GetMimeTypeFromExtension_ResponseParams',
    [
      mojo.internal.StructField(
        'mimeType', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MimeRegistry_GetMimeTypeFromExtension_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.mimeType;
  }
}

