// third_party/blink/public/mojom/mime/mime_registry.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');







goog.provide('blink.mojom.MimeRegistry');
goog.provide('blink.mojom.MimeRegistryReceiver');
goog.provide('blink.mojom.MimeRegistryCallbackRouter');
goog.provide('blink.mojom.MimeRegistryInterface');
goog.provide('blink.mojom.MimeRegistryRemote');
goog.provide('blink.mojom.MimeRegistryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.MimeRegistryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.MimeRegistry.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.MimeRegistryInterface = class {
  
  /**
   * @param { !string } extension
   * @return {!Promise<{
        mimeType: !string,
   *  }>}
   */

  getMimeTypeFromExtension(extension) {}
};

/**
 * @export
 * @implements { blink.mojom.MimeRegistryInterface }
 */
blink.mojom.MimeRegistryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.MimeRegistryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.MimeRegistryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.MimeRegistryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } extension
   * @return {!Promise<{
        mimeType: !string,
   *  }>}
   */

  getMimeTypeFromExtension(
      extension) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ParamsSpec.$,
        blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ResponseParamsSpec.$,
        [
          extension
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MimeRegistry
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.MimeRegistryReceiver = class {
  /**
   * @param {!blink.mojom.MimeRegistryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.MimeRegistryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.MimeRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MimeRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ParamsSpec.$,
        blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ResponseParamsSpec.$,
        impl.getMimeTypeFromExtension.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.MimeRegistry = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MimeRegistry";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.MimeRegistryRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.MimeRegistryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MimeRegistry
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.MimeRegistryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.MimeRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MimeRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getMimeTypeFromExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ParamsSpec.$,
        blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ResponseParamsSpec.$,
        this.getMimeTypeFromExtension.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ParamsSpec.$,
    'MimeRegistry_GetMimeTypeFromExtension_Params',
    [
      mojo.internal.StructField(
        'extension', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MimeRegistry_GetMimeTypeFromExtension_Params');

/** @record */
blink.mojom.MimeRegistry_GetMimeTypeFromExtension_Params = class {
  constructor() {
    /** @export { !string } */
    this.extension;
  }
};



mojo.internal.Struct(
    blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ResponseParamsSpec.$,
    'MimeRegistry_GetMimeTypeFromExtension_ResponseParams',
    [
      mojo.internal.StructField(
        'mimeType', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ResponseParams');

/** @record */
blink.mojom.MimeRegistry_GetMimeTypeFromExtension_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.mimeType;
  }
};

