// third_party/blink/public/mojom/messaging/message_port_descriptor.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_MESSAGE_PORT_DESCRIPTOR_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_MESSAGE_PORT_DESCRIPTOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/messaging/message_port_descriptor.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/messaging/message_port_descriptor.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/messaging/message_port_descriptor.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/messaging/message_port_descriptor_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT MessagePortDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MessagePortDescriptor, T>::value>;
  using DataView = MessagePortDescriptorDataView;
  using Data_ = internal::MessagePortDescriptor_Data;

  template <typename... Args>
  static MessagePortDescriptorPtr New(Args&&... args) {
    return MessagePortDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MessagePortDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<MessagePortDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MessagePortDescriptor>::Convert(*this);
  }


  MessagePortDescriptor();

  MessagePortDescriptor(
      ::mojo::ScopedMessagePipeHandle pipe_handle,
      const ::base::UnguessableToken& id,
      uint64_t sequence_number);

MessagePortDescriptor(const MessagePortDescriptor&) = delete;
MessagePortDescriptor& operator=(const MessagePortDescriptor&) = delete;

  ~MessagePortDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MessagePortDescriptorPtr>
  MessagePortDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MessagePortDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MessagePortDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MessagePortDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MessagePortDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MessagePortDescriptor_UnserializedMessageContext<
            UserType, MessagePortDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MessagePortDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MessagePortDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MessagePortDescriptor_UnserializedMessageContext<
            UserType, MessagePortDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MessagePortDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::ScopedMessagePipeHandle pipe_handle;
  
  ::base::UnguessableToken id;
  
  uint64_t sequence_number;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MessagePortDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MessagePortDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MessagePortDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MessagePortDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MessagePortDescriptorPtr MessagePortDescriptor::Clone() const {
  return New(
      mojo::Clone(pipe_handle),
      mojo::Clone(id),
      mojo::Clone(sequence_number)
  );
}

template <typename T, MessagePortDescriptor::EnableIfSame<T>*>
bool MessagePortDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pipe_handle, other_struct.pipe_handle))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->sequence_number, other_struct.sequence_number))
    return false;
  return true;
}

template <typename T, MessagePortDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pipe_handle < rhs.pipe_handle)
    return true;
  if (rhs.pipe_handle < lhs.pipe_handle)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.sequence_number < rhs.sequence_number)
    return true;
  if (rhs.sequence_number < lhs.sequence_number)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::MessagePortDescriptor::DataView,
                                         ::blink::mojom::MessagePortDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::MessagePortDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::MessagePortDescriptorPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::MessagePortDescriptor::pipe_handle)& pipe_handle(
       ::blink::mojom::MessagePortDescriptorPtr& input) {
    return input->pipe_handle;
  }

  static const decltype(::blink::mojom::MessagePortDescriptor::id)& id(
      const ::blink::mojom::MessagePortDescriptorPtr& input) {
    return input->id;
  }

  static decltype(::blink::mojom::MessagePortDescriptor::sequence_number) sequence_number(
      const ::blink::mojom::MessagePortDescriptorPtr& input) {
    return input->sequence_number;
  }

  static bool Read(::blink::mojom::MessagePortDescriptor::DataView input, ::blink::mojom::MessagePortDescriptorPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_MESSAGE_PORT_DESCRIPTOR_MOJOM_H_