// third_party/blink/public/mojom/messaging/cloneable_message.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/messaging/cloneable_message.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT CloneableMessage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CloneableMessage, T>::value>;
  using DataView = CloneableMessageDataView;
  using Data_ = internal::CloneableMessage_Data;

  template <typename... Args>
  static CloneableMessagePtr New(Args&&... args) {
    return CloneableMessagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CloneableMessagePtr From(const U& u) {
    return mojo::TypeConverter<CloneableMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CloneableMessage>::Convert(*this);
  }


  CloneableMessage();

  CloneableMessage(
      ::mojo_base::BigBuffer encoded_message,
      std::vector<::blink::mojom::SerializedBlobPtr> blobs,
      const std::optional<::url::Origin>& sender_origin,
      uint64_t stack_trace_id,
      int64_t stack_trace_debugger_id_first,
      int64_t stack_trace_debugger_id_second,
      bool stack_trace_should_pause,
      const ::base::UnguessableToken& sender_agent_cluster_id,
      bool locked_to_sender_agent_cluster,
      std::vector<::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>> file_system_access_tokens);

CloneableMessage(const CloneableMessage&) = delete;
CloneableMessage& operator=(const CloneableMessage&) = delete;

  ~CloneableMessage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CloneableMessagePtr>
  CloneableMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CloneableMessage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CloneableMessage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CloneableMessage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CloneableMessage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CloneableMessage_UnserializedMessageContext<
            UserType, CloneableMessage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CloneableMessage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CloneableMessage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CloneableMessage_UnserializedMessageContext<
            UserType, CloneableMessage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CloneableMessage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo_base::BigBuffer encoded_message;
  
  std::vector<::blink::mojom::SerializedBlobPtr> blobs;
  
  std::optional<::url::Origin> sender_origin;
  
  uint64_t stack_trace_id;
  
  int64_t stack_trace_debugger_id_first;
  
  int64_t stack_trace_debugger_id_second;
  
  bool stack_trace_should_pause;
  
  ::base::UnguessableToken sender_agent_cluster_id;
  
  bool locked_to_sender_agent_cluster;
  
  std::vector<::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>> file_system_access_tokens;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CloneableMessage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CloneableMessage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CloneableMessage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CloneableMessage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CloneableMessagePtr CloneableMessage::Clone() const {
  return New(
      mojo::Clone(encoded_message),
      mojo::Clone(blobs),
      mojo::Clone(sender_origin),
      mojo::Clone(stack_trace_id),
      mojo::Clone(stack_trace_debugger_id_first),
      mojo::Clone(stack_trace_debugger_id_second),
      mojo::Clone(stack_trace_should_pause),
      mojo::Clone(sender_agent_cluster_id),
      mojo::Clone(locked_to_sender_agent_cluster),
      mojo::Clone(file_system_access_tokens)
  );
}

template <typename T, CloneableMessage::EnableIfSame<T>*>
bool CloneableMessage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->encoded_message, other_struct.encoded_message))
    return false;
  if (!mojo::Equals(this->blobs, other_struct.blobs))
    return false;
  if (!mojo::Equals(this->sender_origin, other_struct.sender_origin))
    return false;
  if (!mojo::Equals(this->stack_trace_id, other_struct.stack_trace_id))
    return false;
  if (!mojo::Equals(this->stack_trace_debugger_id_first, other_struct.stack_trace_debugger_id_first))
    return false;
  if (!mojo::Equals(this->stack_trace_debugger_id_second, other_struct.stack_trace_debugger_id_second))
    return false;
  if (!mojo::Equals(this->stack_trace_should_pause, other_struct.stack_trace_should_pause))
    return false;
  if (!mojo::Equals(this->sender_agent_cluster_id, other_struct.sender_agent_cluster_id))
    return false;
  if (!mojo::Equals(this->locked_to_sender_agent_cluster, other_struct.locked_to_sender_agent_cluster))
    return false;
  if (!mojo::Equals(this->file_system_access_tokens, other_struct.file_system_access_tokens))
    return false;
  return true;
}

template <typename T, CloneableMessage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.encoded_message < rhs.encoded_message)
    return true;
  if (rhs.encoded_message < lhs.encoded_message)
    return false;
  if (lhs.blobs < rhs.blobs)
    return true;
  if (rhs.blobs < lhs.blobs)
    return false;
  if (lhs.sender_origin < rhs.sender_origin)
    return true;
  if (rhs.sender_origin < lhs.sender_origin)
    return false;
  if (lhs.stack_trace_id < rhs.stack_trace_id)
    return true;
  if (rhs.stack_trace_id < lhs.stack_trace_id)
    return false;
  if (lhs.stack_trace_debugger_id_first < rhs.stack_trace_debugger_id_first)
    return true;
  if (rhs.stack_trace_debugger_id_first < lhs.stack_trace_debugger_id_first)
    return false;
  if (lhs.stack_trace_debugger_id_second < rhs.stack_trace_debugger_id_second)
    return true;
  if (rhs.stack_trace_debugger_id_second < lhs.stack_trace_debugger_id_second)
    return false;
  if (lhs.stack_trace_should_pause < rhs.stack_trace_should_pause)
    return true;
  if (rhs.stack_trace_should_pause < lhs.stack_trace_should_pause)
    return false;
  if (lhs.sender_agent_cluster_id < rhs.sender_agent_cluster_id)
    return true;
  if (rhs.sender_agent_cluster_id < lhs.sender_agent_cluster_id)
    return false;
  if (lhs.locked_to_sender_agent_cluster < rhs.locked_to_sender_agent_cluster)
    return true;
  if (rhs.locked_to_sender_agent_cluster < lhs.locked_to_sender_agent_cluster)
    return false;
  if (lhs.file_system_access_tokens < rhs.file_system_access_tokens)
    return true;
  if (rhs.file_system_access_tokens < lhs.file_system_access_tokens)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CloneableMessage::DataView,
                                         ::blink::mojom::CloneableMessagePtr> {
  static bool IsNull(const ::blink::mojom::CloneableMessagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CloneableMessagePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::CloneableMessage::encoded_message)& encoded_message(
       ::blink::mojom::CloneableMessagePtr& input) {
    return input->encoded_message;
  }

  static  decltype(::blink::mojom::CloneableMessage::blobs)& blobs(
       ::blink::mojom::CloneableMessagePtr& input) {
    return input->blobs;
  }

  static const decltype(::blink::mojom::CloneableMessage::sender_origin)& sender_origin(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->sender_origin;
  }

  static decltype(::blink::mojom::CloneableMessage::stack_trace_id) stack_trace_id(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->stack_trace_id;
  }

  static decltype(::blink::mojom::CloneableMessage::stack_trace_debugger_id_first) stack_trace_debugger_id_first(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->stack_trace_debugger_id_first;
  }

  static decltype(::blink::mojom::CloneableMessage::stack_trace_debugger_id_second) stack_trace_debugger_id_second(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->stack_trace_debugger_id_second;
  }

  static decltype(::blink::mojom::CloneableMessage::stack_trace_should_pause) stack_trace_should_pause(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->stack_trace_should_pause;
  }

  static const decltype(::blink::mojom::CloneableMessage::sender_agent_cluster_id)& sender_agent_cluster_id(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->sender_agent_cluster_id;
  }

  static decltype(::blink::mojom::CloneableMessage::locked_to_sender_agent_cluster) locked_to_sender_agent_cluster(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->locked_to_sender_agent_cluster;
  }

  static  decltype(::blink::mojom::CloneableMessage::file_system_access_tokens)& file_system_access_tokens(
       ::blink::mojom::CloneableMessagePtr& input) {
    return input->file_system_access_tokens;
  }

  static bool Read(::blink::mojom::CloneableMessage::DataView input, ::blink::mojom::CloneableMessagePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_H_