// third_party/blink/public/mojom/mediastream/media_stream.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT MediaStreamDeviceObserverInterceptorForTesting : public MediaStreamDeviceObserver {
  virtual MediaStreamDeviceObserver* GetForwardingInterface() = 0;
  void OnDeviceStopped(const std::string& label, const ::blink::MediaStreamDevice& device) override;
  void OnDeviceChanged(const std::string& label, const ::blink::MediaStreamDevice& old_device, const ::blink::MediaStreamDevice& new_device) override;
  void OnDeviceRequestStateChange(const std::string& label, const ::blink::MediaStreamDevice& device, MediaStreamStateChange new_state) override;
  void OnDeviceCaptureConfigurationChange(const std::string& label, const ::blink::MediaStreamDevice& device) override;
  void OnDeviceCaptureHandleChange(const std::string& label, const ::blink::MediaStreamDevice& device) override;
  void OnZoomLevelChange(const std::string& label, const ::blink::MediaStreamDevice& device, int32_t zoom_level) override;
};
class BLINK_COMMON_EXPORT MediaStreamDeviceObserverAsyncWaiter {
 public:
  explicit MediaStreamDeviceObserverAsyncWaiter(MediaStreamDeviceObserver* proxy);

  MediaStreamDeviceObserverAsyncWaiter(const MediaStreamDeviceObserverAsyncWaiter&) = delete;
  MediaStreamDeviceObserverAsyncWaiter& operator=(const MediaStreamDeviceObserverAsyncWaiter&) = delete;

  ~MediaStreamDeviceObserverAsyncWaiter();

 private:
  MediaStreamDeviceObserver* const proxy_;
};


class BLINK_COMMON_EXPORT MediaStreamDispatcherHostInterceptorForTesting : public MediaStreamDispatcherHost {
  virtual MediaStreamDispatcherHost* GetForwardingInterface() = 0;
  void GenerateStreams(int32_t request_id, const ::blink::StreamControls& controls, bool user_gesture, StreamSelectionInfoPtr audio_stream_selection_info, GenerateStreamsCallback callback) override;
  void FocusCapturedSurface(const std::string& label, bool focus) override;
  void CancelRequest(int32_t request_id) override;
  void StopStreamDevice(const std::string& device_id, const std::optional<::base::UnguessableToken>& session_id) override;
  void OpenDevice(int32_t request_id, const std::string& device_id, MediaStreamType type, OpenDeviceCallback callback) override;
  void CloseDevice(const std::string& label) override;
  void SetCapturingLinkSecured(const std::optional<::base::UnguessableToken>& session_id, MediaStreamType type, bool is_secure) override;
  void ApplySubCaptureTarget(const ::base::UnguessableToken& session_id, ::media::mojom::SubCaptureTargetType type, const ::base::Token& sub_capture_target, uint32_t sub_capture_target_version, ApplySubCaptureTargetCallback callback) override;
  void SendWheel(const ::base::UnguessableToken& session_id, CapturedWheelActionPtr action) override;
  void UpdateZoomLevel(const ::base::UnguessableToken& session_id, ZoomLevelAction action, UpdateZoomLevelCallback callback) override;
  void RequestCapturedSurfaceControlPermission(const ::base::UnguessableToken& session_id, RequestCapturedSurfaceControlPermissionCallback callback) override;
  void GetOpenDevice(int32_t request_id, const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, GetOpenDeviceCallback callback) override;
  void KeepDeviceAliveForTransfer(const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, KeepDeviceAliveForTransferCallback callback) override;
};
class BLINK_COMMON_EXPORT MediaStreamDispatcherHostAsyncWaiter {
 public:
  explicit MediaStreamDispatcherHostAsyncWaiter(MediaStreamDispatcherHost* proxy);

  MediaStreamDispatcherHostAsyncWaiter(const MediaStreamDispatcherHostAsyncWaiter&) = delete;
  MediaStreamDispatcherHostAsyncWaiter& operator=(const MediaStreamDispatcherHostAsyncWaiter&) = delete;

  ~MediaStreamDispatcherHostAsyncWaiter();
  void GenerateStreams(
      int32_t request_id, const ::blink::StreamControls& controls, bool user_gesture, StreamSelectionInfoPtr audio_stream_selection_info, MediaStreamRequestResult* out_result, std::string* out_label, StreamDevicesSetPtr* out_stream_devices, bool* out_pan_tilt_zoom_allowed);
  
  void OpenDevice(
      int32_t request_id, const std::string& device_id, MediaStreamType type, bool* out_success, std::string* out_label, ::blink::MediaStreamDevice* out_device);
  
  void ApplySubCaptureTarget(
      const ::base::UnguessableToken& session_id, ::media::mojom::SubCaptureTargetType type, const ::base::Token& sub_capture_target, uint32_t sub_capture_target_version, ::media::mojom::ApplySubCaptureTargetResult* out_result);
  ::media::mojom::ApplySubCaptureTargetResult ApplySubCaptureTarget(const ::base::UnguessableToken& session_id, ::media::mojom::SubCaptureTargetType type, const ::base::Token& sub_capture_target, uint32_t sub_capture_target_version);
  void UpdateZoomLevel(
      const ::base::UnguessableToken& session_id, ZoomLevelAction action, CapturedSurfaceControlResult* out_result);
  CapturedSurfaceControlResult UpdateZoomLevel(const ::base::UnguessableToken& session_id, ZoomLevelAction action);
  void RequestCapturedSurfaceControlPermission(
      const ::base::UnguessableToken& session_id, CapturedSurfaceControlResult* out_result);
  CapturedSurfaceControlResult RequestCapturedSurfaceControlPermission(const ::base::UnguessableToken& session_id);
  void GetOpenDevice(
      int32_t request_id, const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, MediaStreamRequestResult* out_result, GetOpenDeviceResponsePtr* out_response);
  
  void KeepDeviceAliveForTransfer(
      const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, bool* out_device_found);
  bool KeepDeviceAliveForTransfer(const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id);

 private:
  MediaStreamDispatcherHost* const proxy_;
};


class BLINK_COMMON_EXPORT MediaStreamTrackMetricsHostInterceptorForTesting : public MediaStreamTrackMetricsHost {
  virtual MediaStreamTrackMetricsHost* GetForwardingInterface() = 0;
  void AddTrack(uint64_t id, bool is_audio, bool is_remote) override;
  void RemoveTrack(uint64_t id) override;
};
class BLINK_COMMON_EXPORT MediaStreamTrackMetricsHostAsyncWaiter {
 public:
  explicit MediaStreamTrackMetricsHostAsyncWaiter(MediaStreamTrackMetricsHost* proxy);

  MediaStreamTrackMetricsHostAsyncWaiter(const MediaStreamTrackMetricsHostAsyncWaiter&) = delete;
  MediaStreamTrackMetricsHostAsyncWaiter& operator=(const MediaStreamTrackMetricsHostAsyncWaiter&) = delete;

  ~MediaStreamTrackMetricsHostAsyncWaiter();

 private:
  MediaStreamTrackMetricsHost* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_TEST_UTILS_H_