// third_party/blink/public/mojom/mediasession/media_session.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* MediaSessionPlaybackStateToStringHelper(MediaSessionPlaybackState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaSessionPlaybackState::NONE:
      return "NONE";
    case MediaSessionPlaybackState::PAUSED:
      return "PAUSED";
    case MediaSessionPlaybackState::PLAYING:
      return "PLAYING";
    default:
      return nullptr;
  }
}

std::string MediaSessionPlaybackStateToString(MediaSessionPlaybackState value) {
  const char *str = MediaSessionPlaybackStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaSessionPlaybackState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaSessionPlaybackState value) {
  return os << MediaSessionPlaybackStateToString(value);
}

NOINLINE static const char* MediaSessionEnterPictureInPictureReasonToStringHelper(MediaSessionEnterPictureInPictureReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaSessionEnterPictureInPictureReason::kOther:
      return "kOther";
    case MediaSessionEnterPictureInPictureReason::kUserAction:
      return "kUserAction";
    case MediaSessionEnterPictureInPictureReason::kContentOccluded:
      return "kContentOccluded";
    default:
      return nullptr;
  }
}

std::string MediaSessionEnterPictureInPictureReasonToString(MediaSessionEnterPictureInPictureReason value) {
  const char *str = MediaSessionEnterPictureInPictureReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaSessionEnterPictureInPictureReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaSessionEnterPictureInPictureReason value) {
  return os << MediaSessionEnterPictureInPictureReasonToString(value);
}

namespace internal {
// static
bool MediaSessionActionDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const MediaSessionActionDetails_Data* object = static_cast<const MediaSessionActionDetails_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case MediaSessionActionDetails_Tag::kSeekTo: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_seek_to, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_seek_to, validation_context))
        return false;
      return true;
    }
    case MediaSessionActionDetails_Tag::kEnterPictureInPicture: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_enter_picture_in_picture, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_enter_picture_in_picture, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in MediaSessionActionDetails");
      return false;
    }
  }
}


// static
bool MediaSessionSeekToDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionSeekToDetails_Data* object =
      static_cast<const MediaSessionSeekToDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_time, validation_context))
    return false;

  return true;
}

MediaSessionSeekToDetails_Data::MediaSessionSeekToDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionEnterPictureInPictureDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionEnterPictureInPictureDetails_Data* object =
      static_cast<const MediaSessionEnterPictureInPictureDetails_Data*>(data);


  if (!::blink::mojom::internal::MediaSessionEnterPictureInPictureReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

MediaSessionEnterPictureInPictureDetails_Data::MediaSessionEnterPictureInPictureDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpecMediaMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpecMediaMetadata_Data* object =
      static_cast<const SpecMediaMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->artist, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->artist, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->album, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->album, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->artwork, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& artwork_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->artwork, validation_context,
                                         &artwork_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->chapterInfo, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& chapterInfo_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->chapterInfo, validation_context,
                                         &chapterInfo_validate_params)) {
    return false;
  }

  return true;
}

SpecMediaMetadata_Data::SpecMediaMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionClient_DidReceiveAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionClient_DidReceiveAction_Params_Data* object =
      static_cast<const MediaSessionClient_DidReceiveAction_Params_Data*>(data);


  if (!::media_session::mojom::internal::MediaSessionAction_Data
        ::Validate(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->details, validation_context))
    return false;

  return true;
}

MediaSessionClient_DidReceiveAction_Params_Data::MediaSessionClient_DidReceiveAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionService_SetClient_Params_Data* object =
      static_cast<const MediaSessionService_SetClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaSessionService_SetClient_Params_Data::MediaSessionService_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_SetPlaybackState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionService_SetPlaybackState_Params_Data* object =
      static_cast<const MediaSessionService_SetPlaybackState_Params_Data*>(data);


  if (!::blink::mojom::internal::MediaSessionPlaybackState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

MediaSessionService_SetPlaybackState_Params_Data::MediaSessionService_SetPlaybackState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_SetPositionState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionService_SetPositionState_Params_Data* object =
      static_cast<const MediaSessionService_SetPositionState_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

MediaSessionService_SetPositionState_Params_Data::MediaSessionService_SetPositionState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_SetMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionService_SetMetadata_Params_Data* object =
      static_cast<const MediaSessionService_SetMetadata_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

MediaSessionService_SetMetadata_Params_Data::MediaSessionService_SetMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_SetMicrophoneState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionService_SetMicrophoneState_Params_Data* object =
      static_cast<const MediaSessionService_SetMicrophoneState_Params_Data*>(data);


  if (!::media_session::mojom::internal::MicrophoneState_Data
        ::Validate(object->microphone_state, validation_context))
    return false;

  return true;
}

MediaSessionService_SetMicrophoneState_Params_Data::MediaSessionService_SetMicrophoneState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_SetCameraState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionService_SetCameraState_Params_Data* object =
      static_cast<const MediaSessionService_SetCameraState_Params_Data*>(data);


  if (!::media_session::mojom::internal::CameraState_Data
        ::Validate(object->camera_state, validation_context))
    return false;

  return true;
}

MediaSessionService_SetCameraState_Params_Data::MediaSessionService_SetCameraState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_EnableAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionService_EnableAction_Params_Data* object =
      static_cast<const MediaSessionService_EnableAction_Params_Data*>(data);


  if (!::media_session::mojom::internal::MediaSessionAction_Data
        ::Validate(object->action, validation_context))
    return false;

  return true;
}

MediaSessionService_EnableAction_Params_Data::MediaSessionService_EnableAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionService_DisableAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionService_DisableAction_Params_Data* object =
      static_cast<const MediaSessionService_DisableAction_Params_Data*>(data);


  if (!::media_session::mojom::internal::MediaSessionAction_Data
        ::Validate(object->action, validation_context))
    return false;

  return true;
}

MediaSessionService_DisableAction_Params_Data::MediaSessionService_DisableAction_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::MediaSessionPlaybackState>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::MediaSessionPlaybackState value) {
  return std::move(context).WriteString(::blink::mojom::MediaSessionPlaybackStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::MediaSessionEnterPictureInPictureReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::MediaSessionEnterPictureInPictureReason value) {
  return std::move(context).WriteString(::blink::mojom::MediaSessionEnterPictureInPictureReasonToString(value));
}

} // namespace perfetto