// third_party/blink/public/mojom/manifest/manifest_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool ManifestManager_RequestManifestAndErrors_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ManifestManager_RequestManifestAndErrors_ResponseParam_Result_Data* object = static_cast<const ManifestManager_RequestManifestAndErrors_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ManifestManager_RequestManifestAndErrors_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case ManifestManager_RequestManifestAndErrors_ResponseParam_Result_Tag::kFailure: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failure, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ManifestManager_RequestManifestAndErrors_ResponseParam_Result");
      return false;
    }
  }
}


// static
bool RequestManifestError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RequestManifestError_Data* object =
      static_cast<const RequestManifestError_Data*>(data);


  if (!::blink::mojom::internal::ManifestRequestResult_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->details, validation_context,
                                         &details_validate_params)) {
    return false;
  }

  return true;
}

RequestManifestError_Data::RequestManifestError_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestManager_RequestManifest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestManager_RequestManifest_Params_Data* object =
      static_cast<const ManifestManager_RequestManifest_Params_Data*>(data);

  return true;
}

ManifestManager_RequestManifest_Params_Data::ManifestManager_RequestManifest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestManager_RequestManifest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestManager_RequestManifest_ResponseParams_Data* object =
      static_cast<const ManifestManager_RequestManifest_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::ManifestRequestResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->manifest, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->manifest, validation_context))
    return false;

  return true;
}

ManifestManager_RequestManifest_ResponseParams_Data::ManifestManager_RequestManifest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestManager_RequestManifestAndErrors_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestManager_RequestManifestAndErrors_Params_Data* object =
      static_cast<const ManifestManager_RequestManifestAndErrors_Params_Data*>(data);

  return true;
}

ManifestManager_RequestManifestAndErrors_Params_Data::ManifestManager_RequestManifestAndErrors_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestManager_RequestManifestAndErrors_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestManager_RequestManifestAndErrors_ResponseParams_Data* object =
      static_cast<const ManifestManager_RequestManifestAndErrors_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

ManifestManager_RequestManifestAndErrors_ResponseParams_Data::ManifestManager_RequestManifestAndErrors_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestManager_RequestManifestDebugInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestManager_RequestManifestDebugInfo_Params_Data* object =
      static_cast<const ManifestManager_RequestManifestDebugInfo_Params_Data*>(data);

  return true;
}

ManifestManager_RequestManifestDebugInfo_Params_Data::ManifestManager_RequestManifestDebugInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestManager_RequestManifestDebugInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestManager_RequestManifestDebugInfo_ResponseParams_Data* object =
      static_cast<const ManifestManager_RequestManifestDebugInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parsed_manifest, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parsed_manifest, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->debug_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->debug_info, validation_context))
    return false;

  return true;
}

ManifestManager_RequestManifestDebugInfo_ResponseParams_Data::ManifestManager_RequestManifestDebugInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestManager_ParseManifestFromString_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestManager_ParseManifestFromString_Params_Data* object =
      static_cast<const ManifestManager_ParseManifestFromString_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->document_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->manifest_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->manifest_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->manifest_content, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& manifest_content_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->manifest_content, validation_context,
                                         &manifest_content_validate_params)) {
    return false;
  }

  return true;
}

ManifestManager_ParseManifestFromString_Params_Data::ManifestManager_ParseManifestFromString_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestManager_ParseManifestFromString_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestManager_ParseManifestFromString_ResponseParams_Data* object =
      static_cast<const ManifestManager_ParseManifestFromString_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->parsed_manifest, validation_context))
    return false;

  return true;
}

ManifestManager_ParseManifestFromString_ResponseParams_Data::ManifestManager_ParseManifestFromString_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink