// third_party/blink/public/mojom/manifest/manifest.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/device/public/mojom/screen_orientation_lock_types.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/display_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/manifest_launch_handler.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/safe_url_pattern.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "third_party/blink/public/mojom/manifest/manifest.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::TabStripMemberVisibility, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::ManifestRequestResult, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::Manifest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::manifest_url(input)) in_manifest_url = Traits::manifest_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->manifest_url)::BaseType> manifest_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_manifest_url,
        manifest_url_fragment);

      fragment->manifest_url.Set(
          manifest_url_fragment.is_null() ? nullptr : manifest_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->manifest_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null manifest_url in Manifest struct");

      
      mojo::internal::Serialize<::blink::mojom::Manifest_TextDirection>(
        Traits::dir(input),
        &fragment->dir);

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      decltype(Traits::short_name(input)) in_short_name = Traits::short_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->short_name)::BaseType> short_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_short_name,
        short_name_fragment);

      fragment->short_name.Set(
          short_name_fragment.is_null() ? nullptr : short_name_fragment.data());

      decltype(Traits::description(input)) in_description = Traits::description(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->description)::BaseType> description_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_description,
        description_fragment);

      fragment->description.Set(
          description_fragment.is_null() ? nullptr : description_fragment.data());

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in Manifest struct");

      fragment->has_custom_id = Traits::has_custom_id(input);

      decltype(Traits::start_url(input)) in_start_url = Traits::start_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->start_url)::BaseType> start_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_start_url,
        start_url_fragment);

      fragment->start_url.Set(
          start_url_fragment.is_null() ? nullptr : start_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->start_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_url in Manifest struct");

      fragment->has_valid_specified_start_url = Traits::has_valid_specified_start_url(input);

      
      mojo::internal::Serialize<::blink::mojom::DisplayMode>(
        Traits::display(input),
        &fragment->display);

      decltype(Traits::display_override(input)) in_display_override = Traits::display_override(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_override)::BaseType>
          display_override_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& display_override_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::DisplayMode_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DisplayMode>, send_validation>(
        in_display_override,
        display_override_fragment,
        &display_override_validate_params);

      fragment->display_override.Set(
          display_override_fragment.is_null() ? nullptr : display_override_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_override.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_override in Manifest struct");

      decltype(Traits::borderless_url_patterns(input)) in_borderless_url_patterns = Traits::borderless_url_patterns(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->borderless_url_patterns)::BaseType>
          borderless_url_patterns_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& borderless_url_patterns_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>, send_validation>(
        in_borderless_url_patterns,
        borderless_url_patterns_fragment,
        &borderless_url_patterns_validate_params);

      fragment->borderless_url_patterns.Set(
          borderless_url_patterns_fragment.is_null() ? nullptr : borderless_url_patterns_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->borderless_url_patterns.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null borderless_url_patterns in Manifest struct");

      
      mojo::internal::Serialize<::device::mojom::ScreenOrientationLockType>(
        Traits::orientation(input),
        &fragment->orientation);

      decltype(Traits::icons(input)) in_icons = Traits::icons(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icons)::BaseType>
          icons_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>, send_validation>(
        in_icons,
        icons_fragment,
        &icons_validate_params);

      fragment->icons.Set(
          icons_fragment.is_null() ? nullptr : icons_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icons.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons in Manifest struct");

      decltype(Traits::screenshots(input)) in_screenshots = Traits::screenshots(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->screenshots)::BaseType>
          screenshots_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& screenshots_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestScreenshotDataView>, send_validation>(
        in_screenshots,
        screenshots_fragment,
        &screenshots_validate_params);

      fragment->screenshots.Set(
          screenshots_fragment.is_null() ? nullptr : screenshots_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->screenshots.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null screenshots in Manifest struct");

      decltype(Traits::shortcuts(input)) in_shortcuts = Traits::shortcuts(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shortcuts)::BaseType>
          shortcuts_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& shortcuts_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestShortcutItemDataView>, send_validation>(
        in_shortcuts,
        shortcuts_fragment,
        &shortcuts_validate_params);

      fragment->shortcuts.Set(
          shortcuts_fragment.is_null() ? nullptr : shortcuts_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->shortcuts.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null shortcuts in Manifest struct");

      decltype(Traits::share_target(input)) in_share_target = Traits::share_target(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->share_target)::BaseType> share_target_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ManifestShareTargetDataView, send_validation>(
        in_share_target,
        share_target_fragment);

      fragment->share_target.Set(
          share_target_fragment.is_null() ? nullptr : share_target_fragment.data());

      decltype(Traits::file_handlers(input)) in_file_handlers = Traits::file_handlers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_handlers)::BaseType>
          file_handlers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& file_handlers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestFileHandlerDataView>, send_validation>(
        in_file_handlers,
        file_handlers_fragment,
        &file_handlers_validate_params);

      fragment->file_handlers.Set(
          file_handlers_fragment.is_null() ? nullptr : file_handlers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->file_handlers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_handlers in Manifest struct");

      decltype(Traits::protocol_handlers(input)) in_protocol_handlers = Traits::protocol_handlers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->protocol_handlers)::BaseType>
          protocol_handlers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& protocol_handlers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestProtocolHandlerDataView>, send_validation>(
        in_protocol_handlers,
        protocol_handlers_fragment,
        &protocol_handlers_validate_params);

      fragment->protocol_handlers.Set(
          protocol_handlers_fragment.is_null() ? nullptr : protocol_handlers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->protocol_handlers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null protocol_handlers in Manifest struct");

      decltype(Traits::scope_extensions(input)) in_scope_extensions = Traits::scope_extensions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scope_extensions)::BaseType>
          scope_extensions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& scope_extensions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestScopeExtensionDataView>, send_validation>(
        in_scope_extensions,
        scope_extensions_fragment,
        &scope_extensions_validate_params);

      fragment->scope_extensions.Set(
          scope_extensions_fragment.is_null() ? nullptr : scope_extensions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scope_extensions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope_extensions in Manifest struct");

      decltype(Traits::lock_screen(input)) in_lock_screen = Traits::lock_screen(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lock_screen)::BaseType> lock_screen_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ManifestLockScreenDataView, send_validation>(
        in_lock_screen,
        lock_screen_fragment);

      fragment->lock_screen.Set(
          lock_screen_fragment.is_null() ? nullptr : lock_screen_fragment.data());

      decltype(Traits::note_taking(input)) in_note_taking = Traits::note_taking(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->note_taking)::BaseType> note_taking_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ManifestNoteTakingDataView, send_validation>(
        in_note_taking,
        note_taking_fragment);

      fragment->note_taking.Set(
          note_taking_fragment.is_null() ? nullptr : note_taking_fragment.data());

      decltype(Traits::related_applications(input)) in_related_applications = Traits::related_applications(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->related_applications)::BaseType>
          related_applications_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& related_applications_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestRelatedApplicationDataView>, send_validation>(
        in_related_applications,
        related_applications_fragment,
        &related_applications_validate_params);

      fragment->related_applications.Set(
          related_applications_fragment.is_null() ? nullptr : related_applications_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->related_applications.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null related_applications in Manifest struct");

      fragment->prefer_related_applications = Traits::prefer_related_applications(input);

      fragment->has_theme_color = Traits::has_theme_color(input);

      fragment->theme_color = Traits::theme_color(input);

      fragment->has_background_color = Traits::has_background_color(input);

      fragment->background_color = Traits::background_color(input);

      decltype(Traits::gcm_sender_id(input)) in_gcm_sender_id = Traits::gcm_sender_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gcm_sender_id)::BaseType> gcm_sender_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_gcm_sender_id,
        gcm_sender_id_fragment);

      fragment->gcm_sender_id.Set(
          gcm_sender_id_fragment.is_null() ? nullptr : gcm_sender_id_fragment.data());

      decltype(Traits::scope(input)) in_scope = Traits::scope(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scope)::BaseType> scope_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_scope,
        scope_fragment);

      fragment->scope.Set(
          scope_fragment.is_null() ? nullptr : scope_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scope.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope in Manifest struct");

      decltype(Traits::permissions_policy(input)) in_permissions_policy = Traits::permissions_policy(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->permissions_policy)::BaseType>
          permissions_policy_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& permissions_policy_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>, send_validation>(
        in_permissions_policy,
        permissions_policy_fragment,
        &permissions_policy_validate_params);

      fragment->permissions_policy.Set(
          permissions_policy_fragment.is_null() ? nullptr : permissions_policy_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->permissions_policy.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null permissions_policy in Manifest struct");

      decltype(Traits::launch_handler(input)) in_launch_handler = Traits::launch_handler(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->launch_handler)::BaseType> launch_handler_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ManifestLaunchHandlerDataView, send_validation>(
        in_launch_handler,
        launch_handler_fragment);

      fragment->launch_handler.Set(
          launch_handler_fragment.is_null() ? nullptr : launch_handler_fragment.data());

      decltype(Traits::translations(input)) in_translations = Traits::translations(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->translations)::BaseType>
          translations_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& translations_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestTranslationItemDataView>, send_validation>(
        in_translations,
        translations_fragment,
        &translations_validate_params);

      fragment->translations.Set(
          translations_fragment.is_null() ? nullptr : translations_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->translations.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null translations in Manifest struct");

      fragment->has_dark_theme_color = Traits::has_dark_theme_color(input);

      fragment->dark_theme_color = Traits::dark_theme_color(input);

      fragment->has_dark_background_color = Traits::has_dark_background_color(input);

      fragment->dark_background_color = Traits::dark_background_color(input);

      decltype(Traits::tab_strip(input)) in_tab_strip = Traits::tab_strip(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tab_strip)::BaseType> tab_strip_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ManifestTabStripDataView, send_validation>(
        in_tab_strip,
        tab_strip_fragment);

      fragment->tab_strip.Set(
          tab_strip_fragment.is_null() ? nullptr : tab_strip_fragment.data());

      decltype(Traits::version(input)) in_version = Traits::version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->version)::BaseType> version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_version,
        version_fragment);

      fragment->version.Set(
          version_fragment.is_null() ? nullptr : version_fragment.data());

      decltype(Traits::name_localized(input)) in_name_localized = Traits::name_localized(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name_localized)::BaseType>
          name_localized_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& name_localized_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>, send_validation>(
        in_name_localized,
        name_localized_fragment,
        &name_localized_validate_params);

      fragment->name_localized.Set(
          name_localized_fragment.is_null() ? nullptr : name_localized_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name_localized.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name_localized in Manifest struct");

      decltype(Traits::short_name_localized(input)) in_short_name_localized = Traits::short_name_localized(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->short_name_localized)::BaseType>
          short_name_localized_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& short_name_localized_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>, send_validation>(
        in_short_name_localized,
        short_name_localized_fragment,
        &short_name_localized_validate_params);

      fragment->short_name_localized.Set(
          short_name_localized_fragment.is_null() ? nullptr : short_name_localized_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->short_name_localized.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null short_name_localized in Manifest struct");

      decltype(Traits::description_localized(input)) in_description_localized = Traits::description_localized(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->description_localized)::BaseType>
          description_localized_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& description_localized_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>, send_validation>(
        in_description_localized,
        description_localized_fragment,
        &description_localized_validate_params);

      fragment->description_localized.Set(
          description_localized_fragment.is_null() ? nullptr : description_localized_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->description_localized.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description_localized in Manifest struct");

      decltype(Traits::icons_localized(input)) in_icons_localized = Traits::icons_localized(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icons_localized)::BaseType>
          icons_localized_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& icons_localized_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>, send_validation>(
        in_icons_localized,
        icons_localized_fragment,
        &icons_localized_validate_params);

      fragment->icons_localized.Set(
          icons_localized_fragment.is_null() ? nullptr : icons_localized_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icons_localized.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons_localized in Manifest struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestLocalizedTextObjectDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestLocalizedTextObjectDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestLocalizedTextObject_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in ManifestLocalizedTextObject struct");
      fragment->dir_$flag = Traits::dir(input).has_value();
      if (Traits::dir(input).has_value()) {
        
        mojo::internal::Serialize<::blink::mojom::Manifest_TextDirection>(
          Traits::dir(input).value(),
          &fragment->dir_$value);
      } else {
        fragment->dir_$value =
            static_cast<int32_t>(::blink::mojom::Manifest_TextDirection::kMinValue);
      }

      decltype(Traits::lang(input)) in_lang = Traits::lang(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lang)::BaseType> lang_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_lang,
        lang_fragment);

      fragment->lang.Set(
          lang_fragment.is_null() ? nullptr : lang_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestShortcutItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestShortcutItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestShortcutItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ManifestShortcutItem struct");

      decltype(Traits::short_name(input)) in_short_name = Traits::short_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->short_name)::BaseType> short_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_short_name,
        short_name_fragment);

      fragment->short_name.Set(
          short_name_fragment.is_null() ? nullptr : short_name_fragment.data());

      decltype(Traits::description(input)) in_description = Traits::description(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->description)::BaseType> description_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_description,
        description_fragment);

      fragment->description.Set(
          description_fragment.is_null() ? nullptr : description_fragment.data());

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ManifestShortcutItem struct");

      decltype(Traits::icons(input)) in_icons = Traits::icons(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icons)::BaseType>
          icons_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>, send_validation>(
        in_icons,
        icons_fragment,
        &icons_validate_params);

      fragment->icons.Set(
          icons_fragment.is_null() ? nullptr : icons_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icons.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons in ManifestShortcutItem struct");

      decltype(Traits::name_localized(input)) in_name_localized = Traits::name_localized(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name_localized)::BaseType>
          name_localized_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& name_localized_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>, send_validation>(
        in_name_localized,
        name_localized_fragment,
        &name_localized_validate_params);

      fragment->name_localized.Set(
          name_localized_fragment.is_null() ? nullptr : name_localized_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name_localized.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name_localized in ManifestShortcutItem struct");

      decltype(Traits::short_name_localized(input)) in_short_name_localized = Traits::short_name_localized(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->short_name_localized)::BaseType>
          short_name_localized_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& short_name_localized_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>, send_validation>(
        in_short_name_localized,
        short_name_localized_fragment,
        &short_name_localized_validate_params);

      fragment->short_name_localized.Set(
          short_name_localized_fragment.is_null() ? nullptr : short_name_localized_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->short_name_localized.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null short_name_localized in ManifestShortcutItem struct");

      decltype(Traits::description_localized(input)) in_description_localized = Traits::description_localized(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->description_localized)::BaseType>
          description_localized_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& description_localized_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>, send_validation>(
        in_description_localized,
        description_localized_fragment,
        &description_localized_validate_params);

      fragment->description_localized.Set(
          description_localized_fragment.is_null() ? nullptr : description_localized_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->description_localized.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description_localized in ManifestShortcutItem struct");

      decltype(Traits::icons_localized(input)) in_icons_localized = Traits::icons_localized(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icons_localized)::BaseType>
          icons_localized_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& icons_localized_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>, send_validation>(
        in_icons_localized,
        icons_localized_fragment,
        &icons_localized_validate_params);

      fragment->icons_localized.Set(
          icons_localized_fragment.is_null() ? nullptr : icons_localized_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icons_localized.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons_localized in ManifestShortcutItem struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestImageResourceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestImageResourceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestImageResource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::src(input)) in_src = Traits::src(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->src)::BaseType> src_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_src,
        src_fragment);

      fragment->src.Set(
          src_fragment.is_null() ? nullptr : src_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->src.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null src in ManifestImageResource struct");

      decltype(Traits::type(input)) in_type = Traits::type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->type)::BaseType> type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_type,
        type_fragment);

      fragment->type.Set(
          type_fragment.is_null() ? nullptr : type_fragment.data());

      decltype(Traits::sizes(input)) in_sizes = Traits::sizes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sizes)::BaseType>
          sizes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& sizes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>, send_validation>(
        in_sizes,
        sizes_fragment,
        &sizes_validate_params);

      fragment->sizes.Set(
          sizes_fragment.is_null() ? nullptr : sizes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sizes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sizes in ManifestImageResource struct");

      decltype(Traits::purpose(input)) in_purpose = Traits::purpose(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->purpose)::BaseType>
          purpose_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& purpose_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::ManifestImageResource_Purpose_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResource_Purpose>, send_validation>(
        in_purpose,
        purpose_fragment,
        &purpose_validate_params);

      fragment->purpose.Set(
          purpose_fragment.is_null() ? nullptr : purpose_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->purpose.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null purpose in ManifestImageResource struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestScreenshotDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestScreenshotDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestScreenshot_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::image(input)) in_image = Traits::image(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image)::BaseType> image_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ManifestImageResourceDataView, send_validation>(
        in_image,
        image_fragment);

      fragment->image.Set(
          image_fragment.is_null() ? nullptr : image_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->image.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image in ManifestScreenshot struct");

      
      mojo::internal::Serialize<::blink::mojom::ManifestScreenshot_FormFactor>(
        Traits::form_factor(input),
        &fragment->form_factor);

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestFileFilterDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestFileFilterDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestFileFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      decltype(Traits::accept(input)) in_accept = Traits::accept(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->accept)::BaseType>
          accept_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& accept_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>, send_validation>(
        in_accept,
        accept_fragment,
        &accept_validate_params);

      fragment->accept.Set(
          accept_fragment.is_null() ? nullptr : accept_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->accept.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accept in ManifestFileFilter struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestProtocolHandlerDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestProtocolHandlerDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestProtocolHandler_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::protocol(input)) in_protocol = Traits::protocol(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->protocol)::BaseType> protocol_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_protocol,
        protocol_fragment);

      fragment->protocol.Set(
          protocol_fragment.is_null() ? nullptr : protocol_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->protocol.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null protocol in ManifestProtocolHandler struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ManifestProtocolHandler struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestScopeExtensionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestScopeExtensionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestScopeExtension_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in ManifestScopeExtension struct");

      fragment->has_origin_wildcard = Traits::has_origin_wildcard(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestLockScreenDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestLockScreenDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestLockScreen_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::start_url(input)) in_start_url = Traits::start_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->start_url)::BaseType> start_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_start_url,
        start_url_fragment);

      fragment->start_url.Set(
          start_url_fragment.is_null() ? nullptr : start_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->start_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_url in ManifestLockScreen struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestNoteTakingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestNoteTakingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestNoteTaking_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::new_note_url(input)) in_new_note_url = Traits::new_note_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->new_note_url)::BaseType> new_note_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_new_note_url,
        new_note_url_fragment);

      fragment->new_note_url.Set(
          new_note_url_fragment.is_null() ? nullptr : new_note_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->new_note_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_note_url in ManifestNoteTaking struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestRelatedApplicationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestRelatedApplicationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestRelatedApplication_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::platform(input)) in_platform = Traits::platform(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->platform)::BaseType> platform_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_platform,
        platform_fragment);

      fragment->platform.Set(
          platform_fragment.is_null() ? nullptr : platform_fragment.data());

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestShareTargetParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestShareTargetParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestShareTargetParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      decltype(Traits::text(input)) in_text = Traits::text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text)::BaseType> text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_text,
        text_fragment);

      fragment->text.Set(
          text_fragment.is_null() ? nullptr : text_fragment.data());

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      decltype(Traits::files(input)) in_files = Traits::files(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->files)::BaseType>
          files_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestFileFilterDataView>, send_validation>(
        in_files,
        files_fragment,
        &files_validate_params);

      fragment->files.Set(
          files_fragment.is_null() ? nullptr : files_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestShareTargetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestShareTargetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestShareTarget_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::action(input)) in_action = Traits::action(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->action)::BaseType> action_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_action,
        action_fragment);

      fragment->action.Set(
          action_fragment.is_null() ? nullptr : action_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->action.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null action in ManifestShareTarget struct");

      
      mojo::internal::Serialize<::blink::mojom::ManifestShareTarget_Method>(
        Traits::method(input),
        &fragment->method);

      
      mojo::internal::Serialize<::blink::mojom::ManifestShareTarget_Enctype>(
        Traits::enctype(input),
        &fragment->enctype);

      decltype(Traits::params(input)) in_params = Traits::params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->params)::BaseType> params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ManifestShareTargetParamsDataView, send_validation>(
        in_params,
        params_fragment);

      fragment->params.Set(
          params_fragment.is_null() ? nullptr : params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in ManifestShareTarget struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestFileHandlerDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestFileHandlerDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestFileHandler_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::action(input)) in_action = Traits::action(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->action)::BaseType> action_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_action,
        action_fragment);

      fragment->action.Set(
          action_fragment.is_null() ? nullptr : action_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->action.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null action in ManifestFileHandler struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ManifestFileHandler struct");

      decltype(Traits::icons(input)) in_icons = Traits::icons(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icons)::BaseType>
          icons_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>, send_validation>(
        in_icons,
        icons_fragment,
        &icons_validate_params);

      fragment->icons.Set(
          icons_fragment.is_null() ? nullptr : icons_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icons.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons in ManifestFileHandler struct");

      decltype(Traits::accept(input)) in_accept = Traits::accept(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->accept)::BaseType>
          accept_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& accept_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>, send_validation>(
        in_accept,
        accept_fragment,
        &accept_validate_params);

      fragment->accept.Set(
          accept_fragment.is_null() ? nullptr : accept_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->accept.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accept in ManifestFileHandler struct");

      
      mojo::internal::Serialize<::blink::mojom::ManifestFileHandler_LaunchType>(
        Traits::launch_type(input),
        &fragment->launch_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestTranslationItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestTranslationItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestTranslationItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      decltype(Traits::short_name(input)) in_short_name = Traits::short_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->short_name)::BaseType> short_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_short_name,
        short_name_fragment);

      fragment->short_name.Set(
          short_name_fragment.is_null() ? nullptr : short_name_fragment.data());

      decltype(Traits::description(input)) in_description = Traits::description(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->description)::BaseType> description_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_description,
        description_fragment);

      fragment->description.Set(
          description_fragment.is_null() ? nullptr : description_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestTabStripDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestTabStripDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestTabStrip_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::home_tab(input)) in_home_tab = Traits::home_tab(input);
      mojo::internal::MessageFragment<decltype(fragment->home_tab)>
          home_tab_fragment(fragment.message());
      home_tab_fragment.Claim(&fragment->home_tab);
      
      mojo::internal::Serialize<::blink::mojom::HomeTabUnionDataView, send_validation>(
        in_home_tab,
        home_tab_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->home_tab.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null home_tab in ManifestTabStrip struct");

      decltype(Traits::new_tab_button(input)) in_new_tab_button = Traits::new_tab_button(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->new_tab_button)::BaseType> new_tab_button_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::NewTabButtonParamsDataView, send_validation>(
        in_new_tab_button,
        new_tab_button_fragment);

      fragment->new_tab_button.Set(
          new_tab_button_fragment.is_null() ? nullptr : new_tab_button_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->new_tab_button.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_tab_button in ManifestTabStrip struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::HomeTabParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::HomeTabParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::HomeTabParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::icons(input)) in_icons = Traits::icons(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icons)::BaseType>
          icons_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>, send_validation>(
        in_icons,
        icons_fragment,
        &icons_validate_params);

      fragment->icons.Set(
          icons_fragment.is_null() ? nullptr : icons_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icons.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons in HomeTabParams struct");

      decltype(Traits::scope_patterns(input)) in_scope_patterns = Traits::scope_patterns(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scope_patterns)::BaseType>
          scope_patterns_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& scope_patterns_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>, send_validation>(
        in_scope_patterns,
        scope_patterns_fragment,
        &scope_patterns_validate_params);

      fragment->scope_patterns.Set(
          scope_patterns_fragment.is_null() ? nullptr : scope_patterns_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scope_patterns.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope_patterns in HomeTabParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::NewTabButtonParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::NewTabButtonParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::NewTabButtonParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestDebugInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestDebugInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestDebugInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::errors(input)) in_errors = Traits::errors(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->errors)::BaseType>
          errors_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestErrorDataView>, send_validation>(
        in_errors,
        errors_fragment,
        &errors_validate_params);

      fragment->errors.Set(
          errors_fragment.is_null() ? nullptr : errors_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->errors.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null errors in ManifestDebugInfo struct");

      decltype(Traits::raw_manifest(input)) in_raw_manifest = Traits::raw_manifest(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->raw_manifest)::BaseType> raw_manifest_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_raw_manifest,
        raw_manifest_fragment);

      fragment->raw_manifest.Set(
          raw_manifest_fragment.is_null() ? nullptr : raw_manifest_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->raw_manifest.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null raw_manifest in ManifestDebugInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ManifestErrorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestErrorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::message(input)) in_message = Traits::message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->message)::BaseType> message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_message,
        message_fragment);

      fragment->message.Set(
          message_fragment.is_null() ? nullptr : message_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in ManifestError struct");

      fragment->critical = Traits::critical(input);

      fragment->line = Traits::line(input);

      fragment->column = Traits::column(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::HomeTabUnionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::HomeTabUnionDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::HomeTabUnion_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::HomeTabUnionDataView::Tag::kVisibility: {
    decltype(Traits::visibility(input))
    in_visibility = Traits::visibility(input);
        
mojo::internal::Serialize<::blink::mojom::TabStripMemberVisibility, send_validation>(
  in_visibility,
  &fragment->data.f_visibility);
    break;
  }
  case ::blink::mojom::HomeTabUnionDataView::Tag::kParams: {
    decltype(Traits::params(input))
    in_params = Traits::params(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_params)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::HomeTabParamsDataView, send_validation>(
  in_params,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null params in HomeTabUnion union");
    fragment->data.f_params.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_SEND_VALIDATION_H_