// third_party/blink/public/mojom/lock_screen/lock_screen.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/lock_screen/lock_screen.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/lock_screen/lock_screen.mojom-params-data.h"
#include "third_party/blink/public/mojom/lock_screen/lock_screen.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/lock_screen/lock_screen.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/lock_screen/lock_screen.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

LockScreenService::IPCStableHashFunction LockScreenService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LockScreenService>(message.name())) {
    case messages::LockScreenService::kGetKeys: {
      return &LockScreenService::GetKeys_Sym::IPCStableHash;
    }
    case messages::LockScreenService::kSetData: {
      return &LockScreenService::SetData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LockScreenService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LockScreenService>(message.name())) {
      case messages::LockScreenService::kGetKeys:
            return "Receive blink::mojom::LockScreenService::GetKeys";
      case messages::LockScreenService::kSetData:
            return "Receive blink::mojom::LockScreenService::SetData";
    }
  } else {
    switch (static_cast<messages::LockScreenService>(message.name())) {
      case messages::LockScreenService::kGetKeys:
            return "Receive reply blink::mojom::LockScreenService::GetKeys";
      case messages::LockScreenService::kSetData:
            return "Receive reply blink::mojom::LockScreenService::SetData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LockScreenService::GetKeys_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f2956b1;  // IPCStableHash for blink::mojom::LockScreenService::GetKeys
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LockScreenService::SetData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd099fad7;  // IPCStableHash for blink::mojom::LockScreenService::SetData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LockScreenService_GetKeys_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LockScreenService_GetKeys_ForwardToCallback(
      LockScreenService::GetKeysCallback callback
      ) : callback_(std::move(callback)) {
  }

  LockScreenService_GetKeys_ForwardToCallback(const LockScreenService_GetKeys_ForwardToCallback&) = delete;
  LockScreenService_GetKeys_ForwardToCallback& operator=(const LockScreenService_GetKeys_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LockScreenService::GetKeysCallback callback_;
};

class LockScreenService_SetData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LockScreenService_SetData_ForwardToCallback(
      LockScreenService::SetDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  LockScreenService_SetData_ForwardToCallback(const LockScreenService_SetData_ForwardToCallback&) = delete;
  LockScreenService_SetData_ForwardToCallback& operator=(const LockScreenService_SetData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LockScreenService::SetDataCallback callback_;
};

LockScreenServiceProxy::LockScreenServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LockScreenServiceProxy::GetKeys(
    GetKeysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LockScreenService::GetKeys");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LockScreenService::kGetKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockScreenService_GetKeys_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockScreenService::Name_);
  message.set_method_name("GetKeys");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LockScreenService_GetKeys_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LockScreenServiceProxy::SetData(
    const ::blink::String& in_key, const ::blink::String& in_data, SetDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LockScreenService::SetData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LockScreenService::kSetData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockScreenService_SetData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in LockScreenService.SetData request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in LockScreenService.SetData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockScreenService::Name_);
  message.set_method_name("SetData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LockScreenService_SetData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class LockScreenService_GetKeys_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LockScreenService::GetKeysCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LockScreenService_GetKeys_ProxyToResponder> proxy(
        new LockScreenService_GetKeys_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LockScreenService_GetKeys_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LockScreenService_GetKeys_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LockScreenService_GetKeys_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LockScreenService::GetKeysCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::Vector<::blink::String>& in_keys);
};

bool LockScreenService_GetKeys_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LockScreenService_GetKeys_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LockScreenService_GetKeys_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LockScreenService.0
  bool success = true;
  ::blink::Vector<::blink::String> p_keys{};
  LockScreenService_GetKeys_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadKeys(&p_keys))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LockScreenService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_keys));
  }
  return true;
}

void LockScreenService_GetKeys_ProxyToResponder::Run(
    const ::blink::Vector<::blink::String>& in_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LockScreenService::GetKeys", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys"), in_keys,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LockScreenService::kGetKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockScreenService_GetKeys_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->keys)::BaseType>
      keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_keys,
    keys_fragment,
    &keys_validate_params);

  params->keys.Set(
      keys_fragment.is_null() ? nullptr : keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null keys in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockScreenService::Name_);
  message.set_method_name("GetKeys");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LockScreenService_SetData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LockScreenService::SetDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LockScreenService_SetData_ProxyToResponder> proxy(
        new LockScreenService_SetData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LockScreenService_SetData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LockScreenService_SetData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LockScreenService_SetData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LockScreenService::SetDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      LockScreenServiceStatus in_status);
};

bool LockScreenService_SetData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LockScreenService_SetData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LockScreenService_SetData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LockScreenService.1
  bool success = true;
  LockScreenServiceStatus p_status{};
  LockScreenService_SetData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LockScreenService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void LockScreenService_SetData_ProxyToResponder::Run(
    LockScreenServiceStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LockScreenService::SetData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type LockScreenServiceStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LockScreenService::kSetData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockScreenService_SetData_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::LockScreenServiceStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockScreenService::Name_);
  message.set_method_name("SetData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LockScreenServiceStubDispatch::Accept(
    LockScreenService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LockScreenService>(message->header()->name)) {
    case messages::LockScreenService::kGetKeys: {
      break;
    }
    case messages::LockScreenService::kSetData: {
      break;
    }
  }
  return false;
}

// static
bool LockScreenServiceStubDispatch::AcceptWithResponder(
    LockScreenService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LockScreenService>(message->header()->name)) {
    case messages::LockScreenService::kGetKeys: {
      internal::LockScreenService_GetKeys_Params_Data* params =
          reinterpret_cast<
              internal::LockScreenService_GetKeys_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LockScreenService.0
      bool success = true;
      LockScreenService_GetKeys_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LockScreenService::Name_, 0, false);
        return false;
      }
      auto callback =
          LockScreenService_GetKeys_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetKeys(std::move(callback));
      return true;
    }
    case messages::LockScreenService::kSetData: {
      internal::LockScreenService_SetData_Params_Data* params =
          reinterpret_cast<
              internal::LockScreenService_SetData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LockScreenService.1
      bool success = true;
      ::blink::String p_key{};
      ::blink::String p_data{};
      LockScreenService_SetData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LockScreenService::Name_, 1, false);
        return false;
      }
      auto callback =
          LockScreenService_SetData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetData(        
        std::move(p_key), 
        std::move(p_data), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLockScreenServiceValidationInfo[] = {
    { &internal::LockScreenService_GetKeys_Params_Data::Validate,
     &internal::LockScreenService_GetKeys_ResponseParams_Data::Validate},
    { &internal::LockScreenService_SetData_Params_Data::Validate,
     &internal::LockScreenService_SetData_ResponseParams_Data::Validate},
};

bool LockScreenServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::LockScreenService::Name_,
    kLockScreenServiceValidationInfo);
}

bool LockScreenServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::LockScreenService::Name_,
    kLockScreenServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void LockScreenServiceInterceptorForTesting::GetKeys(GetKeysCallback callback) {
  GetForwardingInterface()->GetKeys(std::move(callback));
}
void LockScreenServiceInterceptorForTesting::SetData(const ::blink::String& key, const ::blink::String& data, SetDataCallback callback) {
  GetForwardingInterface()->SetData(
    std::move(key)
    , 
    std::move(data)
    , std::move(callback));
}
LockScreenServiceAsyncWaiter::LockScreenServiceAsyncWaiter(
    LockScreenService* proxy) : proxy_(proxy) {}

LockScreenServiceAsyncWaiter::~LockScreenServiceAsyncWaiter() = default;


void LockScreenServiceAsyncWaiter::GetKeys(
    ::blink::Vector<::blink::String>* out_keys) {
  base::RunLoop loop;
  proxy_->GetKeys(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::blink::String>* out_keys
,
             const ::blink::Vector<::blink::String>& keys) {*out_keys = std::move(keys);
            loop->Quit();
          },
          &loop,
          out_keys));
  loop.Run();
}

::blink::Vector<::blink::String> LockScreenServiceAsyncWaiter::GetKeys(
    ) {
  ::blink::Vector<::blink::String> async_wait_result;
  GetKeys(&async_wait_result);
  return async_wait_result;
}

void LockScreenServiceAsyncWaiter::SetData(
    const ::blink::String& key, const ::blink::String& data, LockScreenServiceStatus* out_status) {
  base::RunLoop loop;
  proxy_->SetData(
      std::move(key),
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             LockScreenServiceStatus* out_status
,
             LockScreenServiceStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

LockScreenServiceStatus LockScreenServiceAsyncWaiter::SetData(
    const ::blink::String& key, const ::blink::String& data) {
  LockScreenServiceStatus async_wait_result;
  SetData(std::move(key),std::move(data),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif