// third_party/blink/public/mojom/loader/transferrable_url_loader.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_TRANSFERRABLE_URL_LOADER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_TRANSFERRABLE_URL_LOADER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/transferrable_url_loader.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/transferrable_url_loader.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/transferrable_url_loader.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_response_head.mojom-blink.h"
#include "services/network/public/mojom/url_loader.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT TransferrableURLLoader {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TransferrableURLLoader, T>::value>;
  using DataView = TransferrableURLLoaderDataView;
  using Data_ = internal::TransferrableURLLoader_Data;

  template <typename... Args>
  static TransferrableURLLoaderPtr New(Args&&... args) {
    return TransferrableURLLoaderPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransferrableURLLoaderPtr From(const U& u) {
    return mojo::TypeConverter<TransferrableURLLoaderPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TransferrableURLLoader>::Convert(*this);
  }


  TransferrableURLLoader();

  TransferrableURLLoader(
      const ::blink::KURL& url,
      ::mojo::PendingRemote<::network::mojom::blink::URLLoader> url_loader,
      ::mojo::PendingReceiver<::network::mojom::blink::URLLoaderClient> url_loader_client,
      ::network::mojom::blink::URLResponseHeadPtr head,
      ::mojo::ScopedDataPipeConsumerHandle body);

TransferrableURLLoader(const TransferrableURLLoader&) = delete;
TransferrableURLLoader& operator=(const TransferrableURLLoader&) = delete;

  ~TransferrableURLLoader();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransferrableURLLoaderPtr>
  TransferrableURLLoaderPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TransferrableURLLoader::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TransferrableURLLoader::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TransferrableURLLoader::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TransferrableURLLoader::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TransferrableURLLoader_UnserializedMessageContext<
            UserType, TransferrableURLLoader::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TransferrableURLLoader::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TransferrableURLLoader::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TransferrableURLLoader_UnserializedMessageContext<
            UserType, TransferrableURLLoader::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TransferrableURLLoader::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  ::mojo::PendingRemote<::network::mojom::blink::URLLoader> url_loader;
  
  ::mojo::PendingReceiver<::network::mojom::blink::URLLoaderClient> url_loader_client;
  
  ::network::mojom::blink::URLResponseHeadPtr head;
  
  ::mojo::ScopedDataPipeConsumerHandle body;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TransferrableURLLoader::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TransferrableURLLoader::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TransferrableURLLoader::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TransferrableURLLoader::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TransferrableURLLoaderPtr TransferrableURLLoader::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(url_loader),
      mojo::Clone(url_loader_client),
      mojo::Clone(head),
      mojo::Clone(body)
  );
}

template <typename T, TransferrableURLLoader::EnableIfSame<T>*>
bool TransferrableURLLoader::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->url_loader, other_struct.url_loader))
    return false;
  if (!mojo::Equals(this->url_loader_client, other_struct.url_loader_client))
    return false;
  if (!mojo::Equals(this->head, other_struct.head))
    return false;
  if (!mojo::Equals(this->body, other_struct.body))
    return false;
  return true;
}

template <typename T, TransferrableURLLoader::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.url_loader < rhs.url_loader)
    return true;
  if (rhs.url_loader < lhs.url_loader)
    return false;
  if (lhs.url_loader_client < rhs.url_loader_client)
    return true;
  if (rhs.url_loader_client < lhs.url_loader_client)
    return false;
  if (lhs.head < rhs.head)
    return true;
  if (rhs.head < lhs.head)
    return false;
  if (lhs.body < rhs.body)
    return true;
  if (rhs.body < lhs.body)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::TransferrableURLLoader::DataView,
                                         ::blink::mojom::blink::TransferrableURLLoaderPtr> {
  static bool IsNull(const ::blink::mojom::blink::TransferrableURLLoaderPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TransferrableURLLoaderPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::TransferrableURLLoader::url)& url(
      const ::blink::mojom::blink::TransferrableURLLoaderPtr& input) {
    return input->url;
  }

  static  decltype(::blink::mojom::blink::TransferrableURLLoader::url_loader)& url_loader(
       ::blink::mojom::blink::TransferrableURLLoaderPtr& input) {
    return input->url_loader;
  }

  static  decltype(::blink::mojom::blink::TransferrableURLLoader::url_loader_client)& url_loader_client(
       ::blink::mojom::blink::TransferrableURLLoaderPtr& input) {
    return input->url_loader_client;
  }

  static const decltype(::blink::mojom::blink::TransferrableURLLoader::head)& head(
      const ::blink::mojom::blink::TransferrableURLLoaderPtr& input) {
    return input->head;
  }

  static  decltype(::blink::mojom::blink::TransferrableURLLoader::body)& body(
       ::blink::mojom::blink::TransferrableURLLoaderPtr& input) {
    return input->body;
  }

  static bool Read(::blink::mojom::blink::TransferrableURLLoader::DataView input, ::blink::mojom::blink::TransferrableURLLoaderPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_TRANSFERRABLE_URL_LOADER_MOJOM_BLINK_H_