// third_party/blink/public/mojom/loader/resource_load_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_count.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class CommonNetworkInfoDataView;

class RedirectInfoDataView;

class ResourceLoadInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::CommonNetworkInfoDataView> {
  using Data = ::blink::mojom::internal::CommonNetworkInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::RedirectInfoDataView> {
  using Data = ::blink::mojom::internal::RedirectInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ResourceLoadInfoDataView> {
  using Data = ::blink::mojom::internal::ResourceLoadInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ResourceType : int32_t {
  
  kMainFrame = 0,
  
  kSubFrame = 1,
  
  kStylesheet = 2,
  
  kScript = 3,
  
  kImage = 4,
  
  kFontResource = 5,
  
  kSubResource = 6,
  
  kObject = 7,
  
  kMedia = 8,
  
  kWorker = 9,
  
  kSharedWorker = 10,
  
  kPrefetch = 11,
  
  kFavicon = 12,
  
  kXhr = 13,
  
  kPing = 14,
  
  kServiceWorker = 15,
  
  kCspReport = 16,
  
  kPluginResource = 17,
  
  kNavigationPreloadMainFrame = 19,
  
  kNavigationPreloadSubFrame = 20,
  
  kJson = 21,
  kMinValue = 0,
  kMaxValue = 21,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ResourceType value);
inline bool IsKnownEnumValue(ResourceType value) {
  return internal::ResourceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class CommonNetworkInfoDataView {
 public:
  CommonNetworkInfoDataView() = default;

  CommonNetworkInfoDataView(
      internal::CommonNetworkInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool network_accessed() const {
    return data_->network_accessed;
  }
  bool always_access_network() const {
    return data_->always_access_network;
  }
  inline void GetRemoteEndpointDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteEndpoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::IPEndPointDataView, UserType>(),
    "Attempting to read the optional `remote_endpoint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRemoteEndpoint` instead "
    "of `ReadRemoteEndpoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->remote_endpoint.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
 private:
  internal::CommonNetworkInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RedirectInfoDataView {
 public:
  RedirectInfoDataView() = default;

  RedirectInfoDataView(
      internal::RedirectInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginOfNewUrlDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginOfNewUrl(UserType* output) {
    
    auto* pointer = data_->origin_of_new_url.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetNetworkInfoDataView(
      CommonNetworkInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetworkInfo(UserType* output) {
    
    auto* pointer = data_->network_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::CommonNetworkInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::RedirectInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceLoadInfoDataView {
 public:
  ResourceLoadInfoDataView() = default;

  ResourceLoadInfoDataView(
      internal::ResourceLoadInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t request_id() const {
    return data_->request_id;
  }
  inline void GetFinalUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFinalUrl(UserType* output) {
    
    auto* pointer = data_->final_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetOriginalUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginalUrl(UserType* output) {
    
    auto* pointer = data_->original_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRequestDestination(UserType* output) const {
    auto data_value = data_->request_destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }
  ::network::mojom::RequestDestination request_destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestDestination>(data_->request_destination));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRequestPriority(UserType* output) const {
    auto data_value = data_->request_priority;
    return mojo::internal::Deserialize<::network::mojom::RequestPriority>(
        data_value, output);
  }
  ::network::mojom::RequestPriority request_priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestPriority>(data_->request_priority));
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool was_cached() const {
    return data_->was_cached;
  }
  inline void GetNetworkInfoDataView(
      CommonNetworkInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetworkInfo(UserType* output) {
    
    auto* pointer = data_->network_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::CommonNetworkInfoDataView>(
        pointer, output, message_);
  }
  int32_t net_error() const {
    return data_->net_error;
  }
  inline void GetProxyChainDataView(
      ::network::mojom::ProxyChainDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxyChain(UserType* output) {
    
    auto* pointer = data_->proxy_chain.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyChainDataView>(
        pointer, output, message_);
  }
  inline void GetLoadTimingInfoDataView(
      ::network::mojom::LoadTimingInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLoadTimingInfo(UserType* output) {
    
    auto* pointer = data_->load_timing_info.Get();
    return mojo::internal::Deserialize<::network::mojom::LoadTimingInfoDataView>(
        pointer, output, message_);
  }
  inline void GetRawBodyBytesDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawBodyBytes(UserType* output) {
    
    auto* pointer = data_->raw_body_bytes.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetTotalReceivedBytesDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotalReceivedBytes(UserType* output) {
    
    auto* pointer = data_->total_received_bytes.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetRedirectInfoChainDataView(
      mojo::ArrayDataView<RedirectInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectInfoChain(UserType* output) {
    
    auto* pointer = data_->redirect_info_chain.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::RedirectInfoDataView>>(
        pointer, output, message_);
  }
  int32_t http_status_code() const {
    return data_->http_status_code;
  }
 private:
  internal::ResourceLoadInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_DATA_VIEW_H_