// third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"


namespace blink::mojom {
class LocalResourceSourceDataView;

class LocalResourceLoaderConfigDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::LocalResourceSourceDataView> {
  using Data = ::blink::mojom::internal::LocalResourceSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::LocalResourceLoaderConfigDataView> {
  using Data = ::blink::mojom::internal::LocalResourceLoaderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class LocalResourceSourceDataView {
 public:
  LocalResourceSourceDataView() = default;

  LocalResourceSourceDataView(
      internal::LocalResourceSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHeadersDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool should_replace_i18n_in_js() const {
    return data_->should_replace_i18n_in_js;
  }
  inline void GetPathToResourceIdMapDataView(
      mojo::MapDataView<mojo::StringDataView, int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPathToResourceIdMap(UserType* output) {
    
    auto* pointer = data_->path_to_resource_id_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, int32_t>>(
        pointer, output, message_);
  }
  inline void GetReplacementStringsDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplacementStrings(UserType* output) {
    
    auto* pointer = data_->replacement_strings.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::LocalResourceSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LocalResourceLoaderConfigDataView {
 public:
  LocalResourceLoaderConfigDataView() = default;

  LocalResourceLoaderConfigDataView(
      internal::LocalResourceLoaderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourcesDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, LocalResourceSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSources(UserType* output) {
    
    auto* pointer = data_->sources.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::LocalResourceSourceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::LocalResourceLoaderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_DATA_VIEW_H_