// third_party/blink/public/mojom/loader/keep_alive_handle_factory.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  KeepAliveHandleRemote as blink_mojom_KeepAliveHandleRemote,
  KeepAliveHandlePendingReceiver as blink_mojom_KeepAliveHandlePendingReceiver
} from './keep_alive_handle.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class KeepAliveHandleFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.KeepAliveHandleFactory', scope);
  }
}

/** @interface */
export class KeepAliveHandleFactoryInterface {
  
  /**
   * @param { !blink_mojom_KeepAliveHandlePendingReceiver } keepAliveHandle
   */

  issueKeepAliveHandle(keepAliveHandle) {}
}

/**
 * @implements { KeepAliveHandleFactoryInterface }
 */
export class KeepAliveHandleFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!KeepAliveHandleFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          KeepAliveHandleFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!KeepAliveHandleFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_KeepAliveHandlePendingReceiver } keepAliveHandle
   */

  issueKeepAliveHandle(
      keepAliveHandle) {
    this.proxy.sendMessage(
        0,
        KeepAliveHandleFactory_IssueKeepAliveHandle_ParamsSpec.$,
        null,
        [
          keepAliveHandle
        ],
        false);
  }
}

/**
 * An object which receives request messages for the KeepAliveHandleFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeepAliveHandleFactoryReceiver {
  /**
   * @param {!KeepAliveHandleFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!KeepAliveHandleFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        KeepAliveHandleFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!KeepAliveHandleFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        KeepAliveHandleFactory_IssueKeepAliveHandle_ParamsSpec.$,
        null,
        impl.issueKeepAliveHandle.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class KeepAliveHandleFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.KeepAliveHandleFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!KeepAliveHandleFactoryRemote}
   */
  static getRemote() {
    let remote = new KeepAliveHandleFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the KeepAliveHandleFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeepAliveHandleFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      KeepAliveHandleFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!KeepAliveHandleFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.issueKeepAliveHandle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        KeepAliveHandleFactory_IssueKeepAliveHandle_ParamsSpec.$,
        null,
        this.issueKeepAliveHandle.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeepAliveHandleFactory_IssueKeepAliveHandle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    KeepAliveHandleFactory_IssueKeepAliveHandle_ParamsSpec.$,
    'KeepAliveHandleFactory_IssueKeepAliveHandle_Params',
    [
      mojo.internal.StructField(
        'keepAliveHandle', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_KeepAliveHandlePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class KeepAliveHandleFactory_IssueKeepAliveHandle_Params {
  constructor() {
    /** @type { !blink_mojom_KeepAliveHandlePendingReceiver } */
    this.keepAliveHandle;
  }
}

