// third_party/blink/public/mojom/loader/fetch_later.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  MutableNetworkTrafficAnnotationTag as network_mojom_MutableNetworkTrafficAnnotationTag,
  MutableNetworkTrafficAnnotationTagSpec as network_mojom_MutableNetworkTrafficAnnotationTagSpec
} from '../../../../../services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.m.js';

import {
  URLRequest as network_mojom_URLRequest,
  URLRequestSpec as network_mojom_URLRequestSpec
} from '../../../../../services/network/public/mojom/url_request.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FetchLaterLoaderFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FetchLaterLoaderFactory', scope);
  }
}

/** @interface */
export class FetchLaterLoaderFactoryInterface {
  
  /**
   * @param { !Object } loader
   * @param { !number } requestId
   * @param { !number } options
   * @param { !network_mojom_URLRequest } request
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   */

  createLoader(loader, requestId, options, request, trafficAnnotation) {}
  
  /**
   * @param { !Object } factory
   */

  clone(factory) {}
}

/**
 * @implements { FetchLaterLoaderFactoryInterface }
 */
export class FetchLaterLoaderFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FetchLaterLoaderFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FetchLaterLoaderFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FetchLaterLoaderFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } loader
   * @param { !number } requestId
   * @param { !number } options
   * @param { !network_mojom_URLRequest } request
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   */

  createLoader(
      loader,
      requestId,
      options,
      request,
      trafficAnnotation) {
    this.proxy.sendMessage(
        0,
        FetchLaterLoaderFactory_CreateLoader_ParamsSpec.$,
        null,
        [
          loader,
          requestId,
          options,
          request,
          trafficAnnotation
        ],
        false);
  }

  
  /**
   * @param { !Object } factory
   */

  clone(
      factory) {
    this.proxy.sendMessage(
        1,
        FetchLaterLoaderFactory_Clone_ParamsSpec.$,
        null,
        [
          factory
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FetchLaterLoaderFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FetchLaterLoaderFactoryReceiver {
  /**
   * @param {!FetchLaterLoaderFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FetchLaterLoaderFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FetchLaterLoaderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FetchLaterLoaderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FetchLaterLoaderFactory_CreateLoader_ParamsSpec.$,
        null,
        impl.createLoader.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FetchLaterLoaderFactory_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FetchLaterLoaderFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FetchLaterLoaderFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FetchLaterLoaderFactoryRemote}
   */
  static getRemote() {
    let remote = new FetchLaterLoaderFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FetchLaterLoaderFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FetchLaterLoaderFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FetchLaterLoaderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FetchLaterLoaderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createLoader =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FetchLaterLoaderFactory_CreateLoader_ParamsSpec.$,
        null,
        this.createLoader.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FetchLaterLoaderFactory_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FetchLaterLoaderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FetchLaterLoader', scope);
  }
}

/** @interface */
export class FetchLaterLoaderInterface {
  
  /**
   */

  sendNow() {}
  
  /**
   */

  cancel() {}
}

/**
 * @implements { FetchLaterLoaderInterface }
 */
export class FetchLaterLoaderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FetchLaterLoaderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FetchLaterLoaderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FetchLaterLoaderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  sendNow() {
    this.proxy.sendMessage(
        0,
        FetchLaterLoader_SendNow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        1,
        FetchLaterLoader_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FetchLaterLoader
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FetchLaterLoaderReceiver {
  /**
   * @param {!FetchLaterLoaderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FetchLaterLoaderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FetchLaterLoaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FetchLaterLoaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FetchLaterLoader_SendNow_ParamsSpec.$,
        null,
        impl.sendNow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FetchLaterLoader_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FetchLaterLoader {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FetchLaterLoader";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FetchLaterLoaderRemote}
   */
  static getRemote() {
    let remote = new FetchLaterLoaderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FetchLaterLoader
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FetchLaterLoaderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FetchLaterLoaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FetchLaterLoaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendNow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FetchLaterLoader_SendNow_ParamsSpec.$,
        null,
        this.sendNow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FetchLaterLoader_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FetchLaterLoaderFactory_CreateLoader_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FetchLaterLoaderFactory_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FetchLaterLoader_SendNow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FetchLaterLoader_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FetchLaterLoaderFactory_CreateLoader_ParamsSpec.$,
    'FetchLaterLoaderFactory_CreateLoader_Params',
    [
      mojo.internal.StructField(
        'loader', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(FetchLaterLoaderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'request', 16,
        0,
        network_mojom_URLRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 24,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class FetchLaterLoaderFactory_CreateLoader_Params {
  constructor() {
    /** @type { !Object } */
    this.loader;
    /** @type { !number } */
    this.requestId;
    /** @type { !number } */
    this.options;
    /** @type { !network_mojom_URLRequest } */
    this.request;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
  }
}



mojo.internal.Struct(
    FetchLaterLoaderFactory_Clone_ParamsSpec.$,
    'FetchLaterLoaderFactory_Clone_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(FetchLaterLoaderFactoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FetchLaterLoaderFactory_Clone_Params {
  constructor() {
    /** @type { !Object } */
    this.factory;
  }
}



mojo.internal.Struct(
    FetchLaterLoader_SendNow_ParamsSpec.$,
    'FetchLaterLoader_SendNow_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FetchLaterLoader_SendNow_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FetchLaterLoader_Cancel_ParamsSpec.$,
    'FetchLaterLoader_Cancel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FetchLaterLoader_Cancel_Params {
  constructor() {
  }
}

