// third_party/blink/public/mojom/loader/fetch_later.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_LATER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_LATER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/fetch_later.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/fetch_later.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/fetch_later.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-blink.h"
#include "services/network/public/mojom/url_request.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif


namespace network { struct ResourceRequest; }


namespace blink::mojom::blink {

class FetchLaterLoaderFactoryProxy;

template <typename ImplRefTraits>
class FetchLaterLoaderFactoryStub;

class FetchLaterLoaderFactoryRequestValidator;


class PLATFORM_EXPORT FetchLaterLoaderFactory
    : public FetchLaterLoaderFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FetchLaterLoaderFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FetchLaterLoaderFactoryInterfaceBase;
  using Proxy_ = FetchLaterLoaderFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = FetchLaterLoaderFactoryStub<ImplRefTraits>;

  using RequestValidator_ = FetchLaterLoaderFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateLoaderMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateLoader_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FetchLaterLoaderFactory() = default;

  virtual void CreateLoader(::mojo::PendingAssociatedReceiver<FetchLaterLoader> loader, int32_t request_id, uint32_t options, const ::network::ResourceRequest& request, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) = 0;
  // Default implementation for non-const ref params. This method can be
  // implemented as a performance optimization for non-const ref types.
  virtual void CreateLoader(::mojo::PendingAssociatedReceiver<FetchLaterLoader> loader, int32_t request_id, uint32_t options, ::network::ResourceRequest& request, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) {
    CreateLoader(std::move(loader), std::move(request_id), std::move(options), const_cast<const ::network::ResourceRequest&>(request), std::move(traffic_annotation));
  }

  virtual void Clone(::mojo::PendingAssociatedReceiver<FetchLaterLoaderFactory> factory) = 0;
};

class FetchLaterLoaderProxy;

template <typename ImplRefTraits>
class FetchLaterLoaderStub;

class FetchLaterLoaderRequestValidator;


class PLATFORM_EXPORT FetchLaterLoader
    : public FetchLaterLoaderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FetchLaterLoader";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FetchLaterLoaderInterfaceBase;
  using Proxy_ = FetchLaterLoaderProxy;

  template <typename ImplRefTraits>
  using Stub_ = FetchLaterLoaderStub<ImplRefTraits>;

  using RequestValidator_ = FetchLaterLoaderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendNowMinVersion = 0,
    kCancelMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SendNow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FetchLaterLoader() = default;

  virtual void SendNow() = 0;

  virtual void Cancel() = 0;
};



class PLATFORM_EXPORT FetchLaterLoaderFactoryProxy
    : public FetchLaterLoaderFactory {
 public:
  using InterfaceType = FetchLaterLoaderFactory;

  explicit FetchLaterLoaderFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateLoader(::mojo::PendingAssociatedReceiver<FetchLaterLoader> loader, int32_t request_id, uint32_t options, const ::network::ResourceRequest& request, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) final;
  
  void Clone(::mojo::PendingAssociatedReceiver<FetchLaterLoaderFactory> factory) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT FetchLaterLoaderProxy
    : public FetchLaterLoader {
 public:
  using InterfaceType = FetchLaterLoader;

  explicit FetchLaterLoaderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendNow() final;
  
  void Cancel() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT FetchLaterLoaderFactoryStubDispatch {
 public:
  static bool Accept(FetchLaterLoaderFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FetchLaterLoaderFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FetchLaterLoaderFactory>>
class FetchLaterLoaderFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FetchLaterLoaderFactoryStub() = default;
  ~FetchLaterLoaderFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FetchLaterLoaderFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FetchLaterLoaderFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT FetchLaterLoaderStubDispatch {
 public:
  static bool Accept(FetchLaterLoader* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FetchLaterLoader* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FetchLaterLoader>>
class FetchLaterLoaderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FetchLaterLoaderStub() = default;
  ~FetchLaterLoaderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FetchLaterLoaderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FetchLaterLoaderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT FetchLaterLoaderFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT FetchLaterLoaderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_LATER_MOJOM_BLINK_H_